(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    801817,      16577]
NotebookOptionsPosition[    767575,      16022]
NotebookOutlinePosition[    768077,      16042]
CellTagsIndexPosition[    768034,      16039]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Many-outcome experiments on incentivizing honest performative predictions \
with proper scoring rules\
\>", "Title",
 CellChangeTimes->{{3.8801795760792418`*^9, 3.880179609287849*^9}, {
  3.885595100334029*^9, 3.885595104494279*^9}, {3.885596955981344*^9, 
  3.8855969597001667`*^9}, {3.894047098808775*^9, 
  3.894047129828952*^9}},ExpressionUUID->"52092686-dc98-4dd8-8bd4-\
ac5ee8fd66a5"],

Cell["\<\
Caspar Oesterheld*, Johannes Treutlein*, Emery Cooper, and Rubi Hudson\
\>", "Subtitle",
 CellChangeTimes->{{3.8940472070371513`*^9, 
  3.894047222381081*^9}},ExpressionUUID->"f2a24689-57a4-4c2a-ac2a-\
edb571e64304"],

Cell[TextData[StyleBox["Definitions", "Section"]], "Text",
 CellChangeTimes->{{3.882222889945725*^9, 
  3.882222891003194*^9}},ExpressionUUID->"a79707f7-8a46-41e1-b993-\
d355e381a1a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IsDistr", "[", "p_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Total", "[", "p", "]"}], "==", "1"}], "&&", 
   RowBox[{"And", "@@", 
    RowBox[{"NonNegative", "[", "p", "]"}]}]}]}]], "Input",
 CellChangeTimes->{3.8821770596865664`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"a082005a-818a-4701-9b4a-60b74b157c53"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IsDistrAppr", "[", "p_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Total", "[", "p", "]"}], "==", "1"}], "&&", 
   RowBox[{"And", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ">=", 
       RowBox[{"-", "0.00001"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "p", "]"}]}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.882349414371278*^9, 3.882349426509362*^9}, {
  3.882349472375863*^9, 3.882349516670331*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"16f40baf-3d37-448c-904c-cfe18c131f4c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BrierScore", "[", 
   RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{"q", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "*", 
      RowBox[{"p", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "q", "]"}]}], "}"}]}], "]"}], "-", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "q", "]"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.88234895832491*^9, 3.882349019775157*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"2223da2f-387b-43f5-8f08-96535f2e593a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"logscoreh", "[", 
    RowBox[{"0", ",", "0"}], "]"}], ":=", "0"}], ";", 
  RowBox[{
   RowBox[{"logscoreh", "[", 
    RowBox[{"0", ",", "0.0"}], "]"}], "=", "0"}], ";", 
  RowBox[{
   RowBox[{"logscoreh", "[", 
    RowBox[{"0", ",", "x_"}], "]"}], ":=", 
   RowBox[{"-", "\[Infinity]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"logscoreh", "[", 
    RowBox[{"0.0", ",", "0.0"}], "]"}], ":=", "0"}], " ", ";", 
  RowBox[{"logscoreh", "[", 
   RowBox[{"0.0", ",", "0"}], "]"}], ";", 
  RowBox[{
   RowBox[{"logscoreh", "[", 
    RowBox[{"0.0", ",", "x_"}], "]"}], ":=", 
   RowBox[{"-", "\[Infinity]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"logscoreh", "[", 
    RowBox[{"pi_", ",", "qi_"}], "]"}], ":=", 
   RowBox[{"qi", "*", 
    RowBox[{"Log", "[", "pi", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.882344858603986*^9, 3.882344880327227*^9}, {
  3.882344915580941*^9, 3.8823449589140167`*^9}, {3.882345178788286*^9, 
  3.882345213192802*^9}, {3.882346351410597*^9, 3.882346362674019*^9}, {
  3.8823465727823267`*^9, 3.8823465967129507`*^9}, {3.882346632381675*^9, 
  3.8823466403982267`*^9}, {3.882346693071095*^9, 3.882346727516626*^9}, {
  3.882350250093801*^9, 3.882350280059894*^9}, {3.882350603174665*^9, 
  3.8823506158745623`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"0dfd78a9-229a-4ed4-9cc7-ef90784371e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LogScore", "[", 
   RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"logscoreh", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", 
      RowBox[{"q", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "q", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8821776999103107`*^9, 3.882177741984272*^9}, {
  3.882344955012928*^9, 3.8823449790795403`*^9}, {3.8823484095670633`*^9, 
  3.882348421714427*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"9ea27e63-19f8-459a-b3fd-4431739986e2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"uniform", "[", "dim_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", "dim"}], ",", "dim"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.88217663917789*^9, 3.8821766492252502`*^9}, {
  3.8823656661748857`*^9, 3.882365669811932*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"d9a8303c-2ca2-45a9-a2df-02b5ef206b56"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomDistr", "[", "dim_", "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"$RecursionLimit", "=", "1000"}], ",", 
      RowBox[{"res", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RandomInteger", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1000"}], "}"}], "]"}], "/", "1000"}], ",", 
         RowBox[{"dim", "-", "1"}]}], "]"}]}]}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Total", "[", "res", "]"}], "<=", "1"}], ",", 
      RowBox[{"Append", "[", 
       RowBox[{"res", ",", 
        RowBox[{"1", "-", 
         RowBox[{"Total", "[", "res", "]"}]}]}], "]"}], ",", 
      RowBox[{"RandomDistr", "[", "dim", "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882223416238797*^9, 3.882223469907716*^9}, {
  3.8823375670633087`*^9, 3.882337590169599*^9}, {3.882365688804947*^9, 
  3.882365689997933*^9}, {3.885499340352079*^9, 3.885499346500029*^9}, {
  3.885503329205048*^9, 3.885503401102686*^9}, {3.8855522648673687`*^9, 
  3.8855522705132627`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"770c7b71-a8a4-44af-8766-accfebe860ad"],

Cell["\<\
The following randomly generates a matrix that defines a linear function on \
the simplex.\
\>", "Text",
 CellChangeTimes->{{3.894046710288316*^9, 
  3.894046754353648*^9}},ExpressionUUID->"f91a842f-7af8-4dc5-83ec-\
5e59cdace189"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RandomA", "[", "dim_", "]"}], ":=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomDistr", "[", "dim", "]"}], ",", "dim"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8822232628994217`*^9, 3.882223292605811*^9}, {
  3.882337552454254*^9, 3.882337553802312*^9}, {3.882337596941738*^9, 
  3.882337597079131*^9}, {3.882365679447781*^9, 3.882365679852512*^9}, {
  3.885499562244343*^9, 3.8854995667841787`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"b0d939f4-fc4a-492b-a65d-5c6d077e63f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FixedPointDistr", "[", "A_", "]"}], ":=", 
  RowBox[{"Last", "/@", 
   RowBox[{"Last", "@", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"A", ".", 
         RowBox[{"Array", "[", 
          RowBox[{"x", ",", 
           RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "==", 
        RowBox[{"Array", "[", 
         RowBox[{"x", ",", 
          RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "&&", 
       RowBox[{"IsDistr", "[", 
        RowBox[{"Array", "[", 
         RowBox[{"x", ",", 
          RowBox[{"Length", "[", "A", "]"}]}], "]"}], "]"}]}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{"x", ",", 
        RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.882223935267654*^9, 3.8822240292289267`*^9}, {
   3.882224062882372*^9, 3.882224075291823*^9}, {3.882256967091934*^9, 
   3.8822569678423758`*^9}, {3.882365699388661*^9, 3.8823657290008163`*^9}, {
   3.885501955492528*^9, 3.8855019612873*^9}, 3.885503437715993*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"bc039291-3d44-469a-b9d1-0d4250d6868a"],

Cell["\<\
The following finds the optimal report for a given A and a given scoring rule \
numerically.\
\>", "Text",
 CellChangeTimes->{{3.8940467826558523`*^9, 
  3.8940467965672913`*^9}},ExpressionUUID->"abd03ebf-f933-436f-b261-\
4e4f058c681c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "pmax", "]"}], ";", 
  RowBox[{"Clear", "[", "S", "]"}], ";", 
  RowBox[{"Clear", "[", "A", "]"}], ";", 
  RowBox[{
   RowBox[{"OptReportN", "[", 
    RowBox[{"S_", ",", "A_"}], "]"}], ":=", 
   RowBox[{"Last", "/@", 
    RowBox[{"Last", "@", 
     RowBox[{"NMaximize", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{
           RowBox[{"Array", "[", 
            RowBox[{"pmax", ",", 
             RowBox[{"Length", "[", "A", "]"}]}], "]"}], ",", 
           RowBox[{"A", ".", 
            RowBox[{"Array", "[", 
             RowBox[{"pmax", ",", 
              RowBox[{"Length", "[", "A", "]"}]}], "]"}]}]}], "]"}], ",", 
         RowBox[{"IsDistr", "[", 
          RowBox[{"Array", "[", 
           RowBox[{"pmax", ",", 
            RowBox[{"Length", "[", "A", "]"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"Array", "[", 
        RowBox[{"pmax", ",", 
         RowBox[{"Length", "[", "A", "]"}]}], "]"}], ",", 
       RowBox[{"Method", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<RandomSearch\>\"", ",", 
          RowBox[{"\"\<SearchPoints\>\"", "->", "100"}]}], "}"}]}]}], 
      "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.8822565942077703`*^9, 3.882256607069368*^9}, {
   3.882256673790004*^9, 3.8822566780041513`*^9}, {3.8822567175221157`*^9, 
   3.8822567185897617`*^9}, {3.882256986021538*^9, 3.8822569872863503`*^9}, {
   3.8822574021736593`*^9, 3.8822574424293613`*^9}, 3.882257893711363*^9, {
   3.882257945715246*^9, 3.8822579638897867`*^9}, {3.882258007992942*^9, 
   3.882258037119116*^9}, {3.882268455802174*^9, 3.8822684560367527`*^9}, {
   3.882268729661234*^9, 3.8822687701165867`*^9}, 3.882269189697513*^9, 
   3.882339974449245*^9, 3.88235811139147*^9, {3.882360350274784*^9, 
   3.882360352014279*^9}, 3.882360884251844*^9, {3.882365740237184*^9, 
   3.8823657587757387`*^9}, {3.882376765480731*^9, 3.882376765773559*^9}, 
   3.885503495465309*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"c61d7e58-5349-4d03-a78c-fd44833344c8"],

Cell["\<\
For the Brier scoring rule, we can actually solve for the optimal report \
exactly using Maximize:\
\>", "Text",
 CellChangeTimes->{{3.8823518915566177`*^9, 3.882351907053196*^9}, {
  3.882351940106357*^9, 3.882351954031045*^9}, {3.883960194775137*^9, 
  3.88396019551831*^9}, {3.883962459151019*^9, 3.883962459834552*^9}, {
  3.883963095105036*^9, 
  3.883963095718494*^9}},ExpressionUUID->"9ec41904-5c26-49b9-afb3-\
2b550d559319"],

Cell[BoxData[
 RowBox[{
  RowBox[{"OptReportBrier", "[", "A_", "]"}], ":=", 
  RowBox[{"Last", "/@", 
   RowBox[{"Last", "@", 
    RowBox[{"Maximize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"BrierScore", "[", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{"pmax", ",", 
            RowBox[{"Length", "[", "A", "]"}]}], "]"}], ",", 
          RowBox[{"A", ".", 
           RowBox[{"Array", "[", 
            RowBox[{"pmax", ",", 
             RowBox[{"Length", "[", "A", "]"}]}], "]"}]}]}], "]"}], ",", 
        RowBox[{"IsDistr", "[", 
         RowBox[{"Array", "[", 
          RowBox[{"pmax", ",", 
           RowBox[{"Length", "[", "A", "]"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{"pmax", ",", 
        RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.882351859990102*^9, 3.8823518834086027`*^9}, {
  3.882352047289453*^9, 3.8823520529534903`*^9}, {3.882365763501871*^9, 
  3.882365772248074*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"3eadf192-d187-4ec0-ac6c-178c5f7837b0"],

Cell["\<\
The following definition of the operator norm is from \
https://mathworld.wolfram.com/OperatorNorm.html.\
\>", "Text",
 CellChangeTimes->{{3.882269475550675*^9, 
  3.882269508379169*^9}},ExpressionUUID->"6874576d-c5fe-445e-ab5a-\
653735ecffe1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"OperatorNorm", "[", 
   RowBox[{"a_List", "?", "MatrixQ"}], "]"}], ":=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"Max", "[", 
    RowBox[{"Eigenvalues", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "a", "]"}], ".", "a"}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.882191050304612*^9, 3.8821910503059998`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"270a0f29-44b8-4812-964d-f899b9c5b99d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TangentSpaceOpNorm", "[", "A_", "]"}], ":=", 
  RowBox[{"First", "@", 
   RowBox[{"N", "@", 
    RowBox[{"Maximize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Norm", "[", 
         RowBox[{"A", ".", 
          RowBox[{"Array", "[", 
           RowBox[{"v", ",", 
            RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", 
           RowBox[{"Array", "[", 
            RowBox[{"v", ",", 
             RowBox[{"Length", "[", "A", "]"}]}], "]"}], "]"}], "==", "0"}], "&&", 
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"Array", "[", 
            RowBox[{"v", ",", 
             RowBox[{"Length", "[", "A", "]"}]}], "]"}], "]"}], "<=", 
          "1"}]}]}], "}"}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8839610328332443`*^9, 3.883961073104476*^9}, {
  3.884009080210001*^9, 3.884009088211584*^9}, {3.8848058988617907`*^9, 
  3.8848059173332987`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"82b8f933-55a7-4f58-b90b-176a8a1591ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TangentSpaceOpNormN", "[", "A_", "]"}], ":=", 
  RowBox[{"First", "@", 
   RowBox[{"NMaximize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"A", ".", 
         RowBox[{"Array", "[", 
          RowBox[{"v", ",", 
           RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"Array", "[", 
           RowBox[{"v", ",", 
            RowBox[{"Length", "[", "A", "]"}]}], "]"}], "]"}], "==", "0"}], "&&", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"Array", "[", 
           RowBox[{"v", ",", 
            RowBox[{"Length", "[", "A", "]"}]}], "]"}], "]"}], "<=", 
         "1"}]}]}], "}"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{"v", ",", 
       RowBox[{"Length", "[", "A", "]"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8849811952083073`*^9, 3.8849812050129766`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"83f3ba3f-0ba5-4c88-80d6-aa771c2d3b6c"],

Cell["\<\
For our tests we also use the following function to generate constant \
functions.\
\>", "Text",
 CellChangeTimes->{{3.882350309195903*^9, 
  3.882350344834997*^9}},ExpressionUUID->"208cdb7b-43c8-4b60-b2e7-\
13f6e479fb89"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstantA", "[", "q_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"q", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", 
      RowBox[{"Length", "[", "q", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "q", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8822549862392797`*^9, 3.882255029375733*^9}, {
  3.882365782175639*^9, 3.882365791290975*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"3bd49f14-5583-4a63-8db7-1558f454fc36"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AccuracyBoundBrier", "[", "A_", "]"}], ":=", 
  RowBox[{"TangentSpaceOpNorm", "[", "A", "]"}]}]], "Input",
 CellChangeTimes->{{3.8839602347363367`*^9, 3.883960243222707*^9}, {
  3.884013888724532*^9, 3.8840139217233143`*^9}, {3.884014012234962*^9, 
  3.8840140182174187`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"ba63bfc5-ba4b-4118-a771-787d3012a929"],

Cell[TextData[StyleBox["Tests", "Section"]], "Text",
 CellChangeTimes->{{3.8822228994101067`*^9, 3.882222900103126*^9}, {
  3.883960930594329*^9, 
  3.883960931426955*^9}},ExpressionUUID->"b5dcdf67-e79d-47e7-a453-\
d7222081b353"],

Cell[BoxData[
 RowBox[{
  RowBox[{"testdim", "=", "5"}], ";"}]], "Input",
 CellChangeTimes->{{3.882365986597929*^9, 3.882365994163117*^9}, {
  3.884981299012512*^9, 3.8849812992030067`*^9}, {3.8849816452996387`*^9, 
  3.8849816458452053`*^9}, {3.885428902640172*^9, 3.885428903173379*^9}, {
  3.885500057421289*^9, 3.885500057536455*^9}, {3.885500230276959*^9, 
  3.885500230354475*^9}, {3.885511011399521*^9, 3.885511011481554*^9}, {
  3.885511807215716*^9, 3.885511807335383*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"4a66a0c2-6328-42e5-ae41-d549a8c6232b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"trueFraction", "[", "table_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Count", "[", 
    RowBox[{"table", ",", "True"}], "]"}], "/", 
   RowBox[{"Length", "[", "table", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.885498451098588*^9, 3.885498459532486*^9}, {
  3.885498498556766*^9, 3.885498517284725*^9}, {3.8854987844020643`*^9, 
  3.8854988481457863`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"e9bcb382-6c7c-4d5d-8441-4ba263e50f6f"],

Cell[TextData[StyleBox["Operator norm", "Subsection"]], "Text",
 CellChangeTimes->{{3.882430508727551*^9, 
  3.882430510806621*^9}},ExpressionUUID->"9acd8a7f-f213-49c9-8ab2-\
3ea6b1bb38ab"],

Cell["\<\
Example from \
https://math.stackexchange.com/questions/2670350/operator-norm-calculation-\
for-simple-matrix.\
\>", "Text",
 CellChangeTimes->{{3.88243053021976*^9, 
  3.882430538462434*^9}},ExpressionUUID->"c0109029-748a-4884-994c-\
ebba86f21b1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"OperatorNorm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}], "]"}], "==", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"39", "+", 
    RowBox[{"5", "*", 
     RowBox[{"Sqrt", "[", "53", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882430451663802*^9, 3.882430502473815*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"6bfe6974-c524-4911-9e80-82e764af22e5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.88243047970577*^9, 3.882430503506864*^9}, 
   3.883961244297735*^9, 3.884521744444214*^9, 3.884981301846736*^9, 
   3.8849817318668203`*^9, 3.885428905106443*^9, 3.885497927439433*^9, 
   3.885499614447624*^9, 3.885500061990666*^9, 3.8855002624225693`*^9, 
   3.885503547680674*^9, 3.885503907493313*^9, 3.885511014572421*^9, 
   3.8855121354451647`*^9, 3.8855522902619467`*^9, 3.894046676895176*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"658bf447-925b-434b-88f1-8db7db91c5e7"]
}, Open  ]],

Cell["\<\
Example from https://mathworld.wolfram.com/OperatorNorm.html.\
\>", "Text",
 CellChangeTimes->{{3.882430649999413*^9, 3.882430657020398*^9}, {
  3.885428906275299*^9, 
  3.885428906981535*^9}},ExpressionUUID->"89e66e66-f753-4d76-b4c3-\
68a5a5507f36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"OperatorNorm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}], "==", 
  "4"}]], "Input",
 CellChangeTimes->{{3.882430608373611*^9, 3.882430644648885*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"51e11772-2eb6-4940-b2cb-b60f9d53bc62"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.882430637207906*^9, 3.882430665194345*^9}, 
   3.883961244325268*^9, 3.884521744476739*^9, 3.884981303282818*^9, 
   3.884981733301523*^9, 3.885428908354589*^9, 3.885497929677492*^9, 
   3.885499615966538*^9, 3.885500064914507*^9, 3.8855002624995003`*^9, 
   3.8855035491795673`*^9, 3.885511039674656*^9, 3.88551213567603*^9, 
   3.885552291991675*^9, 3.8940466769418497`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"220b54da-fad1-457b-94af-6decd1fbd55a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"OperatorNorm", "[", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "]"}], "==", 
    RowBox[{"Abs", "[", "a", "]"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"a", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882430668704399*^9, 3.882430728920732*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"c63b2baa-371e-403c-9eec-ca877bc79a52"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8824306774428883`*^9, 3.882430729376556*^9}, 
   3.883961244355853*^9, 3.884521744602024*^9, 3.884981306788974*^9, 
   3.8849817357412033`*^9, 3.885428909877248*^9, 3.88549793168438*^9, 
   3.885499617293091*^9, 3.885500086533297*^9, 3.88550026261281*^9, 
   3.885503550185014*^9, 3.8855110400423517`*^9, 3.885512136103883*^9, 
   3.885552293506428*^9, 3.8940466770491533`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"7bf5c319-5183-43c1-9f0f-cbcfdb8661c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TangentSpaceOpNorm", "[", 
   RowBox[{"IdentityMatrix", "[", "3", "]"}], "]"}], "==", "1"}]], "Input",
 CellChangeTimes->{{3.8839611166154346`*^9, 3.883961124933494*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"e81e4cfa-b334-40dc-94a2-16ad3a989a31"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.883961121722076*^9, 3.8839611259193907`*^9}, 
   3.883961244435987*^9, 3.884521744730603*^9, 3.8849813091421757`*^9, 
   3.884981737711074*^9, 3.88542891136698*^9, 3.8854979333685303`*^9, 
   3.88549961854799*^9, 3.8855000869123917`*^9, 3.8855002627432823`*^9, 
   3.8855035514561157`*^9, 3.885511040179316*^9, 3.885512136799464*^9, 
   3.885552294630178*^9, 3.894046677152699*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"df6fa323-646e-439c-8cd4-1ed08cb96627"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "2", "]"}]}], ";", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"TangentSpaceOpNorm", "[", "A", "]"}], "-", 
         RowBox[{"TangentSpaceOpNormN", "[", "A", "]"}]}], "]"}], "<", 
       "0.00001"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "60"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.884981324443124*^9, 3.884981497748065*^9}, {
   3.88498153024292*^9, 3.8849815337121897`*^9}, 3.885503566824339*^9, {
   3.885552514941967*^9, 3.885552516168729*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"f05e6e36-044b-40f5-8b05-85eec96e2289"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.57681`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8849814062264023`*^9, 3.88498150091825*^9}, 
   3.884981590159877*^9, 3.884981792812468*^9, 3.885429022008121*^9, 
   3.885497993703989*^9, 3.8854997026561127`*^9, 3.885500178724099*^9, 
   3.8855003441192093`*^9, {3.885503563826056*^9, 3.8855035730079937`*^9}, 
   3.8855110448567266`*^9, 3.8855121420996027`*^9, 3.885552302789197*^9, 
   3.885552524327407*^9, 3.8940466827441874`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"164b0e73-e0ac-489e-bb0d-98010c5e66b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "3", "]"}]}], ";", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"TangentSpaceOpNorm", "[", "A", "]"}], "-", 
         RowBox[{"TangentSpaceOpNormN", "[", "A", "]"}]}], "]"}], "<", 
       "0.00001"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "35"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.884981506886527*^9, 3.884981523752473*^9}, {
  3.884981601861514*^9, 3.884981602834476*^9}, {3.885552527130486*^9, 
  3.885552528068331*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"4c03a6ab-0d9e-44a1-a6cb-a92562a7a1a3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11.028624`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.884981514977881*^9, 3.884981601261116*^9, 
  3.884981637821137*^9, 3.884981802477737*^9, 3.885429031993717*^9, 
  3.885499713787731*^9, 3.885500189346054*^9, 3.8855003542713413`*^9, 
  3.8855035862639303`*^9, 3.885511055165966*^9, 3.885512153187237*^9, 
  3.8855523323992167`*^9, 3.8855523825311117`*^9, 3.885552428902875*^9, 
  3.88555253911805*^9, 3.894046693994302*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"7986878b-09cc-493a-b903-8ff6c5ad0c0f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "4", "]"}]}], ";", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"TangentSpaceOpNorm", "[", "A", "]"}], "-", 
         RowBox[{"TangentSpaceOpNormN", "[", "A", "]"}]}], "]"}], "<", 
       "0.00001"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "25"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.88498151502159*^9, 3.884981520739595*^9}, {
  3.884981632286704*^9, 3.884981633292411*^9}, {3.8855525314451723`*^9, 
  3.8855525355177307`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"ae05c6e2-7548-4a58-b704-bdf4accb0515"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"33.877082`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.884981525415902*^9, 3.884981628159486*^9, 
  3.884981672897249*^9, 3.884981838707491*^9, 3.885429067333103*^9, 
  3.885499726994589*^9, 3.885500201448749*^9, 3.885500367259087*^9, 
  3.8855036249672527`*^9, 3.885511087282695*^9, 3.8855121936557703`*^9, 
  3.885552360786727*^9, 3.88555246539225*^9, 3.885552565358803*^9, 
  3.894046727915391*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"a127322a-ef05-4f60-8513-e7c74b437696"]
}, Open  ]],

Cell[TextData[StyleBox["Probability distributions", "Subsection"]], "Text",
 CellChangeTimes->{{3.882269536025405*^9, 
  3.882269539075466*^9}},ExpressionUUID->"6dc0f605-1ae0-4474-b9f9-\
3acfb8a9f6e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsDistr", "[", 
  RowBox[{"uniform", "[", "testdim", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.882222961155459*^9, 3.8822229647377453`*^9}, {
  3.882365797495226*^9, 3.882365802186902*^9}, {3.882365874859762*^9, 
  3.882365875016944*^9}, {3.8823659983657017`*^9, 3.882365998555813*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"6c9fc37b-ad46-47a6-bdfb-a4fb0d6b8973"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.882222965828526*^9, 3.882257290835474*^9, 3.8822685060445967`*^9, 
   3.882268982219459*^9, 3.882291618600157*^9, 3.882293747287591*^9, 
   3.8823371975952787`*^9, 3.8823380828736753`*^9, 3.882339982315681*^9, 
   3.882344999488387*^9, 3.8823461549138412`*^9, 3.8823462590807257`*^9, 
   3.882346373685755*^9, 3.882346466004751*^9, 3.8823468756555643`*^9, 
   3.8823472372531776`*^9, 3.882349183971704*^9, 3.882350365506629*^9, 
   3.8823534079133*^9, 3.882365802882617*^9, {3.882365855682419*^9, 
   3.8823658756451797`*^9}, 3.8823666353673143`*^9, 3.882367118324541*^9, 
   3.8823671670315742`*^9, 3.882376473525754*^9, 3.88237661093517*^9, 
   3.883961244454528*^9, 3.8845217447639513`*^9, 3.88498183878438*^9, 
   3.885429067392301*^9, 3.885499727210017*^9, 3.885500201549961*^9, 
   3.885500367377681*^9, 3.885503625161387*^9, 3.88551108749923*^9, 
   3.885512193893396*^9, {3.885552565386673*^9, 3.88555257129517*^9}, 
   3.8940467279715033`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"eab3bed4-ffc1-40bb-9285-2e45cb6bab48"]
}, Open  ]],

Cell["The following should look roughly uniform.", "Text",
 CellChangeTimes->{{3.8854998855215273`*^9, 
  3.885499895875593*^9}},ExpressionUUID->"66d4e9ab-4259-4c88-8ea9-\
0e554cee8db3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RandomDistr", "[", "3", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "2"}], "]"}], "]"}], ",", "10000"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8854997577593117`*^9, 3.885499791077456*^9}, {
  3.885499830729589*^9, 3.885499873257491*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"e724b586-ffc9-4389-b2b7-31120086c1f9"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.003666666666666667], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxk3X2M5WlWF/AJIYYQQgghiogIiqAhhBBDCCHkF0RURBTBEEII2RA0mw0C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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.991}, {0, 0.986}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8854997778973017`*^9, 3.88549978739568*^9}, {
   3.885499832790557*^9, 3.88549987421078*^9}, 3.885500201822538*^9, 
   3.885500367683601*^9, 3.885503626201764*^9, 3.885511088294672*^9, 
   3.8855121945115013`*^9, 3.8855525736958303`*^9, 3.894046728662402*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"4ee0cfd4-11ec-48be-89fd-11fa1fd78372"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RandomDistr", "[", "4", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "3"}], "]"}], "]"}], ",", "3000"}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.8855037663100863`*^9, 3.885503781097682*^9}, {
  3.885503845498427*^9, 3.885503845613042*^9}, {3.885503916987115*^9, 
  3.885503917366832*^9}, {3.885503965157185*^9, 3.885503995334178*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"7c21eead-b6d6-42b2-ae00-0b585eb4e8e1"],

Cell[BoxData[
 Graphics3DBox[{{
    {RGBColor[0.3315753, 0.4561011, 0.6388182], PointSize[
     0.006944444444444445], Point3DBox[CompressedData["
1:eJx13XuMZdl1FvBRiKIoRFFkRSEYCCSElyIURQhFEYqOIEAAY5g8FEXIQiML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      "]]}, {}, {}}, {}},
  Axes->True,
  AxesLabel->{None, None, None},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{350.0638510922421, 184.7744308859776},
  ImageSizeRaw->Automatic,
  Lighting->{{"Ambient", 
     GrayLevel[0.5]}, {"Directional", 
     GrayLevel[0.5], 
     ImageScaled[{0, 2, 2}]}, {"Directional", 
     GrayLevel[0.5], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.5], 
     ImageScaled[{2, 0, 2}]}},
  PlotRange->{{0., 0.941}, {0., 0.909}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{3.1788740784999647`, 1.0114662473254725`, 0.5671821784597268},
  ViewVertical->{0.20174854027230885`, 0.01826393460229953, 
   0.9792670499873033}]], "Output",
 CellChangeTimes->{
  3.885503784441128*^9, 3.885503918160849*^9, {3.8855039703677073`*^9, 
   3.885503996252388*^9}, 3.885511088868054*^9, 3.885512194896893*^9, 
   3.885552585456801*^9, 3.894046729240694*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"fd2fd91c-18fa-4235-b4b3-f7cb5341e3c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IsDistr", "[", 
     RowBox[{"RandomDistr", "[", "testdim", "]"}], "]"}], ",", "100"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.882223641831513*^9, 3.882223663629624*^9}, 
   3.882337524933847*^9, 3.882338064510067*^9, 3.882365860676237*^9, {
   3.88236600016886*^9, 3.882366000405305*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"9c9a5756-efbc-40fb-a086-e349a1cb319a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8822236434825087`*^9, 3.882223664116026*^9}, 
   3.882257291969719*^9, 3.882268506852215*^9, 3.882268982938896*^9, 
   3.882291619610736*^9, 3.882293747432418*^9, 3.8823372013918257`*^9, 
   3.882338082918524*^9, 3.8823399823498373`*^9, 3.882345000236559*^9, 
   3.882346155752634*^9, 3.8823462591223803`*^9, 3.882346373733766*^9, 
   3.882346466046167*^9, 3.882346875694538*^9, 3.882347237281289*^9, 
   3.882349184000937*^9, 3.882350365541958*^9, 3.882353407943651*^9, {
   3.8823658649402103`*^9, 3.8823658763827047`*^9}, 3.882366635402622*^9, 
   3.88236711835993*^9, 3.882367167069029*^9, 3.882376473583619*^9, 
   3.882376610994412*^9, 3.883961244472787*^9, 3.8845217447970533`*^9, 
   3.884981838819579*^9, 3.885429067413237*^9, 3.885499727759429*^9, 
   3.885500201924171*^9, 3.885500367766371*^9, 3.885504007836335*^9, 
   3.885511088959359*^9, 3.8855121951156893`*^9, 3.88555259427428*^9, 
   3.894046729473153*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"7dcb9690-e6e2-46e6-84c3-6c7cf20617bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IsDistr", "[", 
     RowBox[{
      RowBox[{"RandomA", "[", "testdim", "]"}], ".", 
      RowBox[{"RandomDistr", "[", "testdim", "]"}]}], "]"}], ",", "1000"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8821761861818132`*^9, 3.882176210183372*^9}, {
   3.882223506147407*^9, 3.882223528234477*^9}, 3.882223667214883*^9, 
   3.882337523272077*^9, {3.88236587161662*^9, 3.8823658730125227`*^9}, {
   3.882366001504273*^9, 3.882366004517253*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"30afd8a1-8b6a-48d5-90a4-42d41d4d9cb2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.882223511890276*^9, 3.8822235286846657`*^9}, 
   3.882223669342896*^9, 3.882257294279402*^9, 3.8822685082902203`*^9, 
   3.882268984409534*^9, 3.882291623294404*^9, 3.88229374875307*^9, 
   3.882337202932209*^9, 3.8823380830267572`*^9, 3.882339982462709*^9, 
   3.882345000836584*^9, 3.882346156572887*^9, 3.8823462592453337`*^9, 
   3.8823463739094343`*^9, 3.8823464661632547`*^9, 3.8823468758034077`*^9, 
   3.882347237410375*^9, 3.882349184154373*^9, 3.8823503657028313`*^9, 
   3.88235340801868*^9, 3.8823658771148252`*^9, 3.882366635542357*^9, 
   3.8823671185225153`*^9, 3.882367167208735*^9, 3.882376473796928*^9, 
   3.882376611207501*^9, 3.883961244598858*^9, 3.8845217449668283`*^9, 
   3.884981838966064*^9, 3.8854290675353117`*^9, 3.885498148255727*^9, 
   3.885499755875786*^9, 3.885500205003812*^9, 3.885500368409194*^9, 
   3.885504010149075*^9, 3.885511089359879*^9, 3.8855121965732327`*^9, 
   3.885552599326498*^9, 3.894046731522223*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"d78a1249-32f9-4747-9d6d-f3d5be7a7631"]
}, Open  ]],

Cell["\<\
The following lets Mathematica show symbolically that constantA works as \
intended, i.e., that constantA[q].p=q for any distributions q and p.\
\>", "Text",
 CellChangeTimes->{{3.882255278434679*^9, 
  3.882255333129743*^9}},ExpressionUUID->"d54c6a41-2ea7-4a44-a7c1-\
4b2eea4c0584"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "q", "]"}], ";", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ConstantA", "[", 
       RowBox[{"Array", "[", 
        RowBox[{"q", ",", "testdim"}], "]"}], "]"}], ".", 
      RowBox[{"Array", "[", 
       RowBox[{"p", ",", "testdim"}], "]"}]}], ",", 
     RowBox[{"IsDistr", "[", 
      RowBox[{"Array", "[", 
       RowBox[{"p", ",", "testdim"}], "]"}], "]"}]}], "]"}], "==", 
   RowBox[{"Array", "[", 
    RowBox[{"q", ",", "testdim"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8822551354897413`*^9, 3.882255233275403*^9}, {
  3.882357150316638*^9, 3.8823571542933807`*^9}, {3.882365884944831*^9, 
  3.8823658936111526`*^9}, {3.882366009043738*^9, 3.882366018761866*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"de6263a4-990a-4613-837f-00f3bac289ef"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.882255149949492*^9, 3.882255233738974*^9}, 
   3.882257299521391*^9, 3.882268542643695*^9, {3.882268778370998*^9, 
   3.882268800544997*^9}, 3.8822690471829853`*^9, 3.882291623390129*^9, 
   3.882293748805114*^9, 3.8823372031401653`*^9, 3.882338083128852*^9, 
   3.882339982512257*^9, 3.8823461589040937`*^9, 3.882346259287527*^9, 
   3.8823463739459057`*^9, 3.882346466268581*^9, 3.882346875907349*^9, 
   3.88234723743822*^9, 3.882349184225807*^9, 3.8823503657882233`*^9, 
   3.88235340804742*^9, {3.8823571332648067`*^9, 3.8823571569190807`*^9}, 
   3.8823658956693277`*^9, 3.882366635649969*^9, 3.882367118578109*^9, 
   3.882367167290888*^9, 3.882376473971572*^9, 3.882376611349271*^9, 
   3.883961244619746*^9, 3.8845217450058413`*^9, 3.884981839013837*^9, 
   3.885429067562624*^9, 3.885499756103519*^9, 3.885500205133189*^9, 
   3.885500368539819*^9, 3.8855040128370132`*^9, 3.8855110895708237`*^9, 
   3.885512196745551*^9, 3.885552603015211*^9, 3.89404673157512*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"fcc688d6-1a4a-4e15-a23f-742abb9adb58"]
}, Open  ]],

Cell[TextData[StyleBox["Scoring rules", "Subsection"]], "Text",
 CellChangeTimes->{{3.882269566856844*^9, 
  3.8822695687922297`*^9}},ExpressionUUID->"f2aac8c7-1a18-4fe0-a3be-\
49a79025d8f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.23"}], "<=", 
  RowBox[{"LogScore", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.8", ",", "0.2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "<=", 
  RowBox[{"-", "0.21"}]}]], "Input",
 CellChangeTimes->{{3.8823483825632133`*^9, 3.882348394244912*^9}, {
  3.88234843722009*^9, 3.882348442355185*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"05111001-323d-47e1-ad50-250ddbba09a2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.88234839503968*^9, {3.8823484288424397`*^9, 3.882348443114299*^9}, 
   3.8823491842540007`*^9, 3.882350368175481*^9, 3.882353408079895*^9, 
   3.882365898366247*^9, 3.882366635688245*^9, 3.8823671186143017`*^9, 
   3.882367167349181*^9, 3.882376474168524*^9, 3.882376611423914*^9, 
   3.8839612446432533`*^9, 3.884521745040349*^9, 3.884981839055739*^9, 
   3.8854290675808764`*^9, 3.8855002052184153`*^9, 3.885500368608873*^9, 
   3.8855040153106947`*^9, 3.885511089674693*^9, 3.885512196855171*^9, 
   3.885552605645032*^9, 3.894046731605124*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"3e153567-4f1d-4709-a7f4-dfabfafa4fca"]
}, Open  ]],

Cell[TextData[StyleBox["Log scoring rule degenerate cases", \
"Subsubsection"]], "Text",
 CellChangeTimes->{{3.882346775588216*^9, 
  3.882346800914317*^9}},ExpressionUUID->"55b3816c-e93d-4fa2-8e67-\
c3f3e6051394"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"logscoreh", "[", 
     RowBox[{"0", ",", "x"}], "]"}], ",", 
    RowBox[{"x", ">", "0"}]}], "]"}], "==", 
  RowBox[{"-", "\[Infinity]"}]}]], "Input",
 CellChangeTimes->{{3.8823462828606052`*^9, 3.882346287192322*^9}, {
  3.8823464787698183`*^9, 3.882346483140053*^9}, {3.882346804588519*^9, 
  3.882346812104271*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"4a53cff5-3071-4a9a-ae7e-f1f2c795f4dc"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.882346516944612*^9, 3.882346812989958*^9, 
  3.882346875958169*^9, 3.8823472374663353`*^9, 3.882349184296653*^9, 
  3.8823503684468527`*^9, 3.882353408109273*^9, 3.8823659016302156`*^9, 
  3.8823666357252073`*^9, 3.882367118650915*^9, 3.882367167388335*^9, 
  3.88237647425716*^9, 3.8823766114682617`*^9, 3.883961244663457*^9, 
  3.884521745071282*^9, 3.884981839099115*^9, 3.885429067599353*^9, 
  3.8855002052915*^9, 3.885500368683607*^9, 3.885504016427301*^9, 
  3.8855110897915297`*^9, 3.8855121969979343`*^9, 3.885552608667671*^9, 
  3.894046731635294*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"e81a77b1-ff2d-46ab-8e4b-e70a0e30a50c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"logscoreh", "[", 
   RowBox[{"1", ",", "0"}], "]"}], "==", "0"}]], "Input",
 CellChangeTimes->{{3.882346289398778*^9, 3.882346299162813*^9}, {
  3.88234648878592*^9, 3.882346518343493*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"f8186337-1080-4d0f-aff4-2b6bb890260f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.882346294996024*^9, 3.882346299774252*^9}, 
   3.882346374020419*^9, 3.882346466393167*^9, 3.882346518709091*^9, 
   3.882346875995748*^9, 3.882347237494397*^9, 3.882349184323224*^9, 
   3.882350368483822*^9, 3.8823534081392937`*^9, 3.882365902548847*^9, 
   3.882366635763432*^9, 3.882367118686388*^9, 3.882367167426284*^9, 
   3.882376474346204*^9, 3.882376611538321*^9, 3.883961244681553*^9, 
   3.8845217452331467`*^9, 3.884981839144945*^9, 3.885429067617414*^9, 
   3.885500205371326*^9, 3.885500368765635*^9, 3.885504017806528*^9, 
   3.885511089906986*^9, 3.88551219713661*^9, 3.885552610173295*^9, 
   3.894046731664559*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"a24ed4f8-abee-456a-b9db-eef4280c574b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"logscoreh", "[", 
   RowBox[{"0", ",", "0"}], "]"}], "==", "0"}]], "Input",
 CellChangeTimes->{{3.8823463010500927`*^9, 3.8823463069474688`*^9}, {
  3.882346497335453*^9, 3.882346497795926*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"767f3c63-5cdb-4f5f-893a-01160ddc0ee7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.882346303928061*^9, 3.882346307259513*^9}, 
   3.882346374056254*^9, 3.882346466424809*^9, 3.8823465147023897`*^9, 
   3.882346876048141*^9, 3.882347237521659*^9, 3.8823491843499517`*^9, 
   3.882350368517852*^9, 3.882353408169097*^9, 3.882365903412485*^9, 
   3.8823666358154182`*^9, 3.882367118720261*^9, 3.882367167465886*^9, 
   3.88237647443887*^9, 3.882376611700993*^9, 3.883961244702765*^9, 
   3.884521745279701*^9, 3.884981839191409*^9, 3.8854290676343393`*^9, 
   3.885500205449808*^9, 3.885500368847334*^9, 3.885504030733925*^9, 
   3.885511090021579*^9, 3.885512197273473*^9, 3.885552612800667*^9, 
   3.8940467316938877`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"89c21613-1c10-431b-bc73-a84ab2ed0276"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LogScore", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], "==", "0"}]], "Input",\

 CellChangeTimes->{{3.882357266578905*^9, 3.8823572692028017`*^9}, {
  3.882357445775632*^9, 3.8823574462019*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"a077a830-676e-4845-a9f7-19513786400f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.882357270116708*^9, 3.882365904524*^9, 
  3.882366635851233*^9, 3.882367118759948*^9, 3.882367167520467*^9, 
  3.882376474483037*^9, 3.882376611766589*^9, 3.8839612447225*^9, 
  3.884521745322456*^9, 3.8849818392416487`*^9, 3.885429067652216*^9, 
  3.885500205521771*^9, 3.885500368864993*^9, 3.885504030867337*^9, 
  3.88551109013687*^9, 3.8855121974141827`*^9, 3.8855526136680183`*^9, 
  3.8940467317233143`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"757d9bb5-fad6-4416-993d-23ed6d6a98e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LogScore", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
    RowBox[{"uniform", "[", "3", "]"}]}], "]"}], "==", 
  RowBox[{"-", "\[Infinity]"}]}]], "Input",
 CellChangeTimes->{{3.882357266578905*^9, 3.8823572692028017`*^9}, {
  3.882357445775632*^9, 3.8823574784017067`*^9}, {3.8823659119887247`*^9, 
  3.8823659148923264`*^9}, {3.882366026251642*^9, 3.882366034121994*^9}, {
  3.882367229897086*^9, 3.8823672338665333`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"d137ea22-3fe7-4399-a086-a562f4ea015f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.882357472272121*^9, 3.8823574787593727`*^9}, {
   3.8823659056837606`*^9, 3.8823659165593557`*^9}, 3.8823660362124557`*^9, 
   3.882366635889563*^9, 3.882367118794488*^9, 3.8823671675595303`*^9, 
   3.882367462195644*^9, 3.88237647455127*^9, 3.882376611838994*^9, 
   3.8839612447418547`*^9, 3.884521745345798*^9, 3.8849818392847652`*^9, 
   3.885429067669993*^9, 3.88550020560054*^9, 3.885500368951885*^9, 
   3.885504030939129*^9, 3.885511090249611*^9, 3.885512197445245*^9, 
   3.885552614438208*^9, 3.894046731752655*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"084a443a-9f62-4392-b0ec-be67da6cc338"]
}, Open  ]],

Cell[TextData[StyleBox["Propriety", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.882346757278256*^9, 
  3.882346759620695*^9}},ExpressionUUID->"a5b3381e-5bc7-4e32-acde-\
6e2ae37355f9"],

Cell["\<\
We here test that the scoring rules we defined are indeed proper. We do this \
specifically by making sure that if the environment probability is a fixed \
distribution q, then the optimal report is q.\
\>", "Text",
 CellChangeTimes->{{3.882291348831973*^9, 3.882291435732092*^9}, {
  3.882349246194915*^9, 3.8823492542905703`*^9}, {3.882357704269397*^9, 
  3.882357704668198*^9}, {3.894046851223226*^9, 
  3.8940468514839277`*^9}},ExpressionUUID->"2e321a92-5669-472e-9ca8-\
ef13a71a2916"],

Cell["LogScore:", "Text",
 CellChangeTimes->{{3.882357732295587*^9, 
  3.8823577402283077`*^9}},ExpressionUUID->"41977bd3-f400-4807-8edd-\
b13e2913870b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "p", "]"}], ";", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Last", "/@", 
     RowBox[{"Last", "@", 
      RowBox[{"Maximize", "[", 
       RowBox[{
        RowBox[{"LogScore", "[", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{"p", ",", "testdim"}], "]"}], ",", 
          RowBox[{"uniform", "[", "testdim", "]"}]}], "]"}], ",", 
        RowBox[{"IsDistr", "[", 
         RowBox[{"Array", "[", 
          RowBox[{"p", ",", "testdim"}], "]"}], "]"}], ",", 
        RowBox[{"Array", "[", 
         RowBox[{"p", ",", "testdim"}], "]"}]}], "]"}]}]}], "]"}], "==", 
   RowBox[{"uniform", "[", "testdim", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8821768319434566`*^9, 3.882176896053355*^9}, {
  3.8821772792842484`*^9, 3.882177350083803*^9}, {3.8821774508775177`*^9, 
  3.882177457472117*^9}, {3.8821777484136267`*^9, 3.882177759200203*^9}, {
  3.882223000459217*^9, 3.88222301658304*^9}, {3.882269008588173*^9, 
  3.882269040117248*^9}, {3.882291173634514*^9, 3.882291212152443*^9}, {
  3.8823472767870502`*^9, 3.882347280267878*^9}, {3.882365924477523*^9, 
  3.8823659619733877`*^9}, {3.882366039854124*^9, 3.882366049469368*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"fd4ac32f-5316-444e-93b2-efdbf4464fdf"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.8821773715934896`*^9, {3.882177458100724*^9, 3.882177469832679*^9}, 
   3.882177559795746*^9, {3.8821777493273897`*^9, 3.882177788215457*^9}, 
   3.88217784687241*^9, 3.8821781032368717`*^9, 3.882178384111834*^9, {
   3.882191077539382*^9, 3.882191110204965*^9}, 3.882191557044149*^9, 
   3.882191618659542*^9, 3.882193140270051*^9, 3.8821933899754887`*^9, 
   3.882193467847395*^9, 3.882222835768322*^9, {3.882223002604327*^9, 
   3.882223017094091*^9}, 3.882257295942309*^9, {3.882268510256302*^9, 
   3.882268526998179*^9}, {3.8822689847079773`*^9, 3.882268991785026*^9}, {
   3.882269022448184*^9, 3.882269040340012*^9}, {3.882291174400331*^9, 
   3.882291212793375*^9}, 3.882291623745306*^9, 3.882293748956849*^9, 
   3.882337203522389*^9, 3.8823380834539547`*^9, 3.8823399825625343`*^9, 
   3.8823450039498463`*^9, 3.882346259375821*^9, 3.882346374151966*^9, 
   3.882346466889501*^9, 3.88234687654401*^9, 3.882347237721068*^9, 
   3.882347423824315*^9, 3.8823491846146297`*^9, 3.882350368860983*^9, 
   3.88235340826398*^9, {3.8823659328778877`*^9, 3.882365963573477*^9}, 
   3.882366050735333*^9, 3.8823666361106*^9, 3.882367118871911*^9, 
   3.88236716778347*^9, 3.882376474798092*^9, 3.882376612237321*^9, 
   3.883961244997966*^9, 3.884521745660965*^9, 3.8849818393849154`*^9, 
   3.885429067862214*^9, 3.8855002057915907`*^9, 3.885500369084402*^9, 
   3.885504031271194*^9, 3.8855110904379683`*^9, 3.8855121977188473`*^9, 
   3.8855526171332703`*^9, 3.894046731920725*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"07186c32-ae0c-4877-ad34-3793a6811e8d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "p", "]"}], ";", 
  RowBox[{"AbsoluteTiming", "[", 
   RowBox[{"trueFraction", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"q", "=", 
        RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
       RowBox[{
        RowBox[{
         RowBox[{"N", "@", "Last"}], "/@", 
         RowBox[{"Last", "@", 
          RowBox[{"Maximize", "[", 
           RowBox[{
            RowBox[{"LogScore", "[", 
             RowBox[{
              RowBox[{"Array", "[", 
               RowBox[{"p", ",", "testdim"}], "]"}], ",", "q"}], "]"}], ",", 
            RowBox[{"IsDistr", "[", 
             RowBox[{"Array", "[", 
              RowBox[{"p", ",", "testdim"}], "]"}], "]"}], ",", 
            RowBox[{"Array", "[", 
             RowBox[{"p", ",", "testdim"}], "]"}]}], "]"}]}]}], "==", 
        RowBox[{"N", "@", "q"}]}]}], ",", "500"}], "]"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.88236760686965*^9, 3.8823676989750433`*^9}, 
   3.882367775171427*^9, {3.882376566908531*^9, 3.8823765677059*^9}, {
   3.885498542977564*^9, 3.885498548968095*^9}, {3.885499994402563*^9, 
   3.885500014155444*^9}, {3.885500573538926*^9, 3.885500612989489*^9}, {
   3.8855006777200527`*^9, 3.885500679065682*^9}, {3.885504058715622*^9, 
   3.885504088597624*^9}, {3.885504148550872*^9, 3.885504148712285*^9}, {
   3.88550419836788*^9, 3.885504198525457*^9}, {3.885504234206397*^9, 
   3.885504234316579*^9}, {3.885552674492613*^9, 3.8855526755203533`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"eda06d8d-112f-47fc-9de8-a48e9acf17e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"61.61833`", ",", 
   FractionBox["497", "500"]}], "}"}]], "Output",
 CellChangeTimes->{{3.8855005949071703`*^9, 3.885500631317195*^9}, 
   3.885500697137608*^9, {3.8855040864827642`*^9, 3.885504099481875*^9}, 
   3.88550416226514*^9, {3.885504210010474*^9, 3.885504228467516*^9}, 
   3.885504308727127*^9, 3.8855043816913567`*^9, 3.885511126936673*^9, 
   3.885512254615097*^9, 3.885552668452827*^9, 3.885552727389817*^9, 
   3.89404679359157*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"1e9fa2e9-d95d-4cc9-a8b5-d35f2850de2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"trueFraction", "@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
      RowBox[{
       RowBox[{"N", "/@", 
        RowBox[{"Last", "/@", 
         RowBox[{"Last", "@", 
          RowBox[{"Maximize", "[", 
           RowBox[{
            RowBox[{"LogScore", "[", 
             RowBox[{
              RowBox[{"Array", "[", 
               RowBox[{"p", ",", "testdim"}], "]"}], ",", "q"}], "]"}], ",", 
            RowBox[{"IsDistr", "[", 
             RowBox[{"Array", "[", 
              RowBox[{"p", ",", "testdim"}], "]"}], "]"}], ",", 
            RowBox[{"Array", "[", 
             RowBox[{"p", ",", "testdim"}], "]"}]}], "]"}]}]}]}], "==", 
       "q"}]}], ",", "1000"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.885499930906002*^9, 3.8854999606677847`*^9}, {
   3.8855006543784018`*^9, 3.885500739421521*^9}, {3.885504357164691*^9, 
   3.885504376841516*^9}, {3.885504641670982*^9, 3.8855046418738213`*^9}, 
   3.885504920884561*^9, {3.8855531121108017`*^9, 3.885553113096977*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"de44aca1-900d-40b1-b91d-1c4d1820d5fb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"124.967157`", ",", 
   FractionBox["124", "125"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8823673470631647`*^9, 3.8823764435582113`*^9, 3.882376565266773*^9, 
   3.882376704269834*^9, 3.883961349828923*^9, 3.885429231236658*^9, 
   3.885499965376774*^9, 3.8855003722252483`*^9, {3.885500648814646*^9, 
   3.885500669129003*^9}, {3.88550069927862*^9, 3.885500756731179*^9}, 
   3.885504425381113*^9, 3.885504552341503*^9, 3.8855047918898497`*^9, 
   3.885505046627775*^9, 3.885505336175707*^9, 3.885511208448807*^9, 
   3.885512370958778*^9, 3.885553212216585*^9, 3.894046918684145*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"89447c1a-022a-4fca-9955-8582540fdc28"]
}, Open  ]],

Cell["BrierScore:", "Text",
 CellChangeTimes->{{3.8823577447851152`*^9, 
  3.8823577466030912`*^9}},ExpressionUUID->"defb7954-b9b8-46b0-a898-\
357fb45c2b0c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "p", "]"}], ";", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Last", "/@", 
     RowBox[{"Last", "@", 
      RowBox[{"Maximize", "[", 
       RowBox[{
        RowBox[{"BrierScore", "[", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{"p", ",", "testdim"}], "]"}], ",", 
          RowBox[{"uniform", "[", "testdim", "]"}]}], "]"}], ",", 
        RowBox[{"IsDistr", "[", 
         RowBox[{"Array", "[", 
          RowBox[{"p", ",", "testdim"}], "]"}], "]"}], ",", 
        RowBox[{"Array", "[", 
         RowBox[{"p", ",", "testdim"}], "]"}]}], "]"}]}]}], "]"}], "==", 
   RowBox[{"uniform", "[", "testdim", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8823486156508007`*^9, 3.882348616662074*^9}, {
  3.882366084790759*^9, 3.8823661031197*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"5f8494f4-9290-428f-a89f-fbcfad210bc3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.882348617219365*^9, 3.882349043619019*^9, 3.8823491846580544`*^9, 
   3.882350368934409*^9, 3.882353408299717*^9, {3.882366098744697*^9, 
   3.882366104122388*^9}, 3.8823666404126053`*^9, 3.882367127178747*^9, 
   3.882367177659896*^9, 3.8823765654402037`*^9, 3.8823767043501453`*^9, 
   3.883961349926119*^9, 3.885429231324724*^9, 3.8855003724012213`*^9, 
   3.8855007568982153`*^9, 3.885505336350746*^9, 3.885511208668229*^9, 
   3.885512371213904*^9, 3.88555321230485*^9, 3.894046918780756*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"948e349d-662c-4073-8d2e-6514cba6cd6f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"trueFraction", "@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
      RowBox[{
       RowBox[{"N", "[", 
        RowBox[{"Last", "/@", 
         RowBox[{"Last", "@", 
          RowBox[{"Maximize", "[", 
           RowBox[{
            RowBox[{"BrierScore", "[", 
             RowBox[{
              RowBox[{"Array", "[", 
               RowBox[{"p", ",", "testdim"}], "]"}], ",", "q"}], "]"}], ",", 
            RowBox[{"IsDistr", "[", 
             RowBox[{"Array", "[", 
              RowBox[{"p", ",", "testdim"}], "]"}], "]"}], ",", 
            RowBox[{"Array", "[", 
             RowBox[{"p", ",", "testdim"}], "]"}]}], "]"}]}]}], "]"}], "==", 
       "q"}]}], ",", "100"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8823486294509277`*^9, 3.8823486311750193`*^9}, {
   3.88236610921066*^9, 3.882366120156814*^9}, {3.882366554041154*^9, 
   3.882366556521572*^9}, {3.882366673555387*^9, 3.882366675036578*^9}, {
   3.8855007684186697`*^9, 3.885500804351623*^9}, {3.885505277968515*^9, 
   3.8855052851038733`*^9}, 3.885510094633583*^9, {3.885553120317173*^9, 
   3.885553121181031*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"5b4d6d27-5fd6-4fe3-998a-3f76d33b603f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.530715`", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.882348633049509*^9, {3.882349049232799*^9, 3.882349053127915*^9}, 
   3.8823491881646852`*^9, 3.882350373121908*^9, 3.882353410201734*^9, 
   3.882366121770773*^9, 3.882366641051073*^9, 3.882367129684065*^9, 
   3.8823671798478622`*^9, 3.882376567502987*^9, 3.8823767065757837`*^9, 
   3.8839613527232103`*^9, 3.885429234420188*^9, 3.8855003727345343`*^9, {
   3.885500760176651*^9, 3.885500807706654*^9}, 3.8855053606793823`*^9, 
   3.8855112108541317`*^9, 3.885512373689128*^9, 3.8855532141315527`*^9, 
   3.894046922320307*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"ce4c3e71-5c34-403a-af55-222d2f0744da"]
}, Open  ]],

Cell[TextData[StyleBox["Finding fixed points", "Subsection"]], "Text",
 CellChangeTimes->{{3.8822695932592087`*^9, 
  3.882269598806019*^9}},ExpressionUUID->"e7393d13-5e2a-4711-a8c1-\
e7d50c682f84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
      RowBox[{
       RowBox[{"FixedPointDistr", "[", 
        RowBox[{"ConstantA", "[", "q", "]"}], "]"}], "==", "q"}]}], ",", 
     "5000"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882255524426219*^9, 3.882255544585711*^9}, {
   3.882255849062293*^9, 3.88225586512042*^9}, {3.8822559595221653`*^9, 
   3.882255974493338*^9}, {3.8822560747134533`*^9, 3.8822561176170053`*^9}, 
   3.8823375097087793`*^9, 3.8823661259142857`*^9, {3.8823665820561666`*^9, 
   3.882366585067072*^9}, 3.8823666922604313`*^9, 3.8855019944721527`*^9, {
   3.885502061156616*^9, 3.885502061337944*^9}, {3.885553129053746*^9, 
   3.885553130070408*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"9be00068-9b64-4554-acac-7a3769614870"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"38.956855`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.88225557673319*^9, {3.8822558155214443`*^9, 3.8822558655717583`*^9}, {
   3.882255922970263*^9, 3.882255977083803*^9}, {3.882256087318943*^9, 
   3.882256125286269*^9}, 3.882257309822254*^9, 3.882268548071416*^9, {
   3.8822687837625504`*^9, 3.88226880597501*^9}, 3.882269052849131*^9, 
   3.8822916724652147`*^9, 3.8822937578681593`*^9, 3.882337210156494*^9, 
   3.8823380860615997`*^9, 3.882339984955409*^9, 3.8823450107170887`*^9, 
   3.882346261791966*^9, 3.882346377059536*^9, 3.8823464694785852`*^9, 
   3.88234687862934*^9, 3.882347241197191*^9, 3.88234918881384*^9, 
   3.882350373673441*^9, 3.882353410515792*^9, 3.8823661352279787`*^9, 
   3.882366641601886*^9, 3.882367135016019*^9, 3.882367185020322*^9, 
   3.882376572652709*^9, 3.882376711659622*^9, 3.8839613588116913`*^9, 
   3.885429244873301*^9, 3.8855011863292503`*^9, 3.885501986251157*^9, 
   3.885502026659419*^9, 3.885502079426021*^9, 3.8855053912691298`*^9, 
   3.885511230877982*^9, 3.885512402954968*^9, 3.8855532408269567`*^9, 
   3.894046961326254*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"8fc2fbc0-c31c-4f75-96ff-2e98bf84801d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IsDistr", "[", 
      RowBox[{"FixedPointDistr", "[", 
       RowBox[{"RandomA", "[", "testdim", "]"}], "]"}], "]"}], ",", "1000"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882256312085786*^9, 3.882256361896577*^9}, 
   3.8823375070722227`*^9, {3.882345011344515*^9, 3.882345012118064*^9}, 
   3.8823661416788263`*^9, {3.8823665899381857`*^9, 3.8823665959844522`*^9}, 
   3.8823666973742523`*^9, {3.885553136550253*^9, 3.885553137796845*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"182f5977-a283-466a-89b2-5cb368b5978b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.452861`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8822563194004374`*^9, 3.882256370386586*^9}, 
   3.882257315060575*^9, 3.882268552982959*^9, 3.882268810830003*^9, 
   3.882269057781331*^9, 3.882291698801306*^9, 3.882293759825515*^9, 
   3.882337212047624*^9, 3.8823380862617807`*^9, 3.882339985305766*^9, 
   3.882345012987707*^9, 3.8823462621315107`*^9, 3.882346377391553*^9, 
   3.882346469683413*^9, 3.882346878850016*^9, 3.882347241701479*^9, 
   3.882349189372571*^9, 3.882350374215948*^9, 3.882353410768013*^9, 
   3.8823661449716377`*^9, 3.882366642238618*^9, 3.882367140647353*^9, 
   3.8823671902976933`*^9, 3.8823765778504763`*^9, 3.882376716957902*^9, 
   3.883961364974724*^9, 3.885429256213221*^9, 3.8855011926849327`*^9, 
   3.885502032060647*^9, 3.8855020846083384`*^9, 3.885505398320196*^9, 
   3.885511235266836*^9, 3.885512409954729*^9, 3.885553247210455*^9, 
   3.894046969851956*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"93e7ab8c-fbcd-4d87-a17e-6121dae5418a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"FixedPointDistr", "[", "A", "]"}]}], ";", 
      RowBox[{
       RowBox[{"A", ".", "p"}], "==", "p"}]}], ",", "1000"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.88225640695313*^9, 3.882256452370853*^9}, {
   3.882337503358714*^9, 3.8823375060107307`*^9}, 3.8823661502159863`*^9, {
   3.88236659879475*^9, 3.882366601794771*^9}, 3.882366700113532*^9, {
   3.885553154593655*^9, 3.885553155562976*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"9e2cd2fe-1eca-48c5-b2ba-42c79bd3afde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.701236`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8822564377239*^9, 3.882256460916964*^9}, 
   3.8822573204613857`*^9, 3.882268558085856*^9, 3.882268815967786*^9, 
   3.882269062829261*^9, 3.882291725729253*^9, 3.882293761960658*^9, 
   3.882337214088306*^9, 3.882338086501459*^9, 3.882339985669526*^9, 
   3.882345013933487*^9, 3.8823462625004463`*^9, 3.8823463777543287`*^9, 
   3.88234646993666*^9, 3.882346879072709*^9, 3.882347242291497*^9, 
   3.8823491899967413`*^9, 3.88235037475317*^9, 3.882353411038048*^9, 
   3.882366153349436*^9, 3.882366642805689*^9, 3.882367146231924*^9, 
   3.882367195727234*^9, 3.882376583187407*^9, 3.8823767223270082`*^9, 
   3.883961371383184*^9, 3.885429267670004*^9, 3.885501199094451*^9, 
   3.885502089348383*^9, 3.885505405473535*^9, 3.885511239699162*^9, 
   3.8855124170983953`*^9, 3.885553253773889*^9, 3.89404697860612*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"48d5a854-3543-48d6-8c9f-cb79999a0fc1"]
}, Open  ]],

Cell[TextData[StyleBox["Optimal report function", "Subsection"]], "Text",
 CellChangeTimes->{{3.882269415949984*^9, 
  3.882269421874836*^9}},ExpressionUUID->"9437ae99-8f26-49b3-a145-\
139f2d8bc546"],

Cell["Optimal reports should be probability distributions.", "Text",
 CellChangeTimes->{{3.88234004648722*^9, 3.882340078063201*^9}, {
  3.882340628802485*^9, 3.8823406388889093`*^9}, {3.882349296464731*^9, 
  3.882349306108762*^9}, {3.882350434552682*^9, 
  3.882350436310129*^9}},ExpressionUUID->"e371340b-4359-4caf-978e-\
1c21e8db72fc"],

Cell["LogScore:", "Text",
 CellChangeTimes->{
  3.882350439608287*^9},ExpressionUUID->"60ab241d-86a3-4250-a1f9-\
195e7c2ebf9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IsDistr", "[", 
      RowBox[{"OptReportN", "[", 
       RowBox[{"LogScore", ",", 
        RowBox[{"RandomA", "[", "testdim", "]"}]}], "]"}], "]"}], ",", "10"}],
     "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8822567095990543`*^9, 3.8822567377085257`*^9}, 
   3.882256873489937*^9, {3.8822576133354*^9, 3.8822576320067997`*^9}, {
   3.882257673422453*^9, 3.882257674573341*^9}, {3.8823375003701563`*^9, 
   3.882337500509519*^9}, 3.882366158551434*^9, {3.882366477766283*^9, 
   3.882366481293832*^9}, 3.885503475943959*^9, {3.885510088473813*^9, 
   3.8855100885450478`*^9}, {3.885553161599022*^9, 3.8855531626692944`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"3e012485-486d-403a-9f7e-89da1f01dab3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11.473704`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.882256733235341*^9, 3.882256738457387*^9}, 
   3.882256874272752*^9, {3.882256954785823*^9, 3.8822569559619226`*^9}, 
   3.882257451817746*^9, {3.882257619111867*^9, 3.882257637836607*^9}, 
   3.882257680045854*^9, 3.882268598086956*^9, 3.882268827918676*^9, 
   3.882269074826682*^9, 3.882292196419249*^9, 3.882293827721788*^9, 
   3.8823372837464857`*^9, 3.882338106380884*^9, 3.882339988715357*^9, 
   3.882345019300921*^9, 3.8823462658851347`*^9, 3.882346380847427*^9, 
   3.882346472206931*^9, 3.882346881108018*^9, 3.882347245971807*^9, 
   3.882349193760838*^9, 3.88235037832568*^9, 3.882353413515623*^9, 
   3.882366167653496*^9, 3.882366651248927*^9, 3.882367155710517*^9, 
   3.882367204989521*^9, 3.882376591314076*^9, 3.8823767300201893`*^9, 
   3.883961405665722*^9, 3.88542933082969*^9, 3.885501225463024*^9, 
   3.885502117031724*^9, 3.885505434171495*^9, 3.885511289256403*^9, 
   3.88551242710015*^9, 3.885553262359589*^9, 3.894046990118085*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"d2570f90-6160-493a-848e-1966fb405a10"]
}, Open  ]],

Cell["BrierScore:", "Text",
 CellChangeTimes->{{3.882349560867394*^9, 
  3.8823495631633663`*^9}},ExpressionUUID->"a3bbc49f-a26f-44c3-8f81-\
3d58cfc40d9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IsDistrAppr", "[", 
      RowBox[{"OptReportN", "[", 
       RowBox[{"BrierScore", ",", 
        RowBox[{"RandomA", "[", "testdim", "]"}]}], "]"}], "]"}], ",", "10"}],
     "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8823495369532833`*^9, 3.882349554366357*^9}, 
   3.882366164077137*^9, {3.882366484100127*^9, 3.882366488835894*^9}, 
   3.885503484367785*^9, {3.885510085795773*^9, 3.885510085836877*^9}, {
   3.8855531671260357`*^9, 3.885553168196376*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"6dd8bd6b-7bc5-4a44-a85a-c0711c83bf90"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"57.49237`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.882349542584819*^9, 3.882349560829167*^9}, 
   3.882350384692141*^9, 3.8823534176378107`*^9, 3.8823661889934483`*^9, 
   3.8823666636760807`*^9, 3.882367157679372*^9, 3.8823672199306107`*^9, 
   3.882376594556572*^9, 3.8823767488484*^9, 3.883961451591655*^9, 
   3.885429414876522*^9, 3.885501363764882*^9, 3.885502254980372*^9, 
   3.885509747448695*^9, 3.885511322052124*^9, 3.8855124647685537`*^9, 
   3.885553303590707*^9, 3.894047047667718*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"fadc9b41-934c-43c3-8a64-d7bef4289603"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IsDistrAppr", "[", 
      RowBox[{"OptReportBrier", "[", 
       RowBox[{"RandomA", "[", "testdim", "]"}], "]"}], "]"}], ",", "5"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882352182268311*^9, 3.882352194090466*^9}, 
   3.882352226107409*^9, 3.882366169404442*^9, {3.8823664918798532`*^9, 
   3.8823664947471437`*^9}, {3.88236670935292*^9, 3.8823667094398727`*^9}, {
   3.885502193762849*^9, 3.8855021945341578`*^9}, {3.8855531736141644`*^9, 
   3.885553174618655*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"869393f6-6e96-474d-a27a-78a2a8f1e131"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22.838891`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.882352200408725*^9, 3.882352241817225*^9}, 
   3.882353417710951*^9, 3.882366200682555*^9, 3.882366676982814*^9, 
   3.882367255194233*^9, 3.882376784025517*^9, 3.883961492455755*^9, 
   3.8855013648376217`*^9, 3.8855022560065317`*^9, 3.885502545451413*^9, 
   3.8855097723711348`*^9, 3.885511327714551*^9, 3.885512491110978*^9, 
   3.885553323001068*^9, 3.8940470705474663`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"57520077-cfbd-4d11-8001-cd9f5e42a110"]
}, Open  ]],

Cell["\<\
On randomly generated A, I test whether the \[OpenCurlyDoubleQuote]optimal \
report\[CloseCurlyDoubleQuote] is at least as good as the fixed point.\
\>", "Text",
 CellChangeTimes->{
  3.882340655545121*^9},ExpressionUUID->"d8d88217-436d-4d0e-bcaa-\
22d2d3cc4673"],

Cell["LogScore:", "Text",
 CellChangeTimes->{{3.882349570385188*^9, 
  3.8823495723664417`*^9}},ExpressionUUID->"bdf29abe-5688-4a0d-b425-\
45486a90d298"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"LogScore", ",", "A"}], "]"}]}], ";", 
      RowBox[{"fp", "=", 
       RowBox[{"FixedPointDistr", "[", "A", "]"}]}], ";", 
      RowBox[{
       RowBox[{"LogScore", "[", 
        RowBox[{"p", ",", 
         RowBox[{"A", ".", "p"}]}], "]"}], ">=", 
       RowBox[{"LogScore", "[", 
        RowBox[{"fp", ",", "fp"}], "]"}]}]}], ",", "10"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.882257705343505*^9, 3.882257716762706*^9}, {
   3.8822692337672567`*^9, 3.882269279109355*^9}, {3.882337496012097*^9, 
   3.882337496311763*^9}, {3.8823610285221663`*^9, 3.8823610327899923`*^9}, {
   3.882361089455408*^9, 3.88236108977376*^9}, {3.8823611800734777`*^9, 
   3.8823612087962217`*^9}, {3.882361644686738*^9, 3.8823616447869368`*^9}, {
   3.882361933400923*^9, 3.882361953857492*^9}, 3.8823661774317627`*^9, {
   3.882366454440909*^9, 3.882366455536165*^9}, {3.882366726717761*^9, 
   3.882366726814541*^9}, 3.885503485763686*^9, {3.885510073653701*^9, 
   3.885510073743978*^9}, {3.885553178942464*^9, 3.885553179797676*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"4d596275-86c1-4a07-8c52-74844e94ae74"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12.089639`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.882269251588731*^9, 3.8822692910472116`*^9}, 
   3.882292707521372*^9, 3.882293893678925*^9, 3.88233735528375*^9, 
   3.882338127166031*^9, 3.882339991325898*^9, 3.8823450253085613`*^9, 
   3.882346268473853*^9, 3.882346383348954*^9, 3.882346474688643*^9, 
   3.882346883378955*^9, 3.882347250217265*^9, 3.882349198024137*^9, 
   3.882350388547481*^9, 3.882353420130713*^9, 3.882361053333832*^9, 
   3.882361160185562*^9, 3.882361280613717*^9, 3.8823613891496067`*^9, 
   3.882361484459772*^9, 3.8823616255710497`*^9, 3.882361872643076*^9, 
   3.882361959309721*^9, 3.8823620343984203`*^9, 3.882366229126*^9, 
   3.882366682385778*^9, 3.882367264614348*^9, 3.8823767919006767`*^9, 
   3.883961530514895*^9, 3.885501391033136*^9, 3.8855022842416573`*^9, 
   3.8855098001043577`*^9, 3.885511354018448*^9, 3.885512500917324*^9, 
   3.885553331253626*^9, 3.894047082677087*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"def1e7b8-a112-4868-944e-700e8d4e106c"]
}, Open  ]],

Cell["BrierScore:", "Text",
 CellChangeTimes->{{3.8823495771853657`*^9, 
  3.882349580113834*^9}},ExpressionUUID->"abb3e2ef-c528-412d-9257-\
976a4140b46a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"BrierScore", ",", "A"}], "]"}]}], ";", 
      RowBox[{"fp", "=", 
       RowBox[{"FixedPointDistr", "[", "A", "]"}]}], ";", 
      RowBox[{
       RowBox[{"BrierScore", "[", 
        RowBox[{"p", ",", 
         RowBox[{"A", ".", "p"}]}], "]"}], ">=", 
       RowBox[{"BrierScore", "[", 
        RowBox[{"fp", ",", "fp"}], "]"}]}]}], ",", "5"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.882349591074437*^9, 3.8823496026593018`*^9}, {
   3.882366188042873*^9, 3.88236619303148*^9}, {3.882366449836699*^9, 
   3.88236644991397*^9}, 3.8855034866241426`*^9, 3.88551007957556*^9, {
   3.885553183435091*^9, 3.885553184259614*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"2c7efffc-3c84-4d07-ac32-9273cb85ec32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17.334186`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.88234960856562*^9, 3.882350393388174*^9, 
  3.882353426003065*^9, 3.882366257733644*^9, 3.8823666972218647`*^9, 
  3.882367273674513*^9, 3.882376802422963*^9, 3.883961587162408*^9, 
  3.885501475164913*^9, 3.885502386688035*^9, 3.885509888128912*^9, 
  3.885511371862769*^9, 3.885512510843431*^9, 3.8855533518782177`*^9, 
  3.894047100061556*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"8db9c90b-1e78-4ab4-95e6-61a8b220b1e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportBrier", "[", "A", "]"}]}], ";", 
      RowBox[{"fp", "=", 
       RowBox[{"FixedPointDistr", "[", "A", "]"}]}], ";", 
      RowBox[{
       RowBox[{"BrierScore", "[", 
        RowBox[{"p", ",", 
         RowBox[{"A", ".", "p"}]}], "]"}], ">=", 
       RowBox[{"BrierScore", "[", 
        RowBox[{"fp", ",", "fp"}], "]"}]}]}], ",", "10"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8823522637593946`*^9, 3.882352272619987*^9}, {
  3.882366195357765*^9, 3.882366200541355*^9}, {3.882366445510969*^9, 
  3.882366445601516*^9}, {3.8823667338681517`*^9, 3.882366734150902*^9}, {
  3.8855105425442553`*^9, 3.885510553455237*^9}, {3.885553187640861*^9, 
  3.885553188534947*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"cc4283da-740b-45da-8f0a-23c8eff6430b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"46.939575`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.882352288896063*^9, 3.882353426102426*^9, 3.882366244580159*^9, 
   3.882366718924266*^9, 3.882367342154194*^9, 3.882376867879427*^9, 
   3.883961667516656*^9, 3.885501476861772*^9, {3.885510540028336*^9, 
   3.8855105484720182`*^9}, 3.885510839054042*^9, 3.885511376655181*^9, 
   3.8855125878733797`*^9, 3.885553388924765*^9, 3.894047147035592*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"2a304ae7-b8cb-4e60-83b7-1dcece3add34"]
}, Open  ]],

Cell["\<\
On randomly generated A, I test whether the \[OpenCurlyDoubleQuote]optimal \
report\[CloseCurlyDoubleQuote] (as found by OptReport) is at least as good as \
a bunch of randomly generated reports.\
\>", "Text",
 CellChangeTimes->{{3.8823406785797462`*^9, 3.882340687844653*^9}, {
  3.882344679184061*^9, 3.8823446811163282`*^9}, {3.882345034447257*^9, 
  3.882345046618927*^9}},ExpressionUUID->"e5ab2273-6ff1-48dc-81e5-\
d86df3dd382d"],

Cell["LogScore:", "Text",
 CellChangeTimes->{{3.882349621851925*^9, 
  3.882349623179497*^9}},ExpressionUUID->"4935439e-1d14-42f1-b180-\
456352e4dabb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"LogScore", ",", "A"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"And", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"randp", "=", 
           RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"LogScore", "[", 
            RowBox[{"p", ",", 
             RowBox[{"A", ".", "p"}]}], "]"}], ">=", 
           RowBox[{"LogScore", "[", 
            RowBox[{"randp", ",", 
             RowBox[{"A", ".", "randp"}]}], "]"}]}]}], ",", "5000"}], 
        "]"}]}]}], ",", "10"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882257705343505*^9, 3.882257716762706*^9}, {
   3.8822692337672567`*^9, 3.882269279109355*^9}, {3.882269356040642*^9, 
   3.88226938874506*^9}, {3.882337497615753*^9, 3.8823374985921783`*^9}, {
   3.882344692303762*^9, 3.882344728927335*^9}, 3.882345063341647*^9, 
   3.882357924399036*^9, {3.8823580559350767`*^9, 3.8823580749450417`*^9}, 
   3.882358134203228*^9, {3.8823582034628887`*^9, 3.882358206982836*^9}, {
   3.882366208658927*^9, 3.8823662103515244`*^9}, {3.8823663594273043`*^9, 
   3.882366359524693*^9}, {3.882366764690535*^9, 3.8823667656139107`*^9}, 
   3.885503487255248*^9, {3.885511767889627*^9, 3.8855117680675297`*^9}, {
   3.8855531933988867`*^9, 3.885553195228249*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"4390b101-6984-46b0-8cfa-3b628c26c55d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"33.181228`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.882269251588731*^9, 3.8822692910472116`*^9}, 
   3.882269402165227*^9, 3.882293205583632*^9, 3.88229396014917*^9, 
   3.882337425473724*^9, 3.882338147848227*^9, 3.882339993811492*^9, {
   3.882344712598938*^9, 3.882344725298658*^9}, 3.882344759507575*^9, {
   3.882345056192524*^9, 3.882345070816902*^9}, 3.882346272561853*^9, 
   3.882346388235341*^9, 3.8823464802158127`*^9, 3.882346888467695*^9, 
   3.882347258755406*^9, 3.882349206327389*^9, 3.88235040182594*^9, 
   3.882353431497232*^9, 3.882357953138487*^9, {3.882358058944372*^9, 
   3.8823580818405743`*^9}, 3.882358147975072*^9, 3.882358248769924*^9, 
   3.882358301331688*^9, 3.882358877563657*^9, 3.882366299336164*^9, 
   3.882366746871804*^9, 3.882367342231954*^9, 3.8823768821550293`*^9, 
   3.883961693281261*^9, 3.885501497444803*^9, 3.885502413104024*^9, 
   3.885511406909096*^9, 3.885512613900873*^9, 3.885553413698042*^9, 
   3.894047180260322*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"414f032a-e6c9-4b9c-930a-b65173243c4e"]
}, Open  ]],

Cell["BrierScore:", "Text",
 CellChangeTimes->{{3.882349634131789*^9, 
  3.882349635936026*^9}},ExpressionUUID->"d28f7fac-f558-487b-9eed-\
54d046a7da0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"BrierScore", ",", "A"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"And", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"randp", "=", 
           RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"BrierScore", "[", 
            RowBox[{"p", ",", 
             RowBox[{"A", ".", "p"}]}], "]"}], ">=", 
           RowBox[{"BrierScore", "[", 
            RowBox[{"randp", ",", 
             RowBox[{"A", ".", "randp"}]}], "]"}]}]}], ",", "5000"}], 
        "]"}]}]}], ",", "10"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8823496468192043`*^9, 3.8823496581145563`*^9}, {
   3.882357929047665*^9, 3.88235793741325*^9}, {3.882366227027772*^9, 
   3.882366238982439*^9}, {3.8823663628508177`*^9, 3.882366362913471*^9}, {
   3.8823668156765623`*^9, 3.8823668157870693`*^9}, 3.885503490997231*^9, 
   3.885511762219124*^9, {3.8855533263016577`*^9, 3.885553327160083*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"59f4228a-ff92-40cd-873e-32f6312d085f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"67.516073`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.882349669312853*^9, 3.8823504115687723`*^9, 
  3.882353438812976*^9, 3.882357981105515*^9, 3.882358202730983*^9, 
  3.882366346795435*^9, 3.882366780352934*^9, 3.8823768993536987`*^9, 
  3.8839617208828993`*^9, 3.885501573660977*^9, 3.8855024844911327`*^9, 
  3.885511467226573*^9, 3.885512658347802*^9, 3.885553485252306*^9, 
  3.89404724783877*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"28a50a9b-9160-483b-af83-e1fe170514ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportBrier", "[", "A", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"And", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"randp", "=", 
           RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"BrierScore", "[", 
            RowBox[{"p", ",", 
             RowBox[{"A", ".", "p"}]}], "]"}], ">=", 
           RowBox[{"BrierScore", "[", 
            RowBox[{"randp", ",", 
             RowBox[{"A", ".", "randp"}]}], "]"}]}]}], ",", "10000"}], 
        "]"}]}]}], ",", "5"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882352295964209*^9, 3.882352307663775*^9}, 
   3.882357931629471*^9, {3.88236624391341*^9, 3.8823662639627647`*^9}, {
   3.8823668123174543`*^9, 3.882366812449766*^9}, {3.885553331764291*^9, 
   3.8855533328498497`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"264d754c-b1e2-47a5-b464-699a5380092f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"52.109841`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.88235232444243*^9, 3.882353439223213*^9, 
  3.882357984735293*^9, 3.882366365829976*^9, 3.8823667987770433`*^9, 
  3.8823769421259127`*^9, 3.883961768467243*^9, 3.885501580770413*^9, 
  3.885511480600675*^9, 3.8855127132071753`*^9, 3.885553533888838*^9, 
  3.894047299987241*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"2add1619-dd41-4413-8b1f-3be8036b0687"]
}, Open  ]],

Cell["\<\
If A is simply the matrix that maps each probability distribution onto q, \
then the optimal report should be approximately q.\
\>", "Text",
 CellChangeTimes->{{3.882349678724923*^9, 
  3.88234972018489*^9}},ExpressionUUID->"11f66b9a-afa6-4866-ab56-\
9c82ba74a901"],

Cell["LogScore:", "Text",
 CellChangeTimes->{{3.882349745186681*^9, 
  3.882349750318425*^9}},ExpressionUUID->"7443f3f6-f2e3-4f31-85ce-\
e169a852ab65"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"LogScore", ",", 
         RowBox[{"ConstantA", "[", "q", "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"p", "-", "q"}], "]"}], "<=", "0.00001"}]}], ",", "10"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8823402422984133`*^9, 3.882340389993507*^9}, {
   3.882366270676282*^9, 3.882366282079204*^9}, 3.8855034919959*^9, {
   3.885511752426867*^9, 3.885511753532536*^9}, {3.885553337709804*^9, 
   3.885553338822361*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"86cb9997-ca36-4d6f-9487-8806be04ad50"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.044871`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8823403000781317`*^9, 3.8823403927317677`*^9}, 
   3.882346389716893*^9, 3.882346481793098*^9, 3.8823468900822153`*^9, 
   3.882347261308425*^9, 3.8823492092330723`*^9, 3.88234976094477*^9, 
   3.882350414999917*^9, {3.882350500462433*^9, 3.882350509174891*^9}, {
   3.8823506509825563`*^9, 3.882350660388398*^9}, 3.882353440849752*^9, 
   3.882362048952765*^9, 3.882366372263136*^9, 3.882366804071863*^9, 
   3.882376947000619*^9, 3.8839617971329412`*^9, 3.885498916409148*^9, 
   3.885501599810895*^9, 3.88550250947511*^9, 3.885511496100883*^9, 
   3.885512724483417*^9, 3.885553541867702*^9, 3.894047310099985*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"04a0d884-d820-498c-b576-bfbb806fcec4"]
}, Open  ]],

Cell["BrierScore:", "Text",
 CellChangeTimes->{{3.882349754307658*^9, 
  3.882349755864888*^9}},ExpressionUUID->"2f7812c3-156e-4dfc-a794-\
caf0bb921948"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"BrierScore", ",", 
         RowBox[{"ConstantA", "[", "q", "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"p", "-", "q"}], "]"}], "<=", "0.00001"}]}], ",", "10"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8823402422984133`*^9, 3.882340389993507*^9}, {
   3.882349730415555*^9, 3.882349733143602*^9}, {3.882366286575945*^9, 
   3.882366294477509*^9}, 3.8855034927211018`*^9, {3.885511748095357*^9, 
   3.885511748179872*^9}, {3.885553341937475*^9, 3.885553342773472*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"3233da1a-da1f-4afe-a511-1dfb0535abf6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12.335235`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8823403000781317`*^9, 3.8823403927317677`*^9}, 
   3.882346389716893*^9, 3.882346481793098*^9, 3.8823468900822153`*^9, 
   3.882347261308425*^9, 3.8823492092330723`*^9, {3.882349736374568*^9, 
   3.882349764334509*^9}, 3.882350417923882*^9, 3.882350706734035*^9, 
   3.882353442583576*^9, 3.882366379301914*^9, 3.882366811600295*^9, 
   3.882376953806926*^9, 3.8839618249707727`*^9, 3.8855016245060253`*^9, 
   3.885502543801235*^9, 3.885511515037415*^9, 3.885512738148822*^9, 
   3.885553552412551*^9, 3.8940473224762087`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"5f1d7749-2b65-47cb-97f3-9cc3b2c8fb4f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{"RandomDistr", "[", "testdim", "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"OptReportBrier", "[", 
        RowBox[{"ConstantA", "[", "q", "]"}], "]"}]}], ";", 
      RowBox[{"p", "==", "q"}]}], ",", "100"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8823523449595537`*^9, 3.882352355047617*^9}, 
   3.882366306434005*^9, {3.882366394037735*^9, 3.882366396959955*^9}, {
   3.8823668293412933`*^9, 3.88236683005033*^9}, {3.8855533465368958`*^9, 
   3.885553347352047*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"a0222a4d-efbe-4169-a3bf-c09f67b01443"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"35.424585`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.882352364738254*^9, 3.8823534428020697`*^9, 
  3.882366385028998*^9, 3.882366467286275*^9, 3.882366817424201*^9, 
  3.882376981667107*^9, 3.883961858123424*^9, 3.885501639472007*^9, 
  3.885511522699263*^9, 3.885512778807922*^9, 3.885553583421608*^9, 
  3.894047357938196*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"7df5317d-fd59-4413-bc56-c8afc53a1091"]
}, Open  ]],

Cell["\<\
We can now test the NMaximized-based approximate best report function against \
the Maximize-based exact best report function for the Brier scoring rule.\
\>", "Text",
 CellChangeTimes->{{3.8823524529033537`*^9, 3.8823524774947653`*^9}, {
  3.882352889901093*^9, 
  3.882352899139529*^9}},ExpressionUUID->"dc53f0b7-f2ea-4fba-98a0-\
8f3dc980cc6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"trueFraction", "@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "3", "]"}]}], ";", 
      RowBox[{"p1", "=", 
       RowBox[{"OptReportBrier", "[", "A", "]"}]}], ";", 
      RowBox[{"p2", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"BrierScore", ",", "A"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"p1", "-", "p2"}], "]"}], "<=", "0.001"}]}], ",", "10"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8855116639118567`*^9, 3.885511668258679*^9}, {
  3.8855533507107897`*^9, 3.885553351694261*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"11ce6ce8-72b4-4725-b23a-076e91d2c25c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"36.360555`", ",", 
   FractionBox["9", "10"]}], "}"}]], "Output",
 CellChangeTimes->{3.885511689514882*^9, 3.885512789305849*^9, 
  3.885553594573823*^9, 3.894047394359209*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"df35aec4-400d-4d89-b0eb-16209636886d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"trueFraction", "@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "4", "]"}]}], ";", 
      RowBox[{"p1", "=", 
       RowBox[{"OptReportBrier", "[", "A", "]"}]}], ";", 
      RowBox[{"p2", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"BrierScore", ",", "A"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"p1", "-", "p2"}], "]"}], "<=", "0.001"}]}], ",", "8"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8855116639118567`*^9, 3.885511698511813*^9}, {
  3.8855533551116943`*^9, 3.885553356051441*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"771596c2-b491-4ce7-8d56-f1186d5f5e46"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"45.262438`", ",", 
   FractionBox["7", "8"]}], "}"}]], "Output",
 CellChangeTimes->{{3.885511708351656*^9, 3.885511724280877*^9}, 
   3.885512810325197*^9, 3.885553622917921*^9, 3.894047439668775*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"bb7bce44-d9cc-45ff-bc67-16d5ef33e538"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"trueFraction", "@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"A", "=", 
       RowBox[{"RandomA", "[", "5", "]"}]}], ";", 
      RowBox[{"p1", "=", 
       RowBox[{"OptReportBrier", "[", "A", "]"}]}], ";", 
      RowBox[{"p2", "=", 
       RowBox[{"OptReportN", "[", 
        RowBox[{"BrierScore", ",", "A"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"p1", "-", "p2"}], "]"}], "<=", "0.001"}]}], ",", "3"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8823524841841383`*^9, 3.882352582463469*^9}, 
   3.882352668201474*^9, {3.882352746708933*^9, 3.882352746824162*^9}, {
   3.882352827079651*^9, 3.882352833909019*^9}, {3.882353145929184*^9, 
   3.88235316526661*^9}, {3.882353228933836*^9, 3.882353242050205*^9}, 
   3.882366317054489*^9, {3.882366837522729*^9, 3.882366840052908*^9}, 
   3.882366990942828*^9, 3.885503493551112*^9, 3.8855115470957327`*^9, {
   3.8855115805880337`*^9, 3.885511654644857*^9}, {3.88551169137787*^9, 
   3.8855116927325153`*^9}, {3.885512095121833*^9, 3.8855120952675133`*^9}, {
   3.885553360548856*^9, 3.8855533613765783`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"d688878c-d8b2-48a9-9d7d-7f2374b4a633"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25.119201`", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.8823525534157*^9, 3.882352574788471*^9}, 
   3.8823526588348093`*^9, 3.8823527390386066`*^9, 3.882352962755681*^9, 
   3.8823532118832207`*^9, 3.8823534448263083`*^9, 3.882366461239092*^9, 
   3.882366893677002*^9, 3.882366977138459*^9, 3.88237701736516*^9, 
   3.883961904596651*^9, 3.885501664852635*^9, {3.8855115371113777`*^9, 
   3.885511557330514*^9}, 3.885511599912284*^9, {3.885511634671712*^9, 
   3.885511643791974*^9}, 3.8855116738749723`*^9, 3.885512034591773*^9, 
   3.885512835007185*^9, 3.885553654207357*^9, 3.8940474648268642`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"86f69fc8-5c48-4b5f-a851-5d49022c0ab3"]
}, Open  ]],

Cell[TextData[StyleBox["Experiment", "Section"]], "Text",
 CellChangeTimes->{{3.882222904178232*^9, 3.882222905965712*^9}, 
   3.882287663369534*^9, {3.884014877635672*^9, 
   3.884014879576001*^9}},ExpressionUUID->"9e6de677-46db-4ec0-8762-\
9ef426624530"],

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "=", "BrierScore"}], ";"}]], "Input",
 CellChangeTimes->{{3.8823663350905457`*^9, 3.882366339533225*^9}, {
  3.884013463914987*^9, 3.88401346467337*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"e6f51016-5e10-4e8b-bdb0-ebf777d1b42c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dim", "=", "5"}], ";"}]], "Input",
 CellChangeTimes->{{3.88236634354003*^9, 3.882366346852414*^9}, {
  3.8839625851222553`*^9, 3.883962605946944*^9}, {3.8839631146722383`*^9, 
  3.8839631163211393`*^9}, {3.884981838332066*^9, 3.8849818405321836`*^9}, {
  3.884995526118724*^9, 3.884995526216988*^9}, {3.884995588049775*^9, 
  3.884995609831952*^9}, {3.884995649298295*^9, 3.884995649812231*^9}, {
  3.884995747284154*^9, 3.8849957474081497`*^9}, {3.884996140007956*^9, 
  3.8849961828948393`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"aeaaac0b-5e91-4721-bd1f-eef3302176d5"],

Cell["\<\
We sample n matrices A. For each of them we record four numbers: 1) the \
operator norm of A; 2) how far the fixed point distribution of A is from the \
uniform distribution; 3) how far the optimal report is from the fixed point; \
4) how far the optimal report is from the true distribution when the optimal \
report is made; 5) how far the actual report is from the uniform distribution.\
\>", "Text",
 CellChangeTimes->{{3.8822778972322807`*^9, 3.882277919821534*^9}, {
  3.882283663768858*^9, 3.88228369653091*^9}, {3.882287648311202*^9, 
  3.882287754700348*^9}, {3.884521855522951*^9, 
  3.884521871643317*^9}},ExpressionUUID->"f120ba02-f818-408b-ac21-\
5e52ef7edf53"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8855154979567833`*^9, 3.88551550083638*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"a3281549-1eac-48d5-b10c-8bf9ecb0b074"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"data", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"data", ",", 
     RowBox[{"ParallelTable", "[", 
      RowBox[{
       RowBox[{"TimeConstrained", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"A", "=", 
           RowBox[{"RandomA", "[", "dim", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"fixedpoint", "=", 
           RowBox[{"FixedPointDistr", "[", "A", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"optrep", "=", 
           RowBox[{"OptReportBrier", "[", "A", "]"}]}], ";", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"N", "@", 
             RowBox[{"TangentSpaceOpNormN", "[", "A", "]"}]}], ",", 
            RowBox[{"N", "@", 
             RowBox[{"Norm", "[", 
              RowBox[{"fixedpoint", "-", 
               RowBox[{"uniform", "[", "dim", "]"}]}], "]"}]}], ",", 
            RowBox[{"N", "@", 
             RowBox[{"Norm", "[", 
              RowBox[{"optrep", "-", "fixedpoint"}], "]"}]}], ",", 
            RowBox[{"N", "@", 
             RowBox[{"Norm", "[", 
              RowBox[{"optrep", "-", 
               RowBox[{"A", ".", "optrep"}]}], "]"}]}], ",", 
            RowBox[{"N", "@", 
             RowBox[{"Norm", "[", 
              RowBox[{"optrep", "-", 
               RowBox[{"uniform", "[", "dim", "]"}]}], "]"}]}]}], "}"}]}], 
         ",", "120", ",", "\"\<NT\>\""}], "]"}], ",", "1000"}], "]"}], ",", 
     RowBox[{"SameTest", "->", 
      RowBox[{"(", 
       RowBox[{"False", "&"}], ")"}]}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.885556818642662*^9, 3.8855568570269527`*^9}, {
  3.885557459578066*^9, 3.885557464876874*^9}, {3.885558484056735*^9, 
  3.885558484309595*^9}, {3.885559000017811*^9, 3.885559024863872*^9}, {
  3.8855635248894863`*^9, 3.885563528862715*^9}, {3.885563733915833*^9, 
  3.885563737420972*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"5db2f5a9-df69-4497-a0e4-b917f0451902"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2478.221846`", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", ",", "\<\"NT\"\>", 
     ",", "\<\"NT\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
      "0.28095604789032164`", ",", "0.25254936065804234`", ",", 
       "0.05197775963840393`", ",", "0.059372192908414945`", ",", 
       "0.23612523401101337`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.2868717380333753`", ",", "0.1352096314515339`", ",", 
       "0.013898146771123119`", ",", "0.014021822600812058`", ",", 
       "0.1462483092296091`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.30121519622544174`", ",", "0.13723001530503598`", ",", 
       "0.017638278878896012`", ",", "0.02074487055624411`", ",", 
       "0.1221751935357282`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.30203257045767384`", ",", "0.196316651128114`", ",", 
       "0.04878902209849916`", ",", "0.043252160764416334`", ",", 
       "0.22645068782986844`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3069472592916375`", ",", "0.207128492040521`", ",", 
       "0.0916817588670197`", ",", "0.0715759683655777`", ",", 
       "0.2924574786490254`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.30896556420515237`", ",", "0.2046042560889893`", ",", 
       "0.09245905154241214`", ",", "0.06856259491384975`", ",", 
       "0.27845179484376903`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3111433888148688`", ",", "0.20781752758932115`", ",", 
       "0.056852755647085224`", ",", "0.054976518396696976`", ",", 
       "0.2366137575145078`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.32042875704524054`", ",", "0.1491816804238198`", ",", 
       "0.030662345632109216`", ",", "0.0338356141610161`", ",", 
       "0.14815647228175619`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.32406073671657104`", ",", "0.11330138081562634`", ",", 
       "0.03568879654080464`", ",", "0.028761915111241015`", ",", 
       "0.14160064883766665`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3270793617593295`", ",", "0.12566657328174083`", ",", 
       "0.03901130560033547`", ",", "0.034586623544283095`", ",", 
       "0.12609575083809785`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.32751699923570715`", ",", "0.22248271952457646`", ",", 
       "0.0645680478062063`", ",", "0.053310627652189226`", ",", 
       "0.25512273672100183`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3281593118208053`", ",", "0.15223198250017161`", ",", 
       "0.025261537376753882`", ",", "0.029568385243179666`", ",", 
       "0.15811981518200285`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3310140708048996`", ",", "0.22525744813180282`", ",", 
       "0.06506966978547209`", ",", "0.05122573749448135`", ",", 
       "0.2678930747171778`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3346344324399875`", ",", "0.24183678486521734`", ",", 
       "0.049950903319061`", ",", "0.04841981573319825`", ",", 
       "0.2698858811577474`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3378164507912547`", ",", "0.10224485087659849`", ",", 
       "0.020344902771856126`", ",", "0.022620378197362175`", ",", 
       "0.10491119402961291`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3383105955866604`", ",", "0.20052330336296062`", ",", 
       "0.10353393874143492`", ",", "0.0776103185915649`", ",", 
       "0.3003110530922236`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3407969357361389`", ",", "0.06210412239828165`", ",", 
       "0.009796707839017763`", ",", "0.009356673637089103`", ",", 
       "0.057531077686783005`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3413683274033565`", ",", "0.13471358732678665`", ",", 
       "0.023856753381220848`", ",", "0.0265766398361237`", ",", 
       "0.12015521763683576`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.34209273393341644`", ",", "0.20780710159719784`", ",", 
       "0.05775348688999731`", ",", "0.05371641585727288`", ",", 
       "0.2519755149312788`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3426172841495393`", ",", "0.14069476949107765`", ",", 
       "0.03322303254514406`", ",", "0.02678471095939624`", ",", 
       "0.16306562038820496`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.34399318475098917`", ",", "0.2246893088560321`", ",", 
       "0.12103519869606143`", ",", "0.09055987757834572`", ",", 
       "0.34365628280212274`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3513120857517676`", ",", "0.12360262289675293`", ",", 
       "0.023030911665831044`", ",", "0.027312349220006363`", ",", 
       "0.10624591251422899`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3525459599273831`", ",", "0.3361644388439175`", ",", 
       "0.13851185295808668`", ",", "0.1124476591000363`", ",", 
       "0.45226705306260495`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3536294890618182`", ",", "0.12593307671201606`", ",", 
       "0.0338641804482025`", ",", "0.03564667196916449`", ",", 
       "0.1199789593185471`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3549302919566883`", ",", "0.0725009000223849`", ",", 
       "0.02590083337150242`", ",", "0.022749933836122362`", ",", 
       "0.0828750954884601`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3613265791927713`", ",", "0.12963000650060696`", ",", 
       "0.08489738938213938`", ",", "0.0669758108640782`", ",", 
       "0.20306493375604326`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3616408761773257`", ",", "0.09422879185771128`", ",", 
       "0.06001250775711522`", ",", "0.044794345263247555`", ",", 
       "0.13414436500883165`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3618474982338442`", ",", "0.1392566799087293`", ",", 
       "0.06510854834675125`", ",", "0.053009783445717246`", ",", 
       "0.19092032829603486`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3621455378333297`", ",", "0.2582414912206638`", ",", 
       "0.04139171581835288`", ",", "0.042875481541110656`", ",", 
       "0.23965879482091287`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3638624691953689`", ",", "0.2509997329083976`", ",", 
       "0.09278620666880792`", ",", "0.07479021852151585`", ",", 
       "0.31819496480073617`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.365439883959456`", ",", "0.2802724666198841`", ",", 
       "0.07157558756409663`", ",", "0.0811305840759062`", ",", 
       "0.26338726611022373`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3669848859778288`", ",", "0.14814041928717347`", ",", 
       "0.06625072312127375`", ",", "0.055442224695010714`", ",", 
       "0.20209403759495298`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3679963857632276`", ",", "0.1361753483105524`", ",", 
       "0.10493231120524593`", ",", "0.07711021816257742`", ",", 
       "0.2189335902761401`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3688253885085574`", ",", "0.16744584629983297`", ",", 
       "0.06408217022160975`", ",", "0.049974059551741`", ",", 
       "0.20644916752358644`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3692584712533366`", ",", "0.15994218030438342`", ",", 
       "0.04453722494186472`", ",", "0.04143687367401264`", ",", 
       "0.1663636141573963`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.370240469599633`", ",", "0.20669107050303584`", ",", 
       "0.06761084148910994`", ",", "0.05752707987306937`", ",", 
       "0.2694388962205085`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.37036173725790766`", ",", "0.09787580351088813`", ",", 
       "0.03901010818768667`", ",", "0.03442954396431908`", ",", 
       "0.1153387988212997`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.37042231588553776`", ",", "0.1469756000190904`", ",", 
       "0.044728861096145926`", ",", "0.045383218350145554`", ",", 
       "0.16709479076254072`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3713078357451424`", ",", "0.09454025887703421`", ",", 
       "0.02120113883162507`", ",", "0.022398603901534125`", ",", 
       "0.08792571638604534`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.37223823377713383`", ",", "0.1385169383268233`", ",", 
       "0.044654595080228884`", ",", "0.04417477739403827`", ",", 
       "0.158586950747619`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3747056777795237`", ",", "0.24667375965707544`", ",", 
       "0.034765011172416344`", ",", "0.040620071120208275`", ",", 
       "0.22614345699990832`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.37596713334006`", ",", "0.12798916380850825`", ",", 
       "0.022553540994273653`", ",", "0.02289421676362017`", ",", 
       "0.13803875104405994`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.37625270573163205`", ",", "0.16356261844611358`", ",", 
       "0.025333111070737636`", ",", "0.027418662277462178`", ",", 
       "0.1744185430856182`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.37637454790203245`", ",", "0.11524086226446693`", ",", 
       "0.03019436929696522`", ",", "0.023161376929037164`", ",", 
       "0.12507776559499453`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3782254436295909`", ",", "0.20855028901791456`", ",", 
       "0.07582953147746585`", ",", "0.06828081058277692`", ",", 
       "0.2671877659068543`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3786788115456325`", ",", "0.11467364045898326`", ",", 
       "0.054380219865947106`", ",", "0.04663234243891971`", ",", 
       "0.15903491136690487`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3801222532623756`", ",", "0.17228154373577734`", ",", 
       "0.14792266454933703`", ",", "0.10546256563845978`", ",", 
       "0.29370659639873564`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.38431127432636036`", ",", "0.2984699325680976`", ",", 
       "0.16808239720650162`", ",", "0.13596839687571435`", ",", 
       "0.4453091272059003`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3848851011631452`", ",", "0.20453112173935756`", ",", 
       "0.029146587789687244`", ",", "0.029058403875634593`", ",", 
       "0.21276395727499214`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3857150965901485`", ",", "0.1914715751524255`", ",", 
       "0.06472236942372393`", ",", "0.04847818207129331`", ",", 
       "0.23599206341331977`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3860097541394547`", ",", "0.1975151940183243`", ",", 
       "0.03698431366451879`", ",", "0.037574695558503846`", ",", 
       "0.21562867338201747`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.38791635888475356`", ",", "0.24213691722364566`", ",", 
       "0.06653147312317971`", ",", "0.06616243902624722`", ",", 
       "0.2536515781620774`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.38799532307152435`", ",", "0.17630872294204908`", ",", 
       "0.10694911952686967`", ",", "0.07621487786899582`", ",", 
       "0.25613397889391476`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.38834162671634165`", ",", "0.2114640897761655`", ",", 
       "0.06796575224415992`", ",", "0.07039733101236081`", ",", 
       "0.22305924515012668`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.38947303637939096`", ",", "0.12131633526303602`", ",", 
       "0.04737030524509311`", ",", "0.03969541665158044`", ",", 
       "0.15163411494087428`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.390487042500062`", ",", "0.17258638366733423`", ",", 
       "0.09130397028600713`", ",", "0.06660643923575751`", ",", 
       "0.2576574953577445`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3910831028517626`", ",", "0.20891347524883871`", ",", 
       "0.04265665541352808`", ",", "0.04922288711698407`", ",", 
       "0.21465790159460327`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3919916767951687`", ",", "0.13368513352014558`", ",", 
       "0.02410651090150354`", ",", "0.027442255339062353`", ",", 
       "0.11841528431342314`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.39508773739175734`", ",", "0.128958574975718`", ",", 
       "0.1557546815743331`", ",", "0.10270172310334688`", ",", 
       "0.27558506153284656`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3952603686115408`", ",", "0.2517662473020586`", ",", 
       "0.1356390689309278`", ",", "0.11926348243313652`", ",", 
       "0.36696739896054775`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.39526398373773663`", ",", "0.11473862033554338`", ",", 
       "0.09035350999436252`", ",", "0.06214473427678107`", ",", 
       "0.19630882217130224`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.39643326532527523`", ",", "0.228570287559238`", ",", 
       "0.1577229072252033`", ",", "0.1171739891431309`", ",", 
       "0.3518431780180275`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.398391241072189`", ",", "0.16536418515505225`", ",", 
       "0.04904581154890196`", ",", "0.033481909700651416`", ",", 
       "0.16113244980519073`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.39858258766681015`", ",", "0.08819454555954881`", ",", 
       "0.04038030866671998`", ",", "0.036273375130340124`", ",", 
       "0.11167317103380207`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.39863802533432197`", ",", "0.20476730329773832`", ",", 
       "0.029458720759022512`", ",", "0.0329277744619492`", ",", 
       "0.21616241177183387`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4005370838871938`", ",", "0.15457437714391778`", ",", 
       "0.08136861548697803`", ",", "0.056020146055616074`", ",", 
       "0.17991978513851356`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.40065440078046555`", ",", "0.06811949711723339`", ",", 
       "0.05833206979069349`", ",", "0.04108498428014944`", ",", 
       "0.11890315573759776`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.40228864385284363`", ",", "0.08224565154554193`", ",", 
       "0.01667062439939626`", ",", "0.016413077574892743`", ",", 
       "0.08073851960691501`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4027075758896984`", ",", "0.09404820526215564`", ",", 
       "0.02443799219115263`", ",", "0.027732142886724938`", ",", 
       "0.08654803710733655`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4040012310708246`", ",", "0.18141540071365667`", ",", 
       "0.0410340187596628`", ",", "0.046732123250361426`", ",", 
       "0.17539666037329213`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4042298971167582`", ",", "0.17868743935262757`", ",", 
       "0.020519596166129507`", ",", "0.02126313775438071`", ",", 
       "0.1719619472469689`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.40536416764397254`", ",", "0.28877767510992025`", ",", 
       "0.04138970607148264`", ",", "0.04606211429053962`", ",", 
       "0.2666060413862794`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4060520713043429`", ",", "0.14847583138386147`", ",", 
       "0.04957490758533696`", ",", "0.04273738697687822`", ",", 
       "0.14217937366353506`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4068223581968212`", ",", "0.24143814087194937`", ",", 
       "0.0754416937842142`", ",", "0.06186604081924403`", ",", 
       "0.29403597692141037`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4074772593005959`", ",", "0.14282428695350716`", ",", 
       "0.04580668266010865`", ",", "0.03837292786335927`", ",", 
       "0.1658021891474834`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.40832778398946845`", ",", "0.10568286455697042`", ",", 
       "0.02142308822514539`", ",", "0.022976393931907643`", ",", 
       "0.10909587271982212`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.40968598516906796`", ",", "0.10339552102801629`", ",", 
       "0.04755707342844433`", ",", "0.0368821793584988`", ",", 
       "0.15030261388152458`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4116477926079556`", ",", "0.1943410845258448`", ",", 
       "0.05524762170657767`", ",", "0.05009693223396503`", ",", 
       "0.2325264830101366`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4123232011030976`", ",", "0.1747852681061166`", ",", 
       "0.030815187391846938`", ",", "0.03589650702861656`", ",", 
       "0.16307417066288474`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.41241673162957715`", ",", "0.17046961174904088`", ",", 
       "0.0667454686359306`", ",", "0.05084616541711021`", ",", 
       "0.2008869027975275`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4136467534923696`", ",", "0.265888073433266`", ",", 
       "0.1287503373679658`", ",", "0.10916096634747746`", ",", 
       "0.38399406552168913`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4143660867776898`", ",", "0.26280725278257216`", ",", 
       "0.09183202626872042`", ",", "0.07458592438541337`", ",", 
       "0.3167571712239214`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.41552690981381835`", ",", "0.15824818264864732`", ",", 
       "0.05775289812954255`", ",", "0.04649624026054731`", ",", 
       "0.1650787098441873`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4179656117210808`", ",", "0.10164832113394086`", ",", 
       "0.019664334488369885`", ",", "0.021672781485245214`", ",", 
       "0.09425264184674317`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4187360006675243`", ",", "0.23140066205519771`", ",", 
       "0.07240543498215687`", ",", "0.06319687160619784`", ",", 
       "0.2745974352667968`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4187568190879506`", ",", "0.20243043477772074`", ",", 
       "0.17196269924010585`", ",", "0.11459945360747655`", ",", 
       "0.3432054252463455`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.41936482458352475`", ",", "0.053423126550115684`", ",", 
       "0.014935208818352062`", ",", "0.014558540186128508`", ",", 
       "0.049565894768359285`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4211779506718156`", ",", "0.11820244741378123`", ",", 
       "0.10355289674349834`", ",", "0.06685940253368253`", ",", 
       "0.19491342433150877`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4214089023254712`", ",", "0.12504385999560969`", ",", 
       "0.09538290616893096`", ",", "0.07014462606708954`", ",", 
       "0.18119531423469962`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4221364052435764`", ",", "0.12465280490843246`", ",", 
       "0.008384553911720638`", ",", "0.009987075979171239`", ",", 
       "0.12713485346739667`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4255887928484297`", ",", "0.1545920531737343`", ",", 
       "0.03014418632417207`", ",", "0.025891009001892396`", ",", 
       "0.1780531696994794`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4259078085657478`", ",", "0.21956029598089982`", ",", 
       "0.05078173317464908`", ",", "0.0410153360603016`", ",", 
       "0.2607887184476372`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.42646612954392016`", ",", "0.2293365163672689`", ",", 
       "0.25352480062396715`", ",", "0.15723388813002015`", ",", 
       "0.4448899960668694`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.42667364425739107`", ",", "0.10036111938947831`", ",", 
       "0.044013356847047894`", ",", "0.032156728154972426`", ",", 
       "0.11728635092107577`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4274073627182842`", ",", "0.08310817184960051`", ",", 
       "0.021244912841656364`", ",", "0.020277976870349646`", ",", 
       "0.08684314628589712`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4274775853122405`", ",", "0.18184530317798836`", ",", 
       "0.1034989348188733`", ",", "0.06954386630025368`", ",", 
       "0.26179967930910975`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.42867989241856524`", ",", "0.1517620675099278`", ",", 
       "0.06077167961953357`", ",", "0.051065799289988036`", ",", 
       "0.17459429883891112`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.43021175685815655`", ",", "0.19790410776608375`", ",", 
       "0.18140946552567416`", ",", "0.1232242650565751`", ",", 
       "0.3079197107407884`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.43035113011960296`", ",", "0.1095629427520518`", ",", 
       "0.046192714154859454`", ",", "0.04126187687837645`", ",", 
       "0.13981575743033964`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4306404389204751`", ",", "0.26334715041871076`", ",", 
       "0.1549413358314853`", ",", "0.13627280185530946`", ",", 
       "0.37365837210359837`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4309460983538894`", ",", "0.18150728594653204`", ",", 
       "0.11108651187690016`", ",", "0.07461995062152112`", ",", 
       "0.27274398874265016`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4310860411437072`", ",", "0.16478505593976842`", ",", 
       "0.23227272592987666`", ",", "0.14086097652256116`", ",", 
       "0.373175919156593`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.43157627593860953`", ",", "0.09082458805489112`", ",", 
       "0.010693349104156685`", ",", "0.012828225326161619`", ",", 
       "0.09469667861074513`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4318151908371209`", ",", "0.12196947892814804`", ",", 
       "0.05760771131019409`", ",", "0.04428602790572874`", ",", 
       "0.16675718272821968`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4327852244359497`", ",", "0.04716079863424592`", ",", 
       "0.04689032439319457`", ",", "0.0327992405097393`", ",", 
       "0.09226313075038671`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4346623674142351`", ",", "0.17275636110130455`", ",", 
       "0.07793715529518895`", ",", "0.06190643945109898`", ",", 
       "0.22337340317606935`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.43508642940411585`", ",", "0.23582745752653625`", ",", 
       "0.04719937289189745`", ",", "0.05229516130422778`", ",", 
       "0.25251682142084453`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.435531295616692`", ",", "0.13543275890740678`", ",", 
       "0.17871119548543662`", ",", "0.11688817915418097`", ",", 
       "0.30722696502687963`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.43601846914295506`", ",", "0.030751716584803978`", ",", 
       "0.014379883229382528`", ",", "0.013339561295314582`", ",", 
       "0.034169534493716125`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4369019982919928`", ",", "0.13579931250460192`", ",", 
       "0.1626343452527722`", ",", "0.10079321998906346`", ",", 
       "0.27284899276996155`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.43755349885110895`", ",", "0.156215206983338`", ",", 
       "0.1066021082735698`", ",", "0.08113589177524692`", ",", 
       "0.23372935360737188`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4380515369200582`", ",", "0.15053400009537796`", ",", 
       "0.020430884235427018`", ",", "0.02146619861610994`", ",", 
       "0.1364729136973393`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.438227659197498`", ",", "0.1538665687490473`", ",", 
       "0.18996236995051385`", ",", "0.11870377147220174`", ",", 
       "0.3191416082514263`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4383792026530511`", ",", "0.3032203655857672`", ",", 
       "0.2425193991439092`", ",", "0.17302491746920792`", ",", 
       "0.523304998087894`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4390881146218183`", ",", "0.026943291149959466`", ",", 
       "0.00792838410205136`", ",", "0.008564561622522397`", ",", 
       "0.026203379983288883`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.43915147530851306`", ",", "0.0595924904964311`", ",", 
       "0.015299063453702029`", ",", "0.019371728313717484`", ",", 
       "0.05137016970273105`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.439823615260752`", ",", "0.138191912432876`", ",", 
       "0.1617124780453194`", ",", "0.1021256455187019`", ",", 
       "0.25296830980760543`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44072501691580035`", ",", "0.11901570685187922`", ",", 
       "0.043077769563357925`", ",", "0.03473018455621665`", ",", 
       "0.1533916951988609`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44114284903403966`", ",", "0.1163554634926412`", ",", 
       "0.04769579371646346`", ",", "0.0440171096896197`", ",", 
       "0.12560463805143654`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44166454241592196`", ",", "0.12181170613543875`", ",", 
       "0.02534864821503684`", ",", "0.029524243428796438`", ",", 
       "0.10697269763341441`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4419410449027648`", ",", "0.24396011510519944`", ",", 
       "0.11811837452693265`", ",", "0.0990563051022415`", ",", 
       "0.27407134676744943`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44210556710680243`", ",", "0.12862908568836273`", ",", 
       "0.05232833905397963`", ",", "0.04026854617033856`", ",", 
       "0.15772717369135825`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4424084472175919`", ",", "0.141064413555506`", ",", 
       "0.08992389730828768`", ",", "0.07097992302060163`", ",", 
       "0.2107428422720949`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44329737429631555`", ",", "0.22950193508051034`", ",", 
       "0.05144602143486751`", ",", "0.046182743714056174`", ",", 
       "0.21706702211601642`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4441534279982352`", ",", "0.10476254743691693`", ",", 
       "0.09534426894503355`", ",", "0.07007699337932044`", ",", 
       "0.17126322800264812`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4442303333597441`", ",", "0.1667820127657902`", ",", 
       "0.05209362396822061`", ",", "0.05683604551252941`", ",", 
       "0.19259155973360392`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4442307050295745`", ",", "0.1503818833810386`", ",", 
       "0.030544334878123133`", ",", "0.030493098191270905`", ",", 
       "0.15202682645641913`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44475447885505653`", ",", "0.20452060802071398`", ",", 
       "0.07152024013696973`", ",", "0.06068685289907481`", ",", 
       "0.24068081377438152`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4452732361353086`", ",", "0.22270464337054283`", ",", 
       "0.341671049451662`", ",", "0.20366000559931965`", ",", 
       "0.5496332023104484`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44558412545212805`", ",", "0.1187756476115016`", ",", 
       "0.06585939127144957`", ",", "0.05049187900837699`", ",", 
       "0.17951629714295833`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44641794693139625`", ",", "0.09296069581800358`", ",", 
       "0.04665922003020896`", ",", "0.02975131698644828`", ",", 
       "0.11595256064125829`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44812652712174045`", ",", "0.11101687600774941`", ",", 
       "0.02345583078321812`", ",", "0.026943061302530665`", ",", 
       "0.11837756356229377`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44830396388063165`", ",", "0.24310297784110432`", ",", 
       "0.25830248935556294`", ",", "0.19079087526550456`", ",", 
       "0.4414972488174333`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4485047315633493`", ",", "0.09053212885567391`", ",", 
       "0.01031417434105043`", ",", "0.013135210214926136`", ",", 
       "0.08193247473534258`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4487500454092075`", ",", "0.2094140370100352`", ",", 
       "0.0590856703009326`", ",", "0.07163492312007926`", ",", 
       "0.1979528732973286`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.449622448685333`", ",", "0.0675542585467841`", ",", 
       "0.03662719508296118`", ",", "0.03226804743610365`", ",", 
       "0.08693240855881779`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.44997380274551474`", ",", "0.22116288346672885`", ",", 
       "0.15918137666022092`", ",", "0.11574735876154647`", ",", 
       "0.34573154994078664`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4504627535142783`", ",", "0.12362917527054336`", ",", 
       "0.02781147613587752`", ",", "0.026339239493528902`", ",", 
       "0.1476502511578636`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45068842630803824`", ",", "0.08256392066880985`", ",", 
       "0.017605347452314426`", ",", "0.019743605526994765`", ",", 
       "0.0755102727531771`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45096016221974833`", ",", "0.07743289335533571`", ",", 
       "0.03288094947421898`", ",", "0.02310455503242237`", ",", 
       "0.10347800873719387`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45110025125107894`", ",", "0.10097735610672287`", ",", 
       "0.017855500206878486`", ",", "0.017394301490391725`", ",", 
       "0.10263208084887727`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4515787424882565`", ",", "0.13868806906990783`", ",", 
       "0.033688159196178645`", ",", "0.037789922172514166`", ",", 
       "0.14460129561593965`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4518289776833447`", ",", "0.19156460046223556`", ",", 
       "0.1108299856604149`", ",", "0.07848070906412265`", ",", 
       "0.25737021448459313`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4530883765614299`", ",", "0.19849778080526168`", ",", 
       "0.05135279657694966`", ",", "0.04579843672561149`", ",", 
       "0.2472604723088191`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4537275851018774`", ",", "0.1946534251246451`", ",", 
       "0.04433551379874663`", ",", "0.03747992977646708`", ",", 
       "0.20712575298849653`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4540652944038121`", ",", "0.2342159043349827`", ",", 
       "0.2225522110185793`", ",", "0.14282919746615746`", ",", 
       "0.4560441857242791`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4552779370777375`", ",", "0.07021384155807152`", ",", 
       "0.05311937169864574`", ",", "0.032002384819099616`", ",", 
       "0.10014226249167082`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45590174478490525`", ",", "0.15808420579364849`", ",", 
       "0.0332005635870664`", ",", "0.025593411714600372`", ",", 
       "0.18328744306327002`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45617554077658296`", ",", "0.06102554450215766`", ",", 
       "0.02282130771258733`", ",", "0.02475783165353055`", ",", 
       "0.06905057408601882`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45671225033830143`", ",", "0.17778671088308703`", ",", 
       "0.31864806894272013`", ",", "0.1817114929684146`", ",", 
       "0.46450904380873703`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45715820630333065`", ",", "0.07535145068401182`", ",", 
       "0.019231299357450254`", ",", "0.020420414183634585`", ",", 
       "0.06524554397833203`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.457533141108058`", ",", "0.10719711583106012`", ",", 
       "0.05198070437848989`", ",", "0.040157702680561506`", ",", 
       "0.15433853682433946`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45767817613268147`", ",", "0.1988359583429494`", ",", 
       "0.07767724665339415`", ",", "0.06994238494961491`", ",", 
       "0.26910282332726093`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4576923311038795`", ",", "0.09622469619647923`", ",", 
       "0.05444404393346873`", ",", "0.04644191231973139`", ",", 
       "0.12305292574473911`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4578322325995294`", ",", "0.2721979720945292`", ",", 
       "0.12098966561685383`", ",", "0.09862686218524312`", ",", 
       "0.3785083209199524`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45792227394138213`", ",", "0.1582938088321542`", ",", 
       "0.25813359084879506`", ",", "0.16512461021721334`", ",", 
       "0.3889572031402805`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45804264992079025`", ",", "0.1335814523180346`", ",", 
       "0.030981918456772617`", ",", "0.037271062164358076`", ",", 
       "0.10824650781797457`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4581588844415563`", ",", "0.10515021748910844`", ",", 
       "0.027173611790678936`", ",", "0.024239103851519506`", ",", 
       "0.10666956846499422`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45834349222121823`", ",", "0.19876608833087717`", ",", 
       "0.06873700162571164`", ",", "0.06363977904008286`", ",", 
       "0.2001932747852751`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4584219863094471`", ",", "0.12103951344559286`", ",", 
       "0.028850159085586274`", ",", "0.028611630403920146`", ",", 
       "0.11604906991498941`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4588727565172666`", ",", "0.15520773821359987`", ",", 
       "0.07716867170480526`", ",", "0.061542162531520415`", ",", 
       "0.21049935645468565`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.459480526916995`", ",", "0.169285219006998`", ",", 
       "0.3499368379838528`", ",", "0.2152289064504535`", ",", 
       "0.48013495907064313`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4595663112840588`", ",", "0.05152537094778054`", ",", 
       "0.026978112409243964`", ",", "0.024538653501051354`", ",", 
       "0.06445256943617543`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4595691051585376`", ",", "0.1342876832079415`", ",", 
       "0.1615394365499451`", ",", "0.09259399491709644`", ",", 
       "0.2547926751350619`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45960672050625406`", ",", "0.12012154540467655`", ",", 
       "0.024232017265431522`", ",", "0.01900948573843523`", ",", 
       "0.1179406904164324`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4596299153458507`", ",", "0.09838670375503798`", ",", 
       "0.029054148443484425`", ",", "0.021673665201459136`", ",", 
       "0.10423532521263669`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45985084519306324`", ",", "0.1373928456118179`", ",", 
       "0.06656153365952101`", ",", "0.06022191040167247`", ",", 
       "0.15299308252063784`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.45992794699241263`", ",", "0.0736358950995746`", ",", 
       "0.021986935058455476`", ",", "0.02612531676274237`", ",", 
       "0.07615244579038499`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46021126663659295`", ",", "0.1501504188794963`", ",", 
       "0.02800287203294296`", ",", "0.03317957599771881`", ",", 
       "0.15601320826711676`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4602985486770246`", ",", "0.14392367146720644`", ",", 
       "0.09090423990553986`", ",", "0.07519559334377078`", ",", 
       "0.18685246322713076`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4603215039988833`", ",", "0.11026742001824626`", ",", 
       "0.030986557307810487`", ",", "0.03331632912471209`", ",", 
       "0.10043668443453975`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46050689138619977`", ",", "0.1015666564960148`", ",", 
       "0.03558252922229695`", ",", "0.03092079841805442`", ",", 
       "0.11902890336526104`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46054501535924525`", ",", "0.12690870081953398`", ",", 
       "0.06994923277240384`", ",", "0.05892189146440699`", ",", 
       "0.16657182834901538`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46090777543101824`", ",", "0.11322755014698567`", ",", 
       "0.026926538070994835`", ",", "0.025461715279603205`", ",", 
       "0.12642899034568972`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4612968582944521`", ",", "0.12934349712137705`", ",", 
       "0.036486593641365785`", ",", "0.03841503022291079`", ",", 
       "0.1241801651528986`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4619998307495857`", ",", "0.11544903424648248`", ",", 
       "0.039868447176227964`", ",", "0.03151007430068846`", ",", 
       "0.12005579096887832`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4621395900865138`", ",", "0.2114579994423838`", ",", 
       "0.1371381922788686`", ",", "0.1063904181826634`", ",", 
       "0.2816248216212495`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4628040823746429`", ",", "0.1415573955804295`", ",", 
       "0.041606327409305775`", ",", "0.037777534078796214`", ",", 
       "0.15103062932182668`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46286673288559216`", ",", "0.09514615899901462`", ",", 
       "0.04984040889093825`", ",", "0.04079067741761319`", ",", 
       "0.1055277954352392`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46402246424482374`", ",", "0.12113433788799506`", ",", 
       "0.028274447357578305`", ",", "0.029055880968823684`", ",", 
       "0.11907653642287673`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4640765717540726`", ",", "0.10289587911647936`", ",", 
       "0.09226018063595406`", ",", "0.0639991131695682`", ",", 
       "0.15743650911286725`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4648737198163415`", ",", "0.10087561597600499`", ",", 
       "0.08242444780824429`", ",", "0.05605875691991223`", ",", 
       "0.16199635652242536`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4653519103664248`", ",", "0.1505015725124976`", ",", 
       "0.0779072171900209`", ",", "0.04967261707519173`", ",", 
       "0.18333532782833356`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46555955044593866`", ",", "0.10017449737941922`", ",", 
       "0.06766849737056022`", ",", "0.049013842187318836`", ",", 
       "0.13955767595936022`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46560963217510487`", ",", "0.15264917725723495`", ",", 
       "0.05679333263177121`", ",", "0.05525299219814295`", ",", 
       "0.18541232671537147`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46569896091631197`", ",", "0.12381356631990936`", ",", 
       "0.04219454815452803`", ",", "0.035584530696375544`", ",", 
       "0.16223077956413293`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46631837644121`", ",", "0.1751827869889191`", ",", 
       "0.034784907410208066`", ",", "0.03474595351822961`", ",", 
       "0.17216249060251135`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46666276161438214`", ",", "0.1562920995291515`", ",", 
       "0.11860839316356746`", ",", "0.07724827134831504`", ",", 
       "0.22651012595158648`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46713338181216923`", ",", "0.22033731726359362`", ",", 
       "0.08409484781485475`", ",", "0.0659023787391393`", ",", 
       "0.2933881992318173`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4673418530331697`", ",", "0.2231047323554237`", ",", 
       "0.05045588975503237`", ",", "0.05307536544454243`", ",", 
       "0.19479728364793344`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46747438050956325`", ",", "0.17696253020277167`", ",", 
       "0.14079444237982425`", ",", "0.1127796461770377`", ",", 
       "0.2892523203795686`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4677721903579616`", ",", "0.1613294776126643`", ",", 
       "0.06466351492805039`", ",", "0.050889069692553995`", ",", 
       "0.20939613461293227`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4678400341048276`", ",", "0.13248630296177427`", ",", 
       "0.13469117176611622`", ",", "0.105076335020274`", ",", 
       "0.2418899817158467`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4686901324879259`", ",", "0.13353673734341887`", ",", 
       "0.027012777006032974`", ",", "0.03005308268425625`", ",", 
       "0.14220351644612012`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4687095546129344`", ",", "0.11463249938174881`", ",", 
       "0.07104811863747176`", ",", "0.06285477906388935`", ",", 
       "0.1787251664012906`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.46999079074671546`", ",", "0.30958482766208`", ",", 
       "0.11638198730817367`", ",", "0.09198439647471496`", ",", 
       "0.3878484703579185`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4705293399060794`", ",", "0.1503412384715357`", ",", 
       "0.026943873085543097`", ",", "0.028355888656124553`", ",", 
       "0.15537834912650422`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.470768627290281`", ",", "0.15893149221466663`", ",", 
       "0.05466044406906735`", ",", "0.04894786610775851`", ",", 
       "0.1766127959261769`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4707871603068838`", ",", "0.1016548915272264`", ",", 
       "0.060893465482693115`", ",", "0.04220533476382497`", ",", 
       "0.1555275381859023`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4707991389472356`", ",", "0.2584241195612713`", ",", 
       "0.0949623927755406`", ",", "0.0874359372261326`", ",", 
       "0.3186655665204009`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.471223669522562`", ",", "0.1819188871121867`", ",", 
       "0.20752534153143953`", ",", "0.13039165202965192`", ",", 
       "0.31738289758319965`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4714277392024777`", ",", "0.21242122286274095`", ",", 
       "0.2649135399314288`", ",", "0.17794707611788102`", ",", 
       "0.4750227039905371`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.471474587166401`", ",", "0.1334093625615411`", ",", 
       "0.06949617963700143`", ",", "0.06655431357243256`", ",", 
       "0.17787961235887775`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47197662542122326`", ",", "0.22371687740817195`", ",", 
       "0.11359133022215871`", ",", "0.09015658684953456`", ",", 
       "0.3339744309900539`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4721673958422332`", ",", "0.13482123091248743`", ",", 
       "0.04679802146029758`", ",", "0.03331510806820849`", ",", 
       "0.14240353847267967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47332286799515405`", ",", "0.08905354628287586`", ",", 
       "0.03548414883177979`", ",", "0.035241405597573515`", ",", 
       "0.1175474879401834`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4734738895610448`", ",", "0.14342191654061354`", ",", 
       "0.12693983805641537`", ",", "0.0817340771055868`", ",", 
       "0.20614800225389296`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4740014569628299`", ",", "0.12737048182437408`", ",", 
       "0.0314824785095844`", ",", "0.03504938831464179`", ",", 
       "0.11498310023441917`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4746780754652544`", ",", "0.1515117392028889`", ",", 
       "0.2427713682828339`", ",", "0.13953954256645842`", ",", 
       "0.37288457029182026`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4747195283668552`", ",", "0.14648260656661807`", ",", 
       "0.0822376134778058`", ",", "0.06011026163119416`", ",", 
       "0.22630534333996533`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.474763871468588`", ",", "0.10111632526640439`", ",", 
       "0.053948261721383506`", ",", "0.041153246291072205`", ",", 
       "0.11600134726115195`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47501241344013057`", ",", "0.20879969312188926`", ",", 
       "0.4436716558420869`", ",", "0.264223192288772`", ",", 
       "0.609422614696798`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4751610131543071`", ",", "0.08490333847470295`", ",", 
       "0.03056723962387142`", ",", "0.034505228129227614`", ",", 
       "0.08339557762290228`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4765385470427808`", ",", "0.16954275216657794`", ",", 
       "0.02481337970689424`", ",", "0.032221740204598164`", ",", 
       "0.16397226514388732`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.476694802729031`", ",", "0.18096321096703258`", ",", 
       "0.06835467291421458`", ",", "0.05924157118155053`", ",", 
       "0.19100413042939005`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4769514881424485`", ",", "0.13144049769397548`", ",", 
       "0.14417287198341297`", ",", "0.1002298296265006`", ",", 
       "0.25983074308776266`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47698502923821234`", ",", "0.12471779987190343`", ",", 
       "0.10962555779358057`", ",", "0.07496379977194349`", ",", 
       "0.2272372114165229`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4773068449531578`", ",", "0.07301146501327244`", ",", 
       "0.023090542063238004`", ",", "0.021112710897705497`", ",", 
       "0.0720668128654147`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4780086053697099`", ",", "0.08316008282138727`", ",", 
       "0.07491239645113662`", ",", "0.05173948688382581`", ",", 
       "0.1474433150267585`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47822694137180194`", ",", "0.14946479519238284`", ",", 
       "0.041731634040437546`", ",", "0.036607330739123936`", ",", 
       "0.170279371548041`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47832285419680337`", ",", "0.10012548116404466`", ",", 
       "0.1213091593994086`", ",", "0.08130532074143738`", ",", 
       "0.21483995730321437`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47850798067925104`", ",", "0.1689056710029202`", ",", 
       "0.19068264054358997`", ",", "0.1283198204914291`", ",", 
       "0.34750366433624313`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47876813977168775`", ",", "0.05158509990713589`", ",", 
       "0.01396532536407318`", ",", "0.014451349060423755`", ",", 
       "0.05524788349313126`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4792334141401049`", ",", "0.15039778547865715`", ",", 
       "0.08609019086093968`", ",", "0.08105614190506572`", ",", 
       "0.18088526942355476`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47972270781949955`", ",", "0.07595308214557162`", ",", 
       "0.03446880920748452`", ",", "0.031953449342745126`", ",", 
       "0.08489886875969958`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4798238209230861`", ",", "0.13450293235561678`", ",", 
       "0.05198873862229911`", ",", "0.04848655303044248`", ",", 
       "0.145287762497748`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.47989687852030144`", ",", "0.133086976142482`", ",", 
       "0.060939464999341754`", ",", "0.046119296389054085`", ",", 
       "0.1837107616265576`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4802802806341644`", ",", "0.1574585021131362`", ",", 
       "0.03980799791728093`", ",", "0.0323550161461684`", ",", 
       "0.1692124137674788`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4804521104937907`", ",", "0.16783793891044424`", ",", 
       "0.0675057866030804`", ",", "0.05675084144685023`", ",", 
       "0.20395005736696872`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48081711118936116`", ",", "0.13849901244737262`", ",", 
       "0.07021735396723261`", ",", "0.07049337099174009`", ",", 
       "0.17816687597504885`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48172095907085255`", ",", "0.1422096790925509`", ",", 
       "0.06886178240018825`", ",", "0.05483753712904633`", ",", 
       "0.1947564787436527`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48188093568873736`", ",", "0.21545808422076684`", ",", 
       "0.09810302722100915`", ",", "0.09134439883419329`", ",", 
       "0.298473503828425`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4821179941638402`", ",", "0.12685312568784324`", ",", 
       "0.06673076313148565`", ",", "0.06515863130633091`", ",", 
       "0.14971053558551048`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4823389527760038`", ",", "0.21373356884597697`", ",", 
       "0.503888273103399`", ",", "0.2873264229508419`", ",", 
       "0.6869145932906019`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4824390013027934`", ",", "0.06457682155320829`", ",", 
       "0.004864338796614557`", ",", "0.0053491710768643645`", ",", 
       "0.060108723470189675`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48244475510059254`", ",", "0.08283202182000445`", ",", 
       "0.03486522198954442`", ",", "0.03294084386090164`", ",", 
       "0.09101456309764341`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.482473888137831`", ",", "0.1725084631296134`", ",", 
       "0.3974387065889711`", ",", "0.22059123719104157`", ",", 
       "0.5256770326281726`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4827532397293097`", ",", "0.11708330942039505`", ",", 
       "0.10013163484741242`", ",", "0.0813089741025407`", ",", 
       "0.19213517595339583`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4838912571995328`", ",", "0.3191507038945607`", ",", 
       "0.27170133472559904`", ",", "0.19318091547597385`", ",", 
       "0.5781452665918176`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4839434318285506`", ",", "0.18455692761373543`", ",", 
       "0.03702014191971424`", ",", "0.04088046251693492`", ",", 
       "0.2095768710737474`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48516527011758537`", ",", "0.2544384164896824`", ",", 
       "0.06582900293535206`", ",", "0.056443387419683674`", ",", 
       "0.27297324199901374`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4852225521901224`", ",", "0.1281282317457679`", ",", 
       "0.03242243996342736`", ",", "0.026949168636047037`", ",", 
       "0.14696229294198856`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48560856019017845`", ",", "0.20733683110848905`", ",", 
       "0.27219656710573314`", ",", "0.18070753284570107`", ",", 
       "0.3965998721141298`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4857785619116722`", ",", "0.23525707257482378`", ",", 
       "0.0746888653831629`", ",", "0.08082090006983136`", ",", 
       "0.23339404688844956`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48698006468933075`", ",", "0.2221268145880754`", ",", 
       "0.2974184887469808`", ",", "0.16392332522024905`", ",", 
       "0.47208194532119757`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4870436756326793`", ",", "0.20368296421540477`", ",", 
       "0.09407815098758944`", ",", "0.06842005091065834`", ",", 
       "0.27052676932399683`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4875346217156654`", ",", "0.1798732033766329`", ",", 
       "0.04759780109577369`", ",", "0.055802460315662196`", ",", 
       "0.1556460943437134`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4882995546276583`", ",", "0.22178108313067968`", ",", 
       "0.22152596371265296`", ",", "0.17266361882420833`", ",", 
       "0.41733369449143304`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4885068766250019`", ",", "0.14049836518400866`", ",", 
       "0.07837473230746535`", ",", "0.05509777496438209`", ",", 
       "0.18572568440830278`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4885174283344474`", ",", "0.20258029784636838`", ",", 
       "0.06379632059631998`", ",", "0.06776679426454299`", ",", 
       "0.18531671017404114`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48853131220340473`", ",", "0.17082579065147832`", ",", 
       "0.24379836668624358`", ",", "0.13892545626500985`", ",", 
       "0.3696813497068733`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4885909947401451`", ",", "0.1742726457776218`", ",", 
       "0.11865219055161064`", ",", "0.08785915141646625`", ",", 
       "0.24531551550894834`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4889589785923159`", ",", "0.09980834005841455`", ",", 
       "0.06495805439391787`", ",", "0.04996504038142937`", ",", 
       "0.12960040251429672`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48923412261165244`", ",", "0.14436389876556088`", ",", 
       "0.04161590864426843`", ",", "0.03633717580860302`", ",", 
       "0.1621225197294202`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48934640042178074`", ",", "0.10742788809712844`", ",", 
       "0.0554828795094931`", ",", "0.04160806257327513`", ",", 
       "0.15368139528980654`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.48977262451799664`", ",", "0.08319482590152914`", ",", 
       "0.01800702334796495`", ",", "0.018288365164233527`", ",", 
       "0.08132117109284466`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49022099711088746`", ",", "0.1578962803906144`", ",", 
       "0.10140111093926042`", ",", "0.0695553853511406`", ",", 
       "0.2141427020171354`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49026114547482946`", ",", "0.12234051575224023`", ",", 
       "0.02653315201278376`", ",", "0.03148286508291104`", ",", 
       "0.13368082296189224`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4905718817347176`", ",", "0.10307249976062051`", ",", 
       "0.1185485378874625`", ",", "0.07772020658078223`", ",", 
       "0.20513643061147677`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49095296426909774`", ",", "0.2354708675144363`", ",", 
       "0.06204573969214304`", ",", "0.0450874283047011`", ",", 
       "0.23835157110334848`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49113575178488356`", ",", "0.12149567237642012`", ",", 
       "0.12465983007193424`", ",", "0.07609628706767266`", ",", 
       "0.22163605501443082`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4913990900984979`", ",", "0.19407191339467067`", ",", 
       "0.46226016589709895`", ",", "0.2572132664358565`", ",", 
       "0.6377383396964936`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49162468219544153`", ",", "0.12516707390730805`", ",", 
       "0.034915401334732254`", ",", "0.03071187741780958`", ",", 
       "0.13578066658586657`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4916610830848417`", ",", "0.20756192842447563`", ",", 
       "0.06504773208927805`", ",", "0.06033445935063687`", ",", 
       "0.2617364324724932`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4922436157224915`", ",", "0.1004310183412411`", ",", 
       "0.028841958319947673`", ",", "0.036108492185558415`", ",", 
       "0.0961362080080045`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4924176348504344`", ",", "0.11464076441665125`", ",", 
       "0.12275811456902813`", ",", "0.08801422528412224`", ",", 
       "0.21274846712637957`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4927134401732254`", ",", "0.2123490949258328`", ",", 
       "0.22854773685912444`", ",", "0.13892552032983485`", ",", 
       "0.42612489946146176`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4940510446889419`", ",", "0.16953950074428603`", ",", 
       "0.13681925554505592`", ",", "0.10359977380847096`", ",", 
       "0.2666605597069723`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49422661520221733`", ",", "0.09418751470099121`", ",", 
       "0.01106513936467479`", ",", "0.013907245652935354`", ",", 
       "0.09790849044939981`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4952299669568488`", ",", "0.13994728763122707`", ",", 
       "0.025024856918313576`", ",", "0.030523037225860854`", ",", 
       "0.1276354386025664`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49558364723312676`", ",", "0.2367512598004862`", ",", 
       "0.11654950469043111`", ",", "0.08063668193395182`", ",", 
       "0.269159460802504`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49567766372425226`", ",", "0.1049239192921567`", ",", 
       "0.05883114404121229`", ",", "0.04923922714200596`", ",", 
       "0.15722327986923756`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49719412866893153`", ",", "0.15617302704360556`", ",", 
       "0.049084760688145934`", ",", "0.039688994637761425`", ",", 
       "0.19330739033752573`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49832608060212974`", ",", "0.19702575423109642`", ",", 
       "0.17732846320353127`", ",", "0.1220919673033102`", ",", 
       "0.32678596645698654`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49847625454421624`", ",", "0.10027527895368395`", ",", 
       "0.020940898883882276`", ",", "0.02289299759544775`", ",", 
       "0.11016310349462038`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49881377462076476`", ",", "0.06985541698696499`", ",", 
       "0.016133749582555486`", ",", "0.01790450405286449`", ",", 
       "0.06472178129979515`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4988582778758026`", ",", "0.18996700321956803`", ",", 
       "0.0774848653330866`", ",", "0.07273566270530542`", ",", 
       "0.214384555094723`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49885877265297096`", ",", "0.21837287104362413`", ",", 
       "0.06179132504878042`", ",", "0.05464174670595731`", ",", 
       "0.2630140096999649`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4997187377049217`", ",", "0.12077209391246488`", ",", 
       "0.04009527665698832`", ",", "0.04620853776165561`", ",", 
       "0.13749471461426427`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4998168073991853`", ",", "0.0916629181480841`", ",", 
       "0.03202383299554916`", ",", "0.026161307567620962`", ",", 
       "0.09811339392187239`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.501148275516491`", ",", "0.170155707046191`", ",", 
       "0.4976985868084921`", ",", "0.272632427106896`", ",", 
       "0.6409362066196829`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5014207260226613`", ",", "0.21369275890088155`", ",", 
       "0.09599019731625204`", ",", "0.07554158404438524`", ",", 
       "0.23315400355678972`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5021771653884972`", ",", "0.05940541873577501`", ",", 
       "0.014230414561618419`", ",", "0.017032374131577308`", ",", 
       "0.048557671307653094`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5021988374448215`", ",", "0.030167802764509644`", ",", 
       "0.011262455784007927`", ",", "0.010251092439178258`", ",", 
       "0.029615864074479376`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5024395025833164`", ",", "0.0995666818278332`", ",", 
       "0.0301773093665824`", ",", "0.03772935727442738`", ",", 
       "0.08509817468456418`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5024974024701122`", ",", "0.18369363155703242`", ",", 
       "0.038681383932238134`", ",", "0.035915181563962555`", ",", 
       "0.19572046847035013`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5025921636390196`", ",", "0.13910945631827942`", ",", 
       "0.2539454546712912`", ",", "0.14188107234858366`", ",", 
       "0.3287691344875874`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5026327541307098`", ",", "0.14133945635908657`", ",", 
       "0.1549048749246642`", ",", "0.10597064871357051`", ",", 
       "0.2877988079436207`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5032207064791028`", ",", "0.20528542705002392`", ",", 
       "0.0746457398452784`", ",", "0.05382726307861263`", ",", 
       "0.2776558292357573`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5034990057328325`", ",", "0.07049535906053861`", ",", 
       "0.019547386561754077`", ",", "0.018620853784093727`", ",", 
       "0.07643151789517437`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5035150991347599`", ",", "0.22871752777943094`", ",", 
       "0.20327334775754502`", ",", "0.15011143822081907`", ",", 
       "0.3820223163379067`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5039040179257853`", ",", "0.12105597742913035`", ",", 
       "0.22222369425226376`", ",", "0.14003663883256215`", ",", 
       "0.33870821501366`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5040716066020242`", ",", "0.22365469705930913`", ",", 
       "0.28684838510215255`", ",", "0.17623746312125144`", ",", 
       "0.49832935094159003`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5044200372119726`", ",", "0.18522167540952403`", ",", 
       "0.04373914093691171`", ",", "0.05510459113010402`", ",", 
       "0.17222993914504214`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.504577397619975`", ",", "0.08266049676667424`", ",", 
       "0.17491558421351114`", ",", "0.10812160700980789`", ",", 
       "0.2544671777030025`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5058333298168886`", ",", "0.3200387541066112`", ",", 
       "0.313052665751921`", ",", "0.19960341959300265`", ",", 
       "0.6275272682924081`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5059138157648831`", ",", "0.1914037276428481`", ",", 
       "0.05610091162305823`", ",", "0.06397287703262601`", ",", 
       "0.21295138399784933`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5063480912880535`", ",", "0.07895157608888843`", ",", 
       "0.04043639312324039`", ",", "0.038958250172362686`", ",", 
       "0.10924189430853913`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5068569560373034`", ",", "0.1904215045951631`", ",", 
       "0.0721950160854441`", ",", "0.06451026016213357`", ",", 
       "0.23834617959895738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5069336990236277`", ",", "0.11491383354129193`", ",", 
       "0.02564853029003855`", ",", "0.026578130119265974`", ",", 
       "0.11996766482276688`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5069785753854396`", ",", "0.12614027442606068`", ",", 
       "0.11035611350612137`", ",", "0.08026866400965758`", ",", 
       "0.21053138740118743`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.508581698275136`", ",", "0.11138817930051897`", ",", 
       "0.07053947425306951`", ",", "0.06316776633647243`", ",", 
       "0.13661304666345864`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5090130490706007`", ",", "0.28616556273082244`", ",", 
       "0.09420953974449314`", ",", "0.103981086827278`", ",", 
       "0.3375077118270481`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5090745158071213`", ",", "0.07554281096480657`", ",", 
       "0.014611713311059845`", ",", "0.01773767997420651`", ",", 
       "0.0731288583975561`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5097032331410157`", ",", "0.10373241333743008`", ",", 
       "0.03717557749347228`", ",", "0.037332835490175256`", ",", 
       "0.12093741678029798`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5097702989515401`", ",", "0.163140044359092`", ",", 
       "0.25276637827026893`", ",", "0.16343062099971445`", ",", 
       "0.4138222025356595`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5101376905046054`", ",", "0.18289398931018144`", ",", 
       "0.0325813514729794`", ",", "0.02288490319252325`", ",", 
       "0.19612430515015145`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5101737408845498`", ",", "0.09462514660913793`", ",", 
       "0.010472389350423675`", ",", "0.014028791546164578`", ",", 
       "0.08729547856186864`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5104282888991465`", ",", "0.11251337571681846`", ",", 
       "0.03777792075779001`", ",", "0.036234510794392216`", ",", 
       "0.1182030899036311`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5105460544523196`", ",", "0.13309772864282682`", ",", 
       "0.20886977781615162`", ",", "0.13949750627590105`", ",", 
       "0.3316285642571538`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5107337163444935`", ",", "0.12896995744494466`", ",", 
       "0.036599846245415665`", ",", "0.028913533170364686`", ",", 
       "0.16145249306605627`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5109676165658396`", ",", "0.19130917844230239`", ",", 
       "0.1598589227068172`", ",", "0.12329480527163393`", ",", 
       "0.34077170539717366`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5112875671055156`", ",", "0.22632600599540087`", ",", 
       "0.12645487915674586`", ",", "0.08627375904645629`", ",", 
       "0.31622412859808285`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.511305166571192`", ",", "0.21399724711969242`", ",", 
       "0.015638644897917043`", ",", "0.01645916690842267`", ",", 
       "0.21738497557726216`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5118228222776873`", ",", "0.10917821846392683`", ",", 
       "0.15849824422784534`", ",", "0.10212947562209618`", ",", 
       "0.2247690281006993`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5121632639088525`", ",", "0.1183183312576702`", ",", 
       "0.09534902217708291`", ",", "0.0705834989599993`", ",", 
       "0.2110766041705962`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.512295376076618`", ",", "0.1257603251831695`", ",", 
       "0.16355517795834545`", ",", "0.09341469729833392`", ",", 
       "0.2745143616221047`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5123447274497072`", ",", "0.1600234232654637`", ",", 
       "0.14540011673643283`", ",", "0.09123798450568135`", ",", 
       "0.27736389722755866`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5123498624441649`", ",", "0.17671823032032405`", ",", 
       "0.17284847543372003`", ",", "0.1287075466904603`", ",", 
       "0.3210081564573176`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5134548496972436`", ",", "0.31529360687714875`", ",", 
       "0.4082749421898534`", ",", "0.25944379146079194`", ",", 
       "0.6882890818671278`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5136183301997336`", ",", "0.13587392039507198`", ",", 
       "0.021051293329383873`", ",", "0.02371946842736032`", ",", 
       "0.11944089601809917`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.514677152436434`", ",", "0.13530895258585848`", ",", 
       "0.07379525930216098`", ",", "0.06348455516148852`", ",", 
       "0.20146977292355`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.514696541099467`", ",", "0.14015126944950623`", ",", 
       "0.08570723391925791`", ",", "0.06291719689994234`", ",", 
       "0.21837062216882136`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.515190375774175`", ",", "0.10029708719640648`", ",", 
       "0.22792159156240754`", ",", "0.123239880566158`", ",", 
       "0.28013888993186803`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5162353088413104`", ",", "0.18522259490551327`", ",", 
       "0.31592635917623013`", ",", "0.1872070995743627`", ",", 
       "0.494842075755941`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5164640240091273`", ",", "0.16676499116280838`", ",", 
       "0.5984446719897251`", ",", "0.3170137208595993`", ",", 
       "0.6298989896617804`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5166209047883656`", ",", "0.17783425007838574`", ",", 
       "0.14640130144568922`", ",", "0.11384906888028898`", ",", 
       "0.3061471126520558`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5168098037369604`", ",", "0.14988875642520905`", ",", 
       "0.13196595123618832`", ",", "0.10568877179222826`", ",", 
       "0.22036157505580392`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5169052882813336`", ",", "0.10719784992840133`", ",", 
       "0.14274328002344758`", ",", "0.08729899810273538`", ",", 
       "0.23647710731130908`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.516909383215529`", ",", "0.14519977028648445`", ",", 
       "0.031148729386912974`", ",", "0.041282468129838774`", ",", 
       "0.12457529848441597`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.517242017007348`", ",", "0.18519664073558365`", ",", 
       "0.12374113878764278`", ",", "0.09455883226284705`", ",", 
       "0.2929879153042129`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5172746594431856`", ",", "0.13676062227885455`", ",", 
       "0.04069403204629975`", ",", "0.03703946246713058`", ",", 
       "0.17212423381426573`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5172880780887955`", ",", "0.0513613884334337`", ",", 
       "0.16340212503428533`", ",", "0.09138290227613421`", ",", 
       "0.1984890805287003`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5173856882273967`", ",", "0.07229643355645288`", ",", 
       "0.02879532741377212`", ",", "0.024110304086692864`", ",", 
       "0.0794971629521067`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5176386161595596`", ",", "0.10271904991858666`", ",", 
       "0.0598882897881416`", ",", "0.049076432577583644`", ",", 
       "0.15065325960154688`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5180046109515424`", ",", "0.16945859908801417`", ",", 
       "0.0493689691721961`", ",", "0.048620219651979685`", ",", 
       "0.16646947998910916`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5181717749121744`", ",", "0.10769968394815749`", ",", 
       "0.035937560623471504`", ",", "0.03938064396155468`", ",", 
       "0.09700993678400523`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5185509710229004`", ",", "0.06051825683440847`", ",", 
       "0.018476164338031408`", ",", "0.02390944150734097`", ",", 
       "0.0495720887513541`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5188472783968975`", ",", "0.1346059067108397`", ",", 
       "0.023458447867401987`", ",", "0.024469524649873536`", ",", 
       "0.1268318749530827`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5199311009726552`", ",", "0.09134920587508047`", ",", 
       "0.029082962890774465`", ",", "0.03485357450750864`", ",", 
       "0.08834852469915806`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5203433440633944`", ",", "0.1848627320055436`", ",", 
       "0.16783728507551052`", ",", "0.11406182973852434`", ",", 
       "0.33384633839115435`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5204546789550166`", ",", "0.18520234788215395`", ",", 
       "0.08828855390306548`", ",", "0.06265306097491809`", ",", 
       "0.24196356692707718`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.520858994831546`", ",", "0.19276143415809202`", ",", 
       "0.11065584522789423`", ",", "0.0970865351550438`", ",", 
       "0.28674795451150403`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5215535441179988`", ",", "0.11543703351124583`", ",", 
       "0.04306474260605965`", ",", "0.04715768868337666`", ",", 
       "0.1367522329088282`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.521656306236402`", ",", "0.22732012550740996`", ",", 
       "0.15606801662949013`", ",", "0.12336461832726418`", ",", 
       "0.3624221857554973`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5217039896161912`", ",", "0.18022756044120972`", ",", 
       "0.011762513685450102`", ",", "0.014618751343898256`", ",", 
       "0.17486102556615002`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5217115454317777`", ",", "0.10951850685939049`", ",", 
       "0.027973540192944797`", ",", "0.035293797998745505`", ",", 
       "0.11035221460075534`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5218823178657339`", ",", "0.13942257522596052`", ",", 
       "0.06726552728455576`", ",", "0.06301452558895147`", ",", 
       "0.1669001013759615`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.522775818228742`", ",", "0.17306469105159367`", ",", 
       "0.05759042683641723`", ",", "0.052910561104035386`", ",", 
       "0.20868823360494693`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5228198468134152`", ",", "0.07247772776183127`", ",", 
       "0.07642829383764456`", ",", "0.05439756146191244`", ",", 
       "0.1408436746318946`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.523172429143321`", ",", "0.08556609870939492`", ",", 
       "0.028800949415184497`", ",", "0.02732672244487133`", ",", 
       "0.08250591559951855`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5237126468128656`", ",", "0.13171826432397565`", ",", 
       "0.0663928244879033`", ",", "0.05790814065054375`", ",", 
       "0.16032518341930627`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5238385438358287`", ",", "0.12135465789404373`", ",", 
       "0.043240297014042924`", ",", "0.05038458575863522`", ",", 
       "0.124826258089806`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5238934320451156`", ",", "0.20179211119013415`", ",", 
       "0.17085754239291903`", ",", "0.14087981447970324`", ",", 
       "0.35268355911139054`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5242983288078`", ",", "0.16975631110161915`", ",", 
       "0.083752416442326`", ",", "0.05991735465879763`", ",", 
       "0.2072880642956661`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5244832775172086`", ",", "0.1103063382610687`", ",", 
       "0.06881200982687666`", ",", "0.05664718781424564`", ",", 
       "0.1302476082815791`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5248409772895306`", ",", "0.13872417202574625`", ",", 
       "0.06763157496970229`", ",", "0.06006971504842241`", ",", 
       "0.16012525118380344`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5248702526524736`", ",", "0.07206570185497024`", ",", 
       "0.026688194639706585`", ",", "0.03129791240855939`", ",", 
       "0.07336396103858456`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5249527396409249`", ",", "0.12459643596531698`", ",", 
       "0.1367805221978073`", ",", "0.09828273041451457`", ",", 
       "0.24481761698557505`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5249571893650943`", ",", "0.09334400690250835`", ",", 
       "0.07420354621717497`", ",", "0.0502426513658286`", ",", 
       "0.16185111701391416`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5252161749607288`", ",", "0.06774658410846975`", ",", 
       "0.03565957721773368`", ",", "0.032231143823071275`", ",", 
       "0.09021407214873416`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5255428733994301`", ",", "0.20506907626828016`", ",", 
       "0.13345342718374878`", ",", "0.110293273831633`", ",", 
       "0.28706279365506004`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5266439746610807`", ",", "0.2549147189761578`", ",", 
       "0.16839254842540868`", ",", "0.14305314630824026`", ",", 
       "0.4094165398543212`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5270750006262429`", ",", "0.2892413825205856`", ",", 
       "0.13033653930951103`", ",", "0.10372918921269943`", ",", 
       "0.39872970301184557`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5270875014482842`", ",", "0.28156474993427916`", ",", 
       "0.09423443347994608`", ",", "0.09469335121124206`", ",", 
       "0.3434333889736695`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5271788100080792`", ",", "0.24373441875090524`", ",", 
       "0.035622532324721436`", ",", "0.04231876982656032`", ",", 
       "0.22168049999700884`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5272316783266454`", ",", "0.08092834900310628`", ",", 
       "0.06308781494066255`", ",", "0.04984010206020807`", ",", 
       "0.12140928301893456`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5273518798605404`", ",", "0.10714048811609209`", ",", 
       "0.03404273931656808`", ",", "0.042841723346233054`", ",", 
       "0.11643820428184382`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5276992062162323`", ",", "0.20395785155607588`", ",", 
       "0.24357508011529713`", ",", "0.14530274947545455`", ",", 
       "0.4177066112841743`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5281988522820565`", ",", "0.2137849189941772`", ",", 
       "0.6394594985042422`", ",", "0.3429893709861214`", ",", 
       "0.7793050239854229`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5287071470820321`", ",", "0.15421171779573029`", ",", 
       "0.14571714671575023`", ",", "0.10231112080910092`", ",", 
       "0.28226728071777585`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5290154621858266`", ",", "0.12543675817188785`", ",", 
       "0.02195243152248357`", ",", "0.03007232036155867`", ",", 
       "0.12781072315109912`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.529337152038281`", ",", "0.12561396680780143`", ",", 
       "0.39632463075219815`", ",", "0.22211107351669795`", ",", 
       "0.5112381254225129`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5296944507556614`", ",", "0.24433552118622592`", ",", 
       "0.07892655563840693`", ",", "0.07831792754813718`", ",", 
       "0.30926075732680197`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5297899665679507`", ",", "0.2157239842010557`", ",", 
       "0.45404631144492547`", ",", "0.23824343210350152`", ",", 
       "0.5945774323110693`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5298319769929968`", ",", "0.4854077562659025`", ",", 
       "0.4116111412266629`", ",", "0.2516982320160394`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5301941002240035`", ",", "0.14164071011084994`", ",", 
       "0.18888153351213566`", ",", "0.10320225839002947`", ",", 
       "0.2678240382234079`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5305078843992758`", ",", "0.06237113195896975`", ",", 
       "0.023487825710939065`", ",", "0.02195970537942904`", ",", 
       "0.05658335803473646`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5306046065743518`", ",", "0.17407930802541274`", ",", 
       "0.06367191642165429`", ",", "0.05348907681702456`", ",", 
       "0.19909109722509108`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5308508355467577`", ",", "0.09258216024088348`", ",", 
       "0.01930827909042459`", ",", "0.024614734924799323`", ",", 
       "0.09604572317722061`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5310084605656644`", ",", "0.0897705662155352`", ",", 
       "0.01672101061461219`", ",", "0.01545647930393698`", ",", 
       "0.10181422676879047`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5310123969790885`", ",", "0.16611239251368878`", ",", 
       "0.10068193747927898`", ",", "0.0804775728125221`", ",", 
       "0.24969770448521414`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5310795097005894`", ",", "0.16269283927354253`", ",", 
       "0.0467395420975244`", ",", "0.04257223283345187`", ",", 
       "0.19886032806600992`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5314458740479547`", ",", "0.119767938893435`", ",", 
       "0.03694756718961216`", ",", "0.03227886802251662`", ",", 
       "0.15198170868292388`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5317743696939163`", ",", "0.07729603982120138`", ",", 
       "0.022696040627331254`", ",", "0.01382042120231053`", ",", 
       "0.08670745254062968`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5318335267368737`", ",", "0.20115856657426054`", ",", 
       "0.25145051052594064`", ",", "0.14878055227670264`", ",", 
       "0.4283595333270014`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5320076151580548`", ",", "0.12158925833217621`", ",", 
       "0.12615654050434733`", ",", "0.09460218367125381`", ",", 
       "0.18329163191698597`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5323790268098615`", ",", "0.17183184155499262`", ",", 
       "0.1303793565677052`", ",", "0.11749988870555017`", ",", 
       "0.23173791527919368`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.532749514230379`", ",", "0.30972913456546725`", ",", 
       "0.10045070771340864`", ",", "0.08967358652062417`", ",", 
       "0.40264610822746655`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5328208708880996`", ",", "0.19826084635825783`", ",", 
       "0.23939100588587187`", ",", "0.14956575876807807`", ",", 
       "0.43082463761753387`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.533323458149543`", ",", "0.15541198705749146`", ",", 
       "0.05896420906798171`", ",", "0.07158189696778142`", ",", 
       "0.1712583900539943`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5336488751780084`", ",", "0.14507486702536168`", ",", 
       "0.2631055278751396`", ",", "0.15747507742328232`", ",", 
       "0.38477837946578075`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5337770690512754`", ",", "0.13228632828439055`", ",", 
       "0.04754208948055313`", ",", "0.04188589249009954`", ",", 
       "0.16939035187397866`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5341850925116829`", ",", "0.16219101542410808`", ",", 
       "0.3536117515515237`", ",", "0.21248814035894784`", ",", 
       "0.5128214741855626`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5344205039716555`", ",", "0.258871247704591`", ",", 
       "0.15294143491850998`", ",", "0.11068648055432484`", ",", 
       "0.39638443471560125`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5346263929316025`", ",", "0.12123754330005768`", ",", 
       "0.08839542341610522`", ",", "0.0627214258557228`", ",", 
       "0.2026789923777688`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5349844098604907`", ",", "0.06331325356377518`", ",", 
       "0.020482060148937078`", ",", "0.01783809254687075`", ",", 
       "0.08150419782687311`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5363671993353237`", ",", "0.16456139839536688`", ",", 
       "0.04185638597161402`", ",", "0.047605493467146445`", ",", 
       "0.1316168232107424`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5365625898161256`", ",", "0.19089736844309732`", ",", 
       "0.2764626000608432`", ",", "0.161216104941618`", ",", 
       "0.3741286894440568`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5365700410117307`", ",", "0.3546632207338747`", ",", 
       "0.17151382653633768`", ",", "0.12481544570086513`", ",", 
       "0.5220264123606476`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5368804604702658`", ",", "0.16679025443880416`", ",", 
       "0.1448701929946107`", ",", "0.09944898257200827`", ",", 
       "0.2989434997113332`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5369445931138941`", ",", "0.11346036782257135`", ",", 
       "0.12554770486406533`", ",", "0.09231914811061451`", ",", 
       "0.22665704599452374`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5372019689096202`", ",", "0.08290757503555299`", ",", 
       "0.36152679403248517`", ",", "0.18988126856590826`", ",", 
       "0.4232759935202253`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5373451504160214`", ",", "0.24675757044863225`", ",", 
       "0.3152591544460396`", ",", "0.19967431968811922`", ",", 
       "0.5358529411679039`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5373854964758165`", ",", "0.14291286172297096`", ",", 
       "0.10518184983246134`", ",", "0.07051276240990557`", ",", 
       "0.23131885262194898`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5380445530150981`", ",", "0.17721887578680845`", ",", 
       "0.07999413932111689`", ",", "0.08249119849990492`", ",", 
       "0.23734996270913408`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5380530839207627`", ",", "0.2831818140867975`", ",", 
       "0.2361665384235421`", ",", "0.19267102766052108`", ",", 
       "0.46979788484706875`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5384357425901957`", ",", "0.04359066189964709`", ",", 
       "0.012531648279853771`", ",", "0.013004159825705448`", ",", 
       "0.04973296398456887`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5386068542428206`", ",", "0.2535991680128422`", ",", 
       "0.027283088146584044`", ",", "0.03193944506739398`", ",", 
       "0.22804921485397656`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5387800314578532`", ",", "0.15743236888244813`", ",", 
       "0.07397444229844102`", ",", "0.06898874042772127`", ",", 
       "0.20176130781258303`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5388194759938126`", ",", "0.12606942713763483`", ",", 
       "0.08063793916381991`", ",", "0.049861007354154094`", ",", 
       "0.1823121852550391`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5390459321316438`", ",", "0.2963586606618225`", ",", 
       "0.058684317394979896`", ",", "0.06825627509629996`", ",", 
       "0.33474299733172225`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5390892066409655`", ",", "0.09967854628032427`", ",", 
       "0.33688776801062853`", ",", "0.17582185903319647`", ",", 
       "0.39962789041671426`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5391655448041797`", ",", "0.12348831472821427`", ",", 
       "0.033573792935434894`", ",", "0.0375476563990023`", ",", 
       "0.1365341124229361`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5392263221720848`", ",", "0.12169586492427083`", ",", 
       "0.048312819272315545`", ",", "0.0366475966686953`", ",", 
       "0.13962151817687468`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5393710088374436`", ",", "0.12313627481678209`", ",", 
       "0.6047701901007573`", ",", "0.3278839552171539`", ",", 
       "0.674593208031042`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5401736677217379`", ",", "0.08653031938517582`", ",", 
       "0.01979838195776778`", ",", "0.023165752288029806`", ",", 
       "0.08650218040669207`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5407784308869167`", ",", "0.14781290397467323`", ",", 
       "0.08693046796988334`", ",", "0.08478887202363898`", ",", 
       "0.18294500489657195`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5409521362251964`", ",", "0.12536050972844892`", ",", 
       "0.08286941901076733`", ",", "0.05441326199271368`", ",", 
       "0.17556115724030966`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5422008746654465`", ",", "0.24882484830287682`", ",", 
       "0.20844716348377837`", ",", "0.18509387161060528`", ",", 
       "0.4253780937350665`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5422620891505213`", ",", "0.10773052746485362`", ",", 
       "0.25608687602522306`", ",", "0.15389614198089324`", ",", 
       "0.29424612752121354`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5425439065382431`", ",", "0.19817178930508164`", ",", 
       "0.7096723550891737`", ",", "0.36717570725743826`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5427529697719077`", ",", "0.23290657478238833`", ",", 
       "0.07149427211256736`", ",", "0.07896428335516183`", ",", 
       "0.242527292249886`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5430999299134395`", ",", "0.41376299068241645`", ",", 
       "0.49758331312837834`", ",", "0.287753366618012`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5432263197308315`", ",", "0.07424769331021984`", ",", 
       "0.039025077146749534`", ",", "0.034365288957586566`", ",", 
       "0.10078902382666032`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5434512224683093`", ",", "0.0842456289019933`", ",", 
       "0.07586095915693909`", ",", "0.05249573967527816`", ",", 
       "0.11536336245727469`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5441484119243809`", ",", "0.1375756576341519`", ",", 
       "0.22300418971908803`", ",", "0.15489668051770478`", ",", 
       "0.3395205320351308`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5442292931537064`", ",", "0.08227089690088052`", ",", 
       "0.038538234603734955`", ",", "0.03952063024816973`", ",", 
       "0.07710665332928919`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5442970052913048`", ",", "0.10908833511092361`", ",", 
       "0.05069323118043029`", ",", "0.04913171172937895`", ",", 
       "0.13724255446128694`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5444558772750926`", ",", "0.29171706081739157`", ",", 
       "0.5996232502424995`", ",", "0.3632396141703888`", ",", 
       "0.8608178210128175`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5457765238104455`", ",", "0.17754669652139157`", ",", 
       "0.23629173662639721`", ",", "0.15098899846154037`", ",", 
       "0.3573854371366111`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5459502706353568`", ",", "0.12357976215724581`", ",", 
       "0.024742779425401176`", ",", "0.01944392120111272`", ",", 
       "0.1407188848976491`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5459830613957934`", ",", "0.25478871484978555`", ",", 
       "0.1339528451708063`", ",", "0.10705894039284103`", ",", 
       "0.32231743636676236`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5461840889343217`", ",", "0.15671115027889207`", ",", 
       "0.05012647870732833`", ",", "0.028667477597578366`", ",", 
       "0.1750351758468488`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5461842940501036`", ",", "0.0754854307581755`", ",", 
       "0.022220581195324576`", ",", "0.02943496750724809`", ",", 
       "0.06856522420621787`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5472692429581206`", ",", "0.07154943983727186`", ",", 
       "0.02825384246864817`", ",", "0.02989761370505436`", ",", 
       "0.08839877343377125`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5476901203034988`", ",", "0.27372271757949496`", ",", 
       "0.16610061247853802`", ",", "0.1230363153605341`", ",", 
       "0.41036241745247487`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5477276826659494`", ",", "0.11450839164895973`", ",", 
       "0.15375881339773115`", ",", "0.09121220872487071`", ",", 
       "0.22861689283341347`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5477330108411747`", ",", "0.31888836311047364`", ",", 
       "0.2582340288330333`", ",", "0.15323988108655162`", ",", 
       "0.5631429847575881`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5480055754429302`", ",", "0.14542665495654256`", ",", 
       "0.12096675491735573`", ",", "0.08234867207853037`", ",", 
       "0.23865900546667868`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5483062750957685`", ",", "0.08719025333074103`", ",", 
       "0.05303723669497391`", ",", "0.05255136254825424`", ",", 
       "0.11845285633412675`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5484111164645713`", ",", "0.2783349676317867`", ",", 
       "0.1865955169883996`", ",", "0.1596453705538697`", ",", 
       "0.41353258629043244`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5492293511655304`", ",", "0.17093814772021834`", ",", 
       "0.06914906991431821`", ",", "0.05604329781250376`", ",", 
       "0.22898425708989895`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5498399945347564`", ",", "0.15473082496997229`", ",", 
       "0.08226266198335233`", ",", "0.07044000171616044`", ",", 
       "0.22615043091533069`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5500492475477723`", ",", "0.10710734844441687`", ",", 
       "0.021917130438454935`", ",", "0.022823606938639704`", ",", 
       "0.11415229383180633`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5509008808402885`", ",", "0.10519948256956939`", ",", 
       "0.06020629131001302`", ",", "0.05558706706598595`", ",", 
       "0.14666221849134806`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5509798318501739`", ",", "0.16067261247354692`", ",", 
       "0.04650442089017712`", ",", "0.046329221284540104`", ",", 
       "0.1707273240224068`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5509921992003717`", ",", "0.15429659353515404`", ",", 
       "0.14070923562871518`", ",", "0.10320396751075533`", ",", 
       "0.24549583391494573`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5515471528715904`", ",", "0.2674436401705976`", ",", 
       "0.24696181844318896`", ",", "0.2054215418882849`", ",", 
       "0.4702410359698375`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5520759764883737`", ",", "0.3022448694928683`", ",", 
       "0.27423001291413773`", ",", "0.17542947593460984`", ",", 
       "0.5623227801988546`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5526864474341756`", ",", "0.159498970532061`", ",", 
       "0.5492297588015068`", ",", "0.2848545268932172`", ",", 
       "0.6388915869502549`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5526883236479774`", ",", "0.11237622996525162`", ",", 
       "0.027108025465978385`", ",", "0.02486434055940386`", ",", 
       "0.1339686440889093`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5531197749821228`", ",", "0.1283021570775231`", ",", 
       "0.2848922238895173`", ",", "0.14243108984672612`", ",", 
       "0.3223754355485388`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5532443808524653`", ",", "0.14172615755044082`", ",", 
       "0.08276505801987354`", ",", "0.06381739697427877`", ",", 
       "0.19222627552200236`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.553248279881475`", ",", "0.132843291423646`", ",", 
       "0.48884363570032574`", ",", "0.2687284760397647`", ",", 
       "0.5289620763453656`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5533289580719591`", ",", "0.11886770130536722`", ",", 
       "0.034039601241780515`", ",", "0.042884493805926883`", ",", 
       "0.1131166268571496`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5537933217894482`", ",", "0.15472943936952896`", ",", 
       "0.031903125710107914`", ",", "0.03998475500116309`", ",", 
       "0.15860933609518435`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5540166622326862`", ",", "0.09569403430763314`", ",", 
       "0.02490120398268427`", ",", "0.020110261038044152`", ",", 
       "0.09132492441159569`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5544138595868945`", ",", "0.13798646955200872`", ",", 
       "0.17803657395788647`", ",", "0.1064416685063554`", ",", 
       "0.29284056830420674`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.554757830980324`", ",", "0.16582285644818498`", ",", 
       "0.18201999344319356`", ",", "0.1193913752337616`", ",", 
       "0.3434498592039401`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.554974219786374`", ",", "0.09909848288574438`", ",", 
       "0.04035298241206675`", ",", "0.03672731539775502`", ",", 
       "0.1233476066802382`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5551672673415928`", ",", "0.09158639573648052`", ",", 
       "0.032414710998595754`", ",", "0.02968653802304393`", ",", 
       "0.08754050598803181`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5551689117255905`", ",", "0.15031938084823682`", ",", 
       "0.10898002344733615`", ",", "0.0917051536537207`", ",", 
       "0.20633577305679823`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5552317726435637`", ",", "0.11088857088040106`", ",", 
       "0.03606353528517082`", ",", "0.033784330131928504`", ",", 
       "0.142668394798917`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5552952658552428`", ",", "0.3195748007611254`", ",", 
       "0.2937893202827509`", ",", "0.1860502059075363`", ",", 
       "0.5367432336614716`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5553879780951477`", ",", "0.22502324106977206`", ",", 
       "0.27439401208516995`", ",", "0.17095396305683966`", ",", 
       "0.49041878745930884`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5554594434109116`", ",", "0.19187481842509735`", ",", 
       "0.023576066006506552`", ",", "0.029234305038776855`", ",", 
       "0.20191053301180784`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5555216365068567`", ",", "0.10687925939903802`", ",", 
       "0.041095650075172`", ",", "0.046671237566349645`", ",", 
       "0.12808836404131782`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5556967710164351`", ",", "0.3373636380435988`", ",", 
       "0.23223280641144192`", ",", "0.18509411832308087`", ",", 
       "0.5196675883698617`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5558734136416422`", ",", "0.22714169069686677`", ",", 
       "0.08830844391251183`", ",", "0.06841796328410146`", ",", 
       "0.2636329894737473`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.556239192532181`", ",", "0.22241282693033743`", ",", 
       "0.10940438560894293`", ",", "0.09358522643384622`", ",", 
       "0.3257744181764217`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5562735777949039`", ",", "0.19856909591127386`", ",", 
       "0.2612332243020147`", ",", "0.179394817191393`", ",", 
       "0.4446700035714921`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5566472430523309`", ",", "0.21426848406730323`", ",", 
       "0.17656711430528485`", ",", "0.12755202745389493`", ",", 
       "0.34320583792898923`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5567817987076528`", ",", "0.2340202402767362`", ",", 
       "0.06778124400503908`", ",", "0.052660989874868114`", ",", 
       "0.2955443962232312`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5569116888911471`", ",", "0.2072262408755102`", ",", 
       "0.05248616155486141`", ",", "0.042762669578750516`", ",", 
       "0.2384383488723669`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5573665570480082`", ",", "0.1447643534475623`", ",", 
       "0.12330103913523073`", ",", "0.08493406288654748`", ",", 
       "0.2540949990064479`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5576987000180159`", ",", "0.17836999426750735`", ",", 
       "0.1369463102002145`", ",", "0.1012689201534882`", ",", 
       "0.23508817717193348`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5583377061257048`", ",", "0.15142415187193883`", ",", 
       "0.05964642541357724`", ",", "0.041975268315604164`", ",", 
       "0.19361823192667915`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.558429838061487`", ",", "0.06082104982264121`", ",", 
       "0.045749549095147286`", ",", "0.02969660432664326`", ",", 
       "0.07531687528692838`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.558986035238834`", ",", "0.19295393766929297`", ",", 
       "0.20905557868331662`", ",", "0.14890061901162413`", ",", 
       "0.31376421843280217`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5590388141327043`", ",", "0.15953344676086048`", ",", 
       "0.1509467709619568`", ",", "0.08638257382642141`", ",", 
       "0.26694944213105926`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5591629727053926`", ",", "0.15813094728787588`", ",", 
       "0.06498776326626632`", ",", "0.0751667741952518`", ",", 
       "0.15636280296334323`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5598766401003423`", ",", "0.14504856370511307`", ",", 
       "0.0538833155361822`", ",", "0.05737792908846869`", ",", 
       "0.1872400440533163`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5599712015001095`", ",", "0.17154764369325545`", ",", 
       "0.174147401458358`", ",", "0.12924433724301151`", ",", 
       "0.2641150197576516`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5603571346919186`", ",", "0.13071129738944454`", ",", 
       "0.07102403275442605`", ",", "0.0545951006181922`", ",", 
       "0.18731156147580846`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5603928020163483`", ",", "0.2271248000025684`", ",", 
       "0.17050124971272643`", ",", "0.10806207842056799`", ",", 
       "0.38957339291694165`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5604764686912245`", ",", "0.17136127202663926`", ",", 
       "0.07416984754943261`", ",", "0.07896025407839258`", ",", 
       "0.19738542427767533`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5606974897783696`", ",", "0.20559890164711112`", ",", 
       "0.20996565848064008`", ",", "0.1264716778401217`", ",", 
       "0.372764548443478`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5609437064601666`", ",", "0.11851456453184879`", ",", 
       "0.027276889927145942`", ",", "0.025536349888267234`", ",", 
       "0.13526828794679305`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5612638036273235`", ",", "0.18926253944453367`", ",", 
       "0.07163493042189485`", ",", "0.06042145630736813`", ",", 
       "0.2549687741274218`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5616405316777038`", ",", "0.16451122306911528`", ",", 
       "0.14297338745762458`", ",", "0.11134366271186291`", ",", 
       "0.2674221903400507`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.561916539146465`", ",", "0.1273795651447156`", ",", 
       "0.02679180407839672`", ",", "0.03251269877569024`", ",", 
       "0.11558764965807115`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5622468026099524`", ",", "0.0979617069727776`", ",", 
       "0.022259408976263148`", ",", "0.025413328124609443`", ",", 
       "0.09082233456378525`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.562254254067343`", ",", "0.36169297781714116`", ",", 
       "0.30742870646402387`", ",", "0.18642831392753428`", ",", 
       "0.6584192714562028`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5623104516426985`", ",", "0.20836993271860227`", ",", 
       "0.040419721650338664`", ",", "0.052205370637714105`", ",", 
       "0.21053590632781186`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5625848022727881`", ",", "0.10866842953648082`", ",", 
       "0.03427178064653399`", ",", "0.03516281689360705`", ",", 
       "0.10328280938291023`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5625985636648433`", ",", "0.09358972506839414`", ",", 
       "0.0182802914225954`", ",", "0.020861373724625907`", ",", 
       "0.08850231389594808`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5626626062104634`", ",", "0.17118697355543522`", ",", 
       "0.2461763635532955`", ",", "0.16413783615354033`", ",", 
       "0.361845354526663`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5631242576227503`", ",", "0.22932388047962562`", ",", 
       "0.21834940341653022`", ",", "0.11352066388837886`", ",", 
       "0.40665885238618843`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5632465861268022`", ",", "0.09461358251700247`", ",", 
       "0.10199198378567907`", ",", "0.07296821198352643`", ",", 
       "0.17136584831528545`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5643969352897585`", ",", "0.18981463239011534`", ",", 
       "0.022413973605186346`", ",", "0.023497360384089255`", ",", 
       "0.183125888333523`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5644261121576528`", ",", "0.15637972285138443`", ",", 
       "0.8039986835628894`", ",", "0.35938836931653756`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5649465143947159`", ",", "0.14346856374444067`", ",", 
       "0.7351390802087435`", ",", "0.38603433397326936`", ",", 
       "0.7707904933199795`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5651361330415351`", ",", "0.1317703863340674`", ",", 
       "0.08384436322495016`", ",", "0.059569075166256445`", ",", 
       "0.166270561625692`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5660807318963434`", ",", "0.1094319277356313`", ",", 
       "0.03430817625651981`", ",", "0.035864304587513635`", ",", 
       "0.12118026494221486`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5664895374995093`", ",", "0.28202622881396006`", ",", 
       "0.24783607354874487`", ",", "0.20561183584694692`", ",", 
       "0.44282008600590705`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5668826942665057`", ",", "0.1902787058741375`", ",", 
       "0.03946038833162598`", ",", "0.04062942539544642`", ",", 
       "0.2221187776509627`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5669937574182708`", ",", "0.09241771566147983`", ",", 
       "0.0642115511025374`", ",", "0.043182175382726694`", ",", 
       "0.13065491562034043`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5673083896553058`", ",", "0.10851196334125227`", ",", 
       "0.029031611443322253`", ",", "0.028506074311218897`", ",", 
       "0.1351083937409509`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5673240752846825`", ",", "0.1927367555499348`", ",", 
       "0.2629057520404684`", ",", "0.18153118417207723`", ",", 
       "0.43194331709584477`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5675425819134289`", ",", "0.16460505959355884`", ",", 
       "0.0511938206440804`", ",", "0.035757135462480806`", ",", 
       "0.19229382935659664`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5675901051009696`", ",", "0.19242175633894645`", ",", 
       "0.15522401160716237`", ",", "0.10753853675971577`", ",", 
       "0.3355175516661189`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5676839079536999`", ",", "0.22348222410121835`", ",", 
       "0.035020213016859175`", ",", "0.035115896491297934`", ",", 
       "0.24113152369229687`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5676872281064487`", ",", "0.20468156864715192`", ",", 
       "0.13686980033214435`", ",", "0.08465743121569805`", ",", 
       "0.2847832273606851`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5677545148334063`", ",", "0.18634572626877174`", ",", 
       "0.20351891465203575`", ",", "0.14143167756700373`", ",", 
       "0.38664597230029346`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5678399685905462`", ",", "0.27668083031709223`", ",", 
       "0.32702397826967494`", ",", "0.17580513586209923`", ",", 
       "0.5804709410268294`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5680087925967027`", ",", "0.1830030159716332`", ",", 
       "0.38590917390528756`", ",", "0.2380910925784978`", ",", 
       "0.5349930057277842`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5680828690816426`", ",", "0.11179303929287679`", ",", 
       "0.39610589572880317`", ",", "0.21717869345578547`", ",", 
       "0.45755864183265416`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5681957851964597`", ",", "0.14950962638491314`", ",", 
       "0.08191456919097383`", ",", "0.06816549758430529`", ",", 
       "0.21636986619362134`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5683372179693661`", ",", "0.18593253528908987`", ",", 
       "0.20563572034656016`", ",", "0.10034503962054352`", ",", 
       "0.38098454452858693`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5687408571039121`", ",", "0.10676629366024391`", ",", 
       "0.027397587636506116`", ",", "0.03674248108002376`", ",", 
       "0.09063899890581946`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5687680952966708`", ",", "0.17544318583493237`", ",", 
       "0.1330500644850459`", ",", "0.09526710332689518`", ",", 
       "0.2402887395207829`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5689594879850017`", ",", "0.13615479523001375`", ",", 
       "0.13653946209274678`", ",", "0.1004872401535024`", ",", 
       "0.2654068779691881`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5690321965672025`", ",", "0.14532690187628386`", ",", 
       "0.152093458039623`", ",", "0.10327060850862783`", ",", 
       "0.28698774475443345`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5701362447955737`", ",", "0.18265366704316963`", ",", 
       "0.21486077339778478`", ",", "0.1451451262704179`", ",", 
       "0.3761628436328207`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5701834710986369`", ",", "0.2092470518764155`", ",", 
       "0.14606449570730665`", ",", "0.10232590867228174`", ",", 
       "0.33492728863186955`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5706865374812646`", ",", "0.2082495682384631`", ",", 
       "0.06127399393037783`", ",", "0.07140021800757583`", ",", 
       "0.231960777806407`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5708727214026834`", ",", "0.11198632495914222`", ",", 
       "0.09882267659245647`", ",", "0.07465862018152422`", ",", 
       "0.2061032484834534`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5714782532695399`", ",", "0.1250219498693684`", ",", 
       "0.09038658747482375`", ",", "0.07298465903514478`", ",", 
       "0.1480950675027761`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5721206464314054`", ",", "0.1303042603890495`", ",", 
       "0.07554509434808988`", ",", "0.05748476355885196`", ",", 
       "0.2013268357970164`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5730032750521169`", ",", "0.09464941327710794`", ",", 
       "0.015119015378444931`", ",", "0.017967426321611787`", ",", 
       "0.08155634807848494`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5733852700633918`", ",", "0.10447510824126756`", ",", 
       "0.25022737585430704`", ",", "0.1606005975290114`", ",", 
       "0.3290559099839737`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5736387702650521`", ",", "0.25105289263566755`", ",", 
       "0.2566522806922143`", ",", "0.1484514729621352`", ",", 
       "0.5056254983396917`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.57413658978603`", ",", "0.16627666392628407`", ",", 
       "0.007621139292569874`", ",", "0.008274175131357503`", ",", 
       "0.15876268387068934`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5742975255682324`", ",", "0.12060069147088492`", ",", 
       "0.11867927579627281`", ",", "0.09513956645646143`", ",", 
       "0.18018356037780836`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5747362836448341`", ",", "0.21188308575054404`", ",", 
       "0.08390881647201853`", ",", "0.09956433740956872`", ",", 
       "0.2039232730970126`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5751216044230518`", ",", "0.13495897417072003`", ",", 
       "0.02733441944537693`", ",", "0.03135729019246197`", ",", 
       "0.13057019532715025`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.575329655293691`", ",", "0.08832706615096991`", ",", 
       "0.04604356872734516`", ",", "0.04697908704981976`", ",", 
       "0.12194264286428072`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5756500558073815`", ",", "0.11014676017889136`", ",", 
       "0.14921889606362124`", ",", "0.09028460567736377`", ",", 
       "0.22877390317453591`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5759723082838656`", ",", "0.20573951445413508`", ",", 
       "0.1694679840980451`", ",", "0.10262929611921191`", ",", 
       "0.3481269335178547`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5760688436437877`", ",", "0.20998099908296047`", ",", 
       "0.4445065035330572`", ",", "0.23566247377507027`", ",", 
       "0.6302164225647303`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5761568960141491`", ",", "0.16260010834527278`", ",", 
       "0.06547323252431192`", ",", "0.06036707424117891`", ",", 
       "0.21952638336949484`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5771459098693879`", ",", "0.0997307127838921`", ",", 
       "0.012894219302483505`", ",", "0.012971310494749252`", ",", 
       "0.1056341868188017`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5772223251962266`", ",", "0.15368408791397192`", ",", 
       "0.02929362052963201`", ",", "0.03949566715682155`", ",", 
       "0.12657479583668213`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.577450360295296`", ",", "0.18902474516842555`", ",", 
       "0.2117563267394039`", ",", "0.1394325422334586`", ",", 
       "0.37782086275280163`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5777404841212318`", ",", "0.094365347896521`", ",", 
       "0.01953401086194094`", ",", "0.023994470738674983`", ",", 
       "0.10581079125075182`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5777460933647824`", ",", "0.26684031402258507`", ",", 
       "0.6079696784920632`", ",", "0.3254886872500193`", ",", 
       "0.8665028853927917`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5777726683467457`", ",", "0.18379664053960443`", ",", 
       "0.12351915549909534`", ",", "0.09357893810767651`", ",", 
       "0.29718757498133214`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5782710931802162`", ",", "0.0589868446141032`", ",", 
       "0.8176859395342501`", ",", "0.412948352549022`", ",", 
       "0.8671154707875188`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5783288955010001`", ",", "0.15369359903752602`", ",", 
       "0.047349285282915`", ",", "0.046271399672095356`", ",", 
       "0.1911201919112894`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.579007270296607`", ",", "0.3065558638183156`", ",", 
       "0.29407027419518567`", ",", "0.18790319742433023`", ",", 
       "0.598699858526304`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5791837431287977`", ",", "0.2529506507029818`", ",", 
       "0.27613607800182316`", ",", "0.17138046983466118`", ",", 
       "0.5143239117399605`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5804082140201814`", ",", "0.10053911712481721`", ",", 
       "0.3996503792768649`", ",", "0.24198553586268798`", ",", 
       "0.4908697638710418`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5806858136890156`", ",", "0.16078616205926477`", ",", 
       "0.030909264504686392`", ",", "0.03788014413624043`", ",", 
       "0.17634365179141046`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5812570413572478`", ",", "0.20980959619837555`", ",", 
       "0.798990107048015`", ",", "0.3938984640741825`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5814657905696657`", ",", "0.0808689660551024`", ",", 
       "0.049842224920919866`", ",", "0.03722642977527007`", ",", 
       "0.1254482335464836`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5818173666178109`", ",", "0.08568962490325772`", ",", 
       "0.035121501858492624`", ",", "0.036111407496493275`", ",", 
       "0.09044123058314477`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5818909275939159`", ",", "0.19092276540401237`", ",", 
       "0.029008498266345478`", ",", "0.03184395764411415`", ",", 
       "0.18502344552129188`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5821856528553784`", ",", "0.12044435208418401`", ",", 
       "0.0646517307313634`", ",", "0.037840909503768144`", ",", 
       "0.14772972033421305`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5822808724177961`", ",", "0.07018122835947029`", ",", 
       "0.04023421321643659`", ",", "0.02805886983766266`", ",", 
       "0.09937373247239739`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5823646448343563`", ",", "0.17937882408400194`", ",", 
       "0.05664036360590528`", ",", "0.06869139690858243`", ",", 
       "0.18591611360632812`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5831335832505614`", ",", "0.30033174076497915`", ",", 
       "0.2308599800733378`", ",", "0.1680719082547406`", ",", 
       "0.5292578559901143`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5831871734824334`", ",", "0.12376510599976273`", ",", 
       "0.13060327987942105`", ",", "0.08786169055409121`", ",", 
       "0.15738571871484658`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.583394472217179`", ",", "0.14110475967627184`", ",", 
       "0.18171340326782484`", ",", "0.1270069692049756`", ",", 
       "0.30936533684443357`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.583517921543529`", ",", "0.27540397111453163`", ",", 
       "0.39821228105533646`", ",", "0.2038866425494135`", ",", 
       "0.6675906669162767`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5835355071909614`", ",", "0.15835693985871055`", ",", 
       "0.06579018290364251`", ",", "0.05950055651872758`", ",", 
       "0.2147963547099785`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5835459791424301`", ",", "0.14680668223534704`", ",", 
       "0.3867204271819155`", ",", "0.20632126397712888`", ",", 
       "0.39366501890201805`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5845555910448674`", ",", "0.05756722312158171`", ",", 
       "0.03456059605789008`", ",", "0.03031817108911648`", ",", 
       "0.08038453049762129`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.585661755761238`", ",", "0.17354841094563653`", ",", 
       "0.02197214992669745`", ",", "0.03274781177469329`", ",", 
       "0.1738988242055844`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5858757616072706`", ",", "0.14035239769080082`", ",", 
       "0.2825736932172981`", ",", "0.1571200924013452`", ",", 
       "0.3613819603050613`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5861093787537677`", ",", "0.1142665639457676`", ",", 
       "0.04900169527233707`", ",", "0.052914680660734646`", ",", 
       "0.1305237416506842`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.586225324253343`", ",", "0.11467827516190532`", ",", 
       "0.33952621244078374`", ",", "0.17399626932425769`", ",", 
       "0.4454717414507657`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.586374168532328`", ",", "0.5070599518356995`", ",", 
       "0.2604095482698984`", ",", "0.18032781452630053`", ",", 
       "0.7209246541946169`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5871103375103064`", ",", "0.19187697606425835`", ",", 
       "0.12892484486980213`", ",", "0.12242635709725473`", ",", 
       "0.27857595052782486`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.588249636522121`", ",", "0.1951713687788006`", ",", 
       "0.3221247687584446`", ",", "0.16982740689704923`", ",", 
       "0.4428620353201237`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5892146660325481`", ",", "0.16242095809550602`", ",", 
       "0.14108430985025427`", ",", "0.09288994490568044`", ",", 
       "0.2389150131232254`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5894669313442794`", ",", "0.20232353704580722`", ",", 
       "0.19963189456380812`", ",", "0.12540770892977782`", ",", 
       "0.36072453101668617`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5897074035605341`", ",", "0.2162456110722234`", ",", 
       "0.3226550804854283`", ",", "0.20999902167004086`", ",", 
       "0.5000661206939538`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5907620663251891`", ",", "0.15712815179672868`", ",", 
       "0.22219126305621112`", ",", "0.13752740513836045`", ",", 
       "0.3453435238212864`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5909012301135254`", ",", "0.06417927813696289`", ",", 
       "0.01615777713174432`", ",", "0.013886770243016225`", ",", 
       "0.08008382660692025`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5915883698206951`", ",", "0.16253926487790107`", ",", 
       "0.04844874344041633`", ",", "0.050991025169722565`", ",", 
       "0.20123331495878555`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5917072854951915`", ",", "0.0614011633572596`", ",", 
       "0.02192430150005643`", ",", "0.026498513189673705`", ",", 
       "0.061461502895799595`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5919517051869507`", ",", "0.17088798998278756`", ",", 
       "0.055072199263709695`", ",", "0.052672216625904`", ",", 
       "0.20657602148075435`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5923194820827916`", ",", "0.10365107669521147`", ",", 
       "0.2139941668876842`", ",", "0.12431955598763648`", ",", 
       "0.289455905624954`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5926261608318961`", ",", "0.09904290369454415`", ",", 
       "0.010917999646886492`", ",", "0.013917231389772054`", ",", 
       "0.10349314206636072`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5926891865280758`", ",", "0.2489173613559502`", ",", 
       "0.1713890717906054`", ",", "0.15218526267211435`", ",", 
       "0.38905206744134857`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5927646952006471`", ",", "0.17062965269588676`", ",", 
       "0.11975119296766784`", ",", "0.09167434462666503`", ",", 
       "0.27034051904782086`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5930199606240847`", ",", "0.18195426646766022`", ",", 
       "0.04195775184781211`", ",", "0.048754444468186615`", ",", 
       "0.21622654301637612`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5931351018114693`", ",", "0.1733898067102853`", ",", 
       "0.08126697166944076`", ",", "0.08566596748266066`", ",", 
       "0.1845663691938466`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5933439341947587`", ",", "0.10353101807643572`", ",", 
       "0.09123469516453647`", ",", "0.06276828052933946`", ",", 
       "0.1934427470984955`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5961390380607128`", ",", "0.22662369517251585`", ",", 
       "0.5388462824303104`", ",", "0.24099633968101045`", ",", 
       "0.6382776032547031`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.596317056564542`", ",", "0.1442602039198473`", ",", 
       "0.03455197961711462`", ",", "0.03043319505840784`", ",", 
       "0.13587515405870823`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5964916103132526`", ",", "0.16066566513629035`", ",", 
       "0.3538579069629243`", ",", "0.18719743432746114`", ",", 
       "0.44177115721449006`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5967404333867966`", ",", "0.29577268730198286`", ",", 
       "0.4355809149259769`", ",", "0.23078187958953159`", ",", 
       "0.7278785833393886`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5972159733020703`", ",", "0.17209467502172063`", ",", 
       "0.3305104965647449`", ",", "0.1841168050547042`", ",", 
       "0.4461130125476211`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5972872720228894`", ",", "0.18987855276451343`", ",", 
       "0.2361137418939352`", ",", "0.16366605796758932`", ",", 
       "0.34866853520823`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5978754754367647`", ",", "0.20281406657661616`", ",", 
       "0.4847146064644834`", ",", "0.2551130320539801`", ",", 
       "0.6199699173670296`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5993219057203316`", ",", "0.18498880010743962`", ",", 
       "0.458681620800156`", ",", "0.21687168183492014`", ",", 
       "0.5819068738720126`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5993630261429727`", ",", "0.2099876432326582`", ",", 
       "0.4455229160857029`", ",", "0.23512643383960175`", ",", 
       "0.5772844811664436`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5996499116190909`", ",", "0.08281461622911372`", ",", 
       "0.04480246491634149`", ",", "0.03555841881504039`", ",", 
       "0.12194080369064914`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5998710475876918`", ",", "0.13570989453713922`", ",", 
       "0.02229072505318692`", ",", "0.027109438835732254`", ",", 
       "0.1319184260216985`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6005593484470092`", ",", "0.13197636826793568`", ",", 
       "0.28606742921324446`", ",", "0.16648621339850925`", ",", 
       "0.37586798566744273`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6008386103563989`", ",", "0.3082623456859834`", ",", 
       "0.2013079580710703`", ",", "0.13825363243086305`", ",", 
       "0.49472368905579117`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6013905920160673`", ",", "0.03753228844585364`", ",", 
       "0.0017994015254177887`", ",", "0.0018353896604334995`", ",", 
       "0.038627747480044335`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6015693934190246`", ",", "0.16183265958257956`", ",", 
       "0.27721222025437864`", ",", "0.15010102586229163`", ",", 
       "0.43674436348429513`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6017487745534136`", ",", "0.16647705204571808`", ",", 
       "0.0484192033399824`", ",", "0.04091333595567496`", ",", 
       "0.19843135868572107`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6022950066365635`", ",", "0.07198968094662472`", ",", 
       "0.12187804792645952`", ",", "0.08212988005315146`", ",", 
       "0.17284331189944663`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6026336968374999`", ",", "0.11940757306452322`", ",", 
       "0.04507481107307009`", ",", "0.048039030027775736`", ",", 
       "0.11777890878195141`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6026549552258196`", ",", "0.1699406603543693`", ",", 
       "0.2492004131311111`", ",", "0.1500868836325013`", ",", 
       "0.3824666378650729`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6032198588440887`", ",", "0.30449639391886013`", ",", 
       "0.31551310867217397`", ",", "0.19521446082338337`", ",", 
       "0.578096886985798`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6035340839090827`", ",", "0.11109735083062539`", ",", 
       "0.27054877054117393`", ",", "0.15924071466653755`", ",", 
       "0.33003523260763773`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.604230277248066`", ",", "0.20212962359743064`", ",", 
       "0.10701517461958902`", ",", "0.0961899680087675`", ",", 
       "0.22073137889684077`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.604877782445136`", ",", "0.17622372288249782`", ",", 
       "0.1924299588673109`", ",", "0.11811079368102052`", ",", 
       "0.2343608220497718`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6050415518516069`", ",", "0.07028757241542948`", ",", 
       "0.7945872876512418`", ",", "0.3558958752552262`", ",", 
       "0.8593739334952955`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6052789696971499`", ",", "0.15591222057698523`", ",", 
       "0.03435958252315843`", ",", "0.035958040296890835`", ",", 
       "0.1362868729134904`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6053919817101422`", ",", "0.19119561207092559`", ",", 
       "0.32258641218024603`", ",", "0.18492111193933827`", ",", 
       "0.4340243784206748`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6055080792045795`", ",", "0.20526853846312224`", ",", 
       "0.22537808149567862`", ",", "0.11819634857712068`", ",", 
       "0.39738560299713716`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6066032596788898`", ",", "0.1716070111438994`", ",", 
       "0.05395831836218053`", ",", "0.06276194506366964`", ",", 
       "0.20276512041608205`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6071600605138578`", ",", "0.158278375816113`", ",", 
       "0.019933273022284106`", ",", "0.020792261194043`", ",", 
       "0.16342988486830218`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6078607360118039`", ",", "0.14196548931498867`", ",", 
       "0.02455562742987497`", ",", "0.02982277775509638`", ",", 
       "0.14696787760055743`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6083539180092196`", ",", "0.12420948818019488`", ",", 
       "0.0289078683083144`", ",", "0.03470866610829455`", ",", 
       "0.13983686734057163`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6084562444967048`", ",", "0.12478554468230167`", ",", 
       "0.42133224769642574`", ",", "0.24480632865313692`", ",", 
       "0.49644592490223793`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6085909947473036`", ",", "0.09729749871648287`", ",", 
       "0.9225550321186647`", ",", "0.41722895393296955`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6086240123976924`", ",", "0.14359691519593884`", ",", 
       "0.14245925285467365`", ",", "0.1019658011603247`", ",", 
       "0.2789296411740039`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6087141378892676`", ",", "0.11976423993936122`", ",", 
       "0.10048460474870999`", ",", "0.07476438864675516`", ",", 
       "0.21144146594693555`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.608951884618772`", ",", "0.16228951428553096`", ",", 
       "0.1845841458021235`", ",", "0.11583796399707062`", ",", 
       "0.26212144145599237`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.609120755801697`", ",", "0.3278127026646226`", ",", 
       "0.1992868772559325`", ",", "0.13445316923260645`", ",", 
       "0.4889171627167831`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6096631415384027`", ",", "0.11649514222073024`", ",", 
       "0.03456796070907484`", ",", "0.03912993368532761`", ",", 
       "0.13194497810224518`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6097573944189976`", ",", "0.15731877260722282`", ",", 
       "0.051218937808975386`", ",", "0.060527401375651005`", ",", 
       "0.1638402090611733`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6098166753106051`", ",", "0.13906324520554122`", ",", 
       "0.42527758592229037`", ",", "0.24123927112790036`", ",", 
       "0.529508966865224`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6103578948543198`", ",", "0.1653322584419241`", ",", 
       "0.03923802232013143`", ",", "0.036790031176954806`", ",", 
       "0.15315180366398243`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6108520451391842`", ",", "0.1668081469227172`", ",", 
       "0.4685897452493832`", ",", "0.24085320032767488`", ",", 
       "0.6262415288698993`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6111664247199592`", ",", "0.10464176269571773`", ",", 
       "0.4100586828854446`", ",", "0.2269238561141055`", ",", 
       "0.4573575841136894`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6112100212917169`", ",", "0.27566084192623913`", ",", 
       "0.14675539039414115`", ",", "0.11655121100281875`", ",", 
       "0.33619049111017196`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6116107287073675`", ",", "0.15253069207324257`", ",", 
       "0.1034064663943619`", ",", "0.07084694575582205`", ",", 
       "0.1429901240015424`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6121421337072389`", ",", "0.2285771909663262`", ",", 
       "0.270409666887152`", ",", "0.17451245196103077`", ",", 
       "0.35066078521323346`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6130213074007523`", ",", "0.25189843364444126`", ",", 
       "0.3804428999892955`", ",", "0.2232417109461884`", ",", 
       "0.5880650062479921`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6131003799572569`", ",", "0.17030820743766878`", ",", 
       "0.043889198406982445`", ",", "0.052767224875356275`", ",", 
       "0.17576164036260522`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6133332984490637`", ",", "0.18342759275266976`", ",", 
       "0.032421678054855824`", ",", "0.02920486139855873`", ",", 
       "0.2100443967581333`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6133925270060946`", ",", "0.33232272178514377`", ",", 
       "0.41423372578037093`", ",", "0.24269195102575344`", ",", 
       "0.6715179786186881`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6134771754492762`", ",", "0.22861047946498717`", ",", 
       "0.09906996420143259`", ",", "0.07345763447167011`", ",", 
       "0.3173394526720486`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6135936141301588`", ",", "0.07848126738287267`", ",", 
       "0.1867282620811575`", ",", "0.09159224674249997`", ",", 
       "0.23382112746648373`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6138511840061669`", ",", "0.24321309794107385`", ",", 
       "0.3452925096596919`", ",", "0.2124866284824419`", ",", 
       "0.5812847625311541`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6139275386936451`", ",", "0.1672065915862471`", ",", 
       "0.4448471989689387`", ",", "0.22408853950858873`", ",", 
       "0.5315669855009737`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6147178568454966`", ",", "0.21020498086004474`", ",", 
       "0.37636429519997566`", ",", "0.2536616212264275`", ",", 
       "0.5737406812931115`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6147789728304153`", ",", "0.15674489221805188`", ",", 
       "0.061877739302360076`", ",", "0.046346127917447806`", ",", 
       "0.16629253361618207`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6153529039065455`", ",", "0.13487826520544768`", ",", 
       "0.44712154268263216`", ",", "0.2334308365923585`", ",", 
       "0.5679939200135453`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.61574045313341`", ",", "0.2265349907771034`", ",", 
       "0.27250565592986137`", ",", "0.2113753241093181`", ",", 
       "0.4515207612116755`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6157925003951449`", ",", "0.1248789069317455`", ",", 
       "0.26857127936711694`", ",", "0.14510223824527235`", ",", 
       "0.3149067923828259`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6162760124564343`", ",", "0.2000033738728506`", ",", 
       "0.22230071306473226`", ",", "0.1195494133336822`", ",", 
       "0.36406617107015543`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6164905243717654`", ",", "0.1941268695144568`", ",", 
       "0.1385887478116004`", ",", "0.13197854943810575`", ",", 
       "0.27790953296617293`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6165770565112417`", ",", "0.1338064522298631`", ",", 
       "0.15581401793995386`", ",", "0.11454849168466169`", ",", 
       "0.2613178385714084`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6169238281996484`", ",", "0.2620934908671776`", ",", 
       "0.3031270196754729`", ",", "0.18160659839575174`", ",", 
       "0.5075931974032872`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6169826401783082`", ",", "0.38157761796795014`", ",", 
       "0.1852542716051837`", ",", "0.12112021900815402`", ",", 
       "0.5390831229508921`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6172194377778277`", ",", "0.13287643938965607`", ",", 
       "0.03686501238705194`", ",", "0.03779519624253127`", ",", 
       "0.16056517118991023`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6172891281333154`", ",", "0.19270851066125888`", ",", 
       "0.21442281578569714`", ",", "0.16221592254931408`", ",", 
       "0.39675395731163543`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6186661073982413`", ",", "0.2702895365138178`", ",", 
       "0.3809673917231034`", ",", "0.24579078766882262`", ",", 
       "0.6279304335285214`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6188916130687769`", ",", "0.2588408813915308`", ",", 
       "0.12658456832031068`", ",", "0.11093191240795341`", ",", 
       "0.37840236347019485`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6188937104545889`", ",", "0.08298027441246313`", ",", 
       "0.037063986509503676`", ",", "0.035481126354739566`", ",", 
       "0.0974017134237221`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6190487976564549`", ",", "0.3451734355915947`", ",", 
       "0.2608443357328476`", ",", "0.16814885285276523`", ",", 
       "0.5845717170622248`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6190667568739863`", ",", "0.07185472946007483`", ",", 
       "0.030584569911369767`", ",", "0.034720429282050935`", ",", 
       "0.06266704583025261`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6191010333072845`", ",", "0.1654812372585287`", ",", 
       "0.06030357373276989`", ",", "0.056416963759158924`", ",", 
       "0.19555573191335196`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6191883432780342`", ",", "0.1568426993739046`", ",", 
       "0.07732332047074357`", ",", "0.07209976661557821`", ",", 
       "0.2173088851258242`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.619382740707461`", ",", "0.25043390995904635`", ",", 
       "0.09489759114467029`", ",", "0.09301191957893912`", ",", 
       "0.29965928165396544`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6194433761846906`", ",", "0.24714594119809535`", ",", 
       "0.30873960240526077`", ",", "0.15065653404521864`", ",", 
       "0.5482827845656244`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.619667009011199`", ",", "0.2090144272062883`", ",", 
       "0.13061465235936362`", ",", "0.10190006569236087`", ",", 
       "0.3090141966579122`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6198066802371044`", ",", "0.07134057813485423`", ",", 
       "0.07223905740516999`", ",", "0.04947454095483359`", ",", 
       "0.11623014141337042`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6198198796958725`", ",", "0.18194647246245144`", ",", 
       "0.09016807735658162`", ",", "0.06818034061710657`", ",", 
       "0.26408022415566473`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6199022890354342`", ",", "0.1834701154588922`", ",", 
       "0.06723517505735464`", ",", "0.07024640950564226`", ",", 
       "0.24440203609238365`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6199083409799668`", ",", "0.13488833437052114`", ",", 
       "0.45688531220000245`", ",", "0.2323979077927172`", ",", 
       "0.5537328803597084`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6199342709312692`", ",", "0.1564117224530328`", ",", 
       "0.2725733126477911`", ",", "0.17592921818020152`", ",", 
       "0.3689553619123231`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6207274026059297`", ",", "0.1495661879608419`", ",", 
       "0.4156314239981934`", ",", "0.1960661174576147`", ",", 
       "0.5598877732444707`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6210300135461877`", ",", "0.12613207925548997`", ",", 
       "0.016160092296828302`", ",", "0.01821999032492538`", ",", 
       "0.11295169560576457`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.62111720428331`", ",", "0.1241021172225875`", ",", 
       "0.047540762221295496`", ",", "0.04550647774692297`", ",", 
       "0.11492889446197484`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.621129088620258`", ",", "0.27495935947704364`", ",", 
       "0.0941957526091399`", ",", "0.08149236149720057`", ",", 
       "0.31205666800661075`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6213016801507568`", ",", "0.18919855402998592`", ",", 
       "0.47620540661021415`", ",", "0.24210551872770492`", ",", 
       "0.5622432152542393`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6214416354919324`", ",", "0.17667814219395708`", ",", 
       "0.03091380714269861`", ",", "0.03302790956656283`", ",", 
       "0.1814092330474075`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6214427521098431`", ",", "0.08666900236904355`", ",", 
       "0.020877181128070084`", ",", "0.024007315477114585`", ",", 
       "0.07733385690844242`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6214942895813997`", ",", "0.2488907489015756`", ",", 
       "0.12045010404814521`", ",", "0.08132467366181678`", ",", 
       "0.36526237000758716`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6215412801267041`", ",", "0.18606389291095063`", ",", 
       "0.17152185022193367`", ",", "0.10754822927226096`", ",", 
       "0.3010037287174657`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6220756057715039`", ",", "0.16594954681717863`", ",", 
       "0.06765043634325549`", ",", "0.060646851588586355`", ",", 
       "0.2152719042809412`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6221554930839325`", ",", "0.1869052873102775`", ",", 
       "0.42357324086901754`", ",", "0.23007008733789466`", ",", 
       "0.5702962552301007`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6224530720191016`", ",", "0.039202238760327884`", ",", 
       "0.018438025787911302`", ",", "0.019432766064515362`", ",", 
       "0.05411303091434418`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6225343528215235`", ",", "0.22948241445409864`", ",", 
       "0.858386703078505`", ",", "0.3609903045789457`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6230004538700815`", ",", "0.18683026829565`", ",", 
       "0.6616374600928081`", ",", "0.342158940875824`", ",", 
       "0.8343712375383893`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6231205621855723`", ",", "0.10510120060765407`", ",", 
       "0.19530343708170653`", ",", "0.11752071810509424`", ",", 
       "0.28725532911798446`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.623533547822691`", ",", "0.1399876561761412`", ",", 
       "0.06717092203525275`", ",", "0.057671675850760884`", ",", 
       "0.20537626536225684`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6235339200962422`", ",", "0.22384095644098997`", ",", 
       "0.21734620068367713`", ",", "0.14966045662215927`", ",", 
       "0.41487245570698933`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6237255133512785`", ",", "0.11091139655406661`", ",", 
       "0.05401247989780619`", ",", "0.052654968187127636`", ",", 
       "0.14713455921131724`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6237990604525839`", ",", "0.11856134895736072`", ",", 
       "0.6826091178785603`", ",", "0.35977907916356194`", ",", 
       "0.7331306807613842`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6238501483169699`", ",", "0.21767966463401672`", ",", 
       "0.165634017025711`", ",", "0.1155547994272039`", ",", 
       "0.342192450439105`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6238655222052057`", ",", "0.11307588917491078`", ",", 
       "0.08444252715611864`", ",", "0.0834116752917582`", ",", 
       "0.14677228441034043`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6239678683898151`", ",", "0.12825322425860453`", ",", 
       "0.25713851544175015`", ",", "0.15020746861563158`", ",", 
       "0.2681705097608743`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6247758159874257`", ",", "0.25382950774723095`", ",", 
       "0.30961107516153147`", ",", "0.16668647307322457`", ",", 
       "0.5521692171693855`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6248198566863638`", ",", "0.20197556011529513`", ",", 
       "0.048258728612970724`", ",", "0.04423483162649381`", ",", 
       "0.18899453445969547`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6248767677029932`", ",", "0.1637604395329397`", ",", 
       "0.9126740000693894`", ",", "0.3980050250939051`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.625882201285649`", ",", "0.13630281864262736`", ",", 
       "0.5195240729347925`", ",", "0.27267296606904967`", ",", 
       "0.6016113938042937`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6259037098139276`", ",", "0.16981880856429957`", ",", 
       "0.08457075730171768`", ",", "0.08998205306297821`", ",", 
       "0.2203786833353794`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6259460373788365`", ",", "0.11918847795774257`", ",", 
       "0.11552786616033273`", ",", "0.08999552909575849`", ",", 
       "0.19747141130315152`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6263125385954083`", ",", "0.11797557323100537`", ",", 
       "0.06663531837765796`", ",", "0.06967314398013336`", ",", 
       "0.1435477345351543`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6266090425802759`", ",", "0.06848855958264198`", ",", 
       "0.04387783087925434`", ",", "0.03825544164094847`", ",", 
       "0.06965471396707175`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6267932532990161`", ",", "0.10384518102819504`", ",", 
       "0.2764743714595054`", ",", "0.15260045572321979`", ",", 
       "0.35609767883830146`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.627129172465324`", ",", "0.17526476679101569`", ",", 
       "0.13485432618433074`", ",", "0.11754807532615644`", ",", 
       "0.2594876401934817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6278671451149297`", ",", "0.1991542554663624`", ",", 
       "0.4545513456206456`", ",", "0.23564489109682352`", ",", 
       "0.5786451783303208`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6287162975726392`", ",", "0.13343321898102523`", ",", 
       "0.20013560808581818`", ",", "0.11920777947293722`", ",", 
       "0.305700343496969`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6287876235614847`", ",", "0.18884108797856414`", ",", 
       "0.1415218182083208`", ",", "0.09329997078348805`", ",", 
       "0.30193099982165095`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6290333652881801`", ",", "0.040380958924575897`", ",", 
       "0.6110377248495565`", ",", "0.3279314804123259`", ",", 
       "0.6412468389789201`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6303950305738527`", ",", "0.18863538563946014`", ",", 
       "0.1494221309007272`", ",", "0.09469811084913167`", ",", 
       "0.3289672853313962`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6304183440698077`", ",", "0.22109854768232332`", ",", 
       "0.23942695383972207`", ",", "0.16841199200604698`", ",", 
       "0.4565788485633199`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6306432966358745`", ",", "0.11879757246125014`", ",", 
       "0.23233283121818665`", ",", "0.13456835242152987`", ",", 
       "0.2843642322449939`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6311135936860337`", ",", "0.20757946962720997`", ",", 
       "0.1393597867784259`", ",", "0.10978635886549332`", ",", 
       "0.28383102813347044`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.632602271052765`", ",", "0.2789287259414749`", ",", 
       "0.28693179647916706`", ",", "0.17367240992814853`", ",", 
       "0.530941948551722`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6332299374931715`", ",", "0.14565401209363232`", ",", 
       "0.19776876534717097`", ",", "0.12211566204272238`", ",", 
       "0.30350277166910594`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.634072373393719`", ",", "0.21783563366348685`", ",", 
       "0.061315181521935304`", ",", "0.07805123391933161`", ",", 
       "0.2528598782686387`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6340856435871968`", ",", "0.2683709717939121`", ",", 
       "0.36121090880224294`", ",", "0.20364883472500594`", ",", 
       "0.5877198306090123`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6347522689026633`", ",", "0.16901347592704594`", ",", 
       "0.13755184924015884`", ",", "0.09153607003303177`", ",", 
       "0.28929429867966994`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6350312674810177`", ",", "0.24051814840146485`", ",", 
       "0.2922308405659275`", ",", "0.19956751413201615`", ",", 
       "0.5295305061252913`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6356552447188345`", ",", "0.1867815023202924`", ",", 
       "0.03853693804430799`", ",", "0.05059162695180938`", ",", 
       "0.20220434900423773`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6356730164764759`", ",", "0.1572130866390674`", ",", 
       "0.12720040329787255`", ",", "0.11263433508258135`", ",", 
       "0.2701966463791972`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6361337328611487`", ",", "0.15305764970743413`", ",", 
       "0.10066028630493742`", ",", "0.06607174847080119`", ",", 
       "0.23893768725871067`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6362304543874243`", ",", "0.05551066087160877`", ",", 
       "0.1441596425169889`", ",", "0.08356236969966072`", ",", 
       "0.1775253148587357`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6363502793920047`", ",", "0.2570338253337679`", ",", 
       "0.165175747215999`", ",", "0.149618204975498`", ",", 
       "0.4086513926137075`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6364525922969614`", ",", "0.1853155575682774`", ",", 
       "0.2954573261082714`", ",", "0.13864966051485303`", ",", 
       "0.4133172951322694`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6365435000536742`", ",", "0.1763422905400845`", ",", 
       "0.07025743318594092`", ",", "0.08449197955481577`", ",", 
       "0.1585048292066165`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6366031551276475`", ",", "0.1126904874728483`", ",", 
       "0.584019939215267`", ",", "0.2972827916517172`", ",", 
       "0.6250247614703355`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.636954115648865`", ",", "0.1624989172557829`", ",", 
       "0.2155162938192545`", ",", "0.10593858930416143`", ",", 
       "0.33000592588978017`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6372088974696208`", ",", "0.1743308115987497`", ",", 
       "0.06702780183146903`", ",", "0.062170743253645855`", ",", 
       "0.22713091231008323`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6375739894403099`", ",", "0.21022451741123233`", ",", 
       "0.7025338315557156`", ",", "0.3210327086139355`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6376605544446801`", ",", "0.3166284988726403`", ",", 
       "0.2079685078710955`", ",", "0.10877597142896564`", ",", 
       "0.4843981524543662`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6379098222409777`", ",", "0.23470089957032172`", ",", 
       "0.04418036909145851`", ",", "0.04916230265004385`", ",", 
       "0.2256925474683162`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6381807909939128`", ",", "0.24376085938231012`", ",", 
       "0.0741184935618152`", ",", "0.054731553921243896`", ",", 
       "0.2532271873452896`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6384620878761588`", ",", "0.11542223460578785`", ",", 
       "0.08221164228767537`", ",", "0.06931701406866449`", ",", 
       "0.1536554637564541`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6387699889341371`", ",", "0.06204413267558868`", ",", 
       "0.07965526447796137`", ",", "0.04944623401293648`", ",", 
       "0.12485229309991946`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6398524861101174`", ",", "0.22660314075078705`", ",", 
       "0.3592086469237916`", ",", "0.24566775682890996`", ",", 
       "0.5620224223171549`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6405054330531377`", ",", "0.16871189734680775`", ",", 
       "0.4743162187170811`", ",", "0.2374599128910968`", ",", 
       "0.4761016848554338`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6406627861355226`", ",", "0.16154986940030766`", ",", 
       "0.1146251159966274`", ",", "0.07029721139745018`", ",", 
       "0.2696878346518615`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6409979580761247`", ",", "0.13058981458433935`", ",", 
       "0.12010546027390066`", ",", "0.06669495914564375`", ",", 
       "0.23803493742726467`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6415790822153069`", ",", "0.32127993495168977`", ",", 
       "0.18850553534185896`", ",", "0.10576369708068482`", ",", 
       "0.45327243179974613`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6416010428053743`", ",", "0.14699277069578467`", ",", 
       "0.6829860725278488`", ",", "0.30705574816305997`", ",", 
       "0.6909512890166628`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6416901103342781`", ",", "0.20378539354740108`", ",", 
       "0.1899810877829651`", ",", "0.1554860316785413`", ",", 
       "0.38018057248089837`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6418306562725203`", ",", "0.14437557656408476`", ",", 
       "0.2480090935017804`", ",", "0.19866044279567982`", ",", 
       "0.3497179046868684`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.642028459467022`", ",", "0.24414276165571744`", ",", 
       "0.19095319454351076`", ",", "0.09518673490631001`", ",", 
       "0.42769354477435645`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6428850148556089`", ",", "0.3386475596583246`", ",", 
       "0.42772160452071384`", ",", "0.22144080593238177`", ",", 
       "0.7461661604283654`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6433283045087799`", ",", "0.16728171154990806`", ",", 
       "0.06975343833603467`", ",", "0.06044153443810402`", ",", 
       "0.22062514432758196`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6433698659683489`", ",", "0.1662130107697493`", ",", 
       "0.02388487889788438`", ",", "0.033719872642839634`", ",", 
       "0.17323895532296874`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6433769241180172`", ",", "0.1472530169631755`", ",", 
       "0.40927117228440696`", ",", "0.21961798793329151`", ",", 
       "0.4278910710310926`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6434938874577841`", ",", "0.20735321522454542`", ",", 
       "0.3278806536714027`", ",", "0.22412138041914872`", ",", 
       "0.413629440360591`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6445524474762091`", ",", "0.18768848615699063`", ",", 
       "0.21157003998055607`", ",", "0.14184764801946187`", ",", 
       "0.3857524146394535`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.644863921584082`", ",", "0.2548884789699415`", ",", 
       "0.513122839278049`", ",", "0.2535913251119488`", ",", 
       "0.5131775239970346`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6450220324436913`", ",", "0.09669645764761324`", ",", 
       "0.025905163428743723`", ",", "0.030864196957754973`", ",", 
       "0.09518855100953764`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.645130448563295`", ",", "0.16662313881648846`", ",", 
       "0.010869652197514597`", ",", "0.010989763776053742`", ",", 
       "0.15820551211326955`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6454296797454494`", ",", "0.11662453771231168`", ",", 
       "0.05654972197301092`", ",", "0.04959570749026661`", ",", 
       "0.16855415170521923`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6456102286106061`", ",", "0.19256091795736563`", ",", 
       "0.24125650873004537`", ",", "0.16014920343324326`", ",", 
       "0.422711916368127`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6460262287562742`", ",", "0.19149704102039464`", ",", 
       "0.0485898765584167`", ",", "0.04969284500313675`", ",", 
       "0.20206585827664703`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6477072354517266`", ",", "0.28147012117012943`", ",", 
       "0.18568255829345337`", ",", "0.12400527634579957`", ",", 
       "0.4626410012774494`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6491992205056158`", ",", "0.15618817484054626`", ",", 
       "0.07069116254970619`", ",", "0.06120200138601732`", ",", 
       "0.20021431354513972`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6493303713872413`", ",", "0.13649103894632977`", ",", 
       "0.5188761016251288`", ",", "0.28316325236424716`", ",", 
       "0.6050854726185877`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6501509359887031`", ",", "0.16771264787226406`", ",", 
       "0.07669295008644486`", ",", "0.06723234572427672`", ",", 
       "0.2234488966131733`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6502089323588223`", ",", "0.05315531075984307`", ",", 
       "0.02312183629369301`", ",", "0.025674815020423337`", ",", 
       "0.05752442035275605`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6503881073171405`", ",", "0.0826849383229859`", ",", 
       "0.031449216176648566`", ",", "0.027553224075855007`", ",", 
       "0.09929382336476252`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6513812435769805`", ",", "0.21259955720212734`", ",", 
       "0.37631188320692277`", ",", "0.21696266950570625`", ",", 
       "0.5606280939155998`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6515823296479504`", ",", "0.25594218421741705`", ",", 
       "0.25992998446975896`", ",", "0.20871428865696312`", ",", 
       "0.5064244113577065`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6518132340680067`", ",", "0.1311097651234867`", ",", 
       "0.6781418104055748`", ",", "0.2783945957890148`", ",", 
       "0.6885987822349253`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.651816189371133`", ",", "0.2238091840053271`", ",", 
       "0.3484444234563576`", ",", "0.21908689959450459`", ",", 
       "0.5641823402861967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6528355678494885`", ",", "0.2685648560559352`", ",", 
       "0.09638578614436596`", ",", "0.07507468483837737`", ",", 
       "0.34218122002225565`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.653067114139815`", ",", "0.1559796632141129`", ",", 
       "0.17558644366765436`", ",", "0.09326288591302087`", ",", 
       "0.30441539875332674`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6533994623504756`", ",", "0.2535084025800853`", ",", 
       "0.05312292979330274`", ",", "0.043409561967895686`", ",", 
       "0.293879226600517`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6534790683523908`", ",", "0.24306653716688012`", ",", 
       "0.5161966449287029`", ",", "0.2777840021678497`", ",", 
       "0.7177633415810619`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6536405787781867`", ",", "0.2968195763621182`", ",", 
       "0.18165712425371466`", ",", "0.1271609246677727`", ",", 
       "0.440476333244786`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6538553348425608`", ",", "0.30345071444360944`", ",", 
       "0.172998736982453`", ",", "0.18395761097068336`", ",", 
       "0.4186013267867998`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6546663899705991`", ",", "0.2179992585763393`", ",", 
       "0.40606897865358205`", ",", "0.25518448335648775`", ",", 
       "0.6126662478894801`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6555088573314917`", ",", "0.14988277682845247`", ",", 
       "0.04137247529116711`", ",", "0.04943845318296448`", ",", 
       "0.13544325537819535`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6568631769374557`", ",", "0.2364738015516592`", ",", 
       "0.18301493180765996`", ",", "0.13607855734849564`", ",", 
       "0.41043321570236857`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6569357992518049`", ",", "0.13288551974018523`", ",", 
       "0.07133922130182865`", ",", "0.06859813128937686`", ",", 
       "0.1459974053566554`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6580459393717311`", ",", "0.1349818677892989`", ",", 
       "0.027929596328110397`", ",", "0.037131537079891384`", ",", 
       "0.13253933442640856`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.658733466078353`", ",", "0.16191808889607837`", ",", 
       "0.05272877696286306`", ",", "0.0754065881423782`", ",", 
       "0.16052834373317784`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6587889771871843`", ",", "0.20000442088349207`", ",", 
       "0.10234727245717465`", ",", "0.09630111750416694`", ",", 
       "0.27009388843002247`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6589305593922504`", ",", "0.14796549034853554`", ",", 
       "0.753931077914287`", ",", "0.28875595231960155`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6589638156635607`", ",", "0.1436685022614022`", ",", 
       "0.7796995226521894`", ",", "0.3188134250623709`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.659794679702503`", ",", "0.15069995969678113`", ",", 
       "0.1084056201197904`", ",", "0.10363589185715057`", ",", 
       "0.20960694948453953`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6598587906629214`", ",", "0.11379702922823023`", ",", 
       "0.09705792887268119`", ",", "0.08387038658438004`", ",", 
       "0.20566669705364587`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6601851764103472`", ",", "0.40521080066549897`", ",", 
       "0.2584949083573405`", ",", "0.13582765689251222`", ",", 
       "0.6558546055484362`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6602273430604797`", ",", "0.08180444293381926`", ",", 
       "0.3507518336062425`", ",", "0.19670712836854884`", ",", 
       "0.4091834640305118`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6606700220147097`", ",", "0.23189353259949255`", ",", 
       "0.11449182863830759`", ",", "0.08829878576745041`", ",", 
       "0.32344031535823126`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6626356600115173`", ",", "0.20556058074958594`", ",", 
       "0.2140352630536844`", ",", "0.1382060931741595`", ",", 
       "0.4112521284227497`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6626458202641057`", ",", "0.18106828322618865`", ",", 
       "0.0382589424538271`", ",", "0.04661968958375275`", ",", 
       "0.1798803644039293`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6642662559122913`", ",", "0.13588788775885519`", ",", 
       "0.11973663440879846`", ",", "0.1055548031708393`", ",", 
       "0.22785180590814885`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6651887639047569`", ",", "0.3667634726378089`", ",", 
       "0.4089780570360315`", ",", "0.23903462834399658`", ",", 
       "0.7529553425500759`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6653910290713795`", ",", "0.1487836234925602`", ",", 
       "0.044597655817909546`", ",", "0.03985792590162213`", ",", 
       "0.143707802034067`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6654175026392793`", ",", "0.21336201051019246`", ",", 
       "0.34096503732932176`", ",", "0.21900885587139546`", ",", 
       "0.5206445788859653`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6672735922734744`", ",", "0.15763340817913235`", ",", 
       "0.09938936043822516`", ",", "0.09333594181991739`", ",", 
       "0.23577223358507154`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6675180988879109`", ",", "0.13235200531298613`", ",", 
       "0.22100950793732982`", ",", "0.15059261509954597`", ",", 
       "0.2661115823116655`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6677015173347983`", ",", "0.3096732207619061`", ",", 
       "0.3330113229806918`", ",", "0.2587783946616023`", ",", 
       "0.600696303661284`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6692444620802797`", ",", "0.1913450037092073`", ",", 
       "0.04659367117937164`", ",", "0.04747322478497814`", ",", 
       "0.2163165465571608`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6693228921639832`", ",", "0.38383332813867016`", ",", 
       "0.3288477799969954`", ",", "0.2171522826610798`", ",", 
       "0.7121849069688255`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6700596754199388`", ",", "0.17170348551075246`", ",", 
       "0.0963561620187378`", ",", "0.09149638893376544`", ",", 
       "0.24036733727728296`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6701753089684954`", ",", "0.1680088658477204`", ",", 
       "0.228571599379411`", ",", "0.20418150042753014`", ",", 
       "0.36242458703898006`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6703859088764662`", ",", "0.1188196021990517`", ",", 
       "0.042980823402924126`", ",", "0.05401376452287194`", ",", 
       "0.11055669260041137`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.670394015327724`", ",", "0.16406271406004957`", ",", 
       "0.038719412825585754`", ",", "0.034546908933861704`", ",", 
       "0.16968740837528062`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6707748707975918`", ",", "0.20628593958732694`", ",", 
       "0.09279953004736197`", ",", "0.06669912162373214`", ",", 
       "0.27175909205103727`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.670788253998132`", ",", "0.29910831794688175`", ",", 
       "0.031787582966432824`", ",", "0.032908396912667136`", ",", 
       "0.3230609597681505`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.671974921750253`", ",", "0.22372005605834816`", ",", 
       "0.3438870203420967`", ",", "0.1913176232436808`", ",", 
       "0.4919313141702643`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6721917751094271`", ",", "0.14923000707961237`", ",", 
       "0.0826765773614837`", ",", "0.08848084746484831`", ",", 
       "0.16283105497950953`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6723301416961887`", ",", "0.09906703727799494`", ",", 
       "0.029170247058287684`", ",", "0.03869250151148212`", ",", 
       "0.10742731580792804`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6738207255275329`", ",", "0.14294330447766948`", ",", 
       "0.1349835019061509`", ",", "0.09527776751871357`", ",", 
       "0.26126364902384247`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6738664388456357`", ",", "0.0674713878550659`", ",", 
       "0.15498799733236487`", ",", "0.11302656021060385`", ",", 
       "0.21106097336118007`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6740051934013732`", ",", "0.20486900345341963`", ",", 
       "0.4328633434249207`", ",", "0.23972226267395966`", ",", 
       "0.6339461854934785`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6744901449327`", ",", "0.20703688183277888`", ",", 
       "0.25928486033630804`", ",", "0.17077594469737906`", ",", 
       "0.4351228753134614`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6749394014884157`", ",", "0.41541563888305855`", ",", 
       "0.18108852639919273`", ",", "0.14107179481681173`", ",", 
       "0.5906541804680735`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6750342597285863`", ",", "0.09495113296188995`", ",", 
       "0.22884338919956174`", ",", "0.15100620367501802`", ",", 
       "0.28327975392652427`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.675969305175624`", ",", "0.1669420983271532`", ",", 
       "0.07509750658680041`", ",", "0.08805661501422245`", ",", 
       "0.1749039403854531`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6763101734918389`", ",", "0.2618470849768774`", ",", 
       "0.7942385484031789`", ",", "0.3529787529016442`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6771718995344129`", ",", "0.07556050991819228`", ",", 
       "0.04229381028919289`", ",", "0.03993458583542837`", ",", 
       "0.11240720852954282`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.677400312063257`", ",", "0.08687354799814193`", ",", 
       "0.027053435162193343`", ",", "0.0265831740656563`", ",", 
       "0.08486549035583117`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6774100540065118`", ",", "0.11723706255885001`", ",", 
       "0.1393895224124353`", ",", "0.09987051498515113`", ",", 
       "0.23103086471956943`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6774124712611183`", ",", "0.2290416417815944`", ",", 
       "0.48023676150152844`", ",", "0.20259573104550496`", ",", 
       "0.6801853450614853`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6781637291885345`", ",", "0.18643973273985098`", ",", 
       "0.3194326345519172`", ",", "0.18862146811513375`", ",", 
       "0.4234408393402431`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6790362288974646`", ",", "0.15520195960867564`", ",", 
       "0.09787339511269154`", ",", "0.08890698042611168`", ",", 
       "0.23512515638325526`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6792649729187462`", ",", "0.1880377606870275`", ",", 
       "0.06514661759638964`", ",", "0.07546065242574249`", ",", 
       "0.191777120717459`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6797426173736237`", ",", "0.1366624028488203`", ",", 
       "0.2592045208228537`", ",", "0.17181894773594633`", ",", 
       "0.3300345081119652`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6798943341710074`", ",", "0.09451700188579043`", ",", 
       "0.04305268325910321`", ",", "0.039738460209395664`", ",", 
       "0.1180442194848253`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6819780314812653`", ",", "0.19452367411249785`", ",", 
       "0.2755190413513504`", ",", "0.14995732974087486`", ",", 
       "0.44451797849823854`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6825479761529444`", ",", "0.03536778017039394`", ",", 
       "0.05162480442482275`", ",", "0.04242402348620096`", ",", 
       "0.08017620722086902`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6827670017613001`", ",", "0.10456284825959782`", ",", 
       "0.07107176185391421`", ",", "0.054410282024594546`", ",", 
       "0.14006985145878056`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6828360368586082`", ",", "0.29804694364182654`", ",", 
       "0.09343381870605125`", ",", "0.09973828100179599`", ",", 
       "0.3568505291721098`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6828722270606028`", ",", "0.20801662112587857`", ",", 
       "0.07887194849895142`", ",", "0.06446845550907325`", ",", 
       "0.28561410050694036`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6835076587366896`", ",", "0.134169822328042`", ",", 
       "0.03130129275044102`", ",", "0.03134058567327182`", ",", 
       "0.1521113941832175`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6836973652599299`", ",", "0.24165314294379137`", ",", 
       "0.15449667950790238`", ",", "0.06374047962890836`", ",", 
       "0.386004147521537`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6843506498274917`", ",", "0.27026837622359096`", ",", 
       "0.2458520489589604`", ",", "0.12073664871125146`", ",", 
       "0.49126657186807066`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6849428901944756`", ",", "0.17796362360754867`", ",", 
       "0.04205164156337284`", ",", "0.04002823280468174`", ",", 
       "0.19643334453573444`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6853401510410104`", ",", "0.24598914493213592`", ",", 
       "0.1544958445697804`", ",", "0.13368994866316464`", ",", 
       "0.3172910190241073`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6854145771920375`", ",", "0.28005899666314094`", ",", 
       "0.4934984380902679`", ",", "0.272490113175968`", ",", 
       "0.5030474667735872`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6859265643243573`", ",", "0.09833241828733504`", ",", 
       "0.046966677334797875`", ",", "0.03807719764128203`", ",", 
       "0.13463859674245116`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6860072084992498`", ",", "0.14559741441963572`", ",", 
       "0.04295395959612768`", ",", "0.042552690906436166`", ",", 
       "0.14050058770340337`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6866173689124848`", ",", "0.18783807550282855`", ",", 
       "0.08447630832568177`", ",", "0.0810810264022393`", ",", 
       "0.19213002155739461`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6868419222733023`", ",", "0.11869778942266736`", ",", 
       "0.2539069589191054`", ",", "0.18250232788813678`", ",", 
       "0.3311568246173642`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.687333802493553`", ",", "0.21453523715898462`", ",", 
       "0.1620345291972047`", ",", "0.1255424244969882`", ",", 
       "0.37382991070768606`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6883564144135442`", ",", "0.13259859723336773`", ",", 
       "0.07095792996591935`", ",", "0.056277506233840514`", ",", 
       "0.1825049925656035`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6892658611446256`", ",", "0.069164418370512`", ",", 
       "0.015935506362710752`", ",", "0.016304971483821252`", ",", 
       "0.06197216219508236`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.68976676850594`", ",", "0.15732968064096056`", ",", 
       "0.498622727131723`", ",", "0.23284222781396774`", ",", 
       "0.6081823065341276`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6899820148129565`", ",", "0.2811787081909095`", ",", 
       "0.1508196713979564`", ",", "0.1352156435162718`", ",", 
       "0.42005822583101465`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6915616130391165`", ",", "0.13836418173071668`", ",", 
       "0.05846054319047412`", ",", "0.06563751178210239`", ",", 
       "0.15433614503942114`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.692471182338492`", ",", "0.2103329463222852`", ",", 
       "0.5864730825829068`", ",", "0.2793076986850033`", ",", 
       "0.781107630857222`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6929145649143936`", ",", "0.13595261601880143`", ",", 
       "0.03941371931780975`", ",", "0.04769683304688117`", ",", 
       "0.16321342900394353`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6930785231680814`", ",", "0.10322128051851202`", ",", 
       "0.04232679469003726`", ",", "0.0566140314558042`", ",", 
       "0.11865639182552747`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6933187024824283`", ",", "0.07895520944235121`", ",", 
       "0.10782561721499315`", ",", "0.07178910548339548`", ",", 
       "0.15533571556291936`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.693511246043721`", ",", "0.13677780823583482`", ",", 
       "0.4352020126228008`", ",", "0.26091225247816224`", ",", 
       "0.5019417478446369`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6935358277182949`", ",", "0.12270879978862212`", ",", 
       "0.10504722741973652`", ",", "0.07712861493810384`", ",", 
       "0.2021917660509787`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6943123260406503`", ",", "0.25467754077528926`", ",", 
       "0.18382308093691044`", ",", "0.12317447589948018`", ",", 
       "0.39635708850351825`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6944446215311862`", ",", "0.11707407985749098`", ",", 
       "0.029190416240250216`", ",", "0.03522189648387568`", ",", 
       "0.12612888853291357`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6945850386320248`", ",", "0.14790344973503494`", ",", 
       "0.85563616479267`", ",", "0.38268002299571374`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6948814428399492`", ",", "0.10898799606789979`", ",", 
       "0.4359894548518376`", ",", "0.2114310785100744`", ",", 
       "0.48722039552103874`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6950090965156603`", ",", "0.20221816092753228`", ",", 
       "0.09296844534363158`", ",", "0.0850107571330297`", ",", 
       "0.26065550251159775`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6972099891158929`", ",", "0.22277234272397023`", ",", 
       "0.10448689882510634`", ",", "0.11130747219677693`", ",", 
       "0.2778338659173559`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6987306346537295`", ",", "0.19274597168365612`", ",", 
       "0.026835954551517154`", ",", "0.030509053636741185`", ",", 
       "0.21804666318047594`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.699046635594811`", ",", "0.172285745909139`", ",", 
       "0.27573972522491647`", ",", "0.1688919898779995`", ",", 
       "0.4312702349107969`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7000783732669807`", ",", "0.12478141461551516`", ",", 
       "0.03586154230508947`", ",", "0.0471050917876084`", ",", 
       "0.15283537280880943`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7000827561465529`", ",", "0.1330248498228587`", ",", 
       "0.13600148220704567`", ",", "0.10108461898828891`", ",", 
       "0.21289888392272727`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7008061906591843`", ",", "0.21377675013303957`", ",", 
       "0.6249142959493889`", ",", "0.3164078149598438`", ",", 
       "0.6979954302475772`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7017011653909572`", ",", "0.10352567092690323`", ",", 
       "0.03213546195320835`", ",", "0.03494049407089721`", ",", 
       "0.09645377989738364`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7017204462158984`", ",", "0.31527633631682644`", ",", 
       "0.2710237251720408`", ",", "0.19139637340903137`", ",", 
       "0.5672164200274619`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7017328324526894`", ",", "0.22074389702223873`", ",", 
       "0.07683430932359062`", ",", "0.06326302023288359`", ",", 
       "0.24009273080753551`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.701743029295617`", ",", "0.1856314381700315`", ",", 
       "0.04729677439795627`", ",", "0.043898197420144204`", ",", 
       "0.18704525342392755`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7021671838366232`", ",", "0.0766051340550168`", ",", 
       "0.016257565408032654`", ",", "0.019604643165358707`", ",", 
       "0.08663904687578379`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7032081310563686`", ",", "0.25292514234538627`", ",", 
       "0.03913854640195657`", ",", "0.03429300833290278`", ",", 
       "0.28287833648280825`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7034652844079188`", ",", "0.21374488884235177`", ",", 
       "0.6859808536280563`", ",", "0.3620006324142604`", ",", 
       "0.8874218366828843`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7042419466676767`", ",", "0.13056850937542572`", ",", 
       "0.15844386081035905`", ",", "0.14541051570807073`", ",", 
       "0.2618564971815587`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7049656862895526`", ",", "0.3342523750182239`", ",", 
       "0.30043335664236653`", ",", "0.21716997088943202`", ",", 
       "0.6147549630842376`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7050637411828168`", ",", "0.09436217988300069`", ",", 
       "0.8875835677699009`", ",", "0.4207749489581083`", ",", 
       "0.8853654803764882`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7058067725477148`", ",", "0.22585935515732464`", ",", 
       "0.054165740700208`", ",", "0.05905553569800095`", ",", 
       "0.24465308141978953`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7058115275033996`", ",", "0.06831782193100625`", ",", 
       "0.014221834622810124`", ",", "0.015354797734491568`", ",", 
       "0.07944213255421353`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7069912286822351`", ",", "0.16021687835206821`", ",", 
       "0.7474791481806463`", ",", "0.2558397936209299`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7070283938787615`", ",", "0.12710478866645245`", ",", 
       "0.2417576522378773`", ",", "0.18898530384401246`", ",", 
       "0.28828657112826106`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7083987797584796`", ",", "0.1855787059744507`", ",", 
       "0.600604864055337`", ",", "0.22926482434599982`", ",", 
       "0.616363051143335`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7090539623497609`", ",", "0.3148057629896625`", ",", 
       "0.1997552575009118`", ",", "0.11319953572260529`", ",", 
       "0.5029804981891957`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7091757171961155`", ",", "0.2065463685793868`", ",", 
       "0.04855253129054905`", ",", "0.05693404656184509`", ",", 
       "0.23193575020643842`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.711080497151051`", ",", "0.1738005517693935`", ",", 
       "0.07150531712519484`", ",", "0.06492919656204206`", ",", 
       "0.178831598550226`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7111910167148354`", ",", "0.0980803710580063`", ",", 
       "0.024576595235786716`", ",", "0.0315937982542222`", ",", 
       "0.0804614303935667`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7128174066330291`", ",", "0.16708660948693402`", ",", 
       "0.3770165245027093`", ",", "0.23336603793803332`", ",", 
       "0.4612701247952841`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7131436990118185`", ",", "0.2948958245134513`", ",", 
       "0.4037549595645426`", ",", "0.2968347878024006`", ",", 
       "0.6188048961689943`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7131809884162601`", ",", "0.19396013706905907`", ",", 
       "0.12139751176627092`", ",", "0.10772546251552838`", ",", 
       "0.2987328690496504`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7150737023872311`", ",", "0.09522787979407857`", ",", 
       "0.4587447058324325`", ",", "0.24461004962270008`", ",", 
       "0.5477871075463121`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7164550708460634`", ",", "0.2433537707438315`", ",", 
       "0.17208619486732338`", ",", "0.11129585765922968`", ",", 
       "0.4055202944695117`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7166704688771575`", ",", "0.17389406140056404`", ",", 
       "0.1211443933992177`", ",", "0.10444431902522297`", ",", 
       "0.25733254504494607`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7174854365634141`", ",", "0.10112566930306506`", ",", 
       "0.04280022244524381`", ",", "0.04679046753895513`", ",", 
       "0.11687050817484332`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7195932479800928`", ",", "0.19773140842022421`", ",", 
       "0.6172477558714259`", ",", "0.36833628273734725`", ",", 
       "0.8008508205471496`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7197857287951938`", ",", "0.23927536086867832`", ",", 
       "0.1764357759693665`", ",", "0.11936820191539384`", ",", 
       "0.3977759793270056`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7198900916056339`", ",", "0.15935380918875344`", ",", 
       "0.13716774038248997`", ",", "0.12745917544731808`", ",", 
       "0.26465830128493906`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7205282968462793`", ",", "0.12277345370567513`", ",", 
       "0.3632420217615936`", ",", "0.20665243033317443`", ",", 
       "0.4636198299457715`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7208911332955201`", ",", "0.39558037798826695`", ",", 
       "0.32273735117509716`", ",", "0.20819980953544326`", ",", 
       "0.7027884304977721`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.720926082177482`", ",", "0.17785471843184938`", ",", 
       "0.3719429767946953`", ",", "0.21874486361698295`", ",", 
       "0.3465103416242421`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7223334888546378`", ",", "0.09312341430170598`", ",", 
       "0.20066128300005742`", ",", "0.13293932479476192`", ",", 
       "0.23674794580472744`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7224137993754198`", ",", "0.23158836618782339`", ",", 
       "0.14929668200625568`", ",", "0.12615154854928032`", ",", 
       "0.35552085136228545`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7228900513393746`", ",", "0.2464034234746277`", ",", 
       "0.2354055818891095`", ",", "0.19899556085903367`", ",", 
       "0.4202275463938226`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7248536516209287`", ",", "0.17400604541375714`", ",", 
       "0.24097869348199386`", ",", "0.1448829959971486`", ",", 
       "0.36143206693921925`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7249191135548907`", ",", "0.1275556441701027`", ",", 
       "0.06537978464007806`", ",", "0.0617383210822168`", ",", 
       "0.1793718919927265`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7253336429048591`", ",", "0.2323588971850616`", ",", 
       "0.214829496521694`", ",", "0.16348791047188937`", ",", 
       "0.4464614911226302`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.725532805208418`", ",", "0.14214617321702067`", ",", 
       "0.17933963373362558`", ",", "0.09653483609215896`", ",", 
       "0.2963554429071215`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7271409623312678`", ",", "0.06393928316248122`", ",", 
       "0.5573206851910291`", ",", "0.16619452202313245`", ",", 
       "0.5549483091552457`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7274907764760448`", ",", "0.14974477875171793`", ",", 
       "0.3092735502729248`", ",", "0.18772415804913134`", ",", 
       "0.3843391191976862`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7287621003502811`", ",", "0.25436473650773034`", ",", 
       "0.29906282314039884`", ",", "0.16443612059182677`", ",", 
       "0.4878592872518924`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7303969587876187`", ",", "0.18709651649280687`", ",", 
       "0.1820631174503247`", ",", "0.161235133250476`", ",", 
       "0.35830072752473785`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7304934634874111`", ",", "0.5863750302587638`", ",", 
       "0.2541039867517369`", ",", "0.16405067833741965`", ",", 
       "0.838076745428069`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7312901289079174`", ",", "0.2464803380347757`", ",", 
       "0.264652352984841`", ",", "0.1838901247670689`", ",", 
       "0.43543268793520234`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7323111909541319`", ",", "0.2376613875603773`", ",", 
       "0.145366778987915`", ",", "0.10355808464594356`", ",", 
       "0.31029989993583756`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7353037279899429`", ",", "0.15280321970347305`", ",", 
       "0.05715025799126604`", ",", "0.052091697952299204`", ",", 
       "0.19979970275263695`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7383902727567345`", ",", "0.1564820266245971`", ",", 
       "0.42370374134006505`", ",", "0.23308127150490043`", ",", 
       "0.5073163796574862`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7392801255683422`", ",", "0.1836367194029011`", ",", 
       "0.19089086792659155`", ",", "0.14246768861758027`", ",", 
       "0.2642808656097159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.74001121828877`", ",", "0.13249303328445408`", ",", 
       "0.9560302982659838`", ",", "0.36277541261777924`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7407179251709357`", ",", "0.21128661901405948`", ",", 
       "0.08009512404988707`", ",", "0.05428434134104099`", ",", 
       "0.27825522437553124`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7410709897362685`", ",", "0.19883713604580724`", ",", 
       "0.03530798685907707`", ",", "0.03452706428113069`", ",", 
       "0.22639623692452085`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7415728395299045`", ",", "0.20535791375459647`", ",", 
       "0.03756620831396933`", ",", "0.033109303946943995`", ",", 
       "0.2412919270135857`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7428089403960332`", ",", "0.20972676023002396`", ",", 
       "0.19935880028998296`", ",", "0.1537468564130628`", ",", 
       "0.37716666091751405`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7439487441921623`", ",", "0.13773569631817212`", ",", 
       "0.057230101003647324`", ",", "0.05339853474416667`", ",", 
       "0.11651842954179475`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7439917876818941`", ",", "0.2173866137890191`", ",", 
       "0.1621458762180981`", ",", "0.15216367535203795`", ",", 
       "0.3333828559791328`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7466673735333319`", ",", "0.20293322295827448`", ",", 
       "0.07281083137334676`", ",", "0.09804178196235669`", ",", 
       "0.18106461555379738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7476423720713024`", ",", "0.15922116741389714`", ",", 
       "0.16497626629768564`", ",", "0.12103238548737463`", ",", 
       "0.3126099924335435`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7493536145548809`", ",", "0.20448003537236678`", ",", 
       "0.038605752266057454`", ",", "0.03339679345197267`", ",", 
       "0.2387342437043092`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7509756995396116`", ",", "0.16478086493370875`", ",", 
       "0.11450820408174842`", ",", "0.09549214993040918`", ",", 
       "0.2579405320923887`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7515910593238601`", ",", "0.3262654755064008`", ",", 
       "0.09228752287592634`", ",", "0.10281195459979704`", ",", 
       "0.33441675583325103`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7522343873597213`", ",", "0.14746166943521483`", ",", 
       "0.22743859548646317`", ",", "0.1430311997569066`", ",", 
       "0.36994827523557494`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7580733495542027`", ",", "0.06511502990021564`", ",", 
       "0.12978300652030683`", ",", "0.09042886791271751`", ",", 
       "0.14662258281911209`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.760157059115593`", ",", "0.15120101646415723`", ",", 
       "0.0911582838266443`", ",", "0.06521395094228043`", ",", 
       "0.22391428312602024`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7607879075131965`", ",", "0.1998803986584203`", ",", 
       "0.09849938612197512`", ",", "0.09716068808129608`", ",", 
       "0.2890955333592268`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7643002412904882`", ",", "0.2288965273325734`", ",", 
       "0.06589228762909083`", ",", "0.08956279456383026`", ",", 
       "0.24010219690679238`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7696821316389787`", ",", "0.16990759225999166`", ",", 
       "0.24116808135370307`", ",", "0.1822419996697563`", ",", 
       "0.3736176152448548`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.770573023449044`", ",", "0.21483742941278414`", ",", 
       "0.22648811438597097`", ",", "0.14050129314430437`", ",", 
       "0.4224830406427772`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.772007578292459`", ",", "0.07024576299175332`", ",", 
       "0.17390285378024528`", ",", "0.0940768792138373`", ",", 
       "0.23032866384753725`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7725506009118925`", ",", "0.24557042580146668`", ",", 
       "0.18536134275727414`", ",", "0.14335775332357778`", ",", 
       "0.4200651324431899`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7740741583207755`", ",", "0.1904731942359648`", ",", 
       "0.04590106467523941`", ",", "0.04795560207741446`", ",", 
       "0.23367294896978758`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7741301904623353`", ",", "0.11467628512554814`", ",", 
       "0.8270151655959012`", ",", "0.4215186828599653`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7745648121570367`", ",", "0.23684461788959113`", ",", 
       "0.14015026807108652`", ",", "0.12252304924061853`", ",", 
       "0.3635948796341771`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.777513829324211`", ",", "0.14148796803388844`", ",", 
       "0.2095179642809687`", ",", "0.152618632776413`", ",", 
       "0.3397934975945585`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7805742138789814`", ",", "0.18052918251091377`", ",", 
       "0.15162420380550146`", ",", "0.1267190874499071`", ",", 
       "0.27530792175835767`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7873133557493796`", ",", "0.1583475733033796`", ",", 
       "0.12369837864457899`", ",", "0.1339559078552081`", ",", 
       "0.26452036846016025`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7877480224292193`", ",", "0.2391725689664389`", ",", 
       "0.31256594206736354`", ",", "0.18732471570799666`", ",", 
       "0.5004152296736477`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7890002265397573`", ",", "0.2932313176787777`", ",", 
       "0.40314636019591604`", ",", "0.17661372906749673`", ",", 
       "0.6446535440035365`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7902817859194694`", ",", "0.13206286466577383`", ",", 
       "0.7826137172759313`", ",", "0.17778638868034866`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7923026749623305`", ",", "0.18623628772548367`", ",", 
       "0.04854115636903669`", ",", "0.054288460753526`", ",", 
       "0.1564535227560769`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7947471451874112`", ",", "0.23548153236317343`", ",", 
       "0.12371448404846914`", ",", "0.12367636675604138`", ",", 
       "0.3298449163703343`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7974835055924278`", ",", "0.3792647485757954`", ",", 
       "0.528169000799567`", ",", "0.1422884394460773`", ",", 
       "0.8944271909999159`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.797662668168933`", ",", "0.20711492039156057`", ",", 
       "0.3289656842970133`", ",", "0.21752864918178488`", ",", 
       "0.4912908777812129`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7982576934812454`", ",", "0.27373736009055216`", ",", 
       "0.2787592942831934`", ",", "0.18138102172122095`", ",", 
       "0.5507531121258152`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7984999612013206`", ",", "0.16456349572996049`", ",", 
       "0.06973226856177758`", ",", "0.0831078305388818`", ",", 
       "0.20697916630431926`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8080717091502598`", ",", "0.3461594226607592`", ",", 
       "0.09039056227650105`", ",", "0.1325269031028072`", ",", 
       "0.35764766066532944`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8204854056860353`", ",", "0.23007723793878926`", ",", 
       "0.10064010159186261`", ",", "0.09127652377096643`", ",", 
       "0.2584873985179753`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8281761669056011`", ",", "0.0996559327446616`", ",", 
       "0.07514975087519908`", ",", "0.067001006067703`", ",", 
       "0.14762201419175988`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8317897293165614`", ",", "0.13991481141871526`", ",", 
       "0.4008604948919521`", ",", "0.21342509185488254`", ",", 
       "0.4486183207681174`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8528316770160603`", ",", "0.20080121042636567`", ",", 
       "0.6264974069116147`", ",", "0.31930814006031916`", ",", 
       "0.6442555781954072`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8580324664660183`", ",", "0.2799717932898514`", ",", 
       "0.343229408385612`", ",", "0.2120599653627538`", ",", 
       "0.6166782799224089`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8702069484436326`", ",", "0.1675696484690512`", ",", 
       "0.08902577927734082`", ",", "0.10309822855845968`", ",", 
       "0.2482908576625414`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.894049943205819*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"cc956d37-0746-42cd-978b-4a6c500ca534"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", "data"}]], "Input",
 CellChangeTimes->{{3.8855573699828463`*^9, 3.885557373024868*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"b33539b1-165b-4342-abf1-b6f1a550d418"],

Cell[BoxData["1000"], "Output",
 CellChangeTimes->{3.885557373858529*^9, 3.885557816442436*^9, 
  3.885558340291103*^9, 3.885563511148313*^9, 3.885565755186615*^9, 
  3.885565916127818*^9, 3.894049943436473*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"2d9e20bd-4323-4789-8b7e-3816757bb8dd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"data", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "#", "]"}], "==", "dim"}], "&"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8855658066581373`*^9, 3.8855658695876293`*^9}, {
   3.885565907497074*^9, 3.8855659081534224`*^9}, {3.885565946543336*^9, 
   3.88556595305112*^9}, {3.885566030047714*^9, 3.88556603430223*^9}, 
   3.8940491607404003`*^9},ExpressionUUID->"8e7af88f-8653-455c-96da-\
ff3899e0b789"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", "data"}]], "Input",
 CellChangeTimes->{{3.885566038781412*^9, 3.885566040436737*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"ab83ea66-5d29-4883-b38a-853e5306a39f"],

Cell[BoxData["951"], "Output",
 CellChangeTimes->{3.885566040727975*^9, 3.8940499434737873`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"b4debf9b-7999-47d8-a629-c4a90526fe3d"]
}, Open  ]],

Cell[TextData[StyleBox["Analyzing and visualizing the results", "Section"]], \
"Text",
 CellChangeTimes->{{3.882287771947242*^9, 3.882287783076025*^9}, {
  3.8823512121327143`*^9, 
  3.882351216982155*^9}},ExpressionUUID->"67e49088-12fb-4680-bb21-\
f30391a17f78"],

Cell[TextData[StyleBox["Averages, medians, maxes, mins, etc.", \
"Subsection"]], "Text",
 CellChangeTimes->{{3.882290128992378*^9, 3.882290130888975*^9}, {
  3.882346948636672*^9, 3.882346953083943*^9}, {3.8823482156823187`*^9, 
  3.88234821886648*^9}},ExpressionUUID->"61346ca4-f287-4398-8526-\
8659ecda89a6"],

Cell["The average distance to the fixed point:", "Text",
 CellChangeTimes->{{3.882290143097817*^9, 3.882290170475459*^9}, {
  3.8822902435352373`*^9, 3.882290243855042*^9}, {3.8822910814397383`*^9, 
  3.8822910838033533`*^9}},ExpressionUUID->"5288f603-4799-4ac9-82ce-\
84b682498503"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.882290191216399*^9, 3.882290219071104*^9}, {
  3.8855541708295183`*^9, 3.8855541770352993`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"1f6b266c-15e6-496d-9ac9-d8327512c003"],

Cell[BoxData["0.15550993014529585`"], "Output",
 CellChangeTimes->{{3.882290200643248*^9, 3.8822902194393663`*^9}, 
   3.8822937091403227`*^9, 3.8822940282911177`*^9, 3.882337495068639*^9, 
   3.882338219033642*^9, 3.8823400025682697`*^9, 3.882346398494322*^9, 
   3.8823464905467052`*^9, 3.882346898854096*^9, 3.882347067109044*^9, 
   3.882347406565752*^9, 3.882349218846479*^9, 3.882350429510263*^9, 
   3.882351082038568*^9, 3.882353449268221*^9, 3.882366894329185*^9, 
   3.882367019631304*^9, 3.8823670921152267`*^9, 3.882377044711941*^9, 
   3.883964171645227*^9, 3.883966519482057*^9, 3.8840128502612953`*^9, 
   3.884013384639371*^9, 3.8840136501393547`*^9, 3.884015626144815*^9, 
   3.8840168302085037`*^9, 3.884017463497219*^9, 3.8845234907228317`*^9, 
   3.884996201808538*^9, 3.8849964128915567`*^9, 3.885214272671528*^9, 
   3.885218472324607*^9, 3.885285906293352*^9, 3.8854149115771093`*^9, 
   3.8855026113325577`*^9, 3.885513524219014*^9, 3.885554136761888*^9, 
   3.885554177588456*^9, 3.8855543474215193`*^9, 3.885565778217857*^9, 
   3.8855660875213833`*^9, 3.894049943506443*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"a37c2250-5f22-45c2-9830-5a27ed7af5ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8822903632918777`*^9, 3.8822903672628813`*^9}, {
  3.8822904717038918`*^9, 3.882290472318829*^9}, {3.8855541835896997`*^9, 
  3.885554183787032*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"50b9d80c-9541-49f5-92dc-3583a1598ce9"],

Cell[BoxData["0.09130397028600713`"], "Output",
 CellChangeTimes->{{3.882290364388698*^9, 3.882290367730599*^9}, 
   3.882290472711874*^9, 3.88229370916777*^9, 3.8822940283244953`*^9, 
   3.8823374950940638`*^9, 3.882338219060183*^9, 3.8823400025999126`*^9, 
   3.882346398527411*^9, 3.8823464905769043`*^9, 3.882346898885256*^9, 
   3.8823470671660957`*^9, 3.882347406599772*^9, 3.882349218875918*^9, 
   3.8823504295527687`*^9, 3.88235108209488*^9, 3.882353449310947*^9, 
   3.8823668944320583`*^9, 3.882367020403401*^9, 3.882377044749487*^9, 
   3.883964171681395*^9, 3.8839665195004597`*^9, 3.884012850319511*^9, 
   3.8840133846866207`*^9, 3.884013650193276*^9, 3.884015626183805*^9, 
   3.8840168302553587`*^9, 3.884017463539337*^9, 3.88452348269133*^9, 
   3.884996203592598*^9, 3.884996413764391*^9, 3.885214272686676*^9, 
   3.885218472361287*^9, 3.885285906369514*^9, 3.885414912026062*^9, 
   3.8855026114580097`*^9, 3.885513524412168*^9, 3.885554136876853*^9, 
   3.885554347510641*^9, 3.885566087601166*^9, 3.8940499435390863`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"9f2db439-133e-4e01-9eca-1293bff2d852"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8822903632918777`*^9, 3.8822903672628813`*^9}, {
  3.885554185386531*^9, 3.885554185542965*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"10da9712-fb1e-4794-a6e6-4d28e45604c0"],

Cell[BoxData["0.9560302982659838`"], "Output",
 CellChangeTimes->{{3.882290364388698*^9, 3.882290367730599*^9}, 
   3.882293709192296*^9, 3.882294028358014*^9, 3.882337495117544*^9, 
   3.882338219085979*^9, 3.8823400026284924`*^9, 3.8823463985637617`*^9, 
   3.882346490606131*^9, 3.882346898919326*^9, 3.8823470672215567`*^9, 
   3.882347406630148*^9, 3.882349218904337*^9, 3.88235042958002*^9, 
   3.882351082146338*^9, 3.882353449352767*^9, 3.8823668944715652`*^9, 
   3.882367021784729*^9, 3.882377044786759*^9, 3.8839641717050543`*^9, 
   3.883966519520667*^9, 3.88401285033217*^9, 3.884013384731934*^9, 
   3.884013650247422*^9, 3.884015626233244*^9, 3.884016830300585*^9, 
   3.884017463576836*^9, 3.884523480600319*^9, 3.8849962061809263`*^9, 
   3.884996415352401*^9, 3.885214272702231*^9, 3.885218472385626*^9, 
   3.8852859063860483`*^9, 3.8854149122260036`*^9, 3.8855026115859632`*^9, 
   3.885513524519265*^9, 3.885554136934011*^9, 3.885554347538623*^9, 
   3.885566087627933*^9, 3.89404994357164*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"26b58a2e-5870-41ff-a031-90574753d0aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8823482244003057`*^9, 3.882348224606739*^9}, {
  3.8855541886486187`*^9, 3.885554190671735*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"7a0d0bda-9dff-48ea-bdbe-73b5d3250f25"],

Cell[BoxData["0.0017994015254177887`"], "Output",
 CellChangeTimes->{3.882348225239251*^9, 3.882349218931748*^9, 
  3.8823504296088133`*^9, 3.882351082189825*^9, 3.882353449391643*^9, 
  3.882366894509428*^9, 3.882367022721724*^9, 3.882377044823783*^9, 
  3.883964171712057*^9, 3.8839665195430326`*^9, 3.8840128503822937`*^9, 
  3.884013384776222*^9, 3.884013650297274*^9, 3.884015626283326*^9, 
  3.884016830315783*^9, 3.884017463618834*^9, 3.8845234791485*^9, 
  3.884996210656554*^9, 3.884996417097217*^9, 3.885214272717697*^9, 
  3.8852184724042*^9, 3.885285906400428*^9, 3.885414912284149*^9, 
  3.8855026117188807`*^9, 3.885513524622849*^9, 3.88555413697409*^9, 
  3.885554347564478*^9, 3.885566087654572*^9, 3.894049943605282*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"51ea554c-aa30-48a5-b8b9-6cf59a513328"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quartiles", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.882351052827795*^9, 3.8823510534293756`*^9}, {
  3.885554192680401*^9, 3.885554192844256*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"46a95096-7afe-4d80-ad18-72757d871861"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.043773813422497365`", ",", "0.09130397028600713`", ",", 
   "0.21116894460557706`"}], "}"}]], "Output",
 CellChangeTimes->{{3.882351053891571*^9, 3.88235108223713*^9}, 
   3.8823534494224367`*^9, 3.8823668946685123`*^9, 3.8823670236421633`*^9, 
   3.8823770448624287`*^9, 3.883964171735121*^9, 3.883966519566765*^9, 
   3.8840128504240837`*^9, 3.884013384823468*^9, 3.8840136503127747`*^9, 
   3.884015626353917*^9, 3.884016830362752*^9, 3.884017463666855*^9, 
   3.884523477101128*^9, 3.8849962115544786`*^9, 3.8849964188807373`*^9, 
   3.885214272757248*^9, 3.8852184724237947`*^9, 3.885285906418359*^9, 
   3.885414912568033*^9, 3.885502611846177*^9, 3.885513524746387*^9, 
   3.885554137016919*^9, 3.885554347600836*^9, 3.885566087681801*^9, 
   3.885567607088228*^9, 3.894049943639804*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"2f3a2ca1-a932-4b1c-8926-431c8804cbca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.882351191796*^9, 3.882351198746694*^9}, {
  3.88555419447561*^9, 3.8855541946931477`*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"9a79cd16-1916-40e8-a769-2f7e05ad0bc0"],

Cell[BoxData["0.16506181247857912`"], "Output",
 CellChangeTimes->{3.882351199534021*^9, 3.882353449452416*^9, 
  3.882366894713151*^9, 3.8823670248483057`*^9, 3.882377044899197*^9, 
  3.883964171768907*^9, 3.8839665195899477`*^9, 3.884012850466346*^9, 
  3.884013384870843*^9, 3.884013650360186*^9, 3.884015626371488*^9, 
  3.884016830408095*^9, 3.884017465001444*^9, 3.884523473938382*^9, 
  3.8849964210183887`*^9, 3.885214272772779*^9, 3.885218472442918*^9, 
  3.885285906432349*^9, 3.8854149127623034`*^9, 3.885502611982514*^9, 
  3.88551352486872*^9, 3.885554137060237*^9, 3.885554347640346*^9, 
  3.8855660877090073`*^9, 3.8940499436659327`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"a48ed21d-38ee-4836-b429-8d0d05d08712"]
}, Open  ]],

Cell["\<\
The average distance of the optimal report to the true distribution (under \
reporting the optimal report):\
\>", "Text",
 CellChangeTimes->{{3.882290267223476*^9, 3.8822903004919577`*^9}, {
  3.882290420125044*^9, 3.882290443261566*^9}, {3.882351083895578*^9, 
  3.882351084616642*^9}, {3.885567301341811*^9, 
  3.885567303078836*^9}},ExpressionUUID->"06ea9157-768d-4dab-8667-\
990511ad0c76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8822902507349787`*^9, 3.882290252591099*^9}, {
  3.885554199641172*^9, 3.885554199801771*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"ac889393-5bee-4134-9bd2-da26ec5567b0"],

Cell[BoxData["0.10142479775579394`"], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQB2LXRruuh2/eOGa8W2b5GEgLtPYkgujMnU9m/QDS5ZOS
v4JoGdHQKz+B9CKry5//AOkTsSH/QfSn6XFGf4G0V0OGO4j217taCKI3bYsL
+QekL8VveQ2iN+05YPsfSLeU6KcyvH3jKGR78ysbkN6vkcHGDqRvfJj7ihtI
z3CufCj04Y1jysLPbCJAWro4YJkWkA7Ll30Joid/9OHSBtJnvfwYdYB0W8O5
6SA6K1XrOYhOyLj3U/njG0cl9WsvuD69cbxgIelRCqTnnecLLQfSr7z8nGYA
aRMfFYfrQPqOe7MQ0+c3jmty56exA+kWa2VraSB9bWZpKIgum/tdQBFIc/Rq
rATRDwS/TfJnfusIADhisac=
  "],
 CellLabel->"Out[76]=",ExpressionUUID->"b835165f-2d08-4bed-81c2-5e04efe2a58c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8822902507349787`*^9, 3.882290252591099*^9}, {
  3.8822904928157997`*^9, 3.88229049338002*^9}, {3.8855542018222733`*^9, 
  3.885554202050148*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"b6ecf5de-46b6-421f-ba52-19b569cfa03e"],

Cell[BoxData["0.07496379977194349`"], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQB2LXRruuh2/eOE6ctXU5iJZfv9zyMZD+MKM3EUQXzXk6
6weQ5g1O+Qqia/6GXvkJpKeFX/n8B0jPjwj9D6J95sUb/QXSkx9muoNoN5lr
hSD69tL4kH9A+rHT1tcgWvTRB9v/QLqpwCCV4e0bx3MXb39lA9ICc3vZ2IF0
qcD8V9xAeg1j1UOhD0BzE76wiQDpgCOBy7SA9I/7ci9BdN96Py5tIF3GGMCo
A6S1f5yfDqKffNd+DqITvB+wq3x84/ionf8l16c3jpZbJT1KgfSpIv7QciB9
b5+f0wwgXVWn5XAdSBfcaRdi+vzGMZR1cRo7kM5aoWItDaQ9w8tCQXRLzQ8B
RSDtdOvbJH/mt44AeKi0aQ==
  "],
 CellLabel->"Out[77]=",ExpressionUUID->"4391d642-b26f-46d8-8e10-a9e6745a2165"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8822903763893147`*^9, 3.8822903773001413`*^9}, {
  3.885554203569553*^9, 3.885554203772933*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"8aaa46c1-c7aa-4dfb-b391-300c4990f500"],

Cell[BoxData["0.4215186828599653`"], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IfZuYzH75542hVusLyMZCu6+xLBNE25c9m/QDSW+RS
v4Lo66/DrvwE0kGBVz//AdJTvML+g+j8hgSjv0BaY3e2O4jmY7heCKLdWhJC
/gHp2TrbXoPohnf8dv9B5icbpjK8feNo5H33KxuQjlXdxMYOpD85L3jFDaT7
dlc9FPrwxjFQ6CubCJCe5R28TAtId3YrvATRWhMDuLSB9IVtgYw6QHrqnIvT
QfR/Q93nINp5zmJ2lY9vHOdHOr7k+vTGMdxIyqMUSO8REwgtB9I+Rv5OM4C0
VYeOw3UgfZChV4jp8xtHIYdlaexA2kVMzVoaSDezl4eC6C2JPwUUgfTuHd8n
+TO/dQQAJ/On7w==
  "],
 CellLabel->"Out[78]=",ExpressionUUID->"5deb60fa-c6ed-4877-b047-243e363853fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8823482363172703`*^9, 3.882348236579376*^9}, {
  3.885554206801016*^9, 3.885554206984476*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"884bf848-8085-4718-ae05-f1ea98dc45e4"],

Cell[BoxData["0.0018353896604334995`"], "Output",
 CellChangeTimes->{3.882348237048725*^9, 3.8823492190445433`*^9, 
  3.882350429720628*^9, 3.882351089554639*^9, 3.882353449574684*^9, 
  3.882366894954424*^9, 3.88236703048413*^9, 3.882377045043776*^9, 
  3.883964171856414*^9, 3.8839665196796303`*^9, 3.884012850648533*^9, 
  3.884013385067552*^9, 3.884013650572397*^9, 3.88401562659172*^9, 
  3.884016830601397*^9, 3.884017465451997*^9, 3.884523579213067*^9, 
  3.884996427575488*^9, 3.885214272833806*^9, 3.885218472523155*^9, 
  3.8852859064888277`*^9, 3.885414913621462*^9, 3.8855026125292473`*^9, 
  3.8855135253012114`*^9, 3.88555413721434*^9, 3.8855543477408323`*^9, 
  3.88556608782075*^9, 3.894049943769761*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"f8e0ea23-d284-4f7c-87cc-3fcf51840cd1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quartiles", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.882351020473104*^9, 3.8823510389856052`*^9}, {
  3.885554208759985*^9, 3.885554208951478*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"8ecb4a78-0e8a-48b2-8865-8d9b22c77b0c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.04093883598183162`", ",", "0.07496379977194349`", ",", 
   "0.14087510499041772`"}], "}"}]], "Output",
 CellChangeTimes->{3.882351039766643*^9, 3.882351090730117*^9, 
  3.8823534496052237`*^9, 3.882366895025281*^9, 3.882367032128273*^9, 
  3.8823770450808573`*^9, 3.8839641718767*^9, 3.8839665196998997`*^9, 
  3.884012850688449*^9, 3.8840133851136637`*^9, 3.88401365063133*^9, 
  3.884015626636229*^9, 3.884016830647113*^9, 3.8840174654898*^9, 
  3.884523574391663*^9, 3.884996429200037*^9, 3.885214272848741*^9, 
  3.885218472543229*^9, 3.885285906502665*^9, 3.8854149137826014`*^9, 
  3.885502612669443*^9, 3.8855135254588203`*^9, 3.885554137266115*^9, 
  3.8855543477621393`*^9, 3.885566087848629*^9, 3.894049943799053*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"2a2c4643-5690-4f05-b4eb-ef133bfadf08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.882351174645957*^9, 3.8823511817329807`*^9}, {
  3.885554210770323*^9, 3.885554210960661*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"e21f1523-53e5-4432-8fca-2040d26c7cee"],

Cell[BoxData["0.07982591449934198`"], "Output",
 CellChangeTimes->{3.882351182309958*^9, 3.882353449636319*^9, 
  3.882366895071364*^9, 3.882367033271806*^9, 3.882377045117674*^9, 
  3.883964171899439*^9, 3.8839665197088337`*^9, 3.884012850734873*^9, 
  3.8840133851544456`*^9, 3.8840136506844473`*^9, 3.884015626679785*^9, 
  3.884016830708975*^9, 3.884017466599617*^9, 3.884523576813765*^9, 
  3.884996430362111*^9, 3.8852142728634577`*^9, 3.8852184725629873`*^9, 
  3.885285906516465*^9, 3.8854149140913677`*^9, 3.885502612797228*^9, 
  3.88551352554911*^9, 3.885554137312578*^9, 3.885554347791691*^9, 
  3.885566087877322*^9, 3.894049943827778*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"cc6e4436-339f-4287-ba03-d96041b58907"]
}, Open  ]],

Cell[TextData[StyleBox["Distances to bounds", "Subsection"]], "Text",
 CellChangeTimes->{{3.884523930443489*^9, 
  3.884523933043545*^9}},ExpressionUUID->"02dc9801-cbc1-4508-8b2d-\
2670874dde45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diststoloosebounds", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"data", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "*", 
      RowBox[{"2", "/", 
       RowBox[{"Sqrt", "[", "5", "]"}]}]}], "-", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.885575545234805*^9, 3.8855755878124313`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"8c1d4098-8393-43b8-9725-a22f060b202f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1919225358005633`", ",", "0.24256406022564356`", ",", 
   "0.24867019129016618`", ",", "0.22689398282052503`", ",", 
   "0.20296600654776445`", ",", "0.20778460679386884`", ",", 
   "0.22331858885918077`", ",", "0.2527645789185529`", ",", 
   "0.26108681934352496`", ",", "0.2579620512281593`", ",", 
   "0.2396294819789259`", ",", "0.2639462262291687`", ",", 
   "0.24484224803699223`", ",", "0.2508863196859509`", ",", 
   "0.27953184095742106`", ",", "0.22498387710452028`", ",", 
   "0.2954613722947645`", ",", "0.27875247433960004`", ",", 
   "0.2522606272162744`", ",", "0.2796615040904962`", ",", 
   "0.2171169803815966`", ",", "0.2869107328032687`", ",", 
   "0.20287903353618186`", ",", "0.280649158587133`", ",", 
   "0.2947093701994784`", ",", "0.25620450639692083`", ",", 
   "0.2786670877667863`", ",", "0.2706364579699271`", ",", 
   "0.2810373345963082`", ",", "0.2506582677111914`", ",", 
   "0.24572878481328522`", ",", "0.2727990360095631`", ",", 
   "0.2520357554537477`", ",", "0.2799133966614206`", ",", 
   "0.28883794352203235`", ",", "0.2736260633454201`", ",", 
   "0.29683206434512016`", ",", "0.2859325731310395`", ",", 
   "0.30970922062025175`", ",", "0.2887652204260135`", ",", 
   "0.2945268757078507`", ",", "0.3133810102180205`", ",", 
   "0.3091119884161994`", ",", "0.313478252714841`", ",", 
   "0.27001431052753505`", ",", "0.29206828326302686`", ",", 
   "0.23452911358356543`", ",", "0.2077700566896102`", ",", 
   "0.31519329601543583`", ",", "0.2965158882980945`", ",", 
   "0.3076829245350168`", ",", "0.2808005001939582`", ",", 
   "0.27081868906697254`", ",", "0.2769459793198745`", ",", 
   "0.30865985724744627`", ",", "0.2826557893094377`", ",", 
   "0.30057247401424914`", ",", "0.3231657590321873`", ",", 
   "0.250675492050475`", ",", "0.23426813877767522`", ",", 
   "0.2913901204011991`", ",", "0.23740670278067935`", ",", 
   "0.3228500489705169`", ",", "0.3202297291379626`", ",", 
   "0.3236249147635817`", ",", "0.30223111277690434`", ",", 
   "0.31727120597167685`", ",", "0.3434048241175717`", ",", 
   "0.33246046301068344`", ",", "0.31461756301682414`", ",", 
   "0.34029107364194633`", ",", "0.3165066195072777`", ",", 
   "0.32044662655956274`", ",", "0.3020069382587004`", ",", 
   "0.3260858125692171`", ",", "0.342243078909013`", ",", 
   "0.32955210554830383`", ",", "0.3180920465896846`", ",", 
   "0.3328965755181204`", ",", "0.3180305733756986`", ",", 
   "0.2608159374449373`", ",", "0.29603437065678306`", ",", 
   "0.3251623264691016`", ",", "0.3521670265410026`", ",", 
   "0.3113319932413948`", ",", "0.25994803180141907`", ",", 
   "0.360532761870286`", ",", "0.3098536087968107`", ",", 
   "0.30677495470223953`", ",", "0.3675832031816429`", ",", 
   "0.35476717950657366`", ",", "0.33992818878009007`", ",", 
   "0.22420901417455458`", ",", "0.3494717809518632`", ",", 
   "0.3620067899784475`", ",", "0.3128037095460005`", ",", 
   "0.3323571527240954`", ",", "0.26156882816520466`", ",", 
   "0.3436558755781393`", ",", "0.24890371625930194`", ",", 
   "0.31082995760152166`", ",", "0.244714100336879`", ",", 
   "0.37318533086381345`", ",", "0.3419412202658099`", ",", 
   "0.3542956320887753`", ",", "0.3268674008685887`", ",", 
   "0.33685797158987874`", ",", "0.2726628541768108`", ",", 
   "0.3766472132843022`", ",", "0.28998380708549365`", ",", 
   "0.31022385511433537`", ",", "0.3703390070644937`", ",", 
   "0.27325896276228484`", ",", "0.21907336135254343`", ",", 
   "0.38416778734011964`", ",", "0.3734172921699448`", ",", 
   "0.2912645552144002`", ",", "0.35946625432717305`", ",", 
   "0.35055304960159633`", ",", "0.36551253260853983`", ",", 
   "0.29622778227770613`", ",", "0.35516269434242353`", ",", 
   "0.32472222169886367`", ",", "0.35031448155543565`", ",", 
   "0.32718590959812444`", ",", "0.34049564371138274`", ",", 
   "0.3668389234642436`", ",", "0.3371136463078849`", ",", 
   "0.19460448422462664`", ",", "0.34805067867392403`", ",", 
   "0.36953703329934995`", ",", "0.37387348956351524`", ",", 
   "0.21018437986237656`", ",", "0.3880196169874517`", ",", 
   "0.3297393194563629`", ",", "0.36988649635202253`", ",", 
   "0.2867214456516745`", ",", "0.3765668957823345`", ",", 
   "0.3833643776318764`", ",", "0.3802464761146535`", ",", 
   "0.38608202909546707`", ",", "0.3661143839865315`", ",", 
   "0.325647414257555`", ",", "0.35945612719694037`", ",", 
   "0.3683463596453804`", ",", "0.263299148337994`", ",", 
   "0.37521058156557757`", ",", "0.38217750524532296`", ",", 
   "0.3832579758861361`", ",", "0.22678436219692272`", ",", 
   "0.38847431612281347`", ",", "0.3690723795100869`", ",", 
   "0.3394174205107041`", ",", "0.362930553731715`", ",", 
   "0.310870735567974`", ",", "0.24445352296047104`", ",", 
   "0.3724147385624522`", ",", "0.3855506601911967`", ",", 
   "0.34631510322043313`", ",", "0.3814134591034405`", ",", 
   "0.3488861081066067`", ",", "0.19574297055907552`", ",", 
   "0.3865099513789423`", ",", "0.3184571088801993`", ",", 
   "0.392075262248657`", ",", "0.3894318288808592`", ",", 
   "0.35108118934329624`", ",", "0.38524674492803945`", ",", 
   "0.3784458944865623`", ",", "0.33650794457075833`", ",", 
   "0.3784077406538656`", ",", "0.3809690868806076`", ",", 
   "0.35300209295237583`", ",", "0.3867867316091825`", ",", 
   "0.3741814229584822`", ",", "0.38171513655910005`", ",", 
   "0.3069597972282697`", ",", "0.3761670213028493`", ",", 
   "0.3732099142845554`", ",", "0.38597842828653295`", ",", 
   "0.35108359131329786`", ",", "0.3597369384651`", ",", 
   "0.36655078494029425`", ",", "0.3673952787612257`", ",", 
   "0.36120092321074015`", ",", "0.380949282767581`", ",", 
   "0.38234188203372316`", ",", "0.34014759166670017`", ",", 
   "0.35191441977741045`", ",", "0.36492789540061105`", ",", 
   "0.3053421508465568`", ",", "0.3674990965571955`", ",", 
   "0.31337251252141174`", ",", "0.3891561159662977`", ",", 
   "0.3563717912633792`", ",", "0.328388146288699`", ",", 
   "0.3924983471191147`", ",", "0.37212039481037384`", ",", 
   "0.3788795025882882`", ",", "0.33365961414762235`", ",", 
   "0.29108361103408587`", ",", "0.24371071241643205`", ",", 
   "0.35514537705465643`", ",", "0.3319921404435896`", ",", 
   "0.38900424947670553`", ",", "0.38811143765935613`", ",", 
   "0.3417538439463029`", ",", "0.3889104033664897`", ",", 
   "0.2850254351011752`", ",", "0.364491792638777`", ",", 
   "0.3834884696548221`", ",", "0.16064082635457466`", ",", 
   "0.3904917021390533`", ",", "0.39400729383005756`", ",", 
   "0.36712722218763566`", ",", "0.3263685501559793`", ",", 
   "0.3516645800786035`", ",", "0.40580350967877976`", ",", 
   "0.3758044072907911`", ",", "0.39113184909253834`", ",", 
   "0.34651964612887176`", ",", "0.2996707285385554`", ",", 
   "0.413771893335822`", ",", "0.34758325453756767`", ",", 
   "0.39712358467112324`", ",", "0.3806809192926401`", ",", 
   "0.383113520635487`", ",", "0.39722072615409854`", ",", 
   "0.3729785901520922`", ",", "0.35956252715405446`", ",", 
   "0.37602678713848176`", ",", "0.3396630128702952`", ",", 
   "0.3660608119441465`", ",", "0.14409065169044027`", ",", 
   "0.42615738968719785`", ",", "0.3985708632563637`", ",", 
   "0.21094652730688623`", ",", "0.35047865005465473`", ",", 
   "0.2396245824504221`", ",", "0.3919717018163349`", ",", 
   "0.3775016223023036`", ",", "0.4070470757291742`", ",", 
   "0.2536339675707138`", ",", "0.35367265450880425`", ",", 
   "0.27164488611278637`", ",", "0.3672050557797532`", ",", 
   "0.380261761900687`", ",", "0.26408478018791803`", ",", 
   "0.3818360584794608`", ",", "0.36917647691513944`", ",", 
   "0.29803023302458437`", ",", "0.3491499195568164`", ",", 
   "0.38737316535508376`", ",", "0.4012471262202457`", ",", 
   "0.3960766637818982`", ",", "0.4197775876120547`", ",", 
   "0.36891160406392837`", ",", "0.4070200341205418`", ",", 
   "0.3610606235827442`", ",", "0.39403425243959006`", ",", 
   "0.36318888380091263`", ",", "0.18230744138085753`", ",", 
   "0.40901060610448553`", ",", "0.3794205821169143`", ",", 
   "0.4041675823127517`", ",", "0.3524174966539741`", ",", 
   "0.30177077793220825`", ",", "0.3382929143032332`", ",", 
   "0.42814247749978024`", ",", "0.41242411101833454`", ",", 
   "0.362626807566267`", ",", "0.3941083532642779`", ",", 
   "0.40501495324924175`", ",", "0.32362442917165035`", ",", 
   "0.4229577185366946`", ",", "0.42824809921325124`", ",", 
   "0.3734567454822042`", ",", "0.3915511040237052`", ",", 
   "0.4007534890937812`", ",", "0.4208884354889783`", ",", 
   "0.17560821723777092`", ",", "0.37294274744120215`", ",", 
   "0.4321285372911564`", ",", "0.4389292030600168`", ",", 
   "0.4116661956685632`", ",", "0.4135321586121341`", ",", 
   "0.3076510247936347`", ",", "0.3435977536681116`", ",", 
   "0.3962670198704844`", ",", "0.4317223475847741`", ",", 
   "0.30024615752432837`", ",", "0.3106688164543693`", ",", 
   "0.27461788803461173`", ",", "0.39606240583747365`", ",", 
   "0.343186137385474`", ",", "0.25282766470925094`", ",", 
   "0.3885301960900074`", ",", "0.41393325078657994`", ",", 
   "0.3888363832650796`", ",", "0.42683715432163416`", ",", 
   "0.3731867590694802`", ",", "0.39172153344572425`", ",", 
   "0.35129402483524175`", ",", "0.4375924092087992`", ",", 
   "0.4185595955717187`", ",", "0.29252179554669894`", ",", 
   "0.43339611834869546`", ",", "0.4422844744351222`", ",", 
   "0.4203064298525649`", ",", "0.3171487670839772`", ",", 
   "0.4279005900885885`", ",", "0.333728524705272`", ",", 
   "0.371035743392911`", ",", "0.4408660769715926`", ",", 
   "0.3556587735973848`", ",", "0.3875092505113442`", ",", 
   "0.364796216888121`", ",", "0.36701707089077773`", ",", 
   "0.3295521015846674`", ",", "0.1998041874591977`", ",", 
   "0.4356747318992546`", ",", "0.39685668456406664`", ",", 
   "0.3974413845730267`", ",", "0.33756040006772847`", ",", 
   "0.2745277976075446`", ",", "0.14492574538739755`", ",", 
   "0.34823071580140386`", ",", "0.35655996924543903`", ",", 
   "0.3750351469077396`", ",", "0.42105533950112595`", ",", 
   "0.3680764920761659`", ",", "0.42562505815407603`", ",", 
   "0.37129362034657226`", ",", "0.43865352369809585`", ",", 
   "0.41391362082709493`", ",", "0.41469718944641265`", ",", 
   "0.4240862811285821`", ",", "0.43989664689495056`", ",", 
   "0.4396015891246148`", ",", "0.43018693964895693`", ",", 
   "0.35134740584760027`", ",", "0.40285575556558045`", ",", 
   "0.3687839124991756`", ",", "0.4193339827381357`", ",", 
   "0.34321896632715276`", ",", "0.452007482621961`", ",", 
   "0.4313391940940244`", ",", "0.4037712100122221`", ",", 
   "0.4146743455169809`", ",", "0.41322672552241685`", ",", 
   "0.44061292376239175`", ",", "0.41051469092941867`", ",", 
   "0.4181508515419313`", ",", "0.3277047163277148`", ",", 
   "0.40902932682271326`", ",", "0.4124649168219005`", ",", 
   "0.4093623259903031`", ",", "0.4381603133108087`", ",", 
   "0.3712492739102281`", ",", "0.4192933329132036`", ",", 
   "0.4375364842147737`", ",", "0.35976656217304365`", ",", 
   "0.327991544604901`", ",", "0.36770102304370994`", ",", 
   "0.3767480421203109`", ",", "0.4292042923636443`", ",", 
   "0.4217302469916646`", ",", "0.42883613722595526`", ",", 
   "0.3266857692334155`", ",", "0.1294460447498979`", ",", 
   "0.37057892761706046`", ",", "0.44309349347683247`", ",", 
   "0.2513424684727971`", ",", "0.3954551921294922`", ",", 
   "0.23561511951380998`", ",", "0.22219789486773872`", ",", 
   "0.37101776135805387`", ",", "0.45254097146712324`", ",", 
   "0.4210981109728884`", ",", "0.4501926867532455`", ",", 
   "0.4594919264769999`", ",", "0.39447435380361623`", ",", 
   "0.4324397212256589`", ",", "0.44306077227069063`", ",", 
   "0.4618130345287699`", ",", "0.3269058151221379`", ",", 
   "0.3812398931451294`", ",", "0.3586743887912631`", ",", 
   "0.3868320649990234`", ",", "0.3270037160864937`", ",", 
   "0.4054371055992755`", ",", "0.31983498698244844`", ",", 
   "0.4355388320016008`", ",", "0.2653015314103069`", ",", 
   "0.3673137496258024`", ",", "0.41546295700850777`", ",", 
   "0.4606665103933956`", ",", "0.4321359139788391`", ",", 
   "0.3187000650632593`", ",", "0.3551073888559668`", ",", 
   "0.380751499589153`", ",", "0.3879386960308385`", ",", 
   "0.29060677948554753`", ",", "0.28094179379591006`", ",", 
   "0.41013943768705413`", ",", "0.3987504796861946`", ",", 
   "0.28857828079956865`", ",", "0.468587408953197`", ",", 
   "0.44980517062631314`", ",", "0.41291076967597273`", ",", 
   "0.43207378301503835`", ",", "0.41388106380013745`", ",", 
   "0.3063541857610555`", ",", "0.44469666732413937`", ",", 
   "0.44565108798489816`", ",", "0.15454414112411158`", ",", 
   "0.45998026398444614`", ",", "0.39889806086788804`", ",", 
   "0.42942903767659263`", ",", "0.2998653336741075`", ",", 
   "0.3311178152037535`", ",", "0.11809031506168344`", ",", 
   "0.4064887308047878`", ",", "0.19800997812671683`", ",", 
   "0.45151110227648317`", ",", "0.43358181068252216`", ",", 
   "0.33180445504688433`", ",", "0.4472528476871696`", ",", 
   "0.43770232978298906`", ",", "0.12373652676416719`", ",", 
   "0.33716836464393507`", ",", "0.46886884578891336`", ",", 
   "0.3812831555449331`", ",", "0.4598544228367952`", ",", 
   "0.4590871163882581`", ",", "0.45959487799462795`", ",", 
   "0.36683262048093035`", ",", "0.39869032391492776`", ",", 
   "0.33666741721804666`", ",", "0.40780241541718215`", ",", 
   "0.43786867889328107`", ",", "0.33086844385866454`", ",", 
   "0.43520236796518796`", ",", "0.42135184009497084`", ",", 
   "0.4691553964571316`", ",", "0.4371536603033727`", ",", 
   "0.44648212201481685`", ",", "0.3896184374828992`", ",", 
   "0.28789722875865287`", ",", "0.31836228893442187`", ",", 
   "0.20948325978905513`", ",", "0.46947512425950894`", ",", 
   "0.3522942767770395`", ",", "0.4310194205280794`", ",", 
   "0.22611182886015824`", ",", "0.45202797186128574`", ",", 
   "0.4553430502014855`", ",", "0.47541730592988657`", ",", 
   "0.3894411625753724`", ",", "0.37679911321517573`", ",", 
   "0.4596567170831413`", ",", "0.4668701614403963`", ",", 
   "0.40485301659147943`", ",", "0.4628300646275581`", ",", 
   "0.31062097890692003`", ",", "0.3258001461059261`", ",", 
   "0.46758372464562153`", ",", "0.4502024193141545`", ",", 
   "0.31193618362487263`", ",", "0.4287703326309269`", ",", 
   "0.4039302320667738`", ",", "0.3181513964231761`", ",", 
   "0.37032840252724886`", ",", "0.44533979034309834`", ",", 
   "0.45535428795117716`", ",", "0.41358974109119684`", ",", 
   "0.3975519615279305`", ",", "0.4574171578037465`", ",", 
   "0.46977822710123046`", ",", "0.3510716902952261`", ",", 
   "0.4136369423582174`", ",", "0.4249637927927951`", ",", 
   "0.44339096142295137`", ",", "0.3716091315555793`", ",", 
   "0.44660355732106205`", ",", "0.3931684813434864`", ",", 
   "0.4223451394346516`", ",", "0.3750314029430495`", ",", 
   "0.4761869537899809`", ",", "0.4415881509809472`", ",", 
   "0.39100290038832497`", ",", "0.47008073290947666`", ",", 
   "0.47747550018249446`", ",", "0.3164671791656723`", ",", 
   "0.4507403870949588`", ",", "0.46802832750248585`", ",", 
   "0.4823420792347072`", ",", "0.33912289819997626`", ",", 
   "0.3901529840410506`", ",", "0.4308148498861615`", ",", 
   "0.4813146050560908`", ",", "0.14544969270763536`", ",", 
   "0.11926918996198987`", ",", "0.44590404884263857`", ",", 
   "0.47045369432170925`", ",", "0.30107180990958066`", ",", 
   "0.4664058704638083`", ",", "0.463952458379385`", ",", 
   "0.478909975078862`", ",", "0.3258988948714261`", ",", 
   "0.47186838185118707`", ",", "0.40012948658509156`", ",", 
   "0.47263602667558474`", ",", "0.4230974615860813`", ",", 
   "0.36638339831295996`", ",", "0.33208637218182346`", ",", 
   "0.2699514162470248`", ",", "0.29093007139208116`", ",", 
   "0.4400442625069558`", ",", "0.40799122178850344`", ",", 
   "0.4719548061463129`", ",", "0.41345454647967855`", ",", 
   "0.40840559647767305`", ",", "0.40568726065548705`", ",", 
   "0.36480023364932745`", ",", "0.4076616917370537`", ",", 
   "0.43903733865325983`", ",", "0.43594546444115545`", ",", 
   "0.43816102975426835`", ",", "0.45423549914184597`", ",", 
   "0.4945422834170053`", ",", "0.35225077893451623`", ",", 
   "0.36462664097468134`", ",", "0.5052492021212323`", ",", 
   "0.41852775613573506`", ",", "0.4144954223366111`", ",", 
   "0.483047110935013`", ",", "0.46761140043346605`", ",", 
   "0.42459245673737733`", ",", "0.41253599767286353`", ",", 
   "0.2795891638678126`", ",", "0.45496331983598703`", ",", 
   "0.503243684466818`", ",", "0.4767876757508794`", ",", 
   "0.3770547614673523`", ",", "0.4927523276008099`", ",", 
   "0.1912631281494182`", ",", "0.4231966466782292`", ",", 
   "0.10427303696060936`", ",", "0.47100168980494805`", ",", 
   "0.329976648915593`", ",", "0.3466572186048462`", ",", 
   "0.2771473526366608`", ",", "0.48150103705512626`", ",", 
   "0.12599363867590252`", ",", "0.4828523839465014`", ",", 
   "0.4842818654024435`", ",", "0.48861511019204756`", ",", 
   "0.48288176862012`", ",", "0.4927489752519671`", ",", 
   "0.4521913765082745`", ",", "0.35349862458977466`", ",", 
   "0.4337567748509823`", ",", "0.3947969098251143`", ",", 
   "0.31802765291487445`", ",", "0.46242946802679513`", ",", 
   "0.31561812696653035`", ",", "0.4925242441924399`", ",", 
   "0.49108398730690966`", ",", "0.36690311932798225`", ",", 
   "0.4713174845967036`", ",", "0.3503396007406747`", ",", 
   "0.3441411859089809`", ",", "0.4027010928891011`", ",", 
   "0.35631906310415296`", ",", "0.4341196737297652`", ",", 
   "0.40182754265982623`", ",", "0.3174513148084614`", ",", 
   "0.39086625039418443`", ",", "0.5146313571658192`", ",", 
   "0.4781416986772211`", ",", "0.5027405720699757`", ",", 
   "0.4767854842520706`", ",", "0.40546709454619984`", ",", 
   "0.5161437209561651`", ",", "0.3779320615702177`", ",", 
   "0.43851051662557106`", ",", "0.48165873311969415`", ",", 
   "0.44485019551402094`", ",", "0.4679346678293175`", ",", 
   "0.2922066255770248`", ",", "0.5029289947899535`", ",", 
   "0.3463208811400378`", ",", "0.3029589900006934`", ",", 
   "0.3500494003661473`", ",", "0.3705639189678463`", ",", 
   "0.27964305000866446`", ",", "0.31917812680323254`", ",", 
   "0.3009601540226664`", ",", "0.5007847672177709`", ",", 
   "0.5094315372203038`", ",", "0.37067039766168886`", ",", 
   "0.3991527580745037`", ",", "0.536064708250274`", ",", 
   "0.38795899688500984`", ",", "0.4973071301557764`", ",", 
   "0.4565791508860657`", ",", "0.49097293463648417`", ",", 
   "0.38894409511230854`", ",", "0.3443217830779006`", ",", 
   "0.38057658067697075`", ",", "0.4442500215873206`", ",", 
   "0.4229083421696407`", ",", "0.18526974040563654`", ",", 
   "0.5054199283406541`", ",", "0.3565579377155367`", ",", 
   "0.4233865418335859`", ",", "0.4798005045423124`", ",", 
   "0.5222682062187058`", ",", "0.5138643928750828`", ",", 
   "0.5094196199104848`", ",", "0.2994134809584088`", ",", 
   "0.12711137996670574`", ",", "0.44240406462364124`", ",", 
   "0.4696860878274779`", ",", "0.42882515961660245`", ",", 
   "0.4103609973588511`", ",", "0.50616935745705`", ",", 
   "0.4848561921059608`", ",", "0.304197344795072`", ",", 
   "0.5091306662222165`", ",", "0.3055094785227195`", ",", 
   "0.31972001238162917`", ",", "0.4301316514521304`", ",", 
   "0.47619432030732034`", ",", "0.3730041171834298`", ",", 
   "0.32506121505536245`", ",", "0.4956064257707941`", ",", 
   "0.5193771178799503`", ",", "0.3059430038846478`", ",", 
   "0.47525303230798854`", ",", "0.45722256595942423`", ",", 
   "0.3365585617201664`", ",", "0.3250249444026604`", ",", 
   "0.2961587447293785`", ",", "0.5035289018370741`", ",", 
   "0.3169575327224141`", ",", "0.339359679771813`", ",", 
   "0.40567931812197167`", ",", "0.4316646093683555`", ",", 
   "0.41942733855379766`", ",", "0.43693479300568466`", ",", 
   "0.3701868483217744`", ",", "0.43072583074224197`", ",", 
   "0.5142626517196386`", ",", "0.38990425836175435`", ",", 
   "0.3075610009382386`", ",", "0.4426215746025596`", ",", 
   "0.5180742366146737`", ",", "0.385545224326973`", ",", 
   "0.5189897111101764`", ",", "0.4973238344070209`", ",", 
   "0.48171912396248556`", ",", "0.46098084534586453`", ",", 
   "0.4033904648991583`", ",", "0.4523469565328454`", ",", 
   "0.5048974070126228`", ",", "0.48620341330517847`", ",", 
   "0.48421105357073907`", ",", "0.3220649683074126`", ",", 
   "0.3785568503734344`", ",", "0.3591293496318809`", ",", 
   "0.537246140217831`", ",", "0.5100376385619189`", ",", 
   "0.4740623844857545`", ",", "0.3136035978130647`", ",", 
   "0.5228063868368799`", ",", "0.5318279796597495`", ",", 
   "0.47455671799096283`", ",", "0.44837519200195886`", ",", 
   "0.49575448507119096`", ",", "0.32640270270633465`", ",", 
   "0.537306186670798`", ",", "0.19582134791616007`", ",", 
   "0.2150696050708657`", ",", "0.4398152559848356`", ",", 
   "0.5000336838225004`", ",", "0.40804523602268866`", ",", 
   "0.5052220906746369`", ",", "0.19816376222542936`", ",", 
   "0.44243373633682437`", ",", "0.4745906112959396`", ",", 
   "0.40788635918247595`", ",", "0.3921300050250889`", ",", 
   "0.5146210376704605`", ",", "0.16090174696379`", ",", 
   "0.28713309312371726`", ",", "0.46984324394231947`", ",", 
   "0.46986762683452254`", ",", "0.490517820603784`", ",", 
   "0.5222007241692743`", ",", "0.40802047316271794`", ",", 
   "0.44337330879610504`", ",", "0.3259365558294596`", ",", 
   "0.4431331725008258`", ",", "0.4691047770941231`", ",", 
   "0.23469306554760505`", ",", "0.46914434556734547`", ",", 
   "0.39545131663512956`", ",", "0.429496159911422`", ",", 
   "0.454698799936968`", ",", "0.3921442623897435`", ",", 
   "0.4442624122063472`", ",", "0.4890803379058623`", ",", 
   "0.3634946063220643`", ",", "0.4762036188224007`", ",", 
   "0.36842171863814677`", ",", "0.5179557080264219`", ",", 
   "0.45592889543891624`", ",", "0.5029035593124869`", ",", 
   "0.48549944844668336`", ",", "0.41955078791310446`", ",", 
   "0.4306108438179328`", ",", "0.48484983514744684`", ",", 
   "0.2721123801707882`", ",", "0.4637704911514884`", ",", 
   "0.5077662209902605`", ",", "0.2492308038157709`", ",", 
   "0.4615649670944384`", ",", "0.5214015877682094`", ",", 
   "0.5160746983175459`", ",", "0.5017408377503496`", ",", 
   "0.521887012884471`", ",", "0.32663370497687494`", ",", 
   "0.3354255624148058`", ",", "0.5027290047839252`", ",", 
   "0.5066310439330663`", ",", "0.46808207922945616`", ",", 
   "0.26680967029596775`", ",", "0.4184590512001732`", ",", 
   "0.3754103481917831`", ",", "0.4790609766367818`", ",", 
   "0.35357303204085966`", ",", "0.5149687938544224`", ",", 
   "0.541727629349223`", ",", "0.35583582705975264`", ",", 
   "0.3514370497653331`", ",", "0.4346575870288047`", ",", 
   "0.3231925008476917`", ",", "0.5460610476539124`", ",", 
   "0.5660324511609299`", ",", "0.527694147952431`", ",", 
   "0.41730213982375475`", ",", "0.5281305800956066`", ",", 
   "0.45532168684960933`", ",", "0.5194594338101557`", ",", 
   "0.29761548774657515`", ",", "0.5142803296780651`", ",", 
   "0.5558897339123323`", ",", "0.5541715838115667`", ",", 
   "0.36565042645688434`", ",", "0.37407866415523433`", ",", 
   "0.3046048842150031`", ",", "0.3639152237129871`", ",", 
   "0.5088391982980756`", ",", "0.4908580985214752`", ",", 
   "0.5410086837430955`", ",", "0.3067054453158212`", ",", 
   "0.45747298213236`", ",", "0.40086837949285764`", ",", 
   "0.33036693686697066`", ",", "0.5368664927556063`", ",", 
   "0.45143772887095357`", ",", "0.5189831103026996`", ",", 
   "0.551442644021267`", ",", "0.5137825355397214`", ",", 
   "0.492937656823074`", ",", "0.3006094569816122`", ",", 
   "0.270581729552174`", ",", "0.48650241014584844`", ",", 
   "0.5063252580048583`", ",", "0.4546599159839786`", ",", 
   "0.3938181595063738`", ",", "0.5026224462010189`", ",", 
   "0.45447325886631723`", ",", "0.5460687500629064`", ",", 
   "0.4885829981808226`", ",", "0.3559282892400414`", ",", 
   "0.5552859031472352`", ",", "0.3761586518564342`", ",", 
   "0.5034917029456694`", ",", "0.4464537230303723`", ",", 
   "0.338431997914543`", ",", "0.5511172195257361`", ",", 
   "0.3815083116490914`", ",", "0.5078232043544059`", ",", 
   "0.3952415186506619`", ",", "0.5455976208394312`", ",", 
   "0.565071727058869`", ",", "0.5332601618570894`", ",", 
   "0.5670628568666202`", ",", "0.40971501843978625`", ",", 
   "0.5127457537595237`", ",", "0.5626578585504154`", ",", 
   "0.507405811252403`", ",", "0.48969790579521466`", ",", 
   "0.3631263091793856`", ",", "0.4325063809919019`", ",", 
   "0.46261235815163626`", ",", "0.45276279308272904`", ",", 
   "0.5165487118161758`", ",", "0.251931455819327`", ",", 
   "0.5657463740892138`", ",", "0.5793020842355492`", ",", 
   "0.5060234567749945`", ",", "0.40330040277288826`", ",", 
   "0.4179466112209948`", ",", "0.5184414863738235`", ",", 
   "0.5320924092466056`", ",", "0.4361613321244746`", ",", 
   "0.5683775192799366`", ",", "0.4600223652805655`", ",", 
   "0.5680654455469546`", ",", "0.5562750894681997`", ",", 
   "0.5110088373591639`", ",", "0.5463110323525985`", ",", 
   "0.5800072495575146`", ",", "0.5477770342745741`", ",", 
   "0.491365180672919`", ",", "0.572603312467327`", ",", 
   "0.4792969175119044`", ",", "0.34056332177230103`", ",", 
   "0.575434172519576`", ",", "0.5710308095972414`", ",", 
   "0.5330482181659075`", ",", "0.43182776331175554`", ",", 
   "0.4892276177466114`", ",", "0.5594071879168399`", ",", 
   "0.6001931565519043`", ",", "0.3841039253858894`", ",", 
   "0.4819230318333432`", ",", "0.5529139991718452`", ",", 
   "0.34005735578240465`", ",", "0.5720647948524288`", ",", 
   "0.5632942451637929`", ",", "0.5483339940456693`", ",", 
   "0.3593830632475747`", ",", "0.5431886873057723`", ",", 
   "0.4978373475576764`", ",", "0.585908255657263`", ",", 
   "0.23857572201849625`", ",", "0.41008977848723005`", ",", 
   "0.5366242767828617`", ",", "0.5122960999052331`", ",", 
   "0.5944546251821826`", ",", "0.45635432877500903`", ",", 
   "0.5790640410933678`", ",", "0.5250884340593515`", ",", 
   "0.3104122975868018`", ",", "0.5926801082111041`", ",", 
   "0.43624147416706216`", ",", "0.56438590593019`", ",", 
   "0.5837598490765062`", ",", "0.6084327786859537`", ",", 
   "0.5946754650161457`", ",", "0.2671978458846713`", ",", 
   "0.4844826304342119`", ",", "0.4133705076498604`", ",", 
   "0.20985323254393018`", ",", "0.5722372332605682`", ",", 
   "0.615942224185734`", ",", "0.3765123851109008`", ",", 
   "0.4434001164501503`", ",", "0.4043463063411452`", ",", 
   "0.5209976080892514`", ",", "0.5773719980952272`", ",", 
   "0.5710805350795961`", ",", "0.6045147850904024`", ",", 
   "0.4041972327725917`", ",", "0.3410203276840297`", ",", 
   "0.5301630056281706`", ",", "0.3949713133614209`", ",", 
   "0.5295210388352606`", ",", "0.5365652353251655`", ",", 
   "0.5949480160698077`", ",", "0.275287484715993`", ",", 
   "0.5244277256127186`", ",", "0.5164300970161811`", ",", 
   "0.4378076702509967`", ",", "0.43658482183481473`", ",", 
   "0.4260710269835968`", ",", "0.5131353886066607`", ",", 
   "0.5199949967656532`", ",", "0.447576957162228`", ",", 
   "0.5034458195081903`", ",", "0.5866490453568332`", ",", 
   "0.48527022228923977`", ",", "0.5524014328486955`", ",", 
   "0.484180126375799`", ",", "0.462963373632685`", ",", 
   "0.4873885177316739`", ",", "0.49205176691281505`", ",", 
   "0.48932253825342503`", ",", "0.4701956510380061`", ",", 
   "0.5514409568169637`", ",", "0.6055839500055117`", ",", 
   "0.4273550660185673`", ",", "0.5187645574565771`", ",", 
   "0.29911074266467086`", ",", "0.6082339117928849`", ",", 
   "0.6283069794002074`", ",", "0.6301736078356198`", ",", 
   "0.510641657594985`", ",", "0.612009450771544`", ",", 
   "0.5132828094312845`", ",", "0.5697978195583463`", ",", 
   "0.5476792812368743`", ",", "0.6368454550799831`", ",", 
   "0.5762009355180024`", ",", "0.5694315253718942`", ",", 
   "0.5297876903027915`", ",", "0.5876125487009453`", ",", 
   "0.6146911921612364`", ",", "0.583308702982436`", ",", 
   "0.594048123334179`", ",", "0.5061826272949229`", ",", 
   "0.5487201716795364`", ",", "0.5964276904689344`", ",", 
   "0.5476325105553432`", ",", "0.644397372975061`", ",", 
   "0.2708844088634912`", ",", "0.5702687799443773`", ",", 
   "0.5428108775496291`", ",", "0.5714477140368378`", ",", 
   "0.5702385653644269`", ",", "0.5172585352091086`", ",", 
   "0.5290895272547557`", ",", "0.5290631291979991`", ",", 
   "0.6543685952347507`", ",", "0.587167089869137`", ",", 
   "0.5710024923297236`", ",", "0.49592253047405194`", ",", 
   "0.5326023647532813`", ",", "0.6310922467719572`", ",", 
   "0.5902344058389607`", ",", "0.6425879328932206`", ",", 
   "0.6737422765507514`", ",", "0.5305502592403097`", ",", 
   "0.44348770120890324`", ",", "0.5553876034051763`", ",", 
   "0.6752385279265871`"}], "}"}]], "Output",
 CellChangeTimes->{3.8855755892230577`*^9, 3.894049943863714*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"1d0a0a16-de69-4899-a88f-52881ffcb41a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "diststoloosebounds", "]"}]], "Input",
 CellChangeTimes->{{3.885575630970728*^9, 3.885575672193831*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"63a6f114-ce42-4dc1-af7b-04e86949537f"],

Cell[BoxData["0.39961828231620006`"], "Output",
 CellChangeTimes->{{3.8855756382977877`*^9, 3.885575672699491*^9}, 
   3.8855758248142767`*^9, 3.89404994389922*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"b5624b24-a371-4774-ba5f-eeaa13937f81"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "diststoloosebounds", "]"}]], "Input",
 CellChangeTimes->{{3.8855756810628567`*^9, 3.885575685736298*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"f494e38a-148b-46d1-8203-083a0f423654"],

Cell[BoxData["0.09904203601277987`"], "Output",
 CellChangeTimes->{3.885575686182197*^9, 3.885575825573269*^9, 
  3.8940499439081993`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"3cbbaa11-90e3-4e6f-ac5b-7f822d12a6d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quartiles", "[", "diststoloosebounds", "]"}]], "Input",
 CellChangeTimes->{{3.885575692195689*^9, 3.885575695626602*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"2ecf04d0-f7ba-4e2a-affa-000ff89c0e8a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3323829802957424`", ",", "0.3949713133614209`", ",", 
   "0.46904579426782067`"}], "}"}]], "Output",
 CellChangeTimes->{3.885575695985567*^9, 3.8855758306962233`*^9, 
  3.8940499439323673`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"f335c1c2-f8c5-4934-a604-6e487114d157"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diststotightbounds", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"data", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"data", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "5", "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884523801055538*^9, 3.884523884877635*^9}, {
  3.885287661693625*^9, 3.885287690437481*^9}, {3.885554215753244*^9, 
  3.8855542159193373`*^9}, {3.885575531462968*^9, 3.885575531881555*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"ef48ff56-6fd0-432a-a74a-e4f71fcb8d13"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0069686196464967265`", ",", "0.027932684052328426`", ",", 
   "0.01605615433850158`", ",", "0.02514332256274711`", ",", 
   "0.01819305316508324`", ",", "0.01746942098399268`", ",", 
   "0.018644287956586618`", ",", "0.013637980100434662`", ",", 
   "0.017125295470637708`", ",", "0.006656694160405388`", ",", 
   "0.030246405515474646`", ",", "0.02232010449217932`", ",", 
   "0.0374506397080928`", ",", "0.04189329293159046`", ",", 
   "0.012820349017994326`", ",", "0.023988092641322456`", ",", 
   "0.0102497413481643`", ",", "0.0144405458373492`", ",", 
   "0.03248257692984867`", ",", "0.02908438903617029`", ",", 
   "0.027655541602443073`", ",", "0.010013123907967252`", ",", 
   "0.046997263265448466`", ",", "0.006781426112821988`", ",", 
   "0.006664948001535203`", ",", "0.00639694700399962`", ",", 
   "0.003717740432797316`", ",", "0.01607425971018718`", ",", 
   "0.04391588160579645`", ",", "0.0409889870564135`", ",", 
   "0.015121627887812308`", ",", "0.018723232648572147`", ",", 
   "0.0034565517812094465`", ",", "0.026169634867414013`", ",", 
   "0.019994300161927464`", ",", "0.042230103592018474`", ",", 
   "0.00828753394037779`", ",", "0.016512421016524143`", ",", 
   "0.010248903556109575`", ",", "0.014857349052356736`", ",", 
   "0.04411716621034694`", ",", "0.02900381675625726`", ",", 
   "0.038206786488270916`", ",", "0.023914710549375294`", ",", 
   "0.03277640070974232`", ",", "0.013590808791764823`", ",", 
   "0.006181847582650737`", ",", "0.0351689212699445`", ",", 
   "0.052831273344021865`", ",", "0.04254751946268377`", ",", 
   "0.0456600756391055`", ",", "0.032233157599757326`", ",", 
   "0.02316390802154364`", ",", "0.016225859103358622`", ",", 
   "0.019361982513143437`", ",", "0.0340054741044616`", ",", 
   "0.0347261910902817`", ",", "0.018975550517133025`", ",", 
   "0.006178555316633694`", ",", "0.025784186948427948`", ",", 
   "0.015449072817510769`", ",", "0.022308350800977844`", ",", 
   "0.030711846954240715`", ",", "0.008237606353270976`", ",", 
   "0.05324278251827925`", ",", "0.016044400017374616`", ",", 
   "0.006554088332804159`", ",", "0.01606711198445932`", ",", 
   "0.007121407334782233`", ",", "0.024128343466159913`", ",", 
   "0.04824902248925893`", ",", "0.06201042176486403`", ",", 
   "0.01499484219595433`", ",", "0.05775436870663024`", ",", 
   "0.029187693756496276`", ",", "0.021570482018174426`", ",", 
   "0.024694695083039626`", ",", "0.04562208122004898`", ",", 
   "0.03134275703633692`", ",", "0.03200295446183463`", ",", 
   "0.04967693221590552`", ",", "0.05666750511341359`", ",", 
   "0.022098405917059798`", ",", "0.017721581620556738`", ",", 
   "0.05178696023098005`", ",", "0.0291201585624105`", ",", 
   "0.0062276525787299305`", ",", "0.015233834084688341`", ",", 
   "0.006212692411074042`", ",", "0.04368117404472442`", ",", 
   "0.049886424553345646`", ",", "0.07005661551240136`", ",", 
   "0.03249662656542751`", ",", "0.01788626661417419`", ",", 
   "0.0168394232538638`", ",", "0.042369628446323485`", ",", 
   "0.02377926595317121`", ",", "0.009246414672474834`", ",", 
   "0.01890799234029849`", ",", "0.024639603513694347`", ",", 
   "0.0429180071766011`", ",", "0.020009953116818635`", ",", 
   "0.028040614572419145`", ",", "0.027722256777518085`", ",", 
   "0.007130879239230184`", ",", "0.03518557279078575`", ",", 
   "0.057571480892244224`", ",", "0.016918778972360035`", ",", 
   "0.0015589868259629214`", ",", "0.01841505018409023`", ",", 
   "0.021133204679866707`", ",", "0.038315970976968004`", ",", 
   "0.021152908464345727`", ",", "0.05638111033691948`", ",", 
   "0.0029410310910590112`", ",", "0.003187557498085535`", ",", 
   "0.009135791047281058`", ",", "0.03287337290504461`", ",", 
   "0.011392478192280363`", ",", "0.017721804122462315`", ",", 
   "0.022067072266073087`", ",", "0.029463515402632513`", ",", 
   "0.022254490591217757`", ",", "0.050042497236294156`", ",", 
   "0.0059901564280990666`", ",", "0.028718967270202525`", ",", 
   "0.03704188610887294`", ",", "0.04635701700156116`", ",", 
   "0.04107694908086651`", ",", "0.029497733258472457`", ",", 
   "0.02201198707646047`", ",", "0.026105065145773126`", ",", 
   "0.0071340914217442875`", ",", "0.02361189237256959`", ",", 
   "0.01719643776098005`", ",", "0.006818714970225806`", ",", 
   "0.03982278149441014`", ",", "0.040171699200117095`", ",", 
   "0.01428800047022536`", ",", "0.023559904573879117`", ",", 
   "0.02890305596695786`", ",", "0.027508949063904505`", ",", 
   "0.03780661183259422`", ",", "0.06623240926060375`", ",", 
   "0.05649873793941142`", ",", "0.06424463998588409`", ",", 
   "0.013590177862405566`", ",", "0.05796765337510841`", ",", 
   "0.00674135132109259`", ",", "0.030435477731966337`", ",", 
   "0.009407121670784762`", ",", "0.0304572928667002`", ",", 
   "0.05322010442296109`", ",", "0.009878468113530846`", ",", 
   "0.07466644743903784`", ",", "0.012987556710664011`", ",", 
   "0.012310455121258536`", ",", "0.024632506640264458`", ",", 
   "0.02811750564420208`", ",", "0.024587814735873195`", ",", 
   "0.03505025740995187`", ",", "0.0053837575345954125`", ",", 
   "0.005081576087511457`", ",", "0.024500846795673922`", ",", 
   "0.035196848198104654`", ",", "0.026236008502072278`", ",", 
   "0.01013208790413491`", ",", "0.008899321288080398`", ",", 
   "0.03861946019092957`", ",", "0.010812324296404607`", ",", 
   "0.012916836510856483`", ",", "0.023892831855790313`", ",", 
   "0.017791933781007865`", ",", "0.032810389410618326`", ",", 
   "0.018868889824607535`", ",", "0.02395568080744097`", ",", 
   "0.023759561439568422`", ",", "0.03212005773495661`", ",", 
   "0.008054628484115083`", ",", "0.026198306895858083`", ",", 
   "0.009063482248460028`", ",", "0.019249091933361898`", ",", 
   "0.035642827967378055`", ",", "0.015958566693600885`", ",", 
   "0.031076773044531533`", ",", "0.03996617477528441`", ",", 
   "0.04553657958360856`", ",", "0.02845556956187384`", ",", 
   "0.07114904295180198`", ",", "0.037961558061310754`", ",", 
   "0.022438403103354848`", ",", "0.047060618847827904`", ",", 
   "0.008089482275283846`", ",", "0.03659630227912474`", ",", 
   "0.02091541407818215`", ",", "0.09030081279870716`", ",", 
   "0.044754183394065825`", ",", "0.03419589739230632`", ",", 
   "0.03101503328823639`", ",", "0.06259153710380516`", ",", 
   "0.019166681613206893`", ",", "0.04599180329422567`", ",", 
   "0.01731140322978876`", ",", "0.0674715380661243`", ",", 
   "0.03392319985115594`", ",", "0.020396508519899874`", ",", 
   "0.015871619346802923`", ",", "0.019452768722576`", ",", 
   "0.037460587630351205`", ",", "0.04732130422605343`", ",", 
   "0.01392000243020438`", ",", "0.025260114723348825`", ",", 
   "0.005121099026659297`", ",", "0.045917364782383514`", ",", 
   "0.031809105093917656`", ",", "0.02369682995436602`", ",", 
   "0.033424948159576515`", ",", "0.013285272176915237`", ",", 
   "0.018739686503201812`", ",", "0.044824852295008336`", ",", 
   "0.02145754083135548`", ",", "0.03796345620874689`", ",", 
   "0.011999577345905635`", ",", "0.005630123328437153`", ",", 
   "0.008774465869470276`", ",", "0.021225976304592824`", ",", 
   "0.04204292466611809`", ",", "0.048914369424860674`", ",", 
   "0.04123739405043959`", ",", "0.01517231162421609`", ",", 
   "0.03898074059660816`", ",", "0.052484292468944094`", ",", 
   "0.007019511815349613`", ",", "0.04399924262350163`", ",", 
   "0.023649621443679717`", ",", "0.010968654743328365`", ",", 
   "0.03303420464583029`", ",", "0.0114449045549221`", ",", 
   "0.08657852441909983`", ",", "0.0605428877023841`", ",", 
   "0.07599374926964082`", ",", "0.04436025022097707`", ",", 
   "0.011884760023250396`", ",", "0.03255692438638505`", ",", 
   "0.06597117105093284`", ",", "0.06333830117793504`", ",", 
   "0.020080399411720885`", ",", "0.03112023832707364`", ",", 
   "0.035630499034958726`", ",", "0.022763648417079715`", ",", 
   "0.04167545860441471`", ",", "0.03199980033124232`", ",", 
   "0.013404240057114165`", ",", "0.042978692886810194`", ",", 
   "0.03359537502358851`", ",", "0.02154051823078604`", ",", 
   "0.03542186355571916`", ",", "0.03405564831040414`", ",", 
   "0.022913958196633263`", ",", "0.07193198206668444`", ",", 
   "0.03275710343447563`", ",", "0.05617077341192722`", ",", 
   "0.03604124964075228`", ",", "0.06835115852155166`", ",", 
   "0.01121394244615126`", ",", "0.01674687171630497`", ",", 
   "0.07103194482729178`", ",", "0.028144154292096657`", ",", 
   "0.034481736181430134`", ",", "0.03268585681581101`", ",", 
   "0.052754345337854947`", ",", "0.02869284090664198`", ",", 
   "0.05642230486636971`", ",", "0.04075400255697895`", ",", 
   "0.03202069362351748`", ",", "0.01437961197746596`", ",", 
   "0.03421184725241823`", ",", "0.07656509936350378`", ",", 
   "0.02250014746648299`", ",", "0.022877415745507928`", ",", 
   "0.04857164755663945`", ",", "0.041366665694150415`", ",", 
   "0.007352179603566288`", ",", "0.004621960068949139`", ",", 
   "0.005027327284833211`", ",", "0.06243384545262188`", ",", 
   "0.023355718291260708`", ",", "0.0386864587586668`", ",", 
   "0.0858948994674463`", ",", "0.019862339482777762`", ",", 
   "0.0422425662617526`", ",", "0.03063979161729194`", ",", 
   "0.07495621342481978`", ",", "0.031771641182453916`", ",", 
   "0.02027677929527283`", ",", "0.11782078807824214`", ",", 
   "0.043762170218138816`", ",", "0.016356174499457372`", ",", 
   "0.05629715891251438`", ",", "0.03423752197256598`", ",", 
   "0.026466238848916496`", ",", "0.006311128942169758`", ",", 
   "0.0678147426546494`", ",", "0.019490358206056897`", ",", 
   "0.024309356850465154`", ",", "0.04752364689967348`", ",", 
   "0.0771654968885955`", ",", "0.03050706931405097`", ",", 
   "0.024099690127710183`", ",", "0.029814148749276376`", ",", 
   "0.0535456986263458`", ",", "0.050828500828236325`", ",", 
   "0.07540770632451918`", ",", "0.09469089423918386`", ",", 
   "0.012912442701016533`", ",", "0.037522183566810155`", ",", 
   "0.04721774082729492`", ",", "0.05086794582376078`", ",", 
   "0.03576093811390135`", ",", "0.09396157561754798`", ",", 
   "0.03762756514301578`", ",", "0.04020733386881917`", ",", 
   "0.049477407008088614`", ",", "0.021084979406801346`", ",", 
   "0.06824785223118063`", ",", "0.00830644606040748`", ",", 
   "0.04431292945636178`", ",", "0.00819625056352924`", ",", 
   "0.03493726922395271`", ",", "0.023111672573631108`", ",", 
   "0.05698682800788209`", ",", "0.051996041961062986`", ",", 
   "0.011293132712169321`", ",", "0.017020390279408364`", ",", 
   "0.028907512242487977`", ",", "0.037611738565084374`", ",", 
   "0.01088716716593114`", ",", "0.0017962132503070924`", ",", 
   "0.04133684848350906`", ",", "0.011081571208634435`", ",", 
   "0.05965289038324849`", ",", "0.06327800956892456`", ",", 
   "0.05226871620182007`", ",", "0.02416592305627272`", ",", 
   "0.06569520039207168`", ",", "0.07660694332234103`", ",", 
   "0.022278226422433746`", ",", "0.02408768616916128`", ",", 
   "0.05618660097350159`", ",", "0.019238306933773187`", ",", 
   "0.01583809783802261`", ",", "0.02605618550873929`", ",", 
   "0.015004219511604092`", ",", "0.043888785729049556`", ",", 
   "0.04876343103322391`", ",", "0.01166550466605449`", ",", 
   "0.023970578271616562`", ",", "0.007208648357348711`", ",", 
   "0.030234948334425693`", ",", "0.034722256117396766`", ",", 
   "0.015150746078518094`", ",", "0.04057053159191494`", ",", 
   "0.07256360753262622`", ",", "0.10643126925197073`", ",", 
   "0.0863260956968061`", ",", "0.0745464923638588`", ",", 
   "0.01417071799029948`", ",", "0.018562182569382912`", ",", 
   "0.07512069773047655`", ",", "0.0686386482606195`", ",", 
   "0.04692560789379745`", ",", "0.03754152841852476`", ",", 
   "0.048506259807844565`", ",", "0.08549577944436307`", ",", 
   "0.0767577258826379`", ",", "0.22219789486773872`", ",", 
   "0.03879646657418939`", ",", "0.00805821218378576`", ",", 
   "0.05214957649855092`", ",", "0.02637121747452083`", ",", 
   "0.03860773651624191`", ",", "0.05211500376634756`", ",", 
   "0.06303841269474303`", ",", "0.048491183987781496`", ",", 
   "0.032288379720247985`", ",", "0.07903540904395787`", ",", 
   "0.0029103603033299036`", ",", "0.005872517105733097`", ",", 
   "0.12483593204431125`", ",", "0.07998659984734624`", ",", 
   "0.019754219852938112`", ",", "0.047861471971448466`", ",", 
   "0.048530793058757016`", ",", "0.06145344627084451`", ",", 
   "0.10114948881290656`", ",", "0.04563611276221549`", ",", 
   "0.02576538262869165`", ",", "0.022989453383811878`", ",", 
   "0.03952735359099807`", ",", "0.1552882877886942`", ",", 
   "0.061047941207605094`", ",", "0.02938312722731222`", ",", 
   "0.03750342854533245`", ",", "0.08826365958461557`", ",", 
   "0.05379463405055669`", ",", "0.04521365609408133`", ",", 
   "0.06010517310089558`", ",", "0.013773845568537347`", ",", 
   "0.09088942515765144`", ",", "0.03971622334251983`", ",", 
   "0.048372348772252965`", ",", "0.11218557592491861`", ",", 
   "0.039613223363152705`", ",", "0.036066832709865146`", ",", 
   "0.038640001073903724`", ",", "0.03597206395343666`", ",", 
   "0.023560447768180504`", ",", "0.01414384066292848`", ",", 
   "0.040556921054599446`", ",", "0.045546502876068096`", ",", 
   "0.0056623778532107205`", ",", "0.11809031506168344`", ",", 
   "0.05266812476420317`", ",", "0.19800997812671683`", ",", 
   "0.0203859615250332`", ",", "0.010198620680182437`", ",", 
   "0.029852877804932537`", ",", "0.0024430691906772092`", ",", 
   "0.025568999662428336`", ",", "0.10543770774317834`", ",", 
   "0.044063583079355706`", ",", "0.057381592092264434`", ",", 
   "0.06892092025592772`", ",", "0.06693395045379152`", ",", 
   "0.008014281072212096`", ",", "0.01848031611047206`", ",", 
   "0.10171512642204648`", ",", "0.03400759220506455`", ",", 
   "0.1552121214888078`", ",", "0.04843779354687429`", ",", 
   "0.012397081882765004`", ",", "0.06714049678814801`", ",", 
   "0.06972157713610244`", ",", "0.05390654998235779`", ",", 
   "0.03996577638939758`", ",", "0.02520927828688855`", ",", 
   "0.04773809099755574`", ",", "0.0320623219125698`", ",", 
   "0.05393856266426608`", ",", "0.13501542204532996`", ",", 
   "0.06825219459390192`", ",", "0.049178564763487934`", ",", 
   "0.03588113852364552`", ",", "0.04253070981046683`", ",", 
   "0.023918882820842258`", ",", "0.0197062114735543`", ",", 
   "0.04785203610180808`", ",", "0.030485268763120455`", ",", 
   "0.05591320121079944`", ",", "0.0711401237087139`", ",", 
   "0.03172742638212671`", ",", "0.018913085468032036`", ",", 
   "0.02284605292428038`", ",", "0.045429695612485964`", ",", 
   "0.11200077072451325`", ",", "0.10141873573005986`", ",", 
   "0.08291880724676241`", ",", "0.024484620043369244`", ",", 
   "0.10368348253594922`", ",", "0.0781286065232216`", ",", 
   "0.08762327288024767`", ",", "0.06796335663339365`", ",", 
   "0.06349255602874204`", ",", "0.11189275065226978`", ",", 
   "0.09002643398817586`", ",", "0.056689991872793444`", ",", 
   "0.029839450644904092`", ",", "0.06612909116245257`", ",", 
   "0.012362586143133372`", ",", "0.02648919744993941`", ",", 
   "0.06285252573591292`", ",", "0.01226551553027877`", ",", 
   "0.04745339766834212`", ",", "0.018652467704905806`", ",", 
   "0.05036626926506099`", ",", "0.11025204682717278`", ",", 
   "0.03166963149187797`", ",", "0.08253646875050388`", ",", 
   "0.05034154491912793`", ",", "0.08268328766558454`", ",", 
   "0.03885147845313927`", ",", "0.032437913288247175`", ",", 
   "0.02565123908945018`", ",", "0.18377072240863646`", ",", 
   "0.06618116993648265`", ",", "0.022942522001255565`", ",", 
   "0.02892990095424958`", ",", "0.03945901406958097`", ",", 
   "0.1154788004673131`", ",", "0.023553017058781517`", ",", 
   "0.07985832976356567`", ",", "0.14544969270763536`", ",", 
   "0.049421068556436576`", ",", "0.034396427069531395`", ",", 
   "0.03273350848236817`", ",", "0.04524110987003227`", ",", 
   "0.08528586572651423`", ",", "0.03089834615001725`", ",", 
   "0.04814205097087496`", ",", "0.06352065877472132`", ",", 
   "0.07337780093658236`", ",", "0.08289790565367668`", ",", 
   "0.10177058920917534`", ",", "0.07701036973589784`", ",", 
   "0.07808831884864004`", ",", "0.15380946505830034`", ",", 
   "0.06578963865262172`", ",", "0.0427525325696084`", ",", 
   "0.05477494843043232`", ",", "0.11618265650615965`", ",", 
   "0.01480762084471255`", ",", "0.041401465371578364`", ",", 
   "0.05051852124354471`", ",", "0.06003465827685507`", ",", 
   "0.06931894483002307`", ",", "0.08864409532549265`", ",", 
   "0.06097667511022355`", ",", "0.0430001021701583`", ",", 
   "0.011648451459176312`", ",", "0.05769847588132647`", ",", 
   "0.0287646282286505`", ",", "0.0280752142831045`", ",", 
   "0.1415949161200997`", ",", "0.08287729077143763`", ",", 
   "0.008339406416588119`", ",", "0.017637766718898884`", ",", 
   "0.043736450033919946`", ",", "0.02317813163488852`", ",", 
   "0.041409104452330314`", ",", "0.09788217735485065`", ",", 
   "0.12738557201711864`", ",", "0.06611456539420138`", ",", 
   "0.047995028370100945`", ",", "0.033566130807265775`", ",", 
   "0.07874025109022625`", ",", "0.03713670702378498`", ",", 
   "0.1751299696749779`", ",", "0.07812792008878633`", ",", 
   "0.08847945865675427`", ",", "0.06425892982389982`", ",", 
   "0.15874837338794986`", ",", "0.12650757854753455`", ",", 
   "0.04291930710221156`", ",", "0.06452011279314718`", ",", 
   "0.12599363867590252`", ",", "0.03571742651940408`", ",", 
   "0.016508871115066236`", ",", "0.07581950669689275`", ",", 
   "0.048165214175148144`", ",", "0.029804553801777565`", ",", 
   "0.03957957456075069`", ",", "0.14055612177228438`", ",", 
   "0.003923641889721496`", ",", "0.05347505820567253`", ",", 
   "0.18566447585143062`", ",", "0.06584074326972936`", ",", 
   "0.023400374932172507`", ",", "0.016671055646784703`", ",", 
   "0.06909807893436415`", ",", "0.054604838823511026`", ",", 
   "0.023586508470765134`", ",", "0.0871505467534188`", ",", 
   "0.24240378015152408`", ",", "0.04112846323939094`", ",", 
   "0.09068602440946028`", ",", "0.04788228476188268`", ",", 
   "0.08722747342923251`", ",", "0.08489367197297931`", ",", 
   "0.06648844858632488`", ",", "0.03343486141121122`", ",", 
   "0.06805626358035986`", ",", "0.009868705851254721`", ",", 
   "0.06961081154036469`", ",", "0.04713081611794166`", ",", 
   "0.04741551206544531`", ",", "0.07840169069676461`", ",", 
   "0.06857397074710124`", ",", "0.07947221155726672`", ",", 
   "0.023806824700104798`", ",", "0.05200980007552361`", ",", 
   "0.13950585673894553`", ",", "0.05059147687013474`", ",", 
   "0.0763153546293591`", ",", "0.20357270168538275`", ",", 
   "0.08230901193664206`", ",", "0.04458922026715115`", ",", 
   "0.11555177704832437`", ",", "0.13187785476581507`", ",", 
   "0.11087653973769379`", ",", "0.037563373340818274`", ",", 
   "0.05202460557802346`", ",", "0.05924481917601995`", ",", 
   "0.15899546141180967`", ",", "0.021394974264837514`", ",", 
   "0.1126310159581338`", ",", "0.07849249096642655`", ",", 
   "0.021972783634411366`", ",", "0.022938509180978325`", ",", 
   "0.08040853088544395`", ",", "0.15350506174239678`", ",", 
   "0.039946797103034115`", ",", "0.03718261425941849`", ",", 
   "0.023648860652464562`", ",", "0.164061063087587`", ",", 
   "0.04653353772343304`", ",", "0.07783376662326671`", ",", 
   "0.12242384459722942`", ",", "0.06023603792990835`", ",", 
   "0.07843583759236818`", ",", "0.059513224493271163`", ",", 
   "0.050361640020477674`", ",", "0.05725929440857189`", ",", 
   "0.12711137996670574`", ",", "0.0677974762276461`", ",", 
   "0.05394302101117665`", ",", "0.043781381776545045`", ",", 
   "0.16335642244586177`", ",", "0.04131205617470294`", ",", 
   "0.03937537760255386`", ",", "0.0816641265930039`", ",", 
   "0.05668738130053561`", ",", "0.14168771833359256`", ",", 
   "0.05259774338721604`", ",", "0.08893178622670221`", ",", 
   "0.01660734818271814`", ",", "0.040141789306853776`", ",", 
   "0.13725466802058728`", ",", "0.05499230361286772`", ",", 
   "0.09962236128585099`", ",", "0.16921215880918825`", ",", 
   "0.12122287661219752`", ",", "0.051878903919648334`", ",", 
   "0.1443357112420506`", ",", "0.10225507155082461`", ",", 
   "0.09902702076314912`", ",", "0.05588702508847591`", ",", 
   "0.11608587148923874`", ",", "0.06664427399830117`", ",", 
   "0.048815002827562765`", ",", "0.10481583484371525`", ",", 
   "0.039350044268122636`", ",", "0.046574092035577136`", ",", 
   "0.13153974011438405`", ",", "0.21148470946565495`", ",", 
   "0.06130874844600579`", ",", "0.08269598184302798`", ",", 
   "0.14268848935915784`", ",", "0.12325813670915312`", ",", 
   "0.024800181470702343`", ",", "0.1937295657385744`", ",", 
   "0.004074655542957009`", ",", "0.0646517919375596`", ",", 
   "0.0624553619450775`", ",", "0.09259186757032298`", ",", 
   "0.1889736051300551`", ",", "0.08958583729264602`", ",", 
   "0.022565677138076716`", ",", "0.09550183214911659`", ",", 
   "0.08125897211294716`", ",", "0.11086572341712805`", ",", 
   "0.052798855113097065`", ",", "0.15147156577924337`", ",", 
   "0.05192640272718746`", ",", "0.025877835872670424`", ",", 
   "0.11233511229961998`", ",", "0.10721713556311757`", ",", 
   "0.0797073409117552`", ",", "0.024051249391336682`", ",", 
   "0.14568380349686696`", ",", "0.07953801359770385`", ",", 
   "0.07326854867256535`", ",", "0.1247428605387089`", ",", 
   "0.01425005626438279`", ",", "0.19582134791616007`", ",", 
   "0.1776547188067341`", ",", "0.06147398406570584`", ",", 
   "0.07038731552914157`", ",", "0.10902659202477438`", ",", 
   "0.03911661028866529`", ",", "0.09754715068435277`", ",", 
   "0.09792201153217914`", ",", "0.008154492567149813`", ",", 
   "0.017122312724871275`", ",", "0.17829550014691634`", ",", 
   "0.07385270630911914`", ",", "0.16090174696379`", ",", 
   "0.10386489740370913`", ",", "0.04795378240054454`", ",", 
   "0.03361091830505558`", ",", "0.02023260204619888`", ",", 
   "0.005390831989161335`", ",", "0.07059916688806739`", ",", 
   "0.045184193733361466`", ",", "0.12766740505595436`", ",", 
   "0.0729910086571612`", ",", "0.0965505050739109`", ",", 
   "0.07543417669099195`", ",", "0.11268123104515117`", ",", 
   "0.1194236896425406`", ",", "0.04476404444678253`", ",", 
   "0.06934326129942295`", ",", "0.16220267252285114`", ",", 
   "0.07007137909030987`", ",", "0.08228022923051101`", ",", 
   "0.1690158723156679`", ",", "0.09209414243449349`", ",", 
   "0.13670091434259238`", ",", "0.07794062799769197`", ",", 
   "0.05912238216311062`", ",", "0.08592457444629217`", ",", 
   "0.02938464203818328`", ",", "0.11042722288816659`", ",", 
   "0.1244072034132481`", ",", "0.016403239203773734`", ",", 
   "0.10060994353320363`", ",", "0.10426004337984836`", ",", 
   "0.08255909496073141`", ",", "0.2492308038157709`", ",", 
   "0.20010562303706417`", ",", "0.09480919018658318`", ",", 
   "0.10687317279993674`", ",", "0.028786174134860648`", ",", 
   "0.030305663868900712`", ",", "0.11394368734035193`", ",", 
   "0.0674858029445613`", ",", "0.10248174813746758`", ",", 
   "0.08588494969601101`", ",", "0.18504641370689656`", ",", 
   "0.1362593193977485`", ",", "0.08847208182367541`", ",", 
   "0.02579922947974364`", ",", "0.17940469276915988`", ",", 
   "0.2582582371993606`", ",", "0.08149286559416413`", ",", 
   "0.07773685082379556`", ",", "0.055677253204256816`", ",", 
   "0.042046636125475684`", ",", "0.10679001495625531`", ",", 
   "0.0773383454815883`", ",", "0.03053451567978698`", ",", 
   "0.09107342921876566`", ",", "0.059194144664598936`", ",", 
   "0.11275793352961064`", ",", "0.08084699937972531`", ",", 
   "0.1756506475982359`", ",", "0.06877697490155434`", ",", 
   "0.10973712229220478`", ",", "0.07804316355442084`", ",", 
   "0.011728076921702284`", ",", "0.03702629777063535`", ",", 
   "0.1482199554932293`", ",", "0.12126290908608323`", ",", 
   "0.17044320343482294`", ",", "0.148656283561332`", ",", 
   "0.14831338624228266`", ",", "0.10554080005053526`", ",", 
   "0.14861096668885573`", ",", "0.19125931758604148`", ",", 
   "0.16075228073244266`", ",", "0.08974709972103984`", ",", 
   "0.14590751740615038`", ",", "0.03934580038325377`", ",", 
   "0.1335199086384182`", ",", "0.02731279088728729`", ",", 
   "0.05008543374643865`", ",", "0.030338804128795305`", ",", 
   "0.08163375899915705`", ",", "0.3006094569816122`", ",", 
   "0.270581729552174`", ",", "0.03466165824141994`", ",", 
   "0.05184059141307615`", ",", "0.2971578315710208`", ",", 
   "0.07344698291259935`", ",", "0.12538853450071685`", ",", 
   "0.13430423237439054`", ",", "0.0725772820360952`", ",", 
   "0.04579946284262083`", ",", "0.2618228052423712`", ",", 
   "0.0557639563794118`", ",", "0.12743715957358281`", ",", 
   "0.063988643442734`", ",", "0.027041682417190793`", ",", 
   "0.14230743875044183`", ",", "0.09729542605473271`", ",", 
   "0.2595293790268318`", ",", "0.06956407106380574`", ",", 
   "0.03870650916909768`", ",", "0.02010188432843093`", ",", 
   "0.07921051411739793`", ",", "0.11559004823487325`", ",", 
   "0.18379710022517132`", ",", "0.13924788310238168`", ",", 
   "0.020972848424768917`", ",", "0.033534120947703354`", ",", 
   "0.08076709402050268`", ",", "0.02920034628758815`", ",", 
   "0.18756075868563513`", ",", "0.12271014653633067`", ",", 
   "0.25758398423494044`", ",", "0.04021733531286939`", ",", 
   "0.030173080040611047`", ",", "0.251931455819327`", ",", 
   "0.03618441708588301`", ",", "0.030904735584785063`", ",", 
   "0.056632115561703514`", ",", "0.2581703044681922`", ",", 
   "0.09854075058256861`", ",", "0.07075151908330062`", ",", 
   "0.05480682828483743`", ",", "0.052519572631697375`", ",", 
   "0.040519135799975896`", ",", "0.1531941661933853`", ",", 
   "0.012300084488022271`", ",", "0.04122479049306773`", ",", 
   "0.1439321200889846`", ",", "0.13056948138401198`", ",", 
   "0.07262871723207288`", ",", "0.20016953901097176`", ",", 
   "0.2154619489851869`", ",", "0.09451738993219141`", ",", 
   "0.08376232623877317`", ",", "0.07230595357017583`", ",", 
   "0.0542749924477201`", ",", "0.053831725056479596`", ",", 
   "0.050838783488597994`", ",", "0.04495006210597646`", ",", 
   "0.13140350951555105`", ",", "0.06935097606118887`", ",", 
   "0.0264103242585666`", ",", "0.18666171642656654`", ",", 
   "0.1546169774813676`", ",", "0.04109544163159873`", ",", 
   "0.26158682598831556`", ",", "0.06539612909957265`", ",", 
   "0.025624165355085583`", ",", "0.03590805127986732`", ",", 
   "0.08718999451093512`", ",", "0.0630986188878855`", ",", 
   "0.1520211361620975`", ",", "0.05236763177751266`", ",", 
   "0.23857572201849625`", ",", "0.12712933291063575`", ",", 
   "0.09614718816939129`", ",", "0.08240107443548926`", ",", 
   "0.12184682971148077`", ",", "0.13258601686857688`", ",", 
   "0.05989164738603546`", ",", "0.047962218448859034`", ",", 
   "0.17275170360947906`", ",", "0.032741235689459774`", ",", 
   "0.2066309859536236`", ",", "0.10521793180798937`", ",", 
   "0.0873595053329291`", ",", "0.04123045238969959`", ",", 
   "0.1646293379815074`", ",", "0.2622698223176625`", ",", 
   "0.03899981361464916`", ",", "0.2162111835611561`", ",", 
   "0.20346414895026022`", ",", "0.113622266092754`", ",", 
   "0.04071637519172543`", ",", "0.3765123851109008`", ",", 
   "0.014841487517617297`", ",", "0.20736600897215207`", ",", 
   "0.24344077950310067`", ",", "0.10754915543422497`", ",", 
   "0.06223446544136983`", ",", "0.02562964823370846`", ",", 
   "0.0954353361758348`", ",", "0.14446202481818027`", ",", 
   "0.1053251403057265`", ",", "0.14709810549043364`", ",", 
   "0.17924121364444084`", ",", "0.07997831668949076`", ",", 
   "0.03706242004026039`", ",", "0.2079505603676986`", ",", 
   "0.16694527126171682`", ",", "0.06306571330888816`", ",", 
   "0.12739877612181394`", ",", "0.29843413859307555`", ",", 
   "0.031063479404162764`", ",", "0.03807164487753556`", ",", 
   "0.1306816204405322`", ",", "0.10478275172781618`", ",", 
   "0.11710235753664444`", ",", "0.06829179185781409`", ",", 
   "0.1603456293008234`", ",", "0.11848075973902808`", ",", 
   "0.23733112554012287`", ",", "0.0918790062061125`", ",", 
   "0.19109723826125347`", ",", "0.10046662846498372`", ",", 
   "0.4481589060985877`", ",", "0.1345375017237862`", ",", 
   "0.12367800462901761`", ",", "0.09482176833299721`", ",", 
   "0.14151620844434992`", ",", "0.05290990289568068`", ",", 
   "0.29911074266467086`", ",", "0.1518242911263757`", ",", 
   "0.1332486190890907`", ",", "0.1458262355241632`", ",", 
   "0.12641591133578578`", ",", "0.03328520458869448`", ",", 
   "0.09587043165037251`", ",", "0.03715325897301969`", ",", 
   "0.11268809078883169`", ",", "0.14549957498587726`", ",", 
   "0.09821492159729207`", ",", "0.1485326891725648`", ",", 
   "0.13525661441971165`", ",", "0.020721804565255283`", ",", 
   "0.10499607201277135`", ",", "0.12277969781448156`", ",", 
   "0.09394737246640747`", ",", "0.10532480284977536`", ",", 
   "0.18505274083974577`", ",", "0.0837385947744378`", ",", 
   "0.1811638171675423`", ",", "0.1329245892187074`", ",", 
   "0.2708844088634912`", ",", "0.15910475040448818`", ",", 
   "0.11157551071779928`", ",", "0.08817917715127907`", ",", 
   "0.07430451110122299`", ",", "0.20687639186088289`", ",", 
   "0.33201806319095095`", ",", "0.5290631291979991`", ",", 
   "0.06967008383339358`", ",", "0.1384669388838622`", ",", 
   "0.5710024923297236`", ",", "0.1743557432362346`", ",", 
   "0.25826188724195004`", ",", "0.08216502572459883`", ",", 
   "0.1564780533246177`", ",", "0.12080861426678244`", ",", 
   "0.05525602779651295`", ",", "0.15973101974328016`", ",", 
   "0.23013342511902157`", ",", "0.3170700201750923`", ",", 
   "0.11296620101451277`"}], "}"}]], "Output",
 CellChangeTimes->{3.884523885910987*^9, 3.884524025623201*^9, 
  3.8849964330940847`*^9, 3.885214272882972*^9, 3.8852184725876007`*^9, 
  3.885285906541048*^9, 3.885287691147361*^9, 3.8854149143534737`*^9, 
  3.8855026129573317`*^9, 3.885513525707735*^9, 3.88555413737444*^9, 
  3.8855543478345957`*^9, 3.885566087923053*^9, 3.88557553307528*^9, 
  3.894049943960853*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"c832d22f-7993-480e-a9f3-a9d481b96da0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "diststotightbounds", "]"}]], "Input",
 CellChangeTimes->{{3.885575630970728*^9, 3.885575672193831*^9}, {
  3.885576022438196*^9, 3.885576022850524*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"3cd0f59d-46cd-444f-9682-faaae62d578c"],

Cell[BoxData["0.06731135513388292`"], "Output",
 CellChangeTimes->{{3.8855756382977877`*^9, 3.885575672699491*^9}, 
   3.8855758248142767`*^9, 3.885576023766778*^9, 3.8940499439959593`*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"8dd9dd16-bdfe-4f9c-91ed-019952bd3d60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "diststotightbounds", "]"}]], "Input",
 CellChangeTimes->{{3.8855756810628567`*^9, 3.885575685736298*^9}, {
  3.885576027379064*^9, 3.885576027800918*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"aa8c642d-c5ea-440a-a193-04e9e8d2729a"],

Cell[BoxData["0.062453735076064394`"], "Output",
 CellChangeTimes->{3.885575686182197*^9, 3.885575825573269*^9, 
  3.885576028161909*^9, 3.8940499440254087`*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"68eb9c1f-b590-4ed4-96fc-7ccc24788c92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quartiles", "[", "diststotightbounds", "]"}]], "Input",
 CellChangeTimes->{{3.885575692195689*^9, 3.885575695626602*^9}, {
  3.8855760332063427`*^9, 3.8855760336390133`*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"e3e31f7e-d545-4b1e-beb2-daf6159111df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.025818881077975336`", ",", "0.04785203610180808`", ",", 
   "0.08718013257155605`"}], "}"}]], "Output",
 CellChangeTimes->{3.885575695985567*^9, 3.8855758306962233`*^9, 
  3.885576034028821*^9, 3.894049944050008*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"479a88e9-4a54-4612-b4f4-7a624afa849b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diststolooseboundsfp", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "*", 
      RowBox[{"2", "/", 
       RowBox[{"Sqrt", "[", "5", "]"}]}]}], "-", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.885576848189702*^9, 3.885576868681521*^9}, {
  3.885577083974485*^9, 3.885577084091223*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"f055bd0e-24c1-4229-8146-645c0909f237"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.29750675792367043`", ",", "0.34590512637199644`", ",", 
   "0.36790969009687025`", ",", "0.33825789750071855`", ",", 
   "0.30445255932748816`", ",", "0.3074446108414401`", ",", 
   "0.3471429420600034`", ",", "0.39107444215990833`", ",", 
   "0.3931200479799332`", ",", "0.39573338515146184`", ",", 
   "0.3710416394248193`", ",", "0.41161973021634785`", ",", 
   "0.37749268109639456`", ",", "0.39988622383608485`", ",", 
   "0.4359518740294254`", ",", "0.3537715488148728`", ",", 
   "0.45260715897590226`", ",", "0.43972422348247786`", ",", 
   "0.40732276147382734`", ",", "0.43293801437778995`", ",", 
   "0.34797952921214265`", ",", "0.4613670170167615`", ",", 
   "0.34851374750129394`", ",", "0.455477188323721`", ",", 
   "0.4662309472364404`", ",", "0.42112072055036215`", ",", 
   "0.4466951133277933`", ",", "0.44205273444994464`", ",", 
   "0.4664244638116345`", ",", "0.418814619368067`", ",", 
   "0.44352039881571437`", ",", "0.45228549099679427`", ",", 
   "0.41586530165937696`", ",", "0.4585742392839145`", ",", 
   "0.47909218923723484`", ",", "0.4582297805781104`", ",", 
   "0.4871040559464712`", ",", "0.48152198902285104`", ",", 
   "0.5070507520049798`", ",", "0.48570583101467985`", ",", 
   "0.5012177011572303`", ",", "0.5163206833418786`", ",", 
   "0.5141973266338449`", ",", "0.5096162309782047`", ",", 
   "0.46825050146099967`", ",", "0.4907494682821696`", ",", 
   "0.40055916273254055`", ",", "0.390216690029881`", ",", 
   "0.5305077150763784`", ",", "0.4968966260201661`", ",", 
   "0.5253334469533567`", ",", "0.5003239628234858`", ",", 
   "0.46009485908724435`", ",", "0.4999056699478386`", ",", 
   "0.5232110034544849`", ",", "0.4817145755013984`", ",", 
   "0.5317983527648334`", ",", "0.5525435134323472`", ",", 
   "0.4284246068899818`", ",", "0.44896230802714676`", ",", 
   "0.49425670863144244`", ",", "0.4297526303636956`", ",", 
   "0.5432526771004725`", ",", "0.5523911957120013`", ",", 
   "0.5634498837861074`", ",", "0.5162517696997933`", ",", 
   "0.539580371242454`", ",", "0.5853221234243167`", ",", 
   "0.5786043223567577`", ",", "0.5652586534826282`", ",", 
   "0.5863490762405217`", ",", "0.5683426949533111`", ",", 
   "0.5618995937804871`", ",", "0.5379883370103054`", ",", 
   "0.5692899463779183`", ",", "0.5958434707887056`", ",", 
   "0.5731876077083413`", ",", "0.5705492635565883`", ",", 
   "0.5967288695438349`", ",", "0.5610408531492951`", ",", 
   "0.5022292061001202`", ",", "0.5410211720765516`", ",", 
   "0.5781336344929577`", ",", "0.6226341543203333`", ",", "0.5719297815076`",
    ",", "0.4724276311912633`", ",", "0.6310664768138882`", ",", 
   "0.5472740919099729`", ",", "0.5560608894308335`", ",", 
   "0.6450054201010296`", ",", "0.632548643775888`", ",", 
   "0.6127763686847091`", ",", "0.4115499612227003`", ",", 
   "0.6216258646614873`", ",", "0.6463933730148081`", ",", 
   "0.5643309457889939`", ",", "0.6103458723903634`", ",", 
   "0.4939170226096542`", ",", "0.6295178380969738`", ",", 
   "0.5215670508623356`", ",", "0.5662656811368831`", ",", 
   "0.44546609706292695`", ",", "0.6684013822555871`", ",", 
   "0.6221486671480349`", ",", "0.6355581753194219`", ",", 
   "0.6097471910333893`", ",", "0.6416726123989119`", ",", 
   "0.511408611522435`", ",", "0.677108673119227`", ",", "0.531342592845462`",
    ",", "0.5892147313550251`", ",", "0.6767953409831409`", ",", 
   "0.5077628574513208`", ",", "0.45563544247519006`", ",", 
   "0.6922392522065489`", ",", "0.6850487188636869`", ",", 
   "0.5405488300892927`", ",", "0.6617569732844959`", ",", 
   "0.6583346446687638`", ",", "0.6821772140088377`", ",", 
   "0.5902012102937678`", ",", "0.6564638933081289`", ",", 
   "0.6197391934341976`", ",", "0.6607784355062338`", ",", 
   "0.6193545760020278`", ",", "0.6628278859188977`", ",", 
   "0.6843782512583744`", ",", "0.6449204767312648`", ",", 
   "0.3762760837446926`", ",", "0.6529918826162503`", ",", 
   "0.6746220210657983`", ",", "0.7028275848258232`", ",", 
   "0.4685021800206071`", ",", "0.7170806922360464`", ",", 
   "0.6690309294988677`", ",", "0.6940612983476196`", ",", 
   "0.5725452327670884`", ",", "0.7053620036463192`", ",", 
   "0.7162367969058574`", ",", "0.7017670731133762`", ",", 
   "0.71720829150642`", ",", "0.7027973446510107`", ",", 
   "0.6264000153231647`", ",", "0.689634497448025`", ",", 
   "0.6985654241838755`", ",", "0.5213615604289406`", ",", 
   "0.6944416215170647`", ",", "0.716242966237748`", ",", 
   "0.7274498517021887`", ",", "0.43324787463359793`", ",", 
   "0.7340171333432406`", ",", "0.7024065461653557`", ",", 
   "0.6771509521108708`", ",", "0.7004272026501049`", ",", 
   "0.6343071675324746`", ",", "0.49743726825231194`", ",", 
   "0.7249554272899594`", ",", "0.7291177663938098`", ",", 
   "0.6881169757069966`", ",", "0.7282431481431687`", ",", 
   "0.6813003863241004`", ",", "0.41039076809745123`", ",", 
   "0.7336121569661465`", ",", "0.5990593887964096`", ",", 
   "0.7364820100670454`", ",", "0.7317309241525243`", ",", 
   "0.6949005478501298`", ",", "0.7397115446164455`", ",", 
   "0.7345648605676534`", ",", "0.671931466586107`", ",", 
   "0.7319196411591482`", ",", "0.7278931829271907`", ",", 
   "0.6936436454936111`", ",", "0.7377820370125894`", ",", 
   "0.7294203061682438`", ",", "0.7282079113043421`", ",", 
   "0.631370156341584`", ",", "0.7289590134657011`", ",", 
   "0.7209191345018334`", ",", "0.7460757475075585`", ",", 
   "0.6822584961112597`", ",", "0.6945803654151107`", ",", 
   "0.700592528877991`", ",", "0.7114812120049137`", ",", 
   "0.7225132201864551`", ",", "0.7373918329206444`", ",", 
   "0.746744411082443`", ",", "0.6640031197291928`", ",", 
   "0.6999978017443508`", ",", "0.7342936972463722`", ",", 
   "0.6443730344895271`", ",", "0.72144378474715`", ",", 
   "0.6516303750601139`", ",", "0.7619979760100068`", ",", 
   "0.7180241749962785`", ",", "0.6767599721601634`", ",", 
   "0.7679145912164934`", ",", "0.7409618161197413`", ",", 
   "0.7347879801834681`", ",", "0.7007573090708425`", ",", 
   "0.5895513027335999`", ",", "0.5328161553388182`", ",", 
   "0.7283835067270241`", ",", "0.6858973811059854`", ",", 
   "0.7533029086798282`", ",", "0.7683343910873491`", ",", 
   "0.6773658034982561`", ",", "0.7745269625682247`", ",", 
   "0.5654282476834178`", ",", "0.7260963665573643`", ",", 
   "0.7545294740604542`", ",", "0.36561227680742403`", ",", 
   "0.7791990714166491`", ",", "0.7894376632815375`", ",", 
   "0.7464065707972847`", ",", "0.671427153848724`", ",", "0.70608413256031`",
    ",", "0.7936720584307866`", ",", "0.7441507118160653`", ",", 
   "0.7780484844582793`", ",", "0.6987861242680624`", ",", 
   "0.6300212881329188`", ",", "0.8075946656323973`", ",", 
   "0.737002933930966`", ",", "0.7902395539340077`", ",", 
   "0.7730537942454455`", ",", "0.764344597521509`", ",", 
   "0.7867447117325227`", ",", "0.7596161020208297`", ",", 
   "0.7581148338114914`", ",", "0.7624747954693197`", ",", 
   "0.7337664047162773`", ",", "0.7659288743746313`", ",", 
   "0.32950855471433027`", ",", "0.8288664907099389`", ",", 
   "0.7988848199043106`", ",", "0.436408619384907`", ",", 
   "0.7346490874740351`", ",", "0.566892283312999`", ",", 
   "0.8017486889218367`", ",", "0.7770531581439867`", ",", 
   "0.8106530409296453`", ",", "0.572182765056166`", ",", 
   "0.7702653166009857`", ",", "0.551609358619747`", ",", 
   "0.7551658996198587`", ",", "0.8033167010238306`", ",", 
   "0.6319976221312561`", ",", "0.7758573452634144`", ",", 
   "0.7904718312135331`", ",", "0.610517253634518`", ",", 
   "0.7358675118365621`", ",", "0.790821007200485`", ",", 
   "0.815105970010407`", ",", "0.8016240256737555`", ",", 
   "0.8405630452659635`", ",", "0.7587107942787045`", ",", 
   "0.8337169452883626`", ",", "0.7427718612645788`", ",", 
   "0.800589046332668`", ",", "0.7386061046236442`", ",", 
   "0.40191584963899896`", ",", "0.8300409962757109`", ",", 
   "0.8000346506175062`", ",", "0.838259053368528`", ",", 
   "0.7449468180251477`", ",", "0.6401847176583569`", ",", 
   "0.736574559133399`", ",", "0.8629423439066227`", ",", 
   "0.8524978152850287`", ",", "0.7622156008990034`", ",", 
   "0.8202645225918737`", ",", "0.8353598594785733`", ",", 
   "0.7111299143217102`", ",", "0.8680513376192053`", ",", 
   "0.8740595172585736`", ",", "0.8128668824643762`", ",", 
   "0.8285621848624765`", ",", "0.8533262055007974`", ",", 
   "0.8617481882754255`", ",", "0.40084625596770007`", ",", 
   "0.8035344217235112`", ",", "0.888020105491877`", ",", 
   "0.8910662836540122`", ",", "0.8730205033139586`", ",", 
   "0.8647256382775217`", ",", "0.6498040729416643`", ",", 
   "0.7489914031584132`", ",", "0.8313789049402911`", ",", 
   "0.8874864493595046`", ",", "0.7038188819563794`", ",", 
   "0.6862808523931211`", ",", "0.6222654247902728`", ",", 
   "0.8666426961926772`", ",", "0.7360395119552668`", ",", 
   "0.6024908372824038`", ",", "0.8597374331044768`", ",", 
   "0.8769944786435531`", ",", "0.8471054768999264`", ",", 
   "0.8939342591706183`", ",", "0.8093917928524006`", ",", 
   "0.855126700949499`", ",", "0.83305565702035`", ",", "0.9128815699753134`",
    ",", "0.8926539907953486`", ",", "0.6773127572273615`", ",", 
   "0.8988661444799796`", ",", "0.9211094878754263`", ",", 
   "0.894753371992718`", ",", "0.724101092096662`", ",", 
   "0.8970719364204773`", ",", "0.774687224866324`", ",", 
   "0.8092886617449502`", ",", "0.9201708063117556`", ",", 
   "0.7792519622758316`", ",", "0.8436797872190043`", ",", 
   "0.7759702882969006`", ",", "0.7943109480079731`", ",", 
   "0.7668819029313589`", ",", "0.5356209709319179`", ",", 
   "0.9234625090005152`", ",", "0.874730535509634`", ",", 
   "0.862892189863797`", ",", "0.7225551679898019`", ",", 
   "0.6385353979974535`", ",", "0.3568916197936941`", ",", 
   "0.8095353314353498`", ",", "0.8246940650734718`", ",", 
   "0.8142826070239738`", ",", "0.9258928515660763`", ",", 
   "0.8345761560835941`", ",", "0.9177485475115332`", ",", 
   "0.7950919614403731`", ",", "0.9300735177414711`", ",", 
   "0.8999523378310675`", ",", "0.91187966437399`", ",", 
   "0.9259548752247146`", ",", "0.9448783352809774`", ",", 
   "0.9410401259498639`", ",", "0.9396123954185683`", ",", 
   "0.8024593423680081`", ",", "0.8824410020148243`", ",", 
   "0.8616475949471558`", ",", "0.9319485858165523`", ",", 
   "0.8193469219126013`", ",", "0.9638388374347794`", ",", 
   "0.9476573529132364`", ",", "0.9090333067545706`", ",", 
   "0.9222109421670043`", ",", "0.9035460069826181`", ",", 
   "0.9525593468582719`", ",", "0.9170950393939621`", ",", 
   "0.9407440873478542`", ",", "0.8133433956874412`", ",", 
   "0.9020475289441181`", ",", "0.9177192359867193`", ",", 
   "0.9203156565927435`", ",", "0.9613750203877247`", ",", 
   "0.8516095676004927`", ",", "0.9142041799233099`", ",", 
   "0.9537751997546887`", ",", "0.857278526560103`", ",", 
   "0.8267245847638791`", ",", "0.8665027330501079`", ",", 
   "0.902654832029703`", ",", "0.9616319735451647`", ",", 
   "0.9343782322402446`", ",", "0.9639044448021691`", ",", 
   "0.7557637415021814`", ",", "0.36188485604246423`", ",", 
   "0.8576718193980041`", ",", "0.9826788798032363`", ",", 
   "0.6096046539573592`", ",", "0.9284464605610878`", ",", 
   "0.5537130257147515`", ",", "0.5963181599898075`", ",", 
   "0.8205140913069471`", ",", "0.9871802155178674`", ",", 
   "0.9473886828875443`", ",", "0.9927523993750199`", ",", 
   "0.9959804260760922`", ",", "0.9120355065572129`", ",", 
   "0.9662508558179316`", ",", "0.9775342481767016`", ",", 
   "0.9931250185918193`", ",", "0.7646119257337525`", ",", 
   "0.8906165785221282`", ",", "0.8879117484020391`", ",", 
   "0.9193570100566051`", ",", "0.7807090909667469`", ",", 
   "0.9631977377819502`", ",", "0.760393803423616`", ",", 
   "0.9764845998978118`", ",", "0.6720953782299292`", ",", 
   "0.8737365744391584`", ",", "0.9391325145701809`", ",", 
   "1.008525596985118`", ",", "0.9928879348750034`", ",", 
   "0.7590950814272883`", ",", "0.8640748859512384`", ",", 
   "0.8920121692757689`", ",", "0.9116021415679801`", ",", 
   "0.6766972600314385`", ",", "0.7235630126969214`", ",", 
   "0.9338089220421028`", ",", "0.9617549759389702`", ",", 
   "0.8056183327575039`", ",", "1.0308584345690368`", ",", 
   "1.0168256510570068`", ",", "0.9708621714043706`", ",", 
   "0.9643645387871498`", ",", "0.9872709577716791`", ",", 
   "0.7092496879604935`", ",", "1.0128851215097179`", ",", 
   "0.9984021036094494`", ",", "0.4425544585794995`", ",", 
   "1.0309157297780125`", ",", "0.9663452608372257`", ",", 
   "0.9711433274828452`", ",", "0.8508803416317265`", ",", 
   "0.8035019098032188`", ",", "0.351120208951051`", ",", 
   "0.9901922606961577`", ",", "0.5655886506069309`", ",", 
   "1.0246885565892214`", ",", "0.9888172839559993`", ",", 
   "0.844670352381778`", ",", "1.0294845027581494`", ",", 
   "1.0176211032987037`", ",", "0.46937559452720834`", ",", 
   "0.8384157338033342`", ",", "1.0507182007481308`", ",", 
   "0.9416504075164043`", ",", "1.026349441423362`", ",", 
   "1.0542562297448448`", ",", "1.052946151315742`", ",", 
   "0.9169377155150165`", ",", "0.9294437481199881`", ",", 
   "0.8249918312187483`", ",", "0.9634516822703022`", ",", 
   "1.0326985493080627`", ",", "0.8995999858157603`", ",", 
   "1.020641640833766`", ",", "1.0102196461747455`", ",", 
   "1.0714892050649087`", ",", "1.0369696022684536`", ",", 
   "1.0510216553437057`", ",", "0.956871706430638`", ",", 
   "0.8530842037993263`", ",", "0.8281707045062234`", ",", 
   "0.555896128502183`", ",", "1.0780262488065324`", ",", 
   "0.8221725754176674`", ",", "1.0248579830659184`", ",", 
   "0.6187968782939791`", ",", "1.0739625283140986`", ",", 
   "1.0781829160073537`", ",", "1.0861886619496297`", ",", 
   "0.9348410182894666`", ",", "0.9324083401116409`", ",", 
   "1.0750521346636606`", ",", "1.0838626287913977`", ",", 
   "1.0073047492097424`", ",", "1.0805054195414987`", ",", 
   "0.8230667567492138`", ",", "0.842881465610015`", ",", 
   "1.0940228174259283`", ",", "1.0767847636655274`", ",", 
   "0.8864408144960912`", ",", "1.031165848297178`", ",", 
   "1.0117299059467602`", ",", "0.8600572572113826`", ",", 
   "0.9464222484064279`", ",", "1.055820581835783`", ",", 
   "1.071707244232266`", ",", "1.0029667834066247`", ",", 
   "0.9908389386827002`", ",", "1.071064602097153`", ",", 
   "1.0853840158068755`", ",", "0.9246325791908077`", ",", 
   "0.9829841331859566`", ",", "1.069514413325661`", ",", 
   "1.083908803985919`", ",", "0.9640814383495333`", ",", 
   "1.068989140410655`", ",", "0.9696769868199119`", ",", 
   "1.066395691729659`", ",", "0.9316237226730445`", ",", 
   "1.1154542610903473`", ",", "1.072582509212132`", ",", 
   "1.002996072316531`", ",", "1.120463174929358`", ",", 
   "1.1265359197738296`", ",", "0.8414014027166882`", ",", 
   "1.1086727335391566`", ",", "1.1161023879023633`", ",", 
   "1.1321582100498961`", ",", "0.904561582710007`", ",", 
   "0.9345496913894679`", ",", "1.0514805383912187`", ",", 
   "1.1364666825168626`", ",", "0.3550195131543925`", ",", 
   "0.4263354066172548`", ",", "1.0785265818349072`", ",", 
   "1.1325402126660746`", ",", "0.9209561231469785`", ",", 
   "1.131204669719053`", ",", "1.1069831890434803`", ",", 
   "1.1436651482323719`", ",", "0.9098659462632238`", ",", 
   "1.1226223658366181`", ",", "1.0188194812304612`", ",", 
   "1.1394720913605214`", ",", "1.0376383933022648`", ",", 
   "0.9713113457131923`", ",", "0.8482154495586622`", ",", 
   "0.7901390884641488`", ",", "0.7802974661093992`", ",", 
   "1.095030311540409`", ",", "0.9719878380656908`", ",", 
   "1.1521653169554262`", ",", "1.0466438409474719`", ",", 
   "1.044075404598643`", ",", "1.0288714890169819`", ",", 
   "0.9714345440039704`", ",", "1.0404594421061004`", ",", 
   "1.1276883872308232`", ",", "1.0910436173697575`", ",", 
   "1.1024249622058122`", ",", "1.1204001141151236`", ",", 
   "1.1851471220285135`", ",", "0.9519143704931143`", ",", 
   "0.9467360157900366`", ",", "1.1982194305619194`", ",", 
   "1.0879552951628118`", ",", "1.1248934866072653`", ",", 
   "1.1833752953400931`", ",", "1.165697476763277`", ",", 
   "1.0641123873759517`", ",", "1.0454651531861894`", ",", 
   "0.7709069661245908`", ",", "1.1503785513810105`", ",", 
   "1.2078932982124058`", ",", "1.191876213348959`", ",", 
   "1.0105552200453822`", ",", "1.2042318935347385`", ",", 
   "0.6158243640953416`", ",", "1.1004082079011905`", ",", 
   "0.4087450239250653`", ",", "1.1793724036306068`", ",", 
   "0.9360693690827191`", ",", "0.9548945202244743`", ",", 
   "0.8375828217665844`", ",", "1.2077351652503507`", ",", 
   "0.4425641496138326`", ",", "1.1927773794111831`", ",", 
   "1.2092947683488224`", ",", "1.2157840742580586`", ",", 
   "1.1816498424016582`", ",", "1.206555341535611`", ",", 
   "1.1905786923819748`", ",", "1.0203094878620227`", ",", 
   "1.1208420505417866`", ",", "1.0707996918107152`", ",", 
   "0.8549371879411697`", ",", "1.1874499697564866`", ",", 
   "0.8665737296829212`", ",", "1.2239529475388`", ",", "1.2422891302358585`",
    ",", "0.9828031264615752`", ",", "1.217594207961627`", ",", 
   "0.9276752399409199`", ",", "1.007569771528151`", ",", 
   "1.1429099761326826`", ",", "0.9557040242924428`", ",", 
   "1.1418476136083437`", ",", "1.0846379775710278`", ",", 
   "0.9628917245403887`", ",", "1.0689736365115245`", ",", 
   "1.2757505988223066`", ",", "1.2471380732588009`", ",", 
   "1.274300359039206`", ",", "1.2424646550945473`", ",", 
   "1.0855201028656356`", ",", "1.2902479108307527`", ",", 
   "1.1301165762514953`", ",", "1.182161620101084`", ",", 
   "1.2613326463772319`", ",", "1.2226453721053083`", ",", 
   "1.2138065743116335`", ",", "0.7814174110390082`", ",", 
   "1.28668836140224`", ",", "0.9683409099729047`", ",", 
   "0.8879856257834615`", ",", "0.9956746796449678`", ",", 
   "1.0904645850910522`", ",", "0.8451124729544257`", ",", 
   "0.8791749186292157`", ",", "0.8925627396171028`", ",", 
   "1.2948829793953702`", ",", "1.3186294278658244`", ",", 
   "1.0587045887868753`", ",", "1.1450306519462972`", ",", 
   "1.3476421498701512`", ",", "1.0732362991616324`", ",", 
   "1.3030404576011931`", ",", "1.232666249803608`", ",", 
   "1.3113863693905254`", ",", "1.1073811922873045`", ",", 
   "1.0442733018308608`", ",", "1.091024251084518`", ",", 
   "1.2585263474508916`", ",", "1.1768150792848122`", ",", 
   "0.575596381537009`", ",", "1.3371862107733687`", ",", 
   "1.049608334397695`", ",", "1.1474837234272313`", ",", 
   "1.325215411351785`", ",", "1.3624629978943237`", ",", 
   "1.3619088778091233`", ",", "1.3604288595172649`", ",", 
   "0.9686013215722215`", ",", "0.4681649732839842`", ",", 
   "1.2484535344089163`", ",", "1.290954568487137`", ",", 
   "1.2082447726614978`", ",", "1.1945302022589355`", ",", 
   "1.362428708505104`", ",", "1.346331164824313`", ",", 
   "0.9726207388130546`", ",", "1.3618443817364354`", ",", 
   "0.9354075571283427`", ",", "0.9957969408271876`", ",", 
   "1.2593581732096577`", ",", "1.3050806018567414`", ",", 
   "1.141232629755574`", ",", "1.036438536863791`", ",", "1.373464611828262`",
    ",", "1.3863246920828463`", ",", "1.0048670242950164`", ",", 
   "1.320537448161484`", ",", "1.233576455364142`", ",", "1.076556185614766`",
    ",", "0.9774595930079142`", ",", "1.0506947464004042`", ",", 
   "1.3655496101202145`", ",", "0.9837702407329102`", ",", 
   "1.1607313537216888`", ",", "1.164981050906771`", ",", 
   "1.2141849917531249`", ",", "1.2992007281554125`", ",", 
   "1.2825018002852417`", ",", "1.137300465344674`", ",", 
   "1.2555317282964915`", ",", "1.4053656086175386`", ",", 
   "1.2282333027041812`", ",", "1.0701278278275685`", ",", 
   "1.3258985204614915`", ",", "1.4154320182919433`", ",", 
   "1.1926071136221073`", ",", "1.4229775709203734`", ",", 
   "1.3934698585614211`", ",", "1.3769884916868664`", ",", 
   "1.3606138219597201`", ",", "1.1471462350023818`", ",", 
   "1.3266531507419619`", ",", "1.3858926854491913`", ",", 
   "1.3680453438996434`", ",", "1.3914883244063665`", ",", 
   "1.0018756549037406`", ",", "1.186348200513326`", ",", 
   "1.0482113922352152`", ",", "1.4495658237328168`", ",", 
   "1.4187282861211647`", ",", "1.372147345518346`", ",", 
   "0.9912136111503953`", ",", "1.4373783995973197`", ",", 
   "1.4474219948479412`", ",", "1.3481707815866173`", ",", 
   "1.297392438396749`", ",", "1.4046052453669136`", ",", 
   "1.0491828263982017`", ",", "1.4561838330435848`", ",", 
   "0.6167452901431972`", ",", "0.8164241229167963`", ",", 
   "1.2835142381992608`", ",", "1.4142502150879879`", ",", 
   "1.2640772858291673`", ",", "1.428620753703763`", ",", 
   "0.8004888298836588`", ",", "1.317786841090772`", ",", 
   "1.3990755216522763`", ",", "1.2270267483305957`", ",", 
   "1.1796758682397144`", ",", "1.4413080282016941`", ",", 
   "0.577254439273915`", ",", "0.976812271170006`", ",", "1.411903042871081`",
    ",", "1.3812164859301233`", ",", "1.432454221523704`", ",", 
   "1.4571123636428407`", ",", "1.225698174566603`", ",", 
   "1.3694773155022186`", ",", "1.0545372488269535`", ",", 
   "1.3144499993548457`", ",", "1.373526665016924`", ",", 
   "0.9056068822779756`", ",", "1.3761051294386162`", ",", 
   "1.2862529590931882`", ",", "1.2948210208587208`", ",", 
   "1.3908813637236537`", ",", "1.2531339898260978`", ",", 
   "1.3464632539674501`", ",", "1.4885311011567919`", ",", 
   "1.1887240175203857`", ",", "1.4168443605589727`", ",", 
   "1.2640373604110458`", ",", "1.5219283266182293`", ",", 
   "1.4333846102598349`", ",", "1.463033188930477`", ",", 
   "1.4201874145959508`", ",", "1.3999814923853244`", ",", 
   "1.2703921127021482`", ",", "1.4962073701298382`", ",", 
   "0.9828488431004199`", ",", "1.3537318508715466`", ",", 
   "1.5039505387858603`", ",", "0.8709280498060973`", ",", 
   "1.3660829665669194`", ",", "1.5315704395868537`", ",", 
   "1.503482247445793`", ",", "1.4973124758452079`", ",", 
   "1.5019775716521369`", ",", "1.229866495160265`", ",", 
   "1.1192696876606973`", ",", "1.4800502865835516`", ",", 
   "1.4768938214189904`", ",", "1.412533209430442`", ",", 
   "0.9182055797888035`", ",", "1.4118309175015256`", ",", 
   "1.3547824380488824`", ",", "1.4132182172064394`", ",", 
   "1.1824428016039632`", ",", "1.5435238011153665`", ",", 
   "1.5896846069072363`", ",", "1.2043479508468145`", ",", 
   "1.286561315023669`", ",", "1.4103436036917538`", ",", 
   "1.110997775367415`", ",", "1.5993372384680784`", ",", 
   "1.615142533409517`", ",", "1.5715895284534032`", ",", 
   "1.3881678987326354`", ",", "1.5838006338132906`", ",", 
   "1.4587649623311887`", ",", "1.5845544045584723`", ",", 
   "1.1373230462975759`", ",", "1.5854886454131627`", ",", 
   "1.6394836523328364`", ",", "1.6324667433845923`", ",", 
   "1.294892219350424`", ",", "1.4127548487171726`", ",", 
   "0.9962454353115344`", ",", "1.3259646257596613`", ",", 
   "1.5855661336401463`", ",", "1.508084975910306`", ",", 
   "1.6330205761407344`", ",", "1.1705396936370183`", ",", 
   "1.5062828334289298`", ",", "1.5165433803214228`", ",", 
   "1.2895418834736405`", ",", "1.6605724321944553`", ",", 
   "1.5291775428320007`", ",", "1.64140504146476`", ",", 
   "1.6932787438207872`", ",", "1.673749107966148`", ",", 
   "1.6245570035822612`", ",", "0.9740613457136614`", ",", 
   "0.9485486272071646`", ",", "1.6262477400538389`", ",", 
   "1.6380909692555568`", ",", "1.479179648152121`", ",", 
   "1.387249373418596`", ",", "1.6269435596434945`", ",", 
   "1.5427578587703654`", ",", "1.718614027404318`", ",", 
   "1.6499329678116041`", ",", "1.3680319517164525`", ",", 
   "1.7340271891681345`", ",", "1.4378713107243744`", ",", 
   "1.6943595903698248`", ",", "1.5747163229512424`", ",", 
   "1.4641993888655263`", ",", "1.763173288659111`", ",", 
   "1.4815605613238307`", ",", "1.7200922943830932`", ",", 
   "1.5888272654646274`", ",", "1.7761507049806091`", ",", 
   "1.7804788538227752`", ",", "1.729537923154655`", ",", 
   "1.7906603128503922`", ",", "1.4883894778159539`", ",", 
   "1.7514037036475423`", ",", "1.8060622127559836`", ",", 
   "1.7127230384491263`", ",", "1.6931029009868643`", ",", 
   "1.4163948645304838`", ",", "1.594060948700874`", ",", 
   "1.6760548977274146`", ",", "1.629103224660333`", ",", 
   "1.7907915480229586`", ",", "1.0745573147430474`", ",", 
   "1.8338779326635453`", ",", "1.8510799944647147`", ",", 
   "1.7388276361978834`", ",", "1.3980011734461533`", ",", 
   "1.5652774940074006`", ",", "1.7943914692788447`", ",", 
   "1.8291056790772533`", ",", "1.6392069221061998`", ",", 
   "1.8566824492461773`", ",", "1.642523595333689`", ",", 
   "1.8714672635825362`", ",", "1.8539655920259244`", ",", 
   "1.8322172303971807`", ",", "1.8471009242030272`", ",", 
   "1.9003341862963228`", ",", "1.7788337665252545`", ",", 
   "1.6933308736405805`", ",", "1.902457865459555`", ",", 
   "1.793597845181406`", ",", "1.4552677490909645`", ",", "1.90643434443916`",
    ",", "1.91117848265203`", ",", "1.8752023198004735`", ",", 
   "1.7078182364182997`", ",", "1.8041839080578281`", ",", 
   "1.9046472890283213`", ",", "1.9680696316200956`", ",", 
   "1.490029972092956`", ",", "1.8398347578193552`", ",", 
   "1.9469691863859322`", ",", "1.427533471915453`", ",", 
   "1.978792151392205`", ",", "1.97743501220066`", ",", "1.914218454427602`", 
   ",", "1.5886742559799383`", ",", "1.9190631200491153`", ",", 
   "1.8477008448192147`", ",", "2.0036003507026194`", ",", 
   "1.1785004152607812`", ",", "1.6009920476245387`", ",", 
   "1.9452399956756938`", ",", "1.9550380183977882`", ",", 
   "2.0475989223587465`", ",", "1.8018124559535835`", ",", 
   "2.0519143200150096`", ",", "1.9518179609244615`", ",", 
   "1.470116058882005`", ",", "2.0718640494916647`", ",", 
   "1.833169604922537`", ",", "2.027483545451749`", ",", "2.057123601810964`",
    ",", "2.0924335786423973`", ",", "2.0800855266419926`", ",", 
   "1.4358566420008503`", ",", "1.9713143623225013`", ",", 
   "1.8367434029331908`", ",", "1.2506010828089027`", ",", 
   "2.0916782490665438`", ",", "2.131671294916862`", ",", 
   "1.4106548076320666`", ",", "1.9167635391722788`", ",", 
   "1.5722637205217544`", ",", "1.9800205831800914`", ",", 
   "2.132510337812484`", ",", "2.129833551902809`", ",", 
   "2.1779469416326727`", ",", "1.8430458519656534`", ",", 
   "1.8198500764381702`", ",", "2.102612900310129`", ",", 
   "1.7859809244193199`", ",", "2.0879326966946223`", ",", 
   "2.14127262966947`", ",", "2.2287233259427657`", ",", "1.678074174920194`",
    ",", "2.1210772120738706`", ",", "2.1615344945879666`", ",", 
   "1.9427520853759437`", ",", "1.987417245428798`", ",", 
   "1.938612934813862`", ",", "2.1261397083632607`", ",", 
   "2.178436266753725`", ",", "2.097865096938501`", ",", 
   "2.1153266666463235`", ",", "2.291699163367572`", ",", 
   "2.1471566586899096`", ",", "2.185009480679218`", ",", 
   "1.8262347724388062`", ",", "2.0784897821656814`", ",", 
   "2.104084521553237`", ",", "2.241080543042216`", ",", 
   "2.1702276270394742`", ",", "2.169518647681265`", ",", 
   "2.3015007004466623`", ",", "2.427492396639029`", ",", 
   "2.100806124875046`", ",", "2.345288038708643`", ",", 
   "1.5897955290099344`", ",", "2.4751075584753175`", ",", 
   "2.524598463971636`", ",", "2.529048347896028`", ",", "2.383890069367851`",
    ",", "2.541499529969491`", ",", "2.437171070522908`", ",", 
   "2.5634054777350777`", ",", "2.484880891628961`", ",", 
   "2.6354493606440403`", ",", "2.5827911526742247`", ",", 
   "2.613909275604529`", ",", "2.4881072903606483`", ",", 
   "2.6728905119376165`", ",", "2.743634937922579`", ",", 
   "2.7461285086876113`", ",", "2.8344539903682735`", ",", 
   "2.7478515368965817`", ",", "2.7776113824783994`", ",", 
   "2.8547266265825795`", ",", "2.8526342142731975`", ",", 
   "3.0186132463326025`", ",", "2.238481250860746`", ",", 
   "2.932980576380712`", ",", "2.916202201667839`", ",", 
   "3.0301659304756585`", ",", "3.1872498743629945`", ",", 
   "3.006994417186035`", ",", "2.941422426534196`", ",", 
   "2.5878589952511826`", ",", "3.3634289104565696`", ",", 
   "3.339542859067327`", ",", "2.9939684619410007`", ",", 
   "3.197082490794585`", ",", "3.260326774449386`", ",", "3.474684306089124`",
    ",", "3.67539772115908`", ",", "3.9874088922447277`", ",", 
   "4.23591274422986`", ",", "4.022028476586538`", ",", "4.556654957693814`", 
   ",", "5.062566900558728`", ",", "5.907726336124039`"}], "}"}]], "Output",
 CellChangeTimes->{3.885576871051091*^9, 3.885577085692512*^9, 
  3.894049944080131*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"5f29fd53-aca9-4cd5-94c3-b3bae58da92c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "diststolooseboundsfp", "]"}]], "Input",
 CellChangeTimes->{{3.885575630970728*^9, 3.885575672193831*^9}, {
  3.885576022438196*^9, 3.885576022850524*^9}, {3.885577007057482*^9, 
  3.8855770108214407`*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"d901c51e-6cb7-4cb7-856e-3ddd4ab2f892"],

Cell[BoxData["1.1276304752783564`"], "Output",
 CellChangeTimes->{{3.8855756382977877`*^9, 3.885575672699491*^9}, 
   3.8855758248142767`*^9, 3.885576023766778*^9, 3.885577011712281*^9, 
   3.8855770882197943`*^9, 3.8940499441242933`*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"e0117328-96e1-49b8-aa1d-9159b6d4550f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "diststolooseboundsfp", "]"}]], "Input",
 CellChangeTimes->{{3.8855756810628567`*^9, 3.885575685736298*^9}, {
  3.885576027379064*^9, 3.885576027800918*^9}, {3.8855770163893137`*^9, 
  3.885577018503949*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"7c988a2b-0833-4b78-be47-f9ba9ec0b42d"],

Cell[BoxData["0.6223850654287849`"], "Output",
 CellChangeTimes->{3.885575686182197*^9, 3.885575825573269*^9, 
  3.885576028161909*^9, 3.88557701883642*^9, 3.885577089711136*^9, 
  3.8940499441587048`*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"749d3795-c606-4b1d-979e-9bfe72ebd483"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quartiles", "[", "diststolooseboundsfp", "]"}]], "Input",
 CellChangeTimes->{{3.885575692195689*^9, 3.885575695626602*^9}, {
  3.8855760332063427`*^9, 3.8855760336390133`*^9}, {3.885577022880068*^9, 
  3.885577025038086*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"8a5e178a-779d-434e-9d7a-c02333a88f3f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7285273834116934`", ",", "0.9711433274828452`", ",", 
   "1.371479838014314`"}], "}"}]], "Output",
 CellChangeTimes->{3.885575695985567*^9, 3.8855758306962233`*^9, 
  3.885576034028821*^9, 3.885577026314912*^9, 3.885577091174164*^9, 
  3.8940499441930313`*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"c9c069e5-9988-4e95-a868-ec079408c193"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diststotightboundsfp", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"data", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "5", "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.885576901034533*^9, 3.885576923884211*^9}, {
  3.885577053759478*^9, 3.885577053859716*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"b0620cad-1906-4efd-871a-a68d2eb28f0c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.040284768069766656`", ",", "0.044933495292032145`", ",", 
   "0.03502603879939515`", ",", "0.04920334893808629`", ",", 
   "0.03784521109908838`", ",", "0.03203838511410692`", ",", 
   "0.050021164350029956`", ",", "0.039195810894698355`", ",", 
   "0.03219779190647381`", ",", "0.022278711915723802`", ",", 
   "0.05968346944062275`", ",", "0.05197178690431316`", ",", 
   "0.06748375672570485`", ",", "0.08578366586818953`", ",", 
   "0.03317609946038787`", ",", "0.050010020940019426`", ",", 
   "0.019945895082811933`", ",", "0.03841961045011965`", ",", 
   "0.07326648694685917`", ",", "0.05176414257899694`", ",", 
   "0.05916936081894285`", ",", "0.03450904292270215`", ",", 
   "0.10775261138536199`", ",", "0.03177634207564181`", ",", 
   "0.019698706447041612`", ",", "0.02998567209760862`", ",", 
   "0.0159824673057316`", ",", "0.04314777434211528`", ",", 
   "0.09467594270690594`", ",", "0.08921721235833822`", ",", 
   "0.0801077747062933`", ",", "0.05091149891847559`", ",", 
   "0.022546026147431786`", ",", "0.056555911591012975`", ",", 
   "0.052857937793034056`", ",", "0.09079435708195042`", ",", 
   "0.028833732367146814`", ",", "0.05358408888353693`", ",", 
   "0.030728103035638193`", ",", "0.049381279072447035`", ",", 
   "0.10075075207591394`", ",", "0.060612004111796396`", ",", 
   "0.07987848562678274`", ",", "0.04529338913245998`", ",", 
   "0.08670077835450568`", ",", "0.04254734730828517`", ",", 
   "0.032184483688662585`", ",", "0.10987838233906091`", ",", 
   "0.10398248675314191`", ",", "0.08345920077065973`", ",", 
   "0.09857935653833708`", ",", "0.09422367538352262`", ",", 
   "0.055433276616409705`", ",", "0.07365446240390751`", ",", 
   "0.04936153902022108`", ",", "0.07376538894944328`", ",", 
   "0.0952095765804066`", ",", "0.05223751940966992`", ",", 
   "0.024238823517651414`", ",", "0.1042123677089043`", ",", 
   "0.037956703069978545`", ",", "0.07337389107544992`", ",", 
   "0.05765768254466551`", ",", "0.03362982235182072`", ",", 
   "0.11383360667510606`", ",", "0.038846570700501945`", ",", 
   "0.02115307646714009`", ",", "0.03767030324955987`", ",", 
   "0.03391458154762089`", ",", "0.07785962735278731`", ",", 
   "0.09615655107125967`", ",", "0.14035604515108607`", ",", 
   "0.04762591825071867`", ",", "0.12621865396969745`", ",", 
   "0.06821530667334395`", ",", "0.053866700182443376`", ",", 
   "0.05675499251356833`", ",", "0.10744236611262724`", ",", 
   "0.08360019227120052`", ",", "0.07425432550169843`", ",", 
   "0.14214080122371922`", ",", "0.13228994914188458`", ",", 
   "0.05960861487998976`", ",", "0.04801957543023721`", ",", 
   "0.12541144679484195`", ",", "0.07529974940380169`", ",", 
   "0.0208638499450944`", ",", "0.03827521210904662`", ",", 
   "0.03658821952771153`", ",", "0.08448900744581299`", ",", 
   "0.10177774105431409`", ",", "0.1426923346317991`", ",", 
   "0.07728480708860275`", ",", "0.043271998636615044`", ",", 
   "0.04357848464459471`", ",", "0.09197549880240637`", ",", 
   "0.07023205060099084`", ",", "0.05108160694468672`", ",", 
   "0.05943352755313894`", ",", "0.1276786750872889`", ",", 
   "0.09546326742892383`", ",", "0.050495743950497024`", ",", 
   "0.061205197998298294`", ",", "0.0691262025889445`", ",", 
   "0.023506501411038286`", ",", "0.09380448482489508`", ",", 
   "0.14728461176540525`", ",", "0.05833818756712336`", ",", 
   "0.012036847294819528`", ",", "0.049066406324337425`", ",", 
   "0.07522691234654585`", ",", "0.08595283868717386`", ",", 
   "0.05899378146263631`", ",", "0.16595199096454633`", ",", 
   "0.0125839156254255`", ",", "0.02492442795017122`", ",", 
   "0.036906099240428064`", ",", "0.07779936513065616`", ",", 
   "0.05145224042093105`", ",", "0.05927081649833241`", ",", 
   "0.0989256783674614`", ",", "0.07266316016451223`", ",", 
   "0.07728525990827217`", ",", "0.12140252733696469`", ",", 
   "0.041504915054572`", ",", "0.10184607068969392`", ",", 
   "0.09097188581150244`", ",", "0.12126631252158443`", ",", 
   "0.09951363934024615`", ",", "0.07841788493764387`", ",", 
   "0.04684688945433005`", ",", "0.0726678806385953`", ",", 
   "0.10045478589958245`", ",", "0.05631758968416857`", ",", 
   "0.10205966883474349`", ",", "0.034390894795458316`", ",", 
   "0.1236599516846863`", ",", "0.09321933500382582`", ",", 
   "0.04434784564808085`", ",", "0.05211189875873296`", ",", 
   "0.06649024336992725`", ",", "0.0853788360050794`", ",", 
   "0.10130695000843658`", ",", "0.15348988948967537`", ",", 
   "0.12770075446752688`", ",", "0.15674926098787`", ",", 
   "0.030579391000473577`", ",", "0.12037659695110724`", ",", 
   "0.03510029261337828`", ",", "0.07183923880990883`", ",", 
   "0.0357157150411619`", ",", "0.07819313829920266`", ",", 
   "0.14942497190439757`", ",", "0.04940914432754856`", ",", 
   "0.19864075146819282`", ",", "0.07043952397536413`", ",", 
   "0.060504094747716675`", ",", "0.06302185158130025`", ",", 
   "0.1006642395050597`", ",", "0.0693802782567067`", ",", 
   "0.10133355878685618`", ",", "0.05821249792577221`", ",", 
   "0.02783014660018203`", ",", "0.05512997082566504`", ",", 
   "0.07607702800493482`", ",", "0.059606706522598384`", ",", 
   "0.06368767191584217`", ",", "0.042864852505398926`", ",", 
   "0.10501034545544513`", ",", "0.06845778780319309`", ",", 
   "0.05468142090170651`", ",", "0.0660195661495708`", ",", 
   "0.07225693350577364`", ",", "0.08116647836383056`", ",", 
   "0.06985011690046616`", ",", "0.06322771947630088`", ",", 
   "0.10483905167401161`", ",", "0.08850931479946417`", ",", 
   "0.041096624601951647`", ",", "0.07481604464752088`", ",", 
   "0.044070107549359`", ",", "0.058304669116134855`", ",", 
   "0.08166586779199282`", ",", "0.05390240718041994`", ",", 
   "0.10475479854817239`", ",", "0.0992064597889104`", ",", 
   "0.1156466037339906`", ",", "0.07958485737740077`", ",", 
   "0.17310163815948693`", ",", "0.12045471026911828`", ",", 
   "0.11312395014705556`", ",", "0.11937363376258289`", ",", 
   "0.0779625875319852`", ",", "0.09843075235184476`", ",", 
   "0.08662494676283236`", ",", "0.22754639372927804`", ",", 
   "0.1111375685513206`", ",", "0.10244241828461405`", ",", 
   "0.07746366148066805`", ",", "0.18853577469055344`", ",", 
   "0.07531321424850801`", ",", "0.15875394325095088`", ",", 
   "0.08918250404745866`", ",", "0.18493356944048306`", ",", 
   "0.08058764473334892`", ",", "0.07015536110039144`", ",", 
   "0.0584369068328697`", ",", "0.07213407662860417`", ",", 
   "0.09416513090015916`", ",", "0.122284678248047`", ",", 
   "0.050906004254691495`", ",", "0.1077381573099584`", ",", 
   "0.044934634568141285`", ",", "0.12446046757554877`", ",", 
   "0.10563686538943019`", ",", "0.09275861098889138`", ",", 
   "0.09761276996145174`", ",", "0.04271859039333316`", ",", 
   "0.060107402940280136`", ",", "0.11433656781005073`", ",", 
   "0.07567639459601273`", ",", "0.12817799497823906`", ",", 
   "0.03678162321029685`", ",", "0.08036877096044066`", ",", 
   "0.04381236089994661`", ",", "0.08202841198760516`", ",", 
   "0.10856965235482793`", ",", "0.11656356649092423`", ",", 
   "0.12109710732921941`", ",", "0.09478362056835332`", ",", 
   "0.1121570709909527`", ",", "0.17949473207844707`", ",", 
   "0.07264102872126169`", ",", "0.13615537582693304`", ",", 
   "0.05116537092560026`", ",", "0.04997499369170967`", ",", 
   "0.09263403761377753`", ",", "0.07919066503305855`", ",", 
   "0.27035388870864435`", ",", "0.1595151925276193`", ",", 
   "0.1914130380582157`", ",", "0.10610231313212928`", ",", 
   "0.10221147697088645`", ",", "0.14579557197851217`", ",", 
   "0.15070151682739286`", ",", "0.16278261050336956`", ",", 
   "0.10047631852851927`", ",", "0.1767223845040415`", ",", 
   "0.0990045321500627`", ",", "0.11319982296107689`", ",", 
   "0.10930421647960473`", ",", "0.11571785478383739`", ",", 
   "0.05904232480067234`", ",", "0.1136722032025366`", ",", 
   "0.09178610607873905`", ",", "0.0600540241554033`", ",", 
   "0.10452586587209033`", ",", "0.1020395726510351`", ",", 
   "0.07899486650901544`", ",", "0.1678336273556706`", ",", 
   "0.08925457024988162`", ",", "0.15390868820203163`", ",", 
   "0.09639138072313438`", ",", "0.18810152245356493`", ",", 
   "0.06435713497957868`", ",", "0.0836341957106208`", ",", 
   "0.18533562174754104`", ",", "0.12357050653987867`", ",", 
   "0.08460810736757918`", ",", "0.10019829402945343`", ",", 
   "0.14789677374625604`", ",", "0.09569714559225956`", ",", 
   "0.14206515418794236`", ",", "0.1472767505890127`", ",", 
   "0.08855280249422452`", ",", "0.04828166009056923`", ",", 
   "0.13592284996230636`", ",", "0.20002478368378507`", ",", 
   "0.0972448366083622`", ",", "0.06601769266656088`", ",", 
   "0.14618828157127983`", ",", "0.13849257371014512`", ",", 
   "0.03475197845009048`", ",", "0.01861504074851334`", ",", 
   "0.05575532552154029`", ",", "0.15900407038476377`", ",", 
   "0.07825033831965028`", ",", "0.13594079027270528`", ",", 
   "0.20661027136200327`", ",", "0.057961407400828904`", ",", 
   "0.1841583830913694`", ",", "0.12181543651481694`", ",", 
   "0.21966360310032934`", ",", "0.13156300772908908`", ",", 
   "0.08425383132839401`", ",", "0.3292897398045375`", ",", 
   "0.1619481872756428`", ",", "0.0716150822091418`", ",", 
   "0.1727793793838477`", ",", "0.09769320280225455`", ",", 
   "0.10613529544637687`", ",", "0.07084495330034739`", ",", 
   "0.2556894324313082`", ",", "0.06122064695328722`", ",", 
   "0.08854867056866009`", ",", "0.17755081272859874`", ",", 
   "0.17166053066769865`", ",", "0.08044936102825213`", ",", 
   "0.08546081945952075`", ",", "0.13704970360865149`", ",", 
   "0.13193666352718547`", ",", "0.19619787843406852`", ",", 
   "0.20437661701246124`", ",", "0.21180403209489915`", ",", 
   "0.07715783223984932`", ",", "0.12625315438924062`", ",", 
   "0.12480058335123373`", ",", "0.14600641227794686`", ",", 
   "0.1644189057028849`", ",", "0.31808183448016536`", ",", 
   "0.10507811774724735`", ",", "0.13986022704237266`", ",", 
   "0.1458893101537304`", ",", "0.0697722923068051`", ",", 
   "0.21212985590984834`", ",", "0.07434945931219794`", ",", 
   "0.1807994399670189`", ",", "0.103728032699199`", ",", 
   "0.11028426170189684`", ",", "0.10214746488009159`", ",", 
   "0.19017528643910644`", ",", "0.1437493707497764`", ",", 
   "0.04930452323281703`", ",", "0.056429443925957765`", ",", 
   "0.10178291241130275`", ",", "0.129537219924967`", ",", 
   "0.06838968404618896`", ",", "0.03491610194665304`", ",", 
   "0.1133097136305299`", ",", "0.06660152283452678`", ",", 
   "0.19432743831932556`", ",", "0.17431659521907514`", ",", 
   "0.20105876434586634`", ",", "0.10600859854382201`", ",", 
   "0.23917043050423756`", ",", "0.1789681064446137`", ",", 
   "0.09239738632911129`", ",", "0.1149118215415697`", ",", 
   "0.1710173559306119`", ",", "0.07788631439563808`", ",", 
   "0.06172405987767803`", ",", "0.10989639586914711`", ",", 
   "0.09408456291265915`", ",", "0.21722490100294975`", ",", 
   "0.14471174980633691`", ",", "0.07484790632417376`", ",", 
   "0.10923614573702958`", ",", "0.05435611163847529`", ",", 
   "0.13375609483645848`", ",", "0.10465382322636589`", ",", 
   "0.06413718796833859`", ",", "0.18451799102313862`", ",", 
   "0.2871139673868417`", ",", "0.31404778958611235`", ",", 
   "0.28854133891434736`", ",", "0.2115433406608273`", ",", 
   "0.07230793201620302`", ",", "0.09587189124939742`", ",", 
   "0.22312633158473713`", ",", "0.2330013279217762`", ",", 
   "0.17093677192297393`", ",", "0.12160610034329167`", ",", 
   "0.17864603985946015`", ",", "0.2693868062934418`", ",", 
   "0.2158695465535846`", ",", "0.5963181599898075`", ",", 
   "0.11336823608829694`", ",", "0.04044917464700369`", ",", 
   "0.16138068272002973`", ",", "0.08936920828982131`", ",", 
   "0.09855658242126072`", ",", "0.18203891851946172`", ",", 
   "0.17848125271304444`", ",", "0.13543390922185505`", ",", 
   "0.07577956159977607`", ",", "0.2351626374271376`", ",", 
   "0.08220698662337841`", ",", "0.13345056741887149`", ",", 
   "0.35863820732883234`", ",", "0.2519673282327764`", ",", 
   "0.13675189969239282`", ",", "0.17719908053147404`", ",", 
   "0.14639235592492314`", ",", "0.23447931686638213`", ",", 
   "0.3020527630096883`", ",", "0.1444444647342613`", ",", 
   "0.07328571043802523`", ",", "0.11040839501400983`", ",", 
   "0.15669936339171592`", ",", "0.43290055811212985`", ",", 
   "0.2016859552140934`", ",", "0.13727672937877008`", ",", 
   "0.12979918800661044`", ",", "0.3071010770130058`", ",", 
   "0.16352437427744496`", ",", "0.1964499537781037`", ",", 
   "0.31103096839574407`", ",", "0.04548412084515385`", ",", 
   "0.23892994807759832`", ",", "0.16171562141203233`", ",", 
   "0.1323661904838777`", ",", "0.33276867889954653`", ",", 
   "0.13052389928033953`", ",", "0.1261679283679055`", ",", 
   "0.1150810579506725`", ",", "0.18514105333243225`", ",", 
   "0.08181867817165112`", ",", "0.1285052156754667`", ",", 
   "0.1240157242210568`", ",", "0.2953554034567428`", ",", 
   "0.09249364582404263`", ",", "0.351120208951051`", ",", 
   "0.2163860188839684`", ",", "0.5655886506069309`", ",", 
   "0.08084008332036811`", ",", "0.06146141129034295`", ",", 
   "0.18228025626158512`", ",", "0.0535337191407583`", ",", 
   "0.1132308866313457`", ",", "0.4292064471095408`", ",", 
   "0.19312812334468374`", ",", "0.14445787927971457`", ",", 
   "0.2536535317846157`", ",", "0.1605347734001017`", ",", 
   "0.06030024849053642`", ",", "0.07860421624073893`", ",", 
   "0.3307964306136629`", ",", "0.12310933910837787`", ",", 
   "0.4237790518674874`", ",", "0.16838740194767268`", ",", 
   "0.09075144322257343`", ",", "0.3155998992639705`", ",", 
   "0.20985062821107844`", ",", "0.193964790897552`", ",", 
   "0.11763010442188411`", ",", "0.11970131016568972`", ",", 
   "0.1629902053082347`", ",", "0.16054675409447516`", ",", 
   "0.3313823847730881`", ",", "0.41884488748106696`", ",", 
   "0.24016443563251433`", ",", "0.13842064109317923`", ",", 
   "0.11412348185856852`", ",", "0.15528031226035044`", ",", 
   "0.1662122839119511`", ",", "0.10608747081847766`", ",", 
   "0.1649491299648364`", ",", "0.08854592624970611`", ",", 
   "0.1863259027713824`", ",", "0.2459078000135301`", ",", 
   "0.11346898661413518`", ",", "0.07683899252415341`", ",", 
   "0.14853616550062737`", ",", "0.14203827341469505`", ",", 
   "0.37643286029567774`", ",", "0.3382135769313676`", ",", 
   "0.22871387834880255`", ",", "0.11899281193793243`", ",", 
   "0.4177233091893118`", ",", "0.24165732330025583`", ",", 
   "0.2989428507053747`", ",", "0.2962232656575905`", ",", 
   "0.2543416383500794`", ",", "0.3034890243353129`", ",", 
   "0.24720376534619887`", ",", "0.19665683348918717`", ",", 
   "0.15947689905495302`", ",", "0.18512058543934629`", ",", 
   "0.049499618749742604`", ",", "0.18864116218190072`", ",", 
   "0.1874846020143614`", ",", "0.13334469138732244`", ",", 
   "0.18430292111508526`", ",", "0.16195970210421512`", ",", 
   "0.16771831510490093`", ",", "0.32611055793983956`", ",", 
   "0.1775342767800347`", ",", "0.2658070533237607`", ",", 
   "0.14554353406823664`", ",", "0.25453999007952416`", ",", 
   "0.19965669588432758`", ",", "0.12146901347767265`", ",", 
   "0.0943920912720834`", ",", "0.5382654887986351`", ",", 
   "0.2300608987311963`", ",", "0.09856617102221263`", ",", 
   "0.09555398195350567`", ",", "0.21936089238302134`", ",", 
   "0.3058258760567508`", ",", "0.11900509597688665`", ",", 
   "0.21485637300361454`", ",", "0.3550195131543925`", ",", 
   "0.26578475315363626`", ",", "0.13223590781022132`", ",", 
   "0.12378070827186868`", ",", "0.33081880889643994`", ",", 
   "0.2512582910079588`", ",", "0.10687263717856199`", ",", 
   "0.1481110080334775`", ",", "0.303457729144745`", ",", 
   "0.20116613859060217`", ",", "0.2851832146378805`", ",", 
   "0.2816149717909575`", ",", "0.23709046978313103`", ",", 
   "0.3043406326397944`", ",", "0.4356902409175765`", ",", 
   "0.31753276200296654`", ",", "0.20570219989527871`", ",", 
   "0.20279883053967102`", ",", "0.2959773562038679`", ",", 
   "0.09213634636557795`", ",", "0.18387585682983507`", ",", 
   "0.2137890039976814`", ",", "0.22683337938234643`", ",", 
   "0.284050959689482`", ",", "0.2982413677407678`", ",", 
   "0.24707155000192413`", ",", "0.17535873349238418`", ",", 
   "0.10711356541136166`", ",", "0.19365050595262212`", ",", 
   "0.09432457474737196`", ",", "0.19203539327265617`", ",", 
   "0.4236309365753252`", ",", "0.20641806604088936`", ",", 
   "0.12439888110468118`", ",", "0.19168982884147995`", ",", 
   "0.14940730479412248`", ",", "0.11916038195875045`", ",", 
   "0.1611233389996086`", ",", "0.3034055507943295`", ",", 
   "0.4118779361308542`", ",", "0.23294294658993542`", ",", 
   "0.13128397428201932`", ",", "0.14352013553730786`", ",", 
   "0.30456831970013254`", ",", "0.12523757027161692`", ",", 
   "0.577617119068293`", ",", "0.28315006111493857`", ",", 
   "0.37129542526474857`", ",", "0.2147752196136668`", ",", 
   "0.5293443511749738`", ",", "0.43174543445925384`", ",", 
   "0.27935443560433687`", ",", "0.2132996372505298`", ",", 
   "0.4425641496138326`", ",", "0.12444187098119966`", ",", 
   "0.09070935387546207`", ",", "0.22849240627379783`", ",", 
   "0.14119597236138434`", ",", "0.09828810912575292`", ",", 
   "0.2026072554717238`", ",", "0.5094923669292961`", ",", 
   "0.08960427277837707`", ",", "0.2515070303907859`", ",", 
   "0.5371247683672076`", ",", "0.23517497007502847`", ",", 
   "0.16489302209215867`", ",", "0.07854533514017775`", ",", 
   "0.22383159164239813`", ",", "0.22868575888960718`", ",", 
   "0.13583261892679432`", ",", "0.2916066997086527`", ",", 
   "0.7616049453071649`", ",", "0.2671974977202797`", ",", 
   "0.31057274510909433`", ",", "0.20160618571334116`", ",", 
   "0.3183170810334037`", ",", "0.3960824648714944`", ",", 
   "0.2763349901009574`", ",", "0.09951509978098572`", ",", 
   "0.24303974501868336`", ",", "0.0671471360959728`", ",", 
   "0.24460563230839305`", ",", "0.20655664329450907`", ",", 
   "0.13963841207671526`", ",", "0.39473131034055353`", ",", 
   "0.273751810050996`", ",", "0.27311090906755575`", ",", 
   "0.18779726235558097`", ",", "0.19101384421870105`", ",", 
   "0.4033150856623977`", ",", "0.16616165777117659`", ",", 
   "0.2991961451755978`", ",", "0.64152826545346`", ",", 
   "0.3309502350723463`", ",", "0.28101736364831953`", ",", 
   "0.43705162877048365`", ",", "0.41171669041201714`", ",", 
   "0.4181092400936001`", ",", "0.13784216106982206`", ",", 
   "0.17548062824846813`", ",", "0.2790503966687894`", ",", 
   "0.5433760257883838`", ",", "0.056479112378116036`", ",", 
   "0.3822050972930593`", ",", "0.251406181473846`", ",", 
   "0.1398804550461955`", ",", "0.13354511377679393`", ",", 
   "0.33088839771322875`", ",", "0.5633603186870694`", ",", 
   "0.23185888591899478`", ",", "0.22998024115096782`", ",", 
   "0.1663442331048257`", ",", "0.5218978787768377`", ",", 
   "0.17462745309800454`", ",", "0.3432765870089884`", ",", 
   "0.38457152834470454`", ",", "0.2586980165458842`", ",", 
   "0.2326584031606605`", ",", "0.20326140200958634`", ",", 
   "0.18830432923583168`", ",", "0.35014123085115045`", ",", 
   "0.4681649732839842`", ",", "0.2913008212571645`", ",", 
   "0.22844987032697808`", ",", "0.22359924518035124`", ",", 
   "0.5626097854570711`", ",", "0.17151554925478044`", ",", 
   "0.20478278406725917`", ",", "0.40229083458350956`", ",", 
   "0.2006678072681285`", ",", "0.5144320434635721`", ",", 
   "0.30881339316922213`", ",", "0.38176388346219176`", ",", 
   "0.12176528885901022`", ",", "0.2830256503325334`", ",", 
   "0.5511235812177284`", ",", "0.23463143822822322`", ",", 
   "0.30075214365691383`", ",", "0.6511986277257265`", ",", 
   "0.40460148472310437`", ",", "0.18456775141297693`", ",", 
   "0.5787614429754784`", ",", "0.40044388953595805`", ",", 
   "0.5390392558235237`", ",", "0.20351055935070883`", ",", 
   "0.46154697875260586`", ",", "0.4510146843575957`", ",", 
   "0.2361488035887666`", ",", "0.36240406292200317`", ",", 
   "0.3081501324352867`", ",", "0.2644075323256286`", ",", 
   "0.5143248647328813`", ",", "0.6831265470309437`", ",", 
   "0.2220403617866122`", ",", "0.4255169465674765`", ",", 
   "0.6377704770183044`", ",", "0.4879126643511125`", ",", 
   "0.12111054243187455`", ",", "0.6890894520203528`", ",", 
   "0.07125764398061768`", ",", "0.25754647649955037`", ",", 
   "0.2760144153509719`", ",", "0.3927413233234956`", ",", 
   "0.5837166522521329`", ",", "0.3728544326841824`", ",", 
   "0.11724406696386834`", ",", "0.34037040696838666`", ",", 
   "0.33136070502336845`", ",", "0.4462221963805874`", ",", 
   "0.3292385735587013`", ",", "0.5006954755055978`", ",", 
   "0.16893739710728856`", ",", "0.14086661448358684`", ",", 
   "0.4173966340719991`", ",", "0.44622449598318803`", ",", 
   "0.2668876973223163`", ",", "0.10607472677040466`", ",", 
   "0.4792990434815673`", ",", "0.32281539990827696`", ",", 
   "0.2866939836154767`", ",", "0.5154716344225527`", ",", 
   "0.07077690309267093`", ",", "0.6167452901431972`", ",", 
   "0.7171802732935983`", ",", "0.2796354537445306`", ",", 
   "0.2729895109575626`", ",", "0.46979950103018264`", ",", 
   "0.1898828192311727`", ",", "0.5330343900778407`", ",", 
   "0.40189727403876985`", ",", "0.15899744781172592`", ",", 
   "0.18784947168581234`", ",", "0.6097912126413785`", ",", 
   "0.266490172788499`", ",", "0.577254439273915`", ",", 
   "0.4869446509984827`", ",", "0.28414670684344834`", ",", 
   "0.21492297717427167`", ",", "0.17395543007400394`", ",", 
   "0.07301378838148631`", ",", "0.32158454517127155`", ",", 
   "0.30157635447647857`", ",", "0.5217459401027111`", ",", 
   "0.31752457164615056`", ",", "0.3699117651189967`", ",", 
   "0.4762990309658731`", ",", "0.41166161809827106`", ",", 
   "0.5393878954096001`", ",", "0.25319347772636736`", ",", 
   "0.34623582503833383`", ",", "0.6272684175870378`", ",", 
   "0.32622994877757877`", ",", "0.3768355660365454`", ",", 
   "0.6572369889354869`", ",", "0.36520339557911363`", ",", 
   "0.6291314530029302`", ",", "0.31423952734027755`", ",", 
   "0.3442352163879855`", ",", "0.31706550100771713`", ",", 
   "0.16633092245772615`", ",", "0.5499229126396663`", ",", 
   "0.42812605904125883`", ",", "0.20734172592523037`", ",", 
   "0.5109062848268968`", ",", "0.363470114633478`", ",", 
   "0.33190656344078284`", ",", "0.8709280498060973`", ",", 
   "0.6444962134143257`", ",", "0.3534318879646903`", ",", 
   "0.37252646806171713`", ",", "0.18913801403805147`", ",", 
   "0.1411234511290762`", ",", "0.6393028804366758`", ",", 
   "0.3739461581681105`", ",", "0.3662016752971924`", ",", 
   "0.30490579599635925`", ",", "0.6228592493504058`", ",", 
   "0.5539457283648358`", ",", "0.4908767967979284`", ",", 
   "0.37867679183799935`", ",", "0.5761229458296462`", ",", 
   "0.9155405465698857`", ",", "0.3281878668656336`", ",", 
   "0.2886426190076721`", ",", "0.36267898954037564`", ",", 
   "0.4187208972714466`", ",", "0.48793586802277805`", ",", 
   "0.41871622384853224`", ",", "0.1470596914331359`", ",", 
   "0.27673798441602987`", ",", "0.2502719321258542`", ",", 
   "0.5288197152335152`", ",", "0.32019407012835616`", ",", 
   "0.6649052314622307`", ",", "0.2998296113063635`", ",", 
   "0.6015527653136964`", ",", "0.33855900918135673`", ",", 
   "0.0838074006200815`", ",", "0.1532685328418948`", ",", 
   "0.6712009607543963`", ",", "0.6871436740207231`", ",", 
   "0.6109301565384628`", ",", "0.7077309986336088`", ",", 
   "0.5470789538835271`", ",", "0.39744567310802265`", ",", 
   "0.50088812269652`", ",", "0.8373819614882964`", ",", 
   "0.6495984667868762`", ",", "0.6177247328339379`", ",", 
   "0.755393413404029`", ",", "0.21635331956809928`", ",", 
   "0.6026730150023316`", ",", "0.20823212997146137`", ",", 
   "0.2271250465852889`", ",", "0.2571328173048365`", ",", 
   "0.419133173973001`", ",", "0.9740613457136614`", ",", 
   "0.9485486272071646`", ",", "0.2981063943826119`", ",", 
   "0.3019262996539104`", ",", "1.0156857877337448`", ",", 
   "0.4443507320755974`", ",", "0.5152412752179938`", ",", 
   "0.593727423298564`", ",", "0.3150699290401147`", ",", 
   "0.3310797302814294`", ",", "1.0869616833013862`", ",", 
   "0.24117436641945056`", ",", "0.6944926395600564`", ",", 
   "0.37344532177900225`", ",", "0.31325806248555227`", ",", 
   "0.8739933861444692`", ",", "0.3910971132296516`", ",", 
   "1.1126843079281798`", ",", "0.39179411243639106`", ",", 
   "0.5078438849708112`", ",", "0.18187500299293702`", ",", 
   "0.3064121331454849`", ",", "0.4608920131839376`", ",", 
   "0.6264680830893248`", ",", "0.6638575951302033`", ",", 
   "0.2512189370849718`", ",", "0.19125473445532426`", ",", 
   "0.4047346080931288`", ",", "0.281112188109371`", ",", "0.87784165159568`",
    ",", "0.6423348192676496`", ",", "1.0453159682616546`", ",", 
   "0.3595987611273501`", ",", "0.28977439272173194`", ",", 
   "1.0745573147430474`", ",", "0.19349422306828595`", ",", 
   "0.15114856502608298`", ",", "0.3457546443249056`", ",", 
   "0.9481074690240847`", ",", "0.5728291915426453`", ",", 
   "0.3995612498036895`", ",", "0.3410063426712722`", ",", 
   "0.4412899331312806`", ",", "0.2076695143674983`", ",", 
   "0.6777216965330878`", ",", "0.12076063924331595`", ",", 
   "0.23039458322568024`", ",", "0.6748451455158463`", ",", 
   "0.5361417889776359`", ",", "0.29720366408466276`", ",", 
   "0.6798625374387254`", ",", "0.8192494553295784`", ",", 
   "0.38499989464834533`", ",", "0.536575086854581`", ",", 
   "0.6025347590888119`", ",", "0.24707980860990408`", ",", 
   "0.264009826108123`", ",", "0.3364781314052087`", ",", 
   "0.4724111729498023`", ",", "0.6597554054414484`", ",", 
   "0.3321579630136192`", ",", "0.12153022527442013`", ",", 
   "0.8535984460167327`", ",", "0.7840700280585908`", ",", 
   "0.2875824849337687`", ",", "1.1723686701554425`", ",", 
   "0.3288647765832636`", ",", "0.22561860183210453`", ",", 
   "0.24334400947895993`", ",", "0.7005729301627169`", ",", 
   "0.3525176252087495`", ",", "0.7164278467409033`", ",", 
   "0.2574663878399571`", ",", "1.1785004152607812`", ",", 
   "0.6736133650222659`", ",", "0.5010097462443772`", ",", 
   "0.5352586002640567`", ",", "0.47887720739944467`", ",", 
   "0.72600354268114`", ",", "0.32088745355471543`", ",", 
   "0.36095839753224285`", ",", "1.0100109708769534`", ",", 
   "0.19475690874298354`", ",", "1.0633867441783056`", ",", 
   "0.488031590689185`", ",", "0.3927858243191387`", ",", 
   "0.18800164396561503`", ",", "0.6311033541677344`", ",", 
   "1.4192379349561481`", ",", "0.46507366388578336`", ",", 
   "1.168484441427444`", ",", "1.2289384916466874`", ",", 
   "0.5327879539383313`", ",", "0.1763742565509015`", ",", 
   "1.4106548076320666`", ",", "0.4539643464232539`", ",", 
   "0.8967511242238273`", ",", "1.0260401446500576`", ",", 
   "0.5170233567001669`", ",", "0.36862994805936`", ",", 
   "0.17355936936275662`", ",", "0.7679044481055273`", ",", 
   "1.134634858265404`", ",", "0.6214075123667003`", ",", 
   "0.916025395751829`", ",", "0.8525735377916157`", ",", 
   "0.5297677617292714`", ",", "0.2540088572680482`", ",", 
   "1.4379340075981393`", ",", "0.845330431533486`", ",", 
   "0.5430113002245516`", ",", "0.8320532538794138`", ",", 
   "1.4924466453438745`", ",", "0.5231902730993909`", ",", 
   "0.4152249071165854`", ",", "0.7759408420923037`", ",", 
   "0.8608319009408011`", ",", "0.7111885988596577`", ",", 
   "0.40731795390664427`", ",", "0.9641774382829972`", ",", 
   "0.6040530627759161`", ",", "0.9215588527964957`", ",", 
   "0.7167583786267772`", ",", "1.011717710524778`", ",", 
   "0.7886297966155174`", ",", "2.017490581446836`", ",", 
   "0.920371573366324`", ",", "0.7035147640429875`", ",", 
   "0.49787632084817635`", ",", "1.0081905689235586`", ",", 
   "0.5584865699812926`", ",", "1.5897955290099344`", ",", 
   "0.71482536014979`", ",", "0.6126521748830696`", ",", 
   "0.6548360111184311`", ",", "0.8899588773161301`", ",", 
   "0.28131047384874036`", ",", "0.8067062740957867`", ",", 
   "0.46085529296679806`", ",", "0.7611715905931029`", ",", 
   "0.6751343167165875`", ",", "0.6633559287341321`", ",", 
   "0.9195305022250673`", ",", "0.8957512257768027`", ",", 
   "0.32965654787833376`", ",", "0.6185145642772529`", ",", 
   "0.8209373514163285`", ",", "0.7126836771278562`", ",", 
   "1.0073968023259823`", ",", "1.1924994819211452`", ",", 
   "0.606015499016451`", ",", "1.2414244469269164`", ",", 
   "0.7547164740343888`", ",", "2.238481250860746`", ",", 
   "1.1091125570442493`", ",", "0.9779452505864438`", ",", 
   "0.8277422981910533`", ",", "0.8554906047079738`", ",", 
   "1.5446657882585564`", ",", "2.0074334424136153`", ",", 
   "2.5878589952511826`", ",", "0.5482818627258774`", ",", 
   "1.1534580350829213`", ",", "2.9939684619410007`", ",", 
   "1.6078217037328284`", ",", "1.9004708163941646`", ",", 
   "0.7504802596780125`", ",", "1.4154059784413322`", ",", 
   "1.0807966436948158`", ",", "0.6363757206642978`", ",", 
   "1.8175302732937761`", ",", "3.106925343575939`", ",", 
   "3.383890253175544`", ",", "1.5756583234701662`"}], "}"}]], "Output",
 CellChangeTimes->{{3.885576912219183*^9, 3.885576924614328*^9}, 
   3.885577063219441*^9, 3.8855770943552923`*^9, 3.8940499442275667`*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"5cd0463c-8713-4a98-9671-9cce65948541"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "diststotightboundsfp", "]"}]], "Input",
 CellChangeTimes->{{3.885575630970728*^9, 3.885575672193831*^9}, {
  3.885576022438196*^9, 3.885576022850524*^9}, {3.885576962521472*^9, 
  3.8855769626783743`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"8610105e-99f0-4bfc-a3c1-7d125596fed9"],

Cell[BoxData["0.3000732199385131`"], "Output",
 CellChangeTimes->{{3.8855756382977877`*^9, 3.885575672699491*^9}, 
   3.8855758248142767`*^9, 3.885576023766778*^9, 3.885576972980259*^9, 
   3.885577096282693*^9, 3.894049944263707*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"cb0ab842-5c16-42e5-bcd6-ed26ac217b68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "diststotightboundsfp", "]"}]], "Input",
 CellChangeTimes->{{3.8855756810628567`*^9, 3.885575685736298*^9}, {
  3.885576027379064*^9, 3.885576027800918*^9}, {3.8855769662216053`*^9, 
  3.885576966340645*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"fdb5c0f6-2c73-44bf-aea4-258f1c15d1b1"],

Cell[BoxData["0.3463838941653559`"], "Output",
 CellChangeTimes->{3.885575686182197*^9, 3.885575825573269*^9, 
  3.885576028161909*^9, 3.885576971421363*^9, 3.885577097699016*^9, 
  3.894049944299684*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"02899b4a-06bf-476b-a040-a4075b7058e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quartiles", "[", "diststotightboundsfp", "]"}]], "Input",
 CellChangeTimes->{{3.885575692195689*^9, 3.885575695626602*^9}, {
  3.8855760332063427`*^9, 3.8855760336390133`*^9}, {3.885576969039761*^9, 
  3.8855769691408043`*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"9283b3f8-481d-4036-953d-a772df44778f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.09470286217226778`", ",", "0.18493356944048306`", ",", 
   "0.3732975995052973`"}], "}"}]], "Output",
 CellChangeTimes->{3.885575695985567*^9, 3.8855758306962233`*^9, 
  3.885576034028821*^9, 3.885576969846175*^9, 3.885577098714428*^9, 
  3.894049944327745*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"5db8267b-5543-439d-bd4d-4911550293db"]
}, Open  ]],

Cell[TextData[StyleBox["Scatter Plots", "Subsection"]], "Text",
 CellChangeTimes->{{3.8822901020928097`*^9, 
  3.882290118534096*^9}},ExpressionUUID->"d6439e93-e358-4d59-b506-\
d4acb696c1ab"],

Cell[TextData[StyleBox["Accuracy of optimal report against distance of fixed \
point to uniform ", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.8840123046207733`*^9, 3.884012320872609*^9}, {
  3.884012367881872*^9, 
  3.884012381625038*^9}},ExpressionUUID->"1f210c38-852d-4655-b049-\
a7f494cc73da"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subdata24", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884011918838072*^9, 3.8840119264757957`*^9}, {
  3.884522356134788*^9, 3.884522358148755*^9}, {3.885554222156242*^9, 
  3.885554222414811*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"5ae7840b-63f1-4362-b9ed-75cfe762febd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minx", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata24", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884013243159874*^9, 3.884013322107534*^9}, {
  3.884522362161368*^9, 3.8845223622110023`*^9}, {3.88555422381676*^9, 
  3.885554224074088*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"a6a0702c-e4e1-4943-a491-b9a4c2f732cf"],

Cell[BoxData["0.026943291149959466`"], "Output",
 CellChangeTimes->{3.884013385253646*^9, 3.884013650779702*^9, 
  3.884013725989493*^9, 3.8840144770456877`*^9, 3.884015626778102*^9, 
  3.884016830819841*^9, 3.884017466824724*^9, 3.8845223816227427`*^9, 
  3.884996442709096*^9, 3.885214272959683*^9, 3.8852184726920023`*^9, 
  3.885285906620566*^9, 3.8854149154864283`*^9, 3.885502613680628*^9, 
  3.885513526274996*^9, 3.885554137588159*^9, 3.885554348003549*^9, 
  3.885566088072733*^9, 3.8855680962552557`*^9, 3.885569251415495*^9, 
  3.894049944368658*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"ffd66cb9-c1d4-4e99-b8f3-a8ef90794770"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxx", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata24", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.88452236395507*^9, 3.8845223640857067`*^9}, {
  3.8855542252909613`*^9, 3.885554225487494*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"3a1179e9-988c-474e-b095-2fce78f18317"],

Cell[BoxData["0.5863750302587638`"], "Output",
 CellChangeTimes->{3.884013385303389*^9, 3.884013650825342*^9, 
  3.884013726036738*^9, 3.884014477741612*^9, 3.884015626825495*^9, 
  3.884016830869611*^9, 3.884017466861472*^9, 3.884522382420033*^9, 
  3.884996443595525*^9, 3.885214272973359*^9, 3.8852184727106543`*^9, 
  3.885285906635055*^9, 3.885414915675766*^9, 3.885502613799733*^9, 
  3.88551352635935*^9, 3.885554137634907*^9, 3.885554348023052*^9, 
  3.885566088099526*^9, 3.885568096941957*^9, 3.8855692520956173`*^9, 
  3.894049944403646*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"ca17e2aa-0266-41af-8209-8700aa06fc59"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"miny", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata24", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143318092823`*^9, 3.884014344525115*^9}, {
  3.8845223655848923`*^9, 3.884522365687346*^9}, {3.885554227239566*^9, 
  3.885554227436407*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"f28775d2-c99f-4137-8c54-e7b3320ab2af"],

Cell[BoxData["0.0018353896604334995`"], "Output",
 CellChangeTimes->{3.884014355277335*^9, 3.88401447844201*^9, 
  3.8840156268698597`*^9, 3.884016830912118*^9, 3.8840174668976517`*^9, 
  3.884522383274045*^9, 3.8849964444074173`*^9, 3.885214272988819*^9, 
  3.8852184727317963`*^9, 3.885285906649284*^9, 3.885414915849107*^9, 
  3.8855026139392767`*^9, 3.885513526512097*^9, 3.885554137682509*^9, 
  3.885554348053356*^9, 3.8855660881268597`*^9, 3.8855680975868597`*^9, 
  3.88556925280265*^9, 3.894049944438847*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"cc7edce9-1113-471e-a0c7-0b93a756ccaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxy", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata24", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143501700583`*^9, 3.8840143533427343`*^9}, {
  3.88452236761937*^9, 3.8845223677041073`*^9}, {3.8855542317634153`*^9, 
  3.8855542320012817`*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"2040d380-e350-43df-8111-705037320099"],

Cell[BoxData["0.4215186828599653`"], "Output",
 CellChangeTimes->{3.8840143559614563`*^9, 3.884014479136077*^9, 
  3.8840156269152927`*^9, 3.884016830959639*^9, 3.884017466930704*^9, 
  3.884522384033804*^9, 3.884996445327873*^9, 3.885214272996232*^9, 
  3.885218472752542*^9, 3.885285906662998*^9, 3.885414916077819*^9, 
  3.8855026139713306`*^9, 3.88551352661092*^9, 3.885554137726475*^9, 
  3.885554348072886*^9, 3.88556608815366*^9, 3.8855680982831907`*^9, 
  3.8855692535520153`*^9, 3.8940499444736843`*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"af3f3474-7ad5-4866-a543-4c43fd616147"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trend", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"subdata24", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840119053884897`*^9, 3.884011933703392*^9}, {
  3.8840120521962643`*^9, 3.884012052730195*^9}, {3.8845223732176533`*^9, 
  3.884522373340232*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"3fd8a46c-11f2-48ca-916e-0a4e2ed4b6d2"],

Cell[BoxData[
 RowBox[{"0.02797416456322746`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.4378925269299`", " ", "x"}]}]], "Output",
 CellChangeTimes->{3.8840119448526773`*^9, 3.8840120551812696`*^9, 
  3.8840128508319197`*^9, 3.884013385316222*^9, 3.88401365087146*^9, 
  3.8840137260900393`*^9, 3.884014479923321*^9, 3.88401562696446*^9, 
  3.884016831009397*^9, 3.884017466971765*^9, 3.884522384727212*^9, 
  3.884996446187923*^9, 3.885214273011602*^9, 3.885218472773758*^9, 
  3.885285906677165*^9, 3.885414916434306*^9, 3.885502614113351*^9, 
  3.88551352672644*^9, 3.8855541378513308`*^9, 3.8855543481041813`*^9, 
  3.885566088181212*^9, 3.885568099171481*^9, 3.885569254796466*^9, 
  3.8940499445080442`*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"8aed541d-1c5a-482b-bbd9-260d6eda567a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Correlation", "[", "subdata24", "]"}]], "Input",
 CellChangeTimes->{{3.885570426473235*^9, 3.885570430808814*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"9947c43f-9abd-4455-b460-acdbadf88111"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999997`", ",", "0.37550916678898166`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.37550916678898166`", ",", "1.000000000000003`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.885570431554878*^9, 3.894049944543088*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"1319459a-105f-49a1-9fe2-8d5cc46b3c2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "@", "trend"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"minx", "-", "0.05"}], ",", 
         RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minx", "-", "0.05"}], ",", 
            RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"miny", "-", "0.05"}], ",", 
            RowBox[{"maxy", "+", "0.05"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TraditionalForm", "[", 
           RowBox[{"Norm", "[", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<p^*-uniform\>\"", ",", "TeXForm", ",", "HoldForm"}],
              "]"}], "]"}], "]"}], ",", "\"\<||f(p)-p||\>\""}], "}"}]}]}], 
      "]"}], ",", 
     RowBox[{"ListPlot", "[", "subdata24", "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882192696300736*^9, 3.882192700311585*^9}, {
   3.882195533785142*^9, 3.882195533944455*^9}, {3.882287808996023*^9, 
   3.8822878997355423`*^9}, {3.882287979342745*^9, 3.882288014377759*^9}, {
   3.884011926003563*^9, 3.884011929283166*^9}, {3.884012110721346*^9, 
   3.884012138083975*^9}, {3.884012181411414*^9, 3.88401223960191*^9}, {
   3.884012283054537*^9, 3.884012287357141*^9}, 3.8840126847719727`*^9, {
   3.884013395290963*^9, 3.884013406303516*^9}, {3.8840136104565277`*^9, 
   3.884013612235993*^9}, 3.884013700314098*^9, {3.884014092968576*^9, 
   3.884014119033299*^9}, {3.884014430462318*^9, 3.884014457199595*^9}, {
   3.88401449238861*^9, 3.884014494370552*^9}, {3.884014530552906*^9, 
   3.884014548292404*^9}, 3.884015481701353*^9, {3.8845223757656193`*^9, 
   3.884522375861189*^9}, {3.885567835655208*^9, 3.885567866034699*^9}, {
   3.8855680377876997`*^9, 3.8855680378733683`*^9}, 3.885568079124205*^9},
 CellLabel->
  "In[105]:=",ExpressionUUID->"cb73a2b9-4eb1-42d7-9fe1-30ef7c8020e9"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVj3s0lAkAR1UWUWlbqdTaZVZyEso79Cs1RR5ZjZAo1DobE1rNKKnN0AM1
GoxYx2ARJoXyWjSe0zTkMZ9iJUbzHVNYUVMqLdv+cc/9755z9YLCPU8sVlJS
cvvK//4YfTvfODtD0DFxMJ7tzkFjKFtvU0iGoM+ltEd4goO4AGYuZVuGYJiv
9P38eQ6W79mXoyPiCqZDy6rC+Bzoa8oz1RTpAu1JFbmzWipcCzfeJF3SBMcm
65yVW1LB6y28mD2XIvgw+YPmWct0JNOc6tZWxwv0piYygzbcwg2LqCnF8ghc
YGZFmoXkQNQuydh16ibUG5c38Sj5iGGu5hSm5yBV4tg9plyId2ou4bb0IuRu
ZoH/UzGE3ARm4+oyODUbu6zU5ONccrhWzMZKRGWN1ry1vounSTwaKqrwhkU9
pF5Sjov8TuqqhVq8HXDPCV1fCW/qtSSkNaC2+wVXo+w+Yhcc42ImBeg4rvdi
jlIFxRzK32Q2Y373UXlSajVgWfTYPbAVM236+Yf1a3F/PtHOUr0d5mRW6Vlu
HXYk1PSLnglhU3gruN+oHuOlhSHTWSL4ladI+6oa0HhslQdvpxgdvg58fcOH
KCaEQXNLO7FQEL7xXo0Adc8+PRl+8AQ79/Fn27lNeMmNCg5ndUOaHPjgYGAz
tGN8Pjwu6AFnVuvg1k0t6H5rKedF9+JkRf7amtEWfOdsTXcNkEDf/jerodJW
hMqZvAYLAou0dWNKfmkDzSuz44NKH2a0hHlC3XaI8oaTVSf60EyW/8gaa4eH
VfDn54KnqF3CEMpzhQgu0fj3ctEzsN/Ftk2cfATVybRPc1f7wVBjFWCrCAKG
f77FkQEkhAXx7cZFWCJ1lu7e9TfO5MWr91c+xuGbZ8TaawaRZHApReeUGI6r
4u7efzWIiq5zH8sMOlAdWWlo2PkctU41tdLJDjis03cLyB3C2LddvPqiTnjw
qlTDLr/Ae77hiGXEEzDoV085+A9jc7of1ce4C1s07LsHTEcQ8WfydTHZhdrW
a0EG6lJw45RMhu50gzRIN2+KkuK0z+3PYvMeeDG3Hdj7Sgr1gfDE2Vs9YJs1
hVT4jsJo3ErD9UsPiOv0QxdaRzFECeUpfHrhP3iHbWX1EkrCppGwxl5MizV4
HnkvUc1mmduul8CV4sc/oC6DYmJP9BamBFMn7RdvPy9DQbnhrzODEmQecjC9
PCbDWDaTvtSGQLFiBXHslQwm49s2lNgSqOZIGXbjMkRZT4md7AhIulgPp/+R
YbHk+KarOwho7BO7+b2XQVfVU6ZCJRBr7R1mpkyCFmnsq+xJIHBtZMmgHokW
6uiehVACEdWOblUUEmqp2e9y6AQu0LRm2AYkPKTe+TvCCWSl1NhQjUgMneta
iD1NgFCbf3TPjMTHe/V/fYkmQP2UOBYPEiY6XLPPCQRoGUcSj+4iwQj5eSTz
CoEgSxOT7btJNDxYdsP22td+ZO+ZN3tJ7D/AmohOJlDzes03h91JHI+PKJrl
EBBeeV1s4UHiTu9mr4w0An0G9a6aniQUuvIl1lwC04EBaW1eJH6v8w9kZBKY
XzC14XmTEKqsW6n9B4FlOYuGzvqSWEHre1iVTUDHnrhI8/v6n8eme+UQMBos
oJj6k8ie2r/hPY/Af8a0cxg=
        "]]},
      Annotation[#, "Charting`Private`Tag$826309#1"]& ]}, {}}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVl3c81X8fhlMZJUKKCoUkoyiSim6KKDIrq2X0a5CQooyMQpJdRPbezrG3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      "]]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      TagBox[
       FormBox[
        TemplateBox[{
          TagBox[
           RowBox[{
             SuperscriptBox["p", "*"], "-", "uniform"}], HoldForm]}, "Norm"], 
        TraditionalForm], TraditionalForm, Editable -> True], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox["\"||f(p)-p||\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->300,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.023056708850040537`, 
   0.6363750302587639}, {-0.0481646103395665, 0.4715186828599653}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.884012196029457*^9, 3.884012240295251*^9, 3.884012288198164*^9, 
   3.8840128509364443`*^9, {3.884013385395379*^9, 3.884013407088152*^9}, {
   3.884013650966929*^9, 3.884013659359556*^9}, 3.8840137262198553`*^9, {
   3.884014083284018*^9, 3.884014119553261*^9}, {3.884014457966527*^9, 
   3.884014480658473*^9}, {3.884014522785919*^9, 3.88401454976902*^9}, 
   3.884015627040113*^9, 3.884016831107782*^9, 3.884017467074411*^9, 
   3.884522385808362*^9, 3.884996447480482*^9, 3.8852142730898857`*^9, 
   3.8852184728271103`*^9, 3.885285907213256*^9, 3.885414917404687*^9, 
   3.8855026143391113`*^9, 3.885513526931828*^9, 3.885554138197946*^9, 
   3.885554348228578*^9, 3.885566090711013*^9, 3.885568039523408*^9, {
   3.885568080710622*^9, 3.885568100970427*^9}, 3.8940499451475887`*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"248d00a7-28c2-4206-b886-495e5e79a0c9"]
}, Open  ]],

Cell[TextData[StyleBox["Distance of optimal report to fixed point against \
distance of fixed point to uniform", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.884012393812606*^9, 
  3.8840124313477373`*^9}},ExpressionUUID->"6793148c-c7ec-43d2-9ab7-\
8e1d3a80fa81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subdata23", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8840125025071507`*^9, 3.8840125083027573`*^9}, {
  3.8845223178825808`*^9, 3.884522320337839*^9}, {3.885554242048232*^9, 
  3.885554242265505*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"1dd9c4a6-ca4b-4cba-9239-a5e2d3ee4369"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minx", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata23", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884013315814835*^9, 3.8840133162370853`*^9}, {
  3.884522325840185*^9, 3.884522325964531*^9}, {3.885554243886466*^9, 
  3.885554244109933*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"c19bb5f4-66b6-4e1d-a602-6dc3ee7688ac"],

Cell[BoxData["0.026943291149959466`"], "Output",
 CellChangeTimes->{3.884013385472114*^9, 3.884013651086718*^9, 
  3.884013726329211*^9, 3.884015291809607*^9, 3.884015627143826*^9, 
  3.884016831224866*^9, 3.8840174671724243`*^9, 3.884996458842105*^9, 
  3.88521427313166*^9, 3.8852184728560047`*^9, 3.885285937235476*^9, 
  3.885414917826275*^9, 3.885502614607554*^9, 3.88551352706247*^9, 
  3.8855541382757883`*^9, 3.885554348306951*^9, 3.885566090923218*^9, 
  3.885567932428629*^9, 3.885569325708459*^9, 3.894049945173417*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"18ae9ae0-b5fb-40fd-999a-4ca1ed841fca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxx", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata23", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884522327762705*^9, 3.8845223278481617`*^9}, {
  3.8855542455699987`*^9, 3.8855542457847443`*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"012f849d-14c7-42c8-bb66-7268266e6f9a"],

Cell[BoxData["0.5863750302587638`"], "Output",
 CellChangeTimes->{3.884013385518179*^9, 3.884013651139813*^9, 
  3.884013726341441*^9, 3.884015292678733*^9, 3.884015627183591*^9, 
  3.884016831268537*^9, 3.884017467209475*^9, 3.884996459564177*^9, 
  3.885214273161633*^9, 3.885218472878804*^9, 3.8852859372512836`*^9, 
  3.88541491801849*^9, 3.885502614726647*^9, 3.885513527160398*^9, 
  3.885554138320403*^9, 3.885554348327577*^9, 3.8855660909582653`*^9, 
  3.885567933103986*^9, 3.885569326420035*^9, 3.894049945201324*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"899f29e4-0986-49ef-81bf-a0a562197b37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"miny", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata23", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143318092823`*^9, 3.884014344525115*^9}, {
  3.884522330149189*^9, 3.8845223303019648`*^9}, {3.885554248609065*^9, 
  3.885554248808703*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"2f91c725-a7cf-4e26-9f50-0fe01fe504df"],

Cell[BoxData["0.0017994015254177887`"], "Output",
 CellChangeTimes->{
  3.884014355277335*^9, 3.88401447844201*^9, {3.884015285416799*^9, 
   3.8840152934026213`*^9}, 3.8840156272300787`*^9, 3.884016831308136*^9, 
   3.884017467248816*^9, 3.884805516057988*^9, 3.884996460270834*^9, 
   3.885214273191942*^9, 3.885218472901113*^9, 3.885285937266912*^9, 
   3.885414918267757*^9, 3.885502614854932*^9, 3.885513527262021*^9, 
   3.8855541383610287`*^9, 3.885554348347144*^9, 3.885566090987185*^9, 
   3.885567933744515*^9, 3.885569327056229*^9, 3.894049945232278*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"459e44f9-126f-41e3-bf5c-3d3944ca9e8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxy", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata23", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143501700583`*^9, 3.8840143533427343`*^9}, {
  3.8845223362870502`*^9, 3.884522336483692*^9}, {3.8855542502884903`*^9, 
  3.885554250480667*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"f9b8a4a2-ee72-4337-b220-b75af31a7ddc"],

Cell[BoxData["0.9560302982659838`"], "Output",
 CellChangeTimes->{
  3.8840143559614563`*^9, 3.884014479136077*^9, {3.8840152862672358`*^9, 
   3.884015294230492*^9}, 3.8840156272764673`*^9, 3.8840168313240557`*^9, 
   3.884017467285602*^9, 3.884996461025445*^9, 3.885214273210681*^9, 
   3.885218472921637*^9, 3.8852859372827797`*^9, 3.885414918334524*^9, 
   3.885502614898552*^9, 3.8855135273725967`*^9, 3.8855541384045353`*^9, 
   3.8855543483661737`*^9, 3.8855660910161*^9, 3.8855679344410887`*^9, 
   3.8855693279130707`*^9, 3.894049945261323*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"e1ff38b7-0c6f-4f24-ab92-b2885ffb02b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trend", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"subdata23", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840119053884897`*^9, 3.884011933703392*^9}, {
  3.8840120521962643`*^9, 3.884012052730195*^9}, {3.88452233841498*^9, 
  3.8845223385112667`*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"cf51cffa-bf90-4d46-ab58-7b12be332b53"],

Cell[BoxData[
 RowBox[{"0.045177791821492515`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.6577699435963342`", " ", "x"}]}]], "Output",
 CellChangeTimes->{3.8840119448526773`*^9, 3.8840120551812696`*^9, 
  3.884012558099855*^9, 3.884012851019084*^9, 3.884013385560072*^9, 
  3.884013651186311*^9, 3.88401372639071*^9, 3.8840153024818773`*^9, 
  3.884015627332687*^9, 3.884016831363606*^9, 3.884017467328103*^9, 
  3.8849964621723824`*^9, 3.885214273226239*^9, 3.885218472941497*^9, 
  3.8852859372985992`*^9, 3.885414918574151*^9, 3.885502615048195*^9, 
  3.885513527519001*^9, 3.8855541384494953`*^9, 3.885554348385861*^9, 
  3.885566091045553*^9, 3.8855679352975388`*^9, 3.885569328854207*^9, 
  3.89404994528574*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"bb105252-34d6-489e-ad79-3b33b3c899c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Correlation", "[", "subdata23", "]"}]], "Input",
 CellChangeTimes->{{3.8855703247655783`*^9, 3.885570330198518*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"385248a4-21df-476f-bcba-a0399a123695"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999997`", ",", "0.2727874131897617`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2727874131897617`", ",", "0.9999999999999998`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8855703319961863`*^9, 3.894049945353421*^9},
 CellLabel->
  "Out[112]=",ExpressionUUID->"ccfebee4-3cb0-40a0-8f49-d779f6bfcc37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "@", "trend"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"minx", "-", "0.05"}], ",", 
         RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minx", "-", "0.05"}], ",", 
            RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"miny", "-", "0.05"}], ",", 
            RowBox[{"maxy", "+", "0.05"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TraditionalForm", "[", 
           RowBox[{"Norm", "[", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<p^*-uniform\>\"", ",", "TeXForm", ",", "HoldForm"}],
              "]"}], "]"}], "]"}], ",", 
          RowBox[{"TraditionalForm", "[", 
           RowBox[{"Norm", "[", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<p^*-p\>\"", ",", "TeXForm", ",", "HoldForm"}], 
             "]"}], "]"}], "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", "subdata23", "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882192696300736*^9, 3.882192700311585*^9}, {
   3.882195533785142*^9, 3.882195533944455*^9}, {3.882287808996023*^9, 
   3.8822878997355423`*^9}, {3.882287979342745*^9, 3.882288014377759*^9}, {
   3.884011926003563*^9, 3.884011929283166*^9}, {3.884012110721346*^9, 
   3.884012138083975*^9}, {3.884012181411414*^9, 3.88401223960191*^9}, {
   3.884012283054537*^9, 3.884012287357141*^9}, 3.8840126821263113`*^9, 
   3.88401342553695*^9, {3.884013677220203*^9, 3.884013696691018*^9}, {
   3.8840140545128117`*^9, 3.8840140718705273`*^9}, {3.884014176264812*^9, 
   3.884014187046541*^9}, {3.884014572412644*^9, 3.88401458299006*^9}, {
   3.88401534035882*^9, 3.884015349506917*^9}, 3.8840154782008142`*^9, {
   3.884522341106526*^9, 3.884522341209758*^9}, {3.885567912484899*^9, 
   3.88556791826418*^9}, {3.885567965605503*^9, 3.885567974198937*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"131707eb-e1ba-4073-895b-9de4a1bcb94e"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVzXk41AkAxnFsRWQTpcM+PY6l7FokZ453yVmO4ZkijPNpPetISqaotO5Q
jgcTlRnFIGmRc4tx1GBy34afVfMLWRtJh1xr/3if73/vR8En2OmsiJCQkN3m
/u/Xy4UP1O4xOKty3mq/P8tFfUCKwmE/BufWvGGz9UQuojzoLCUtBudgi6zL
YWEmJM2tcg+0ZXHg3xE9bcmE4s7pbLGlTE5Urd7Y2T4mbAtU0siTGZyYn0Qt
ykNZYPYWRN5bSeVItBIfS5PykEy1rttXHcPZL5TkWFj3ELe1Q98vSZ6HUfgH
xcsXi9D2so9hei4NWxLju38gHiOCvie9IDMXvEfyXrZ3yvBR7GSwQRAbmRnR
vssLFeBmxdLr95RC2+Y6NVWhCuHJwbsjVCowJBxJkf2jBoNJTCrKq+B2J+19
/GAdIks6LKQ3alG5bBguEH4OZ4ubSch4DinPOSl1WgOubZhFRcxxwLLKOXHE
uhFLKyibz25CsX0rzdS9CdBht9t7t6DSmf65Lb4ZT9cTDXXEX0LV8mOsBbMF
JrE1w21DXLB0F3MMul5g9lGB30JOG8Rkv914+OUl6r2kKcxfeRjld9JEJFtR
1M/1WdnegdK8HxtHDNpQN7TcOVHZiVk7q/35Tu14kxXqGxzdDdXVuS9TUTzI
Rrh8bs/vgWv23UJm6St0L+pMMy/3YklO1t7uRQdkbPSCbD36kMKSCb+w2ImA
aTrzuXY/MsWJe8k7ukE9lf3q87YBcMudrW9L9aAtbyJZ9J8BmHmKbE1n94Ci
6/ttjDOI0A1p41StXvgWS6zFsYfAln+rd4LXC9G5jOWVhGFQ6gzl4NkHThjt
gbb7CMrMv15Rn+3Dd5M2k8dNR7HLMezu6I1+uKZd4snu5UOF4qofKbnpSEc9
eTrDRyW3ud6TMYDqkIpDhzrGYN4wt3VVbRDG+xXtPFjjiC+62p5eOwgKs0o0
MI5Ah0yXw1uHIYQFJZwzpk2AGxLrqEUM4RcJo+4Rjb+hb9Vk+JffMGpbbvoo
i0+i5H7DzNraMEjlzKONoZMYnFLYZZQ4glN0LQfLmUmsl1mu6iiOIkWz0a/8
zGuwFue7/WtG0X8r6PT1ltf4qrJxMMeMDxr/cYqu7hs4jndrxo7yscCTYFLy
3oAWs63B/7cx2Cq5lTiIC0A+bDqatDCG9/5GIseuChBgbhLoFzeO7NPGGnFT
ArCH5eVNpAkULX3f7zUjwI2nUQlPdhOoTp8MM5wVwCWFXDi4l0BfV3TDwr8C
bLcqatqQIyBhxbNz+yRAYLWGb5MygWt6zoGaW0hoZZqwzQ0IeO8LKeYrkKh3
clc76UXgfLWZXZUSCYZ6Q8YzHwLXqbs/pCiTOC8uv/bzWQI5qTX6Fqok5JsF
nTv8CfSLrbf+qUki+khAcNdFAhbLiVMxIGEjFV7hGE+AynBP9DQloTQ3dqD5
JgEfHXX1Y8dJrLQaR2slb/6H9F6atyTxOFKYKpNGoObd3q2u9iR2zid8Gsgh
wI1/V6RNIfGON0uzuE9gQPmZ7U4nEk1sW24Vk8CCt0fGi1MkLnhIMbLyCaxv
aOgznUmcOHZhY1shgR25wuNXzmz6sgN+9GICB4z6I6lum/4HnZ7pEgKq/Hwl
DRqJwU6GvssTAv8B/WRwJQ==
        "]]},
      Annotation[#, "Charting`Private`Tag$827055#1"]& ]}, {}}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVl3c81f8fxUPSkFGiQhGRpIhSokNISmV8o4xkNBRCkpCMopRRdsre+9rb
nca19x4lK6SoJNTv/v76/HE/j8f9vN+v1znPc4TN7+veZF63bl0xy7p1/3+a
l0k0UCVakWTwQrbzfTrs90VEvL5Egvqugew4p9dY/fixiRhEwuljtAEq51vM
5wvZTgrV45FS/OzIn1Q8FiaUHvGm49rp5QxH52Jki6lOOEvT0cQa4XIzoxii
nGo1lEg6BsXNZ5v4s/Au+HyC+U4K+IO6Di/ejEH4gEylDlMlUj4vXmhSj8fy
+pMxPTuIsA51lD2/nIB6iOpquzTCvoSw44VvLm4d3Guj70ZB2o9n2yWGI+Gx
0dFWsasRXRm5k7dTc/EkfmXV80cz+ux1pQ8Gp4FjS/5C8aEycHgf1r7QFYLg
VhaL6vR6fEyZUZb1LIOg8wV/gcYcMN+UH77A9Qy73i88vnCaBObXp6MnbSKw
82y0tjXj+w10ex2G3mRhl2GPmiYzGaHlXqtRzHF4xpP8IprcCO+nXJkSq1Xw
Dd88eS+xGqMPonTuhoYj6l5ZX7F3F+L4zyWQykhYO7VyPHgPER7NnAZJ+nGw
7PY5cy8wD5MneDyrn7+DGrvy5eJwIqSeTHd3lRfiZff1hht7SyDy+cr7n6XZ
sA36kyfRQYLtcLfUj/RcGHW16rD5tuIbydf7gkwSNphsOmLG1YqOEIlT3cRi
PPX0mVuZb0N0TC1frW4eVuc2TKn+IiP5jiih+Wcudi+SPsjYkjAVPMPeO1iG
+rL+oCFbGiZqjaxyb+diXqVTedWZCqXpA5qhTcnQrOW73u9Ix/Z/7ITvlwhY
ERF7asFRigBdMus+xrx2HMoj7GwlI6dW2jd/IhkRyhuv0mVLIDeYZUAsDMXK
PjatWcY93Mr+/XZpMBnxvCqPmYJbcCiDU66kMQ67LG/NLpgRwTz1xfvsznAM
u7/MjZ6nwpD7xKXZb5GoLgrrtvaoxJzHh3b1mWhsjnkQU0OgI1WDahNklQ9H
Drf7ykaViEO1RWlPBsYNNujrbq2BVZMmhOfJ4N3UHCe8uwMJns8MSr1pYIb9
7e2H6TjFanHzXe8HNOjnrYp41UEy8q9k0ptcqNHNX0qdqwf71KWEqPl49H/Q
zjb424ykdSfG5TYSYB74jHLuTQ2ajxa4rDcrh9DKV0MV7gYI/9vHL3eLANmP
1sZhHNV4GpCaM6OcihjWhmeX+WqgGWJqm2dajFcR35FVSUf43S89fD1J+Mkn
fzhCgISXoAXeyIlA83u2+SJPInwotUvUeQq2voyU+ibQilXhwD/RxiSMTs59
8DKthLyUp+Ed4WKcqlr0o6s0wdf0cKKqNBXOPaF6KQdpaHaUv/ZCIA2fRYe+
fQkugrybsm5ZZiJMdrkktB6jQ7d56ZzNwWgcW9Ue4Kun4NHS/e63nQUYTtZ/
pmFHQIz8Huf8oSzs14/l3MpRiNjcm+m7t72Bilzf1lfbS/A859dn9Q2RuCfu
mx19ohb3VGRkrJiT0DQk8ElhpAYuhT31vCyheH39ndEV13YsJM9v38jY1z5h
1tcqTBSc/xc49NEsDevTfWbsJ5uxbzAgfL92PpR20X5wnSNjVW1OfvlBCtK4
WLGRoxxemScF5+dDwaZ6fU3IuQzJoiJht66lYsJMXEpytA4HC9qD7mpmwvmy
5C4T0xo4l6mfWB8QgznVouqFNhosghZET/EScL9w4c7l9W1I4Dkk8NmFiKfB
v7y62lphm/u68qJXMdovBv1+rEIFycKWUM/Qv2bWr+4Y1jL0k3aJje0LQciN
CfuX0U3w4bwYI/EyDw/n/IKUpushuTcnc4S5Bq7rqOlnDTPgoOfccC0sAB82
Lq55n6mChMmMtr1XGcxDY2bvMxHh2xwezXKvBMtF9zdiuhoPjlfWzEh6Ilv0
4r5Mxjw27SzctWc4Gmecr6v4727E0fN2x7nWpeNfaf2+CcMmyE/37SCebEXN
1TdSaoRSHH3zRHrmRTI8evYSg88W4s0P+6WTpFAo6G1eKjhbC+46+dVJ9zIs
nTZx/2ZNge7lP9KPBHNAL9FamfmvHr1bWz5bM+ZYorgsrsNeAYF38ppvk1PA
SYlnyu5vRdzXncJ7uig4LRLkHHeqFm5lL28ftKvAqWoupSw+Gi4HtfQKlDfh
ts71cg3lYujzP2W9OfEcOhr8FyxPVkP8tNhGsnsWogWCWx7uT8VOlpeyzMyp
yA32t/woUAO+3n1Pchfz4ZlQvzPiSDOaibP7nx1MBb/SAb3BKySY/11/kHm0
BsEqAtQbT2IgK+KjIvvAH79ussiOmJFgHbKRJttGRU5z0L7BvxR8PlkScfZ8
OWSVM4vz1CgotnCx7ZoJgW698X8TBAp+KMoN5GjXIYr5nuWv2x3gWluRHN3c
As5KgzTW8Cjo29nkkxQ9MDz9UnLKKxvrbV69FLwSiJtnFevUc0m4kawR9jeP
iqXohBOtj6pgtG+G9zxHMqjWVlXO9ZV4762vFnovFeP7917aeqQaNlf1Vv/+
iITb8CJth0ILpo2TXZmUqmB39tCfL05EOArUEWrp6ZDtsea+xUFG3k3uZGXW
YrzhoFF1bjTBbUKUbZ9BOqT1eMeK28rQM/TH0vVOCYLmZeYErtEgsuv1L5bM
dMiLP8soAgXVJc8+sGjEoPvC7WPlUnTwfLV4JnY5D2j5vRjq2Yi1uF58G+rC
U+eteTx3qqB8LOmUxCDD/zcbZqo3FuPT1UOxxWMp2DpG4n93rwLxUg8PNK+P
wEocIfSfYAssXLkOsr1oxaxQJo+gVDF8xHq2RO59Do4Nomo8zXQwxR3jd1HO
Ru6yhIXiBQIubdta1kiMxzNuejnX5UbMJttLctygokkn+oZEcjWM2TvfvHd5
jwLh3eVT+wrRYy05vI/tLTp9I24ktueDz+5SKK0rFnb3BL8k95Xi+yj1StG5
t+DZ4dHrSyTBex8rezCDAt9OsxlIP69DzEhHlKFpBZYC7LfduFOPWYOimenz
6Xjg5qpx+0sdDM/Hr4jmJwMyaXfq/zShmW9NJdytESMz8vUvlgn4E/fwqtPR
DHycXbDdrUiFvmXc1vR/sRhYKnKtPJ2Dr4cENjlfD4fvOscNxaQafCkhD5dZ
dsJ00DLo1Pl8DLDJplwnBEP0YslBdftyjKinMst/SIcem9S044N6rNvIupDy
KR/flU55H44vAe/fy795RzPQV7VlC+FeG9Ye/iFKLVehbXFL0e8zVCQ7ZhLP
PG/FUXtfu6O7SODac8CwtDQGxx+cm947U4YtfO3ytzqiMJv5qPGgfT285ph8
qiMYvKqlcTowcorzAbbb434fcPnKwEjvEEP/TnisR8rHi1vpBiIZNFi+y3cx
udmNjwLqAS/M0hGdxOoiFhuFRMG2cn1pEvb7PGXWy6LCYIhDUJNYhWOnc8Q0
WiPgK7/2Z/hIKT798hq/TvyAyKKLpbxhJJyEkoLUZgK2ZanqNPXlobeQU7HK
OwzlJeeYhE9QcOvGxa91me/BKrdJlc+ajBINJ24P9WKszdB13RQq8LCSOe1b
WQyW8lgq1NeV4ZV0QsCIfDx+ezUavDpNRKyaiIXMFAE2smNcrqsVcESCWdzb
KMjt2DKuF0DEMaWh2evZ8TB/Zm/OHVCJt+q+uxKsEuEQvFmNg8Hrdbfuv6zy
J+HMEVUP/z1kvDrEmWN9MQksiUppT41K0GVp9T77WRr2NyYvpjJXg8+yf/Of
xffwbMqzMDcoA++C/x/j6GLsyAn5t9JeitOHyyjUXYU4svE3IV6VAvFdP46V
fc9HnqbI4U1JpQxeSP0r0SXA03yzALMfBdlBb9av58kCUXz/wum8agxq1+/0
eZeEqTPOZRbWNTinbt+i1xKH0mn2A2ZMVLhKZsTtManCif3DZixyjbjtJmSj
5FsIFl0f0byARuh9qikx7ErDz4szFwqTa3DXptLcn5UM9+2C1fbJVIieGSTV
++fiIEUm7fJPItRaxu0ClRg5UKrfoJyPhN0fztQqpkVh05lJ2YCrlTjvtRZ3
TDoP/KYvPyq2doB9/ZXKYw2VuNqnWGx2moKHHjNFhxg++Xoqe3XIgIq8LF1x
x9UMaLuHbePYUAbjiOAkG6kcHOjz0GH1a8VDEd1gx8sliPp55dQezVrYrXOr
lA6iw28t9Hq0dAP4XN7MGPxoRYxWeG/AdhJefa6460En4DvzemlSfCMCm63O
6fJUQjqr3rFdhYQd683Ypn+moKVwNOR4YxH0/Z89/HMwHtYSLxWTjchY8fb0
CwIRJuk/NmddJOLvmnSO855YbNt2L6zCkgLzjeE9wttb4PlI5+D3ajJ0blrI
+WwtxAVLAVvyp1JEzL3U4I/JwGJ9Ts1CKR23lNc1Cd4cxM957uSTFYX417u1
bP3FGGwQ+5ITnE/Dp3c3SrPuRMJ7yc6uSaIWnEx5AoSnBFhGuLZs7iCitoW7
UMWRjLONWY8856pBdfZNu8dVgYqtj/Z8zM2DcelGdvakcBz7yp75R7MQAuHt
jg+l8vEoPDY4TZiCAP6Os30mSch7sbOjPa4UDWZ6vwUZOfOq1wun/Ggacg19
ZjXv1GGUsrfM2CodA/XlSv2RrxFHY+ZWVKZgjkOljGlzEbRde1XT7PPhYR+g
PZ4UB163HlNLeRLYlTUj1KLTcWM32+O/G0kQfHB330PZHIzTfZIjxalY5bpG
LjJLxMRf3awiVxreKhMlOM8R8CLXffYKI9/nxk8UURi+2XrWTnlOlgxlC8N/
s7EEOL4k3BEOacBtH/8sDcFSNJIE9pcqEqFwX9NGbQcBZvxCQjFGDVgTLdPq
3zsK9zfJ5/hfMPZUkLYubvYBLp6vLXGRK0TFmnVJf18cnloUjZB4arBcUEmK
v98HhRPDvyWXK6G7+ItLIb4UFUpfty1Zd+Klavlff4s2yP08VBIYUwt3zayu
iz/iYdF5l7vkXCvmdCpuSfbnotb6uZfnLSJKtCMDMiNjEcZ0/xaLHx25Jg/E
Mhg+3KZhazwp0IxdR44qtOzJh4m8QE2ybSPK5SMDJjd24IQx26tz2+jQeU5+
6LmjBPd+/aLv2FCLzKp9hyuvp4LL+eEbXYtGXD6U7fzLsBGbM5oK+1ZIKBzj
azXhKoCY3MZCsa/1KPoTlPzjv1wIp/NERA/RICMxPFcn1wLlz7umgy7VYDZs
ve2aKcPHcY9ns38pAttOXeaLy2X0gZ/iz1zIeJKpJJV9KQnSxzk+WXqU447J
L0/lO5n452sfpKJVCMInr4+2dm+Rz3Zi3cIxKpb3qBpY/yyFU77wmUKdaty7
G53rKRkFUmVY+E/zMnTyy9scvVaFX5ffNE2JNKNmId3/ITUHV/WdRAx2V2ND
5rnxAkZuzeX1l7vWUwcXM0JaRugQ8Nn12WNWIr4xlTy0HY0Dl4RSisUbOl5E
r+tfSs7FpRCNsd7CUnx9sMBR/eIDihR/Du28VglFT8vb222q0fUfq47K4QZE
gGC6ldFreHpeWjkz9PWjhGX3BW8StnFd0cgUKME/0+AhnTQfBO6lzdOnSVB+
JFciGBsJiVgu76GLzQhPY5aX7q5EYMCcygVGz/1pqBkjuDcblMKuiy5rFKyz
q1FNEE5D8nGHNpET9ZBZ2rqUl1eDUo4ClsSMUgwl3Jv3tQ/Fvst37m35RIBD
6Nkok+dB8O7eVtrNyI3D5n667N35iEgqt0pcbABv4vNWgYQcHH8f4znzpQoy
Xl9PXfdNRGVefvCJR8U4K9TmY3MzFtND7j5ptTRkT946dKF/BOU+9+vPGTZA
p/zY2da3JeCpubbD4m42jobITXeJ+oNLiGv50udo3EzYo0Dj8kVSzYky2Sel
kJQ7vdg4EQ1KFvOwunctrs5NDm1pTsAgrTRPv5mEtFXC/UTlVuhLXbtgxUeG
s824+mwHBRqnKMv0s3TYdNzLX+HPh92lnKGVLXnI2ss6pbA+BNu6vmR/ONuE
jdLmtoPr6Ti4Z8s5n7UqfO9797DDvhFfi8pDimMbcW//qf9Kjdpxyuko29XC
WiTvI7P9sUzGWN45ZiWJQtz7O6oWb1EDO3poh7drJ3KErrBzbOpE4RONni9P
61BDszx5pjQTD5fVkiSPF2BzMpccT0Eimp9cNSo3rUPrPVYzU9c8XFv6Ivf3
biVi2feXR6m+Q4R4jrbJfiLDd60NtZQr8KNY5dW8dwXSHP/+HeHIg+fEeZOX
2u3odD/UKLiHocdcP44a/Xy0fXn8q2rWH2dpbbuPBZQhooTXImtjAm4bRXyk
faRCrpp9o55UK/bbG69wW9VC7Oa2Ko/sWHiRuHwMT5bgDr/kpdcOz0H9zXUs
q6kCk7X/ZcYaJMAhuzfj6iYSwmbv5Z6uoIMdeXd5vYj4ekFvq3xlPCbodwva
3Oqw9P1pt4oTFbGsf0WVfzPucfaoVeYRIn5tn1qvatmArKxAQjBLEEp+VPjv
XiyHjlZxQoYmFbcH1WQFzldBseaHSAMj74d+Huf+spOI07zHz96Yp2LWgUxN
cqWCvY8/1Pk9GbURX37mR9fA1CR498TeGmyRf6VIk+qEYeeek1LC/Ti2oMih
Y0kCh4+/mXNAKMYk+SlNOiSEOl9kwuc86CZbcLp8I2G4sqhm6lshxLwtx7mz
SnFg89SnF4eacLmssdKUMe+vjWIyIic6sbciRCTgKg2eEl12D8XGcJFpV6s6
pQb+LyeENCrJcJS1Zw04QkG3oWn8mc9ESAwluuow8rDGlaJ7Vupk3Dlq/mMy
lAzr+4K9D8ZjwP0lkdWnoBbNKqqtT7OqUVC5UdnUk4T2tUDhvq5E3A08Kr9Z
Kx2hyoGmxl+o4OKo+rjeKw9jijxFz90+4HPY9tyGC2W4Zsz/OistG+GL/uS2
XBpWNblKxs6mIbHx6qDc23IMtovdv3MrHrjSWY7VbAQ7Xbt1d+YtJBdDj1AV
SHggGlP/hDUCR0nVRmnmxXDSX4icrf0AbTX+vyFptfC1OylDYHCQfTZpvJDx
vf0LMSI874rQ1NjGfyezDm4PTNZ/16uASGjWlnP+ldjGe+xPCHsyWhwsrDt2
NoFpY67Vpj8MLt9eMszjZvTu43WD33lfgByklnR7UwUWmoU8dya9h1Phw/8i
e0n4r79LQ/sEAbuv8vSviNUgwCGZ090tC6VfrN0n/PMg9fb536agfMTdeTeT
OlkIw3m9f3+ffICfQe0n0UEiVAyGSHv+5SJMY+TSLu5qSAzwRoWLJCPQa/uM
bmc9bu+1WUgdpiHogqJYcBkNo5khZo12heCwM1XdpFQBP83axbQPBKwsMuUX
kUj4tpbhd1GbgM4bcb3jDnlw6ki3FvsvCgbaGTr+49UI/1h3eIMXCf1es0GW
48Ww+ofZdf/ywHpdYnuPAQEDC6MDv1XisSj0j68AdDx8leS2bgcJxuY6Hc+1
W/HrnDTPmD8NC72Jml+92sHpMLlvOJuRG/ZLHjjA2o6cHT/sq/eW4OBsiXvu
0RYIFmd0CyrF43CcpmVJcQEklRbGn4vlQl/ppUCgTTmGOzjr2G3jsMCx69F5
fjqKo6OGHkm1gBRT9vGiSQMkxcWoD5w+o2TgQvKxSgqeizezDiaTIXFmY8Nl
DiL0Czsq81zC4L03W28PDxEhz2ZWzEz64OxqOmV+tgVjFcojvnIMH/vg/63n
fQO+xMSd2ck5hEOkCMIM1whM5QNVug36sS+93/KcMBm5N2JF1aXq4DP6Y5J/
Pgc77gpflNkagR1v7bafOleDPxYF7k1auZhwtplwyi+GLdf3zNe0YBxav/mw
3EoRLMtWNmjvfYPF0ylVkqo01LjS3p+vKYV98OqDPR1UtF5yqT/9NQVjO1ND
BNIYHN/gHkf/Eo9IB1GjzPp8ZEz99ohTCsejYFPjoOp6zF1v+0jha4XiGI/y
Y6FqsKu2U8YZPmvw7fvP0L80vNmmpq2eS0T818/737V34P2JJydEiktR3xz+
/P2NeoipRF8ySWwGX9WUot9nCppLJF4FSGcj8kSmdOsbMr4X3X5T0t0Kb6Ve
MfJXIk6pM7XcN0iFYtPjvkwyFf3ndh0JjusGByuh8OqbVvxoD6sKDabg053n
D6w3VaNBOldgR1wRXPIfCmsdy4WGyp96LIfAznI/1zUuRh79RlSRtU2CpLeU
jN79OmizPpQOIrThztWXJk153Xjr+1nl4A8aboZv5TK/RsP+oZdn+F+RUZEq
vatySyX8tZVcF7gZvnrx+gXbk4VYbmf8hUgPrFgCfYmhLdjA5Vsux/BRheCE
5aXzZNTUSnw4OleGs+7DWfw5NbjmofLD3aUAaXUhH5L3tsNsv7N3gUIznij4
TXjrJKPuiLyxTPpLCAkoMP1WaMV2hQtbd32LAjR7bKrEqHA0szq6Np8Hkv15
pi0iRHh6++zNTSxg+PuAtt9SO6xJ/+aHt2RDd4OFx4tnpRBp9Cx6E9gF9X1H
hb++r0Yfv65/qHQc1N2nWh6KV+Pibs9jDytSkbXt/MeB59Uo9PJi0TAcw5rk
yECfWBFsh3hnN5wNAb0KXi9myDAY/6G4XaUIQVLVh1q3EPGf2RPRr8cLYX5p
QcC9rwVWGVtf3cymw5j99H8KIeXgSTQ5VmbRCnsOtocEk3ocffS0Mb5wAoVG
Az8+tjRBViy41+FiHkQydah8rv3QX1PIvt07As59b8PGmfJBthLR2rmSgH1b
lgT2vinEwwsxeTH38rGlR1iV5z0JXg8Gym69aoQQz7uoAs5CSL94+fZceQKc
jmQFHp8rx8aenSFOP9LAY7C80T2jHXPNx3cJSjP4c/plQl9pDVq2BhGbTzfj
UM608Wx8NWonatok9SNhMHhX7+GlVtx5EjVlsp+EuPHsOwKcVIxctX4ulZ4G
zQu2N1j08jHZKPRrjRiGkG/773Dp5EHseYB68Nf3cDy75XzmszbsvH9iru4M
DdE/wWqtXQmlWU+r69kULLxLrUi/04lTBiKsUz6tKEr0kDX4QIb+L/UbWUtV
8P0UWrRLtwjpTmKGeeIZDD51PFJqbYNWy/Mk40+1eHOfXfDiRxpO53Z+JOYT
QJtzUjzRTEG6x4TDQcY9GH0u22Nxrxxbz7SX2tuHIeqMjL3h1zLQVMymjDqy
8W1yKXAmiAotlxwbm5YUPOcKTFirpuBOTHw0mZkMphCWrw2CbZh3r/9k/74F
fBSnoT8GHXDkUt28+roNlWJ8Bk53qcgw8tQ8H/wRPtavz+VSK/AqyKBBjhwF
00o9DzlrIk6Y7o3IPNWO18ZdUjtEyfh320GFT7oQHQd5tJiZSLgly952XHME
jiqpuwRtq3DDUs4twSYO3mzT7w8xzuOtJ6wadSUWpE01rrefluDWlQWv/KeR
SN7JfNsvjQQ/dl22yfoapE3mfMs+ScMVZV9TW61anO7envLseinWrfe+vT8t
EbWGDlVyDsWgTV2QT4uIRa/xNeN0JQpyk2IsBSfK0eZk6yljUQGSl4r9jFM8
glUfD00/6AShPa7Evqkdx9miyYFNjZD8xjaZEdiG1gm2BMPAOpx7PMSkJxoB
i/8q79kZl+PDfxJHn2xOwmY7rlST8C48kNf601TahKbF1+/+bGuC3/ugbrOo
IizIf1u/wbkRPSUKzHNMFfhS8OhS0d160K8TA7aUtGJkqVVHzKYB46SqS8TI
Gpx8d4Hzxo8mZKSdeytgSID3o+J8Cx9G/2ys1H80ko6xFz1WCb5kkNiTD6YG
VUOpfOVnR2cNOra3TDv6kmCVytE/ZEYBN9Pi7PLLbBzc3lA7L5IDGRjsc7NO
QfPZX9+L8uoQN1KldYVMx3dThdfh96gg/zA6f1KXgntCr3zjlaj4ZjVcuSkh
F7fXSvwWg8iIvczBHhGWgafiOfPqP2k4f2L5nNP5GlBziV37y4n4vnH6Zdzh
PGQGcn6xZpy/sLJk/2o7DfpjwS8PztPwYPmtf8NqHnzdroRz6dAx6K/wTnyU
jqxgisNv/SoI9RN2Pv4ahaHueGXSyTroNFrlp+vnwWybo0QBBw1KfOn5i1pk
HOhSVFq+SET+IfWXl+9HIcewsHg9Tylen9dLlmwIw1Rx2cU/+3vAcYXNcTqz
A1QP5Axl0PF6o1zTZ0IiPJ4tFRHaylE+uXvfttdx+MZhtfHpz2IcFtAM5y55
i6m1h3cdp2mYUVBhKfRqwXc2GxE3wyZUHrfwH1lowLq1dK+IEyWIudDqt1+g
DKUux171XqiDgZrtpdzFMIhU5csor6eisfqJg1HZNPrTE/2kTMjYf8bO8ozP
JD7d+y7YP0RE3CWmv+1OhWBRp/CWs1RgLY3lek9QHMZyDSqL2duRF/FfBl9p
Cy5b2jzealSHcqOqL2JyieC6oP8nJ7UYrTRmLkm7XPh51STZ1Zajjq3Ryans
A5LdpnkjM+rAa12R5NDRisBv/Tq13DRwfe59u/14OpRGVXLOxjF4yFFgbjZM
AavaKI0rqhFaD48bSX6NQ6tbsT2TLB2Kmnt2Lz4j4bbdJmWp/lqMCp+9OcVO
hxCflbdIYRsK1Wb+/JzrRLz9laBE61p0vtW0rMjrxcJ89tKj6Aq8E/jj13it
D+L/fUwSFqGgtqLynuHvAkwIHBRPaKzF0zdjDuq6dMivhkpuulKOoVv+KwIc
72FfXy4w61iD+o7erjo2EoRtDeWe25CQHyu2QciFhJttllbb3pHB/IH/VuMj
CrYsnGA5alYLz8lHTQEeDahaueAeVUfHXOGORqU8MurJ7n9nUuj48WAr1yXT
HHi7aFH2ZVTghiG3pb1WKRK0VoVK1hGRGyh7MVikGK4qD4xbsoiYPhBpMsvo
iceN3id/VyhB3t+6z8W/ArDVVvThx6oyTM/8yi5laUX33ICYMjeDezxMuWvW
rZC50UH0P0fDf1o6667KP8VVrqq+nJEqWG0600sxq8KBz/P7V/c0QGgqXJ/d
tRClRYe/XjlLws6G893+a1Ho/M9Z7d37InzbRGxgDU5B6quy1eCjFWiYVet4
t4uCzJRNIplX6HhRW+gmRGDocHhGM5Who3cSn243OAxiIq7rDU8rowcFOQb1
k3MhrtFauOhbCt6bhLZzd/zQWUt8M5NBweBiTMT+fx+wb7POk18ydRjz39jW
ubsBsoZ8HXoHSiCgAI3SdSFoa3a/Ob29Ddqp5A43xzGslgn+TvKpBVlPy38x
uhpvtmzg9pHNhpIRb4HrwS9QV64wPJVJwd3xANODp1MxUG/q9j66A74nIoXY
29tBM+KeM5BuBXWIK/V4Zht6uFndvlaUYte6Y0dGgvuQ2ta7IzGEivuxlNis
5BgsvmZ7uHmAjm0SD/L13kyjtvmRQGd+AW4GrL2aeZYGnfGgq6T5QixUVGxx
WInDcdsKxQN2dWhItzO5XfAB1Z7S03ZdVdjzZ8/W9f65EO6JiL25RIBg3Zhk
SGQiUt4+S/j0k9GfLiUqLP3LhK7evpj4Ex2INz8y2va6CbwZKV+4c6qR7v+l
OKqYiHQtzmclnGQ8HxTxMj/D4A/buT/ysW1gHvtnfNmtDyndn89vVqcimOs3
f2xPLtyfPCsMpJMhrjK4kY3Yi/wplccPHmdh3eZIyTlCHGQtEsO6jtegM8iW
dfhpGBwS/p3mXiKBzET7nbOjHTFmhzreKlfCxUBzK5E3DR4tZjIBRpUoupoo
1ljWBbfBWnrXyVH4pl1teZ3eCoFgnwprBq9QJ7Ua5UHEaAwz/42VOkiIUuQI
HzrxVPVd9TE6Fcn+lr/ZGefg1rHqqRivB8tXmcKX/vXoLC5Lm89qACE70d0s
uRPaZTHONQJU7FMXvUOxa8TVwaz3W21z0eJkw53+KghSha5SvM1UOFfLc59t
TkVaoIDE8v0ciBSXLOk+CMNyhpBx6ggNYee9TayPZoJ7LNJj9EUZ3sYcOCxh
2YDAPjXpUcNSRDlc55cy9gHLTnlJn8EWNBEFK7d/o2GDCpu6TA8NIf8exLGk
ViFEd5ZF43wtGtave+HmmgTD8YQ9CTI1MCMEvZxuKoCyL1mZ2bMMBUx/jxww
KobhSJwBE3MTJp5uD1Q4/RGkd8taex6R0Wg5z96YGwfCQOY5QtD/7+NhfFRS
N+xpxKBvc+0Yf8dXEzA6ABOjZ9SjbDU4VWn7dId4F05/PVj97WIdYjfXxyyf
aIYiJSC/5Wc9tEXTrYJYR/BJ4YJvUVYtHimIH9hsNASmhr0bRhn6JJz0f+3g
PYj84isF+rKFuMMro3rtWzKsZyz4v19n+Nt+W0WzjjDw7K1d/+4zEc2rCpS5
S+0Ib9Fbe1PWAUF3ydcPqfUIeNYdbSufgHZWzixFVxNsdT1Y9bWIiuh2Zr3e
yjaEcm8q33OZBqHZnKFb9FQQ87Rtvtjkwaru+5VbstWI+yGX5P6mCrgwlL2F
JwVNtUqhH4g0ZO05G9I43oLHVnfsh906UCTb9NlEphODZk+UR+0qYBFnTM/Q
boNC9gMp85F6RBUfzL96sxy8iRrlTwNqcPfFVvdXDK4ETnfXmfwlYPv3Op0z
NtOgmx/3+PqDAqqr69mQ8DjkDz3ZvOtxHY5lv3dRSerEkGXjRaWzDN4cirsh
3deIIxe1F+SXaOifti61js3A/dRxPDpDhZrf10sWViFIu/6pe1aSDKuvy2cE
9kdiQCHMSqaxGmzds7Ib3n2Ahb/1poXv1VhoEnvBv9SPXRd+iz2ZKsHDYifh
t8/n8Oia5ilzMzKM/zF37lYkY88O2vNhxl5FZ++fMSotBdFXcs8kjQofNfpm
x9haOPGfF/70pxOuGyXdT3nVM7i2IhHbXgkbVWfNz3lxePYqz5tVhApaVLLJ
9ZPpWBkV3NrRSMKhZ60u1fIDMM1+4hklQYNlN/yZ+BJBShoW/83om+FvaT2m
a0MQnXnr2FRfhnwKf82t0/34t1ve1CaxDRyhQvYf68jYFbvliJAPBcqdRjG9
zmWYmZ18sP5MEwxMFq9aXmrDz5R3Ubv3tuIqxVhK6lov8vLD6amNNDx58n5v
knMyCs+wHQpwqcVgUv/a28hY0E85PK9R68KrvecONXv1IzTSKo9ftQmUjjPS
ycal6OciH7rGVwA/HTuZoolaCLc160cJt+B+3j6S+q5uvJxX899wm4Yk13bz
G86DcN8gdOTfJB2TrG1qhry9OLF3wVGeiwrCyKWbdtk5eNn+73OuKgnRh+iZ
CR8GMVdjqbjrXyO+32IPKrdrw2mrUze5flcjtMAsXF26DbGt8xOFkfUYrjvt
d82xEaIPZo6J9dXh3aeSrLOVJAjslBh9I0SCUGVKcdF3CvTlv9eI1DD68xvm
EdtbHeAr9Pal3uuF9su/TlZFtZCUbTDeyUzCir6I/++RePiUPhbPTK+DjHXq
gpxDA07UfXe11mrDMnkbB82M4c/2Alf7glqxEB6gOytLxOSr1lWZ04U4NdTF
svVPPC7z/qery9cNR/tOu0xCK7Zu3amz7WYevmsLVQXqxDD6DdepJ4dpeKTC
dlBgNBsChOOz97ZTIdKVwO7UkI+zV9UX+dlaYfP0vvmxCyXweWx5zyW+Be4f
O6otyB3wF4rZuUqkQ/y58J4VBm86Xyxp3lDNw1Igu/oZ9zyoJVnHszL8z55q
cVllRzF8FHpHF1xrUSvIwqF3nICWQRNjVjUS9v51+RylNAQPum6sFisVPXfH
r/TYt6H+5bc9q6IUbKvVflUQ2Y9Ot9w3O/cTIXMk7b766yDM9HdtOECrxu8L
8+qqBqmwK5IUnY9ow/XBUbfjgiXYLM3kmSrP8D/bz0piLsNg5dTNsvhQg+Nj
uS7DKTHQ8yK+/XakiJGXCqc6boTCOOT2XPJAC6iUHKs2Boenbbw4v7fWouBK
bJDNDxoS2g/ndSnREOCbsvJSh4C7p05Ke8/WYjEQ39r5B1CR1tKvvS0RipLs
S3c/voXq0Vfrs02bMGIhbDn5aAZ99YKftn6pxU62D7r7Do3j7hWzV9OTZTj2
x3c5/18drlgEvhWcIYHzqDm34FECLucUbmpPbkSDzuz2de0NOLXth2OuZQVe
X368wyclA9w2BsabDKuQnJmyfb5nHPGVF2/MDTZAzkuwx12WhvLZ3x/8Fipg
+93n2YboQsSyT7C+u0tEu3b47p+OrdA4Er+n6nQrLu8I/p3e2gHZjMTGK/0M
v7ygoXC9MBVPeXn37f5FBU9ize5YuTmI8x//ct2BBMWMnoVvMaOoJ3nfjamg
wYezZdAmuRBCTmPd+7yrYHd//tep4Er4spEyk2SrYE2XFmbhJMC3KsDo0QsC
7FLPE8QfJYODyWRjZGgZzB0mAkmENvTtIFlvv1+D/joDnqkzJByV3LLy6Uk9
ROsWfK7zDeF31OCSPg8JetLVElui65Eo5jn4XbIONzfYcVgIkvElblakNTMR
+xWjVqP9xxi5ducluf11sDxGzlYVomD6ddWWn1qN8Pt4ZtAvqRn9BUEvnllV
4avK/JYdlU2IvZrT+OsNHYVxF2L8ukm4de3n8FJfGzhHvQ/zmbTDPEzRip5I
xjbOjCQ37Xq4uJyu3PSpATQhGm+BZQ4+KVLs1g61IWCCy5hnTw9EtHsbTsXT
kNv+108rioTj5yqdtOqb4Yzalan8dsYcVpocp/6veyluwfIEzO5u+RGwlwqT
yV26u88R8YmwEGMZToGCX47JCLUUt8u25H2+l4nlMqby9gdkaAbYrzv9oBWq
52UiXEQZe8kR+eZeSS0ip9FLm2oHc6X5NfO3NZBJ6BK2XCXAQVQt+VxfBdb5
Woaez/0E8ZGYYkojFbVl/QWbwhrw5aRyj7M2Qx9L9VPlBwggx7zmTpiiYy9h
QOGA6wQiv05JJap24nT1omZRNB0Svv96sjY34/tqlXRLdDKiya8uBMi2oMdx
dNlmOQ/MPwbJl19X4tjgskv7lkJcO+QRB2oOdPnGgjUtC5C04drMf0xNEIqs
Uj271o1k15rf1yJokHvVbXXUaBiB6SM+6VlUfHfy/G/b1UpMXrhLOcjwmRa/
BZyqrsJazPXivsBOVKsUbF4UYuyBt315aisZXVKJUawD47ggcrUuYQcdkQ/s
R7R06pD0skdwwoWMs3l9XJSqFohP2s5yK7eAra7VXdy+Dv1vb7XeyuwCr3nT
fbrpAHzyJArcrGjw67jvYTxAQOTTIvqjszSYrXzj1XgYgc6t7N1H+sjYwbG5
+KlMP85xcfS89qPjSKyQyL+VTrxP/LZPakMd6B2qwmU8DSi4qUfl025F24/c
MI97oxjRUjTaRSqBl8k47yefd6iOW5WZ0qOhzTyVtfOMD37kmHPyD1QiMfl7
444fmVifGcDRnVSHvjRnDfePzQi8fOr9slcdVoycC2mjqZh7dkkliqUdd6xT
ZByotdDe72q6vEZB9W21ydadeSg0Umx/6UyCyNrnrfHvRrGmN5wa9YiGt08c
pcXi88G6lnjmkHwGTBraDipnhcON6zd3z8FC7LgyFyqwOxaan9KuOh1vwOy2
4fvuO3qxbFSiZ2TWiqSNCaaE+FZ4COVZy9URMVUt76ifP44jD2e9apMawfG3
qXtaqxuqpreTDzK4mc15XrwyswSyyoeURZco+HUsrPfD4xpofA295HqyFXd8
z1TMHc0AQfD7eJNAC6TILzqyn43Cw1r3Jd+/dviljN72U65F6Uz0q4p7HbA1
bwhrF60B4QO33q1JBiePtFRuXOtDwB6jQaMjFExtSJuiHU5C3QmWDTVqzSAE
33y+0aYWbHl5LywZvA3otfLRZHDrY2z/8g4NEsItNFyDI9+jQfnEjfJSKrzE
FCTU/qUjbN2NnCoG72+1b9KylS3DvfE19xffyHgUYM4tJzQFr3r96jILMv6b
b7HSWpzCvr+yY/vOU3Dyj6CnM7GckfO+6DcJV8Lhul53fW8JJjYeP7f8tQ83
FywVDr9qxZIzd8u+74xe4BjWVuzQjZ8RV77nZDeB/UCaiP7lSmhrdAm3XKbj
cYvHjOfNBvzUvtV3WqoWMXTFHVlhCVhnOXuixpKEj4ozNzhTqpAkw+ux9XEP
Qni/aeUd6keekZ+7wRYKPuXYMnt2JSO0JVPN4XID8g/uZjVt78Klh/bD/0lR
Yc2eQg2xL0Xea2m+6W9ElG27JrT5fCN6EiZjc9o6UBV6rZRDuwukgHCFv08Y
+WSlU1JoIAX2/MNppUG9uEgSCOzZwvj9ut0psz803HNOEG1ML8Fdb6Fn2p40
+Htxve5SacKT4DfCv+5WoaapUjCUKRkVpNwGpnU0bK17P8nWkQBd1+2fgm/T
sfFkArmQVAyv2k/Hw0U78GD52Xmns7HYbSPYPxDPyF29zgWnmbvhFPSX7fcu
Cm5kTjecZ+ytzuMTOx4ycqJtlY9o8/AHCP76cXXpAhmXh/lyRBhz1u5UZm9W
Z3BWb8o/qZsCrZ/j5P0n6Qiynn6wsWAAIq1qp4940LHOe8Rnb0QrGv+0PJYM
68e4ybm0Kca939hNTy++VALBC2fcKs83oZpFt93oOg0rkk284SfzMd8Zd3Y3
uRXKKR0/b92dxqOKpb9fDfKx0M1W9yIlCRyCfhpXlYrg6MR1cTw/CmzkN8/B
UoXeSzu4nvWQcO3T/deKOk0Y343fRyuGcfrhzS6VoVrsUsoIDrXvxPbsm7dS
hyjI0TnAd4qjFG6HznHFcNeh3pN11CErF38339UTdyfhxrE/Ac1hrfi8yHJA
7WgJUrLlrqzbkgxN2Ut9YhN1uDPKFL07vg2PF/RqSvkZudHrylqQbTrEm5Of
xFHL0DDZqUWWycMV3Uk32e0MvbVlG2nMFIPlvNlnzVg6rBZMixelC6Ak4bnF
5RAJsZymu0o3xEI59afbk6/NUBmc5nldQ8Fzd5Xy7Yz8euLRkhOPcwuMOuK3
e9fW4MFf7wW6bxLe1up5vXVrwaaa8e3PGe+3R06+cZttY/ghx2OX0BEInsk+
oX2oFCoKlw+vZ0/FNZXU+Pl4Mv7N3izm/JuEgOMfVrZvqcPjrFfqSrGFSPLN
evDHvAqHZI8uMyu3QvhvMdPnhw1IoQ7uf11Jxcz9Sylrv4nwso94pnUwD/OV
C+bkAgJ4jhLKbuoEIc3r+XozRl8yy3qmdX96BGIV61Y6/7ZBs2Dvbs5LDC7r
VHz8UkgCE8cJXb+vWbAfHoyXnqXjPKHwqAX1Exyim2THb5GQnrb0a+PhRKhu
5CkptC7DtMmo/0BGEmoMb7+7c7wAl5jfZzx8Vw4+r4i7854kXH/b43etfwC/
NmzY3GtVDd24ixtufC7D7A8JtgStViwO36d6+9aC5HZU6M3vSojw38/k+/wB
unP1nB5fyXCZEN5pajYDiTSqWMJEOcT+e6qtPDmAe8kzH899qkdEyOXc2sZi
TCyeHGjyboTLQ231lOoyzIfcuTWRUQcOhxjrTy5ReBCyN+zh1hp4i3ifKklq
Q8/O2apMRl/17adm2xvHo4tA0/m5gQS7QtG9T++Q8LzklNEmkwbULq+qav0b
g5D9nF+qRxlWmVUPcTrGYqbyXqObVCcGHFnGH1xtA7u6Mqu+SiOYbUhNVhn5
iDTZcJ1GrkV9/pNb5+RT8bLT+aPl+3x09fysak8KQqVV1vzsEUZevR1NWNqU
COO5uB1/jRqwz9ljT8DiOLw7OzY7FxGxx0jebkyDCuZtndssLbsQymLYqaXQ
AcPk4Mw9B0qgoOSZsuP2LIbLF8J/TjXi54/KtPflGShznus/+4QA5BH/0xfy
h9ymm2GrnlRs5Vu1uDYzCQ2L0/itRgQh5+ehL9+bsVPt6fotpFro/xQkiJ8Y
w5jngW21+zuxt32Hf8ibelT83v5cwI4O8y7O96MDqYg8+C1vJ2pw/pef2KFL
eWgf3Pa2gb8Uom9ELKIORuLD2UzunRY0iEblfdkk3AvDOo+KtyPtMDUu37y3
p4/Rn0oCcjrqkMfbf3ZqezXubjEv7L9RAslBadI24yHsX7tmIS/WgrhDPnEz
G2oQHGAgKHGmBoaXq1J0WKpRec3+qOlYKRrH9MSnp5MwraFxVvVyPeqnYkzc
iWN4XtAlFxzbjD//WgMdQmtwrdgloeAmFfrinreLAkgoinIl8thWY/P8Pycj
9GDVN9JYWqcPuml7g8pSOvFK19/7O6UG5b16X6abeuA09yV+vrsYZE+2XrWc
epwKcWTNTWzCM6HLBuICFJjuKC3b79cCyknSfppwM3RHpDw71WugNkhtsOht
hkwVl1aVHhFZKn3UsopcPOI7VDDPyOljtmO2L5424NNqlE+vDBkz7z5+ivxR
A/sWgYN613Pxe/GF9Nuuj9gmXIXugxQYSqxqijR0wCJKZKO3RivyI47d7BXp
QI8A9UrtAmPfxmL39l6shfOo2ptQyic8tT9xXUm1FQF5rvPpr1sgoHHCmutb
K/KYXsvn3muGQm337I0oMg7SMy9zBFJwOJzTofFMFoz7zMzesVFxYIJT65fg
AGy5+BzveNZiH806TeB+Hb7XPdjz4icRd2WF+xvDv6K92DTGbksDuFlMjgp6
FuAN61m6+wPG3nQR7Me2x2P5ac0mSU06DP7TrBs9lYD0a6Iher10JIgXdoQ9
q0dVRxhFN46E0++1X6hezILqt9u8eh0N2DRElTlKYszN4JtK8XI9zm18taU8
IQ88Hfd/GplRsSH3sMJ3QRp8Vy4O3jpEB0mkh3cfNQFFjQs8fnw0HI5LGbmj
XYk2zdqwFx874VEaUiAeW4yahDaRDaNkqMmVnygUaMKw2sTMjYxciN4+Ty17
TwTvwl2OAEMKtns0yIvpF6O6OPNydmg9Bqe4XVTkS8E94KvkqtUE6QVrUZ3h
XNxMZJd+UU1DqJXQ04jhZly2TfxDZ8y1Xl6AOWitEWy25fqxKwSE3O4admDs
8cClnk39ti3oGvdLnCmtxcnNTL+szeqQ6qAqftUjBcfzlJqtjSohuyztNeX0
BfafNqbOajcjYfNCqv03Em52Vu7SECBj0E5lm1sbHe/bbV6F8Nci8bg2s/Ud
CrrCrpeUqzH6ELH3bl56NXg6J2flPjB6oiMphIepE6eWxzUvUtvRVLXPUqyp
D++Kbry7P0mEvqLIrOSWadSsCzge3l2LznGFr+b9qfgyJa52RrQZWZFsMcSM
asgd+JI8ot6Lt6fFssgTo/h+rHG00ovRN3+N7ajZ2oUD3LoF08/aIEPcdVKm
pw3mGiKpd7kYvW5k4b/lPgK6vn7seyzeDcWTvatdIsUwF1UmSz5oYuS4daWv
KaXQi17j3+pdClXi5XcsSvkwdI33LJsiIej+j5q8lD7cSRxL6M9n9Ob+4+fV
2D/DbORvC8dMG3amM7s6L3XBg22Nb9aBBi+Vp2WW9CL8D7RkcYs=
      "]]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      TagBox[
       FormBox[
        TemplateBox[{
          TagBox[
           RowBox[{
             SuperscriptBox["p", "*"], "-", "uniform"}], HoldForm]}, "Norm"], 
        TraditionalForm], TraditionalForm, Editable -> True], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox[
      TagBox[
       FormBox[
        TemplateBox[{
          TagBox[
           RowBox[{
             SuperscriptBox["p", "*"], "-", "p"}], HoldForm]}, "Norm"], 
        TraditionalForm], TraditionalForm, Editable -> True], HoldForm], 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->300,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.023056708850040537`, 
   0.6363750302587639}, {-0.04820059847458221, 1.006030298265984}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.884012196029457*^9, 3.884012240295251*^9, 3.884012288198164*^9, 
   3.884012559057365*^9, 3.884012851097315*^9, 3.8840133856521378`*^9, 
   3.884013428811202*^9, 3.8840136512859488`*^9, 3.884013726514287*^9, 
   3.884014073754488*^9, 3.884014196113626*^9, 3.884015303424016*^9, 
   3.884015350634283*^9, 3.8840156275106697`*^9, 3.884016831451799*^9, 
   3.8840174674255943`*^9, 3.8849964632874537`*^9, 3.885214273290443*^9, 
   3.8852184730003433`*^9, 3.885285937341345*^9, 3.885414918891262*^9, 
   3.885502615221813*^9, 3.88551352766667*^9, 3.885554138659478*^9, 
   3.885554348466751*^9, 3.885566091137031*^9, {3.885567922225975*^9, 
   3.885567937604657*^9}, {3.885567969978755*^9, 3.885567975432774*^9}, 
   3.885569330532302*^9, 3.894049945491074*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"e6903ea8-9180-48db-a9db-2d8279c189eb"]
}, Open  ]],

Cell[TextData[StyleBox["Accuracy of the optimal report against operator norm \
of A", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.884012468718375*^9, 
  3.88401248772099*^9}},ExpressionUUID->"4b15408e-205b-424d-999a-\
ec13adbf5a97"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subdata14", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884012513340663*^9, 3.884012517256351*^9}, {
  3.884522281490299*^9, 3.884522306794042*^9}, {3.885554256253442*^9, 
  3.885554256433011*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"cc3a88e5-8418-47c1-92e5-d8400e7d7c83"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minx", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata14", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884013315814835*^9, 3.8840133162370853`*^9}, {
  3.884522288355459*^9, 3.884522288466313*^9}, {3.885554258136181*^9, 
  3.885554258343669*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"a1068824-8851-452a-90f5-af4a36dde8b5"],

Cell[BoxData["0.28095604789032164`"], "Output",
 CellChangeTimes->{3.8840133857235813`*^9, 3.88401365132701*^9, 
  3.884013726593689*^9, 3.88401562760655*^9, 3.8840168315453453`*^9, 
  3.884017467518814*^9, 3.884523104564231*^9, 3.884996468162673*^9, 
  3.885214273322617*^9, 3.885218473037725*^9, 3.885218993255681*^9, 
  3.8852859373774853`*^9, 3.885414919139822*^9, 3.8855026153709393`*^9, 
  3.885513527789001*^9, 3.8855541387421207`*^9, 3.885554348621407*^9, 
  3.885566091198104*^9, 3.8855669807789803`*^9, 3.8940499455173597`*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"3ee0d5cd-50d0-4f86-9faa-ef58671cbc46"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxx", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata14", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884522289707193*^9, 3.8845222897839537`*^9}, {
  3.885554259771799*^9, 3.88555425995245*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"488c2fec-f2bf-497a-8e61-281f4a4c9a27"],

Cell[BoxData["0.8702069484436326`"], "Output",
 CellChangeTimes->{3.884013385769895*^9, 3.884013651380131*^9, 
  3.884013726637669*^9, 3.884015627653101*^9, 3.884016831595228*^9, 
  3.8840174675516977`*^9, 3.8845231054611597`*^9, 3.884996469020998*^9, 
  3.885214273349435*^9, 3.885218473065798*^9, 3.885218993948515*^9, 
  3.8852859373954678`*^9, 3.885414919350024*^9, 3.885502615482592*^9, 
  3.885513527876696*^9, 3.885554138780102*^9, 3.8855543486531*^9, 
  3.8855660912214737`*^9, 3.885566981645998*^9, 3.89404994554497*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"39726977-2f8d-4cfc-af9d-be3adb903744"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"miny", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata14", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143318092823`*^9, 3.884014344525115*^9}, {
  3.884522291378057*^9, 3.8845222914628353`*^9}, {3.885554266506102*^9, 
  3.885554266864491*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"6a44f6b2-8e6a-42de-a795-0d8dbdabaa8c"],

Cell[BoxData["0.0018353896604334995`"], "Output",
 CellChangeTimes->{
  3.884014355277335*^9, 3.88401447844201*^9, {3.884015285416799*^9, 
   3.8840152934026213`*^9}, 3.884015627705495*^9, 3.884016831633647*^9, 
   3.884017467586946*^9, 3.8845231067546473`*^9, 3.884996469929739*^9, 
   3.8852142733757753`*^9, 3.885218473084797*^9, 3.885218994712071*^9, 
   3.885285937411682*^9, 3.8854149194121237`*^9, 3.8855026156333838`*^9, 
   3.8855135279951057`*^9, 3.88555413881491*^9, 3.885554348678402*^9, 
   3.885566091244563*^9, 3.8855669825136223`*^9, 3.8940499455731916`*^9},
 CellLabel->
  "Out[117]=",ExpressionUUID->"9ec7cdc7-90e1-468c-864a-39f80c11640d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxy", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata14", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143501700583`*^9, 3.8840143533427343`*^9}, {
  3.884522294390691*^9, 3.884522295033194*^9}, {3.8855542682795553`*^9, 
  3.885554268789153*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"adf0d353-b631-4010-99de-9aa7d2ce817b"],

Cell[BoxData["0.4215186828599653`"], "Output",
 CellChangeTimes->{
  3.8840143559614563`*^9, 3.884014479136077*^9, {3.8840152862672358`*^9, 
   3.884015294230492*^9}, 3.884015627753573*^9, 3.884016831677526*^9, 
   3.884017467628291*^9, 3.884523107521693*^9, 3.884996470903907*^9, 
   3.8852142733933496`*^9, 3.885218473103731*^9, 3.8852189954526167`*^9, 
   3.885285937427558*^9, 3.885414919644444*^9, 3.8855026157409353`*^9, 
   3.885513528105616*^9, 3.885554138849771*^9, 3.885554348700926*^9, 
   3.8855660912688026`*^9, 3.885566983418642*^9, 3.894049945601801*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"4d6d16db-d91b-4421-8bd8-14950922cda3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trend", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"subdata14", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840119053884897`*^9, 3.884011933703392*^9}, {
  3.8840120521962643`*^9, 3.884012052730195*^9}, {3.88452229655088*^9, 
  3.884522296665358*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"6dddb80e-63fd-43be-beae-857f43da7c1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.05273962854402905`"}], "+", 
  RowBox[{"0.2752035907723767`", " ", "x"}]}]], "Output",
 CellChangeTimes->{3.8840119448526773`*^9, 3.8840120551812696`*^9, 
  3.884012558099855*^9, 3.884012851179722*^9, 3.8840133858201847`*^9, 
  3.884013651427788*^9, 3.8840137266838503`*^9, 3.884015627805661*^9, 
  3.8840168317186604`*^9, 3.884017467673553*^9, 3.884523108392568*^9, 
  3.884996471831213*^9, 3.885214273408546*^9, 3.8852184731228123`*^9, 
  3.8852189962916183`*^9, 3.885285937443247*^9, 3.885414919902363*^9, 
  3.8855026158658857`*^9, 3.8855135282240067`*^9, 3.8855541388856707`*^9, 
  3.885554348723579*^9, 3.885566091291914*^9, 3.885566440607349*^9, 
  3.885566984295147*^9, 3.89404994563452*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"160896ba-156f-44b7-847f-3c4bebf0391b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Correlation", "[", "subdata14", "]"}]], "Input",
 CellChangeTimes->{{3.885570468652562*^9, 3.885570476366802*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"21802f2b-5f19-4319-9995-42af3474945b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999999`", ",", "0.36437198509492036`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.36437198509492036`", ",", "1.000000000000003`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8855704773704*^9, 3.894049945668746*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"89e3f9bd-45a3-4430-b457-2b7112cc10a9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"accbound", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"S", "==", "BrierScore"}], ",", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"dim", "-", "1"}], ")"}], "/", "dim"}], "]"}], "*", "x"}], 
    ",", 
    RowBox[{"{", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8845229559839687`*^9, 3.8845229846174793`*^9}, {
  3.884523075769032*^9, 3.884523076687139*^9}, {3.884523121941701*^9, 
  3.8845231282986393`*^9}, {3.884523176641615*^9, 3.884523212796288*^9}, {
  3.884523420699067*^9, 3.884523449864194*^9}, {3.884523505999906*^9, 
  3.884523565953412*^9}, {3.884523762610065*^9, 3.884523766087171*^9}, {
  3.885220704906062*^9, 3.885220705250886*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"7040c131-d525-445f-b66a-0475cf5b8dde"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "@", "trend"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"minx", "-", "0.05"}], ",", 
         RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minx", "-", "0.05"}], ",", 
            RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"miny", "-", "0.05"}], ",", 
            RowBox[{"maxy", "+", "0.05"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{
            RowBox[{"\"\<||\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Subscript", "[", 
                RowBox[{"\"\<f\>\"", ",", "\"\<A\>\""}], "]"}], ",", 
               "StandardForm"}], "]"}], "<>", "\"\<||\>\""}], ",", 
            "\"\<op\>\""}], "]"}], ",", "\"\<||f(p)-p||\>\""}], "}"}]}]}], 
      "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"accbound", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"minx", "-", "0.05"}], ",", 
         RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", "Red"}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", "subdata14", "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882192696300736*^9, 3.882192700311585*^9}, {
   3.882195533785142*^9, 3.882195533944455*^9}, {3.882287808996023*^9, 
   3.8822878997355423`*^9}, {3.882287979342745*^9, 3.882288014377759*^9}, {
   3.884011926003563*^9, 3.884011929283166*^9}, {3.884012110721346*^9, 
   3.884012138083975*^9}, {3.884012181411414*^9, 3.88401223960191*^9}, {
   3.884012283054537*^9, 3.884012287357141*^9}, {3.884012646601001*^9, 
   3.8840126742000513`*^9}, {3.884012962093193*^9, 3.8840129654268827`*^9}, {
   3.8840130044338427`*^9, 3.884013014341793*^9}, 3.884013440128804*^9, {
   3.884014205369504*^9, 3.884014208109778*^9}, {3.884014596104752*^9, 
   3.8840148131085*^9}, {3.884014943228815*^9, 3.88401501350168*^9}, {
   3.884015383127598*^9, 3.884015434252266*^9}, {3.8845223001821327`*^9, 
   3.884522300275921*^9}, {3.884523005860135*^9, 3.884523035642198*^9}, {
   3.8845230832100153`*^9, 3.884523085096426*^9}, {3.8845234281815357`*^9, 
   3.884523428871141*^9}, {3.884995402269524*^9, 3.884995418258813*^9}, {
   3.885218934100951*^9, 3.885218957573431*^9}, {3.885219033018175*^9, 
   3.8852190457721357`*^9}, {3.885220713256021*^9, 3.885220713529642*^9}, {
   3.8855661852794847`*^9, 3.885566279786599*^9}, {3.8855663264141827`*^9, 
   3.885566416181868*^9}, {3.885566508938842*^9, 3.88556650899302*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"a152af05-5111-42a9-88e3-54ae9d0bfa5b"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVkHk01AkAxx2lepGpdSy1tai2yGKSu77l2F6DtI6xWptYR1SUjJ5dcuQa
qwjZxXPO6yET2mGUslI5foVIhhFjjFvzc701rqa2/ePzPu/z70fLJ8TZT05G
RsbxC/+75SxDsJzWAcVfR2lLBxLRku+yfzy7A5H5yrGMk19aaBT8Nr8DY32W
dUt+iWj1n5WyKzrw0iFLR1KSiLbQgG98WjsQZmL3UbIrCa9SPDzbP3VgcEvp
gxVKMjrrjw4UXe4EuzqI8nGFCZ6mAu+U/Rs4fFrolSNuYfpN6vri3S7Esdzs
ixUy0TYZ5OEa3o2M47cvloiyUV/ZtHDa+S3oRUUq1hW50O7nF8we7wGPnty/
1lyAD/Qfcor3vMMm+f3BNMdi6JqFla1SeiFNCJWyzrPwe5vm4oy0F04zet0O
QfegX6nKnBvgYZ3WYztxphRukm7jnFd9kHcft0s9Xw5Bpkiffr8fAV7jE9qO
FYgQXvRmJ/Chc8q5fbPhA/yRxi0vvTYACA5i3bIK0kw3cH98j4G65QMhGdUY
X6udDrQehDVPedU/7yGElLRO7vdD+Mnv3MXEwr9hFflURn2rALmLLP3dGRxs
o1Wc3LUmQGpvgYlVTg1OXJ59b8wfBpubnvb2di0YERHWEX5C/EaaGsz9xUXP
V2Y1eweFkGSpXj1cUAdRf1E7nzaCAosZufk7j3DIKShk5PkIVo6EvafmPsb+
+aFHi1QRIg2W5GfT61E+dauwq0gEdg67syvuCQIyCiiyX48i1UNDaM58Cp6/
xwHLpFHkqked2HmjATHisFetn0dB18uejkv6BxyifYtW+BieVY0f3pHaiOzu
zrmbY2PQ01CbTMUz1KYYnTf3HMfpjVl9Li+eIT742PWV1+NIuqI0Tz/WhMHy
JL148wmoqZTwSW4TQrKNgnyqJxDlc2ei1fw5OA8SnGh7JrFuELlTwHkOarhF
Y/yfkzhT1nTN1OwFvANzets2TeFJody/7ZwX0KgxZvIZU4h8c85OcuglFKsN
W63IKajeV633qX6Jah6votxzGs3ybfStes1IqxzSDOydhsPmXrXlqmYsD337
3ZL9DA7aSUvDqS2gmG0bSKmfwW5ZLW8quwW+Np7q16gfMBNQeNTIsBUXIlzX
fUs+oN1Rw/pSRSuWFJiROhQxNlyqVLfc24YGu93JxkliqBwpoDiWtsGk6hcL
J4kYllFMozwtAlczalyxIsZ1F6ZTgw4BNmNriMGaGJyDzMvD+whoWT1mKX8S
Q4+XXK6jS0CRUFHq2khip0GyFptKQCR6PXxGlYRUmLi9wYbAbTWLBGdjEo22
8QsCPwLEanqhtQmJdc14ZdkLBDYMTT6mmpEwXbiprxNEIIJ1d3aHFYmq/JuB
AcEEfA0X3HtsSBRK4kbmwglY0Mp0XV1IRJfFdsskE2Dof7a1dSPRcCN2TjuF
QDWF7mXsTmLVNVbJLpXAvj75LJWfSVyVjT3FTCdA8fWSvvMh4X02pml7DgH7
k1z1Zl8S+YYxw4fzCCTqKlFr/UnwFWKkbvkEPs7X+98NIuHCiTbPLSZg+m57
bMIlEmnMaPenLAKhdRfyGMEkXntFMwT3vvzKbaz1u0Jik0l0pkwZgckotS63
UBI2itEPte8T+A+0Qm/n
        "]]},
      Annotation[#, "Charting`Private`Tag$827211#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVjms0lAkAhpVd1nbT1dIFtdQqxZiVNOsNiTVJMXQsrZpcoi2XwpmKXaeR
ZdO0hZr2VFOdPYhF61KsalO5jEsGM8wwYy7GzHzmU7EU7WTtj/c85/nznNeW
mRAUPd/IyChgbv+z6bsU2TtOBxpoMdaziXw03Qy2Vxd2wGY62dk5bc7lzie7
b3aAXfOj99F0PppjxgxlpR0I2MqNbc7hoyU5di2zuQMy6/YKzl0++LlhEe0f
OzDPmLLLppePzvpvJLwTndjTajjsub0NIisT0bf0V+gKKbh73tAG3auLH8YL
urA5gJvBnOu2aOLDGKkCpNp+1fCC9gr15c/e7gvqBi1/a9mGo11Y3y++Nbar
BwqTKvsrbgKMhu7h3rHuxcdYw4HGWQEc3E4XT5sL4eH2Z8ntvm6cbbEaJwxC
iG3rnPJKe+BYvjLntUQE/XTWMVpSL0KmBFQuvw8bPB+3X/cVQnZV6Rh6vx+C
1HpF7RIRWPLjR8qyxJC8NLNX94jwC6e2pOiUBKbs54V/F/fBcDUEtQcGUObk
/ehQQj/UMzW6OK9BnN7raFK8Rwy5OaezdqsU1zPjzs+3koB2rsHIYoEMLr8f
f7BuSILF/qW+a2ZkmNjev0BbPQDPE2MDVPEQHOo+tzh1bhApLJYXK1oOdknR
vlKGFD3L3aq/HJRjZ1VhzcQmGZT9vHaxvwJxpfQOw5gMWwLjExSNCjQsO760
5uUQ7N9IH41TlPCmbjK28JWjRJt3u4unhHDUuyC8RI7YK7fM532hwrQk//HU
cgVEMWGbdmarEPbM70lymgI/6U/zm2dVoA85h/ioFKhqbTezTR3GqNkLY5sA
JQoFna/PDw+jaXNd7kCFEjW5zod3RKjhkqUqIq1UYJ/0SHvfpsagMPGmPEOF
wZLszewdI3BxKbo/IFchodA5nlk5gtUty/Y50odR9UdWoL+1BrsYitbI8mFQ
Ut2fsq9pMGWhHtBaqnEkjitsMdVC201vCspQw7KamiNO0SL7RnjLC7kaCyud
mmmkFnVc3uE8+ggqRaLSkggd7C/7CVwrRsApl1rFCXWwe2LX77pag3dSm42T
dALd70unPLI0MHdbLMmtJ/CXQwG5UatBlHeExSnKKFzzq87EBmtxjMX4EHV3
FPp/qPLsh1pMmuSc22Cux35m5KFKSx0e+6z7mZqth4/p08RtbB1cKw65B07p
kXYvM4Kj0SHpSjUD7/VwXy9ZRdfpUJayIGHbjB4GHkVgMqqDLa3u3pKPemTe
UvlkjOmwsHXFoq5PSVzk+mw7MamDUtk2tH8lCR7HbD7dmMClVe5ZQVQS/LO/
FplYE2idvnzby5VE3ozuSKMNgU+kmjqKG4lAlteajPUEWPcKxpbRSPSmTlye
tCMQ5fT2YI83CVlSyJnhLQTc/YsdGMEkJmItAxrdCaQ4zu7eHUKidiTJNING
oNI8NJJ6kAQrmv9shwcBuz7j/BXhJAzMs64PPAmYR0UaepkkPvteas3zI0D3
rbV4GUWibfBrSbg/gQsOiyg1MXP/wi/lW+wl8O+b+piCeBLLw2DGCSSwvXdp
ZtYPJER91577HyCQ/PDYbyknSXBD36SbBBMou/G0JjqRRLjQz62RQUCTvqor
JJnEWsad8fRQAv8BMoaB1A==
        "]]},
      Annotation[#, "Charting`Private`Tag$827264#1"]& ]}, {}}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwV13c8lt8bB3AqJBlFaVBJkowoZUQfDVmFUCqroaSkCKUyIhLKzMzee++9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      "]]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      SubscriptBox[
      "\"||\\!\\(\\*SubscriptBox[\\\"\\\\\\\"f\\\\\\\"\\\", \\\"\\\\\\\"A\\\\\
\\\"\\\"]\\)||\"", "\"op\""], HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"||f(p)-p||\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0.23095604789032215`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->300,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.23095604789032165`, 
   0.9202069484436326}, {-0.0481646103395665, 0.4715186828599653}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.884012196029457*^9, 3.884012240295251*^9, 3.884012288198164*^9, 
   3.884012559057365*^9, {3.88401265317181*^9, 3.884012674696662*^9}, 
   3.8840128513061438`*^9, {3.884012997084785*^9, 3.884013015020599*^9}, 
   3.8840133859119987`*^9, 3.8840134416482487`*^9, 3.884013651531496*^9, 
   3.8840137267722607`*^9, {3.8840142373062267`*^9, 3.8840142409286833`*^9}, {
   3.8840146707242937`*^9, 3.8840147075732613`*^9}, {3.884014743802075*^9, 
   3.884014779161002*^9}, 3.884014813619544*^9, {3.8840149626446877`*^9, 
   3.884014968531563*^9}, {3.884015005785964*^9, 3.884015035325348*^9}, {
   3.884015384651052*^9, 3.8840154347750483`*^9}, 3.884015627882365*^9, 
   3.884016831802718*^9, 3.884017467775408*^9, 3.884523036969812*^9, 
   3.884523091603183*^9, 3.884523148106153*^9, 3.884523218607544*^9, {
   3.8845235148024178`*^9, 3.884523567240592*^9}, 3.884523767522675*^9, 
   3.884995420567873*^9, 3.8849964735883837`*^9, 3.885214273501302*^9, 
   3.885218473181959*^9, {3.8852189413886023`*^9, 3.885218957977079*^9}, 
   3.885218997949646*^9, 3.8852190920068207`*^9, 3.88522071600043*^9, 
   3.885285937503377*^9, 3.885414920309082*^9, 3.885502616089416*^9, 
   3.885513528433165*^9, 3.885554139235787*^9, 3.885554348838273*^9, 
   3.8855660913791227`*^9, {3.8855662404434013`*^9, 3.8855662827861147`*^9}, {
   3.8855663310255938`*^9, 3.885566359079953*^9}, {3.885566396019478*^9, 
   3.885566442949785*^9}, 3.885566510049325*^9, 3.88556698637262*^9, 
   3.894049945760133*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"c53db7e4-24a6-45a5-8a5e-8576aeeeae21"]
}, Open  ]],

Cell[TextData[StyleBox["Distance of optimal report to fixed point against \
operator norm of A", "Subsubsection"]], "Text",
 CellChangeTimes->{
  3.884012468718375*^9},ExpressionUUID->"be3288b6-eaf2-4572-bda5-\
d3264f983fd0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subdata13", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.88401251958403*^9, 3.884012523490527*^9}, {
  3.884522229796391*^9, 3.884522232535627*^9}, {3.885554274362846*^9, 
  3.885554274746932*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"67723295-67e9-4a71-848e-f883623de3e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minx", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata13", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884013315814835*^9, 3.8840133162370853`*^9}, {
  3.884522241564007*^9, 3.884522241668228*^9}, {3.885554276362211*^9, 
  3.885554276911913*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"88a6f15a-7b2e-4896-9027-bda98425f0f8"],

Cell[BoxData["0.28095604789032164`"], "Output",
 CellChangeTimes->{3.88401338598598*^9, 3.884013651593842*^9, 
  3.884013726864806*^9, 3.88401562795704*^9, 3.8840168318788147`*^9, 
  3.8840174678981943`*^9, 3.884996496810851*^9, 3.885214273540079*^9, 
  3.885218473207171*^9, 3.885285937536001*^9, 3.885414920601489*^9, 
  3.8855026162808437`*^9, 3.885513528557467*^9, 3.8855541392909927`*^9, 
  3.885554348925716*^9, 3.885566091439694*^9, 3.885567058249014*^9, 
  3.885567486583603*^9, 3.894049945795416*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"96910600-a5c3-4d4c-a294-594b6cb731bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxx", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata13", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884522243789529*^9, 3.88452224388069*^9}, {
  3.885554278255076*^9, 3.885554278602675*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"5e06c5b0-1e5b-41a5-a8bd-1b7fe495453f"],

Cell[BoxData["0.8702069484436326`"], "Output",
 CellChangeTimes->{3.8840133860348997`*^9, 3.884013651641603*^9, 
  3.884013726912167*^9, 3.884015628000339*^9, 3.884016831921006*^9, 
  3.884017467927054*^9, 3.88499649788476*^9, 3.885214273554674*^9, 
  3.885218473226289*^9, 3.88528593755196*^9, 3.885414920805442*^9, 
  3.885502616408381*^9, 3.8855135286346188`*^9, 3.8855541393265753`*^9, 
  3.885554348975913*^9, 3.885566091463752*^9, 3.885567059037806*^9, 
  3.885567486616933*^9, 3.894049945820651*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"8588075c-35bb-4e98-b224-d8d5af4f5641"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"miny", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata13", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143318092823`*^9, 3.884014344525115*^9}, {
  3.8845222465037518`*^9, 3.8845222465883827`*^9}, {3.885554282658259*^9, 
  3.885554282935255*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"b47c32ad-2386-4df8-ab05-ddd6908a2d91"],

Cell[BoxData["0.0017994015254177887`"], "Output",
 CellChangeTimes->{
  3.884014355277335*^9, 3.88401447844201*^9, {3.884015285416799*^9, 
   3.8840152934026213`*^9}, 3.8840156280504837`*^9, 3.88401683195887*^9, 
   3.884017467966743*^9, 3.8849964986389503`*^9, 3.8852142735705976`*^9, 
   3.885218473245205*^9, 3.885285937568231*^9, 3.885414921103016*^9, 
   3.8855026165475388`*^9, 3.885513528748063*^9, 3.8855541393675737`*^9, 
   3.885554349013412*^9, 3.885566091488043*^9, 3.885567059794348*^9, 
   3.8855674866509542`*^9, 3.894049945849204*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"40ffeafd-cb06-4fa3-8821-3140e009d6f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxy", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata13", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143501700583`*^9, 3.8840143533427343`*^9}, {
  3.8845222510213327`*^9, 3.884522251089953*^9}, {3.885554284346743*^9, 
  3.8855542847443943`*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"77ca7e86-da6d-49d7-be68-2c68df03e2d3"],

Cell[BoxData["0.9560302982659838`"], "Output",
 CellChangeTimes->{
  3.8840143559614563`*^9, 3.884014479136077*^9, {3.8840152862672358`*^9, 
   3.884015294230492*^9}, 3.88401562810179*^9, 3.884016832002812*^9, 
   3.884017468001355*^9, 3.884996499494858*^9, 3.885214273585688*^9, 
   3.8852184732644672`*^9, 3.885285937575616*^9, 3.885414921273988*^9, 
   3.8855026167138443`*^9, 3.88551352885538*^9, 3.8855541394025183`*^9, 
   3.885554349049436*^9, 3.885566091511757*^9, 3.885567060693206*^9, 
   3.885567486679227*^9, 3.894049945879079*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"aa7ca6cb-5e90-4689-9276-58acf66d1902"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trend", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"subdata13", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840119053884897`*^9, 3.884011933703392*^9}, {
  3.8840120521962643`*^9, 3.884012052730195*^9}, {3.88452225384838*^9, 
  3.8845222539347486`*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"6d86ed36-b41a-4fe8-bf25-cb7f6bcd5a29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.13911156164199845`"}], "+", 
  RowBox[{"0.5259377562297637`", " ", "x"}]}]], "Output",
 CellChangeTimes->{3.8840119448526773`*^9, 3.8840120551812696`*^9, 
  3.884012558099855*^9, 3.884012851382483*^9, 3.8840133860859623`*^9, 
  3.884013651688321*^9, 3.8840137269736423`*^9, 3.884015628161447*^9, 
  3.8840168320472937`*^9, 3.8840174680483513`*^9, 3.884996500436287*^9, 
  3.885214273602344*^9, 3.885218473283431*^9, 3.885285937592533*^9, 
  3.8854149213425827`*^9, 3.885502616834206*^9, 3.885513528974147*^9, 
  3.88555413943887*^9, 3.885554349086666*^9, 3.885566091535182*^9, 
  3.885566525305319*^9, 3.885567061567397*^9, 3.8855674867060843`*^9, 
  3.8940499458887997`*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"e52eed04-ab9e-443c-9441-1da940c353ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Correlation", "[", "subdata13", "]"}]], "Input",
 CellChangeTimes->{{3.8855704885582457`*^9, 3.8855704918349743`*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"d9643718-9482-4ceb-9264-48487cb08031"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999999`", ",", "0.3367615693590307`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3367615693590307`", ",", "0.9999999999999998`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.885570492390279*^9, 3.89404994591757*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"95f5aad9-d0e4-4def-98c2-e6f5c6c79983"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"fpdistbound", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"S", "==", "BrierScore"}], ",", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"dim", "-", "1"}], ")"}], "/", "dim"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], ")"}]}], ",", 
    RowBox[{"{", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.885220721444236*^9, 3.885220736268064*^9}, {
  3.8852207745753517`*^9, 3.885220782221633*^9}, {3.8852208523632183`*^9, 
  3.885220876270487*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"ac4676b1-9676-4372-8e9d-97091a577aa7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "@", "trend"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"minx", "-", "0.05"}], ",", 
         RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minx", "-", "0.05"}], ",", 
            RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"miny", "-", "0.05"}], ",", 
            RowBox[{"maxy", "+", "0.05"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{
            RowBox[{"\"\<||\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Subscript", "[", 
                RowBox[{"\"\<f\>\"", ",", "\"\<A\>\""}], "]"}], ",", 
               "StandardForm"}], "]"}], "<>", "\"\<||\>\""}], ",", 
            "\"\<op\>\""}], "]"}], ",", 
          RowBox[{"TraditionalForm", "[", 
           RowBox[{"Norm", "[", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<p^*-p\>\"", ",", "TeXForm", ",", "HoldForm"}], 
             "]"}], "]"}], "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", "subdata13", "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"fpdistbound", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"minx", "-", "0.05"}], ",", 
         RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", "Red"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882192696300736*^9, 3.882192700311585*^9}, {
   3.882195533785142*^9, 3.882195533944455*^9}, {3.882287808996023*^9, 
   3.8822878997355423`*^9}, {3.882287979342745*^9, 3.882288014377759*^9}, {
   3.884011926003563*^9, 3.884011929283166*^9}, {3.884012110721346*^9, 
   3.884012138083975*^9}, {3.884012181411414*^9, 3.88401223960191*^9}, {
   3.884012283054537*^9, 3.884012287357141*^9}, 3.884012692543071*^9, {
   3.884013025508174*^9, 3.884013027475286*^9}, 3.8840134464215918`*^9, {
   3.884014216598124*^9, 3.884014231500669*^9}, 3.8840154578520603`*^9, {
   3.884522259532007*^9, 3.884522259612155*^9}, {3.885220800374111*^9, 
   3.885220825912838*^9}, {3.885221328027884*^9, 3.885221334612912*^9}, {
   3.885221370283174*^9, 3.885221417592268*^9}, {3.885221473529538*^9, 
   3.885221558259131*^9}, {3.885221628439375*^9, 3.885221629777446*^9}, {
   3.885221690695821*^9, 3.885221699761713*^9}, {3.885221761804326*^9, 
   3.885221903115903*^9}, {3.885221995802352*^9, 3.88522206254786*^9}, {
   3.885222093151492*^9, 3.8852221469426003`*^9}, {3.8855665198909082`*^9, 
   3.885566519953641*^9}, 3.885566559941708*^9, 3.8855665948596907`*^9},
 CellLabel->
  "In[131]:=",ExpressionUUID->"3d3c0f7d-606e-499e-9109-cac419baede8"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVxXk01AkAB3A2FRuaUEq2Uosixew8Sepb6EJN5NhKjyRXiyJ6Sm/bjXVs
NSE8bXL0CkuaraHMaieSqxnGjN/PuMbMuJkfIoWi3f3j8z5GfuFu575RUVE5
8p//rz0ZJf3EEqDQM3JKbUUqrzb7uEl/hgDXe3ykPVMpvFqZVZgoWwD3IJcG
LpnCqwsYmy8pFmAmxjjnwv0UXn1E4Hd+dQIcym5z6jJN4TUmn/DmLwjQ17sr
//meO7wm7u6O3NAmWCrU82skN3mkwRLysHMzaPrmp39mxfOGm29+nkwXQoW9
171AM5BXPxhywj26BSrM6SeucxfBLa16f9RNBF/62/HAyARslLQ/GNsrhkrS
5UUVKWkY9TyQlbe+FbRQtbzK3nsws7lUOEsjUHNNJnULzsPVeoPJkXkC/Gdh
ifZHH8GidGXSeAeJD/KZK1YThfD42MLIamzDsQEDizRZCaRpCgvPPyUIiDDU
mzvARozs/JmS+HYkBzmsD9J7ht9Z5UUFkR1wOWydvFyDg/k0D5S7dsLAtCDL
uqsM/XNlw8H2Xfh1vFc9k3wBGY3VVL6tG6LSl4vL6ipgF1upor9MCvr5ZQVu
mX9D26n4oOGcFFt1zAq33H6FfaFjnYz2HtiU1x65fpaHqJgY+5hzMoTlZ25R
Z7+GWNeG832XDIx+/anSoiooJLn8dic54kzabqenVmMrMyRcXi3HhtOxHatZ
b2Ay0f1ykq6AfarvTOeVGhQN3coR5iogqaZ1z595i8DUBzTV1b2oHHp8sdK7
FmTAic27EnqxWStWwj1Qh+vKS411X3shM9kx7uFYj+cNfA2j6D5o2/3DZ+5u
QEZL0/iNvj68ZsbFJhk3oizZynendz9qfrTs8jF6h7iwPZdn3vXDxXetdrQm
H11FCeZxOwdw6KxoyegkH+EZViF+7AGkngp/+kUpwPMn8Uyn9YPwd3M2O0o2
gR5ty4vLHETcHi0PO3EzzgRnEfVLh3BXb+mWMh8h1nAYSe1RQ8hLoJKvioXQ
ZFvW2VFDcJ+udaS5toBNksVF3sNwUfAGHWtbwCrtNggmhjHSUKw4uF+ET90b
TKedR2D/dH7vXJUINBvtjmTuCKS64Yku1mL4O3jrR9JHsSFSbBrKESMoxv2z
f/4oHrt6sS3MWjG9JCl2E02JAYt997OzW/Fq/7pERoISfLV1sk4DAtZPT9sy
Pyrx6aSBFpdF4GIqxx0zSryaed37JoVASdSy8O1zStzICOQK0ggY2VU8XL6g
xHIRJ1CeSUCzQU9LuJiCyWFmtXouAYXiXc+xlRQ8d8Rd9mITuL3KNt6NQYGj
Oyb/ICTQMHsnx96awtW/7r5cEBFQ6x6soNtQ2MfcxVInCMQ8TB/TsaPAT060
M2wn4G/53kvsQKFPdVOmg5yArVOhmftxCroTXi6p7wlEWXx1dPSg0H5rYeP9
KQJsmqcPw4tCjvmj2UfTBIzbFt3VO0XBPHDyccUsAZq/z3yrHwV76U1VuSoJ
54Pl+m/9KWjE/iAZWUTiNzMtelkAheY1HaUfFpP4MsENSA+hcMrD1Fv9WxI7
Wlf8Ev8TBaMpAV1Hk0TEi6A/osIoDN25pGGoTaLkHq/s3AUKT7atlRnTSAxe
WyX0iKAQya8q365D4l9C3Xss
        "]]},
      Annotation[#, "Charting`Private`Tag$827420#1"]& ]}, {}}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwV2Xc4118bB3CUpITKqFCklNAPKSV6oyEqRFtIVgplpmmVpIzsUfbee2Xv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      "]]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVk3k41Hkcx0VYj2OHGYxrKbNsxOYq9+ebYltad4pVSY4oR4SV1lJEKjwU
j61cKYmYpSgpVnIPxjnjHMcM5vfLmWscrf3j/bye17+v53nv8wxy9Obn4+M7
s7v/2egWNrqWQoPicMZL7iE6ND5xUmNn0OCrxTuu+uFdZ+kEdj+hQcJoxLS3
CR2afOa2S4ppsKypTZ6ypENziK+SZxMNQGfMbdaNDq1Jru7tOzT4694fibLx
dOioNhvMDegAmwdiuQKDdOiXF+r/1aYT1GTn6lVvd8Ns573NpYddcKS14RNF
qBeap/1dncPpEMvQiy673gfVpf8u2jp2w4dxK//2lX7Yz2Bmz6EeqNgrp3Iz
jwGYi1VWnnIvuHy4WSB5dBA0DK+92CD0gXiD+8UgmWGIapZf4m73wVk5llPN
2gholUrfmR/sB0pSlYtB+xicWqXrZ7UOwJp+fXfEPAtG0ye0XF4yoN2vKCdr
aRwiWZcvlMQzYbQuJvf7rQm4m1JZVBg6CIqvz4e1HpiC7fRTUOkwBJ7L5CRl
BzaweW9m/SyGISMz5p+reRxgEVI6KrVHQL6nqOfE9jSY3qjhkxUdhSuL5e/e
Oc6ChHXxL4q8UVDfH5yrxeTC0YC5IX3mGKjlvFclueEQFhlpEenNgqGnhq1+
xDnoIRq+pgyzIGvmVd+fY/MwwchtZ1qPA/WuX+qVngU4aOcfNF4/DjfHJGI4
zEVQWxh5u6Q7AdjtgcuEsSUomrmf05U7Aeq10uPl88vgm5ZN2EOeBOJh+9p1
zRXo93H9ySRhEvja8jL9L61CDH6ttenbJKil2ElaMNegoqVdZF/4FPDCJNef
e2xABr1j/tbUFGS0KSSRMB68SdLxMHJnw07I+dHl6i2ICzSPWG9jQ2GLkcfp
tB0YLkrQjDPiQPIEr7TwOB8KytDx96Ry4NOYcTs1aA+qeBVvZ608DZJSlubT
+fxIN9y4Ni5zGtZowwEVxL3ogl9WX7PwDNz7MdTeIV0Qyb3Wv8MMmwGHgLjE
msPCSIx6qMn0ywy0N8WIOx8RQdT+/uIi91nQEiKXVbqIopTSEXm/vlkIQf1v
NXjiaG1ERX3FZrd7bFnYt2gCIhhKDCZVc+GAGEb6gSKFzIIFovxruBDMerrF
0JRC/i/WFaw/cmHxIM8nS08KfSZPnhWp50Knxr4hjWNS6PpG1XhCCxcGT+TP
pHpKIXb1hdk4BhfSks3nA/OlULXZm/XoVS7MB3DMctSIyOuYu2yoLgantk4S
XSxIyJSCj+rqYyC8/1aKsA0JkQRvPF8ywAC52XnXOpFQQ+MjgxAjDPQb0ows
vEmIYj3kdBVh4JPoaf0wkYTY9m6pQbYYjJxJd4/oIiGfc2dErvhjoJoSzefh
LY0uRTpveuVjEEiz7Ex9JoOybVxXFAowyI7Iaxsvk0G9Sufmu59hYO0kOmtc
LYOO1vtOoiIMuN9lvhLslEHyolFtilQMaMzGwJ11GdT2OO9R7wcM9iSMJMfb
yiLtujmT40wMBkI30vT4yMgrbdlgcxCDui++yY9Fyehvr/Wfy4cxsJys25GQ
JSNhEX6KCguDdSWPAII2GbEcpMW2OBiwr3G6bruTUdqkyXDFVwyOGKtfOvme
jFaE7txQJeBQIK638CBGDi38XlX3TRKHEBGv067JcginsvcOE3EooTBpGo/l
0ISbxf0Hsji0qGjqrVTJoY7SzSeCyjgwv8QuHliQQ4UugbXTWjiQDTOsKBfl
ketzJ/4SGxyiez4X4E4KyHkz1irxNxxOcxY5kRcVkL09NcnLDocdv6YBmVAF
ZMUTIyo54SDAplJi0hSQrm2javLub7vd5gjEbgUkumpoGeyHw2SguYC9syKq
cKz/K+oqDrrlzR9NsxXRf2XSwzY=
        "]]},
      Annotation[#, "Charting`Private`Tag$827549#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      SubscriptBox[
      "\"||\\!\\(\\*SubscriptBox[\\\"\\\\\\\"f\\\\\\\"\\\", \\\"\\\\\\\"A\\\\\
\\\"\\\"]\\)||\"", "\"op\""], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      TagBox[
       FormBox[
        TemplateBox[{
          TagBox[
           RowBox[{
             SuperscriptBox["p", "*"], "-", "p"}], HoldForm]}, "Norm"], 
        TraditionalForm], TraditionalForm, Editable -> True], HoldForm], 
     TraditionalForm]},
  AxesOrigin->{0.23095604789032215`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->300,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.23095604789032165`, 
   0.9202069484436326}, {-0.04820059847458221, 1.006030298265984}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.885222099051749*^9, 3.8852221479919453`*^9}, 
   3.8852859378349857`*^9, 3.885414922165225*^9, 3.885502617336541*^9, 
   3.885513529713132*^9, 3.885554139742155*^9, 3.885554349360153*^9, 
   3.885566091674917*^9, {3.885566520583069*^9, 3.885566526842443*^9}, 
   3.885566561050102*^9, 3.885566596659617*^9, 3.885567064235949*^9, 
   3.885567486884822*^9, 3.894049946070853*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"1bc47f8e-ac32-4a04-95a4-bc4324417765"]
}, Open  ]],

Cell[TextData[StyleBox["Accuracy of the optimal report against distance of \
optimal report to fixed point, along with the plot", "Subsubsection"]], "Text",\

 CellChangeTimes->{{3.88452244743425*^9, 3.88452244991464*^9}, {
  3.884522499581081*^9, 
  3.884522524243498*^9}},ExpressionUUID->"6235bc7a-10ae-41cf-8d57-\
acc08927cb2e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subdata54", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884522452917981*^9, 3.884522461532322*^9}, {
   3.884522579777443*^9, 3.8845226066532087`*^9}, {3.884522916990265*^9, 
   3.884522917091852*^9}, 3.884996548708006*^9, {3.885554291065234*^9, 
   3.885554291452623*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"2eff472a-7724-4f66-8f51-21202a3e7e84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minx", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata54", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884013315814835*^9, 3.8840133162370853`*^9}, {
  3.884522241564007*^9, 3.884522241668228*^9}, {3.884522618454651*^9, 
  3.8845226195353813`*^9}, {3.8855542929143133`*^9, 3.8855542932848253`*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"58ab65c8-2022-45f6-9eca-598bd358e4eb"],

Cell[BoxData["0.026203379983288883`"], "Output",
 CellChangeTimes->{3.884996550271113*^9, 3.885214273723566*^9, 
  3.885218473381186*^9, 3.885285937887665*^9, 3.885414922481456*^9, 
  3.8855026174905233`*^9, 3.8855135298484087`*^9, 3.885554139819508*^9, 
  3.885554349419351*^9, 3.885566091719594*^9, 3.8855666333900347`*^9, 
  3.885581888467197*^9, 3.894049946105605*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"5a0e88d8-38db-4a79-be3f-e740a6274169"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxx", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata54", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.884522243789529*^9, 3.88452224388069*^9}, {
  3.8845226227340727`*^9, 3.884522623467472*^9}, {3.885554294953867*^9, 
  3.885554295254345*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"95735ba9-bd58-4131-b383-336426200a9d"],

Cell[BoxData["0.8944271909999159`"], "Output",
 CellChangeTimes->{3.8840133860348997`*^9, 3.884013651641603*^9, 
  3.884013726912167*^9, 3.884015628000339*^9, 3.884016831921006*^9, 
  3.884017467927054*^9, 3.8849965058495083`*^9, 3.8849965522273607`*^9, 
  3.8852142737554007`*^9, 3.885218473439937*^9, 3.885285937959403*^9, 
  3.8854149226855717`*^9, 3.8855026175838757`*^9, 3.885513529915371*^9, 
  3.885554139857278*^9, 3.885554349443926*^9, 3.8855660917475758`*^9, 
  3.885566634208283*^9, 3.885581889270443*^9, 3.894049946132463*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"8a9a775a-7769-429b-8c23-9e271db53d66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"miny", "=", 
  RowBox[{"Min", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata54", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143318092823`*^9, 3.884014344525115*^9}, {
  3.8845222465037518`*^9, 3.8845222465883827`*^9}, {3.884522626979789*^9, 
  3.88452262765972*^9}, {3.885554296639237*^9, 3.885554296946422*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"bf0989d3-47be-440f-9e70-452e3ebba401"],

Cell[BoxData["0.0018353896604334995`"], "Output",
 CellChangeTimes->{
  3.884014355277335*^9, 3.88401447844201*^9, {3.884015285416799*^9, 
   3.8840152934026213`*^9}, 3.8840156280504837`*^9, 3.88401683195887*^9, 
   3.884017467966743*^9, 3.884996507169136*^9, 3.884996553172838*^9, 
   3.885214273771288*^9, 3.885218473464204*^9, 3.8852859379771833`*^9, 
   3.885414922891693*^9, 3.885502617722039*^9, 3.885513530019058*^9, 
   3.88555413989247*^9, 3.8855543494651117`*^9, 3.885566091792811*^9, 
   3.8855666348684397`*^9, 3.8855818899806213`*^9, 3.8940499461611843`*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"5ba5bffc-91b0-4a61-9b3d-1ec6d7d52540"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxy", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"subdata54", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840143501700583`*^9, 3.8840143533427343`*^9}, {
  3.8845222510213327`*^9, 3.884522251089953*^9}, {3.884522631804204*^9, 
  3.884522632625292*^9}, {3.885554301597021*^9, 3.88555430188031*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"65c5f2f7-2920-4017-9b80-96486484ecb7"],

Cell[BoxData["0.4215186828599653`"], "Output",
 CellChangeTimes->{
  3.8840143559614563`*^9, 3.884014479136077*^9, {3.8840152862672358`*^9, 
   3.884015294230492*^9}, 3.88401562810179*^9, 3.884016832002812*^9, 
   3.884017468001355*^9, 3.8849965541172733`*^9, 3.885214273788404*^9, 
   3.885218473484894*^9, 3.8852859379955*^9, 3.8854149231658363`*^9, 
   3.885502617832314*^9, 3.8855135301359797`*^9, 3.885554139930152*^9, 
   3.885554349486054*^9, 3.885566091822977*^9, 3.885566635542927*^9, 
   3.8855818907729673`*^9, 3.894049946190222*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"fc1eb5fa-a78b-4731-b83a-5466f06ac8ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trend", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"subdata54", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8840119053884897`*^9, 3.884011933703392*^9}, {
  3.8840120521962643`*^9, 3.884012052730195*^9}, {3.88452225384838*^9, 
  3.8845222539347486`*^9}, {3.88452263737679*^9, 3.884522637483733*^9}, {
  3.8849965628646107`*^9, 3.884996562951838*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"978dd4c7-9246-4503-82e9-19b882fe6ea3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.014323782885526786`"}], "+", 
  RowBox[{"0.3995845659336616`", " ", "x"}]}]], "Output",
 CellChangeTimes->{
  3.8840119448526773`*^9, 3.8840120551812696`*^9, 3.884012558099855*^9, 
   3.884012851382483*^9, 3.8840133860859623`*^9, 3.884013651688321*^9, 
   3.8840137269736423`*^9, 3.884015628161447*^9, 3.8840168320472937`*^9, 
   3.8840174680483513`*^9, {3.8849965550199757`*^9, 3.8849965636634073`*^9}, 
   3.8852142738048677`*^9, 3.885218473506997*^9, 3.885285938014042*^9, 
   3.885414923476007*^9, 3.8855026178635263`*^9, 3.885513530245908*^9, 
   3.885554140018846*^9, 3.885554349531139*^9, 3.8855660918537083`*^9, 
   3.885566636875574*^9, 3.8855818915770397`*^9, 3.894049946219206*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"7b210730-e409-4c4f-9a2a-eede5d07a00f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "@", "trend"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"minx", "-", "0.05"}], ",", 
         RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minx", "-", "0.05"}], ",", 
            RowBox[{"maxx", "+", "0.05"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"miny", "-", "0.05"}], ",", 
            RowBox[{"maxy", "+", "0.05"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TraditionalForm", "[", 
           RowBox[{"Norm", "[", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<p-uniform\>\"", ",", "TeXForm", ",", "HoldForm"}], 
             "]"}], "]"}], "]"}], ",", "\"\<||f(p)-p||\>\""}], "}"}]}]}], 
      "]"}], ",", 
     RowBox[{"ListPlot", "[", "subdata54", "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882192696300736*^9, 3.882192700311585*^9}, {
   3.882195533785142*^9, 3.882195533944455*^9}, {3.882287808996023*^9, 
   3.8822878997355423`*^9}, {3.882287979342745*^9, 3.882288014377759*^9}, {
   3.884011926003563*^9, 3.884011929283166*^9}, {3.884012110721346*^9, 
   3.884012138083975*^9}, {3.884012181411414*^9, 3.88401223960191*^9}, {
   3.884012283054537*^9, 3.884012287357141*^9}, 3.884012692543071*^9, {
   3.884013025508174*^9, 3.884013027475286*^9}, 3.8840134464215918`*^9, {
   3.884014216598124*^9, 3.884014231500669*^9}, 3.8840154578520603`*^9, {
   3.884522259532007*^9, 3.884522259612155*^9}, {3.884996601340008*^9, 
   3.884996622290279*^9}, {3.885566620493825*^9, 3.885566620589509*^9}, {
   3.8855819670479507`*^9, 3.885582002694881*^9}, {3.885582185027883*^9, 
   3.8855821861639357`*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"72cedf42-02c6-4c13-b20a-2f22c88d941b"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV0vk71AkAx/GJUK0zU8rVzjzkPpYR0dNHeNQUHSviIcqm0pZqIkerZ+qR
khLrlhZjNqK2GKOl+K5hylGSY745Sq4mjfk2aUVqs7s/vJ/XP/BmhB//MUKJ
RqP5/tf/Ovx24hkzNI/It7FLTDuUR5SPiYVbtfMI/3G9i6e25BHGFgaFHFEu
oXOdlhFokUcsqxEfFq3NJVKWdPOZslxipE1fKfx9NhE3Fv2kNiqXSJ9pYZVw
M4nA/HqD4ZgcYiDfgQXvq4Seine9XVIWUUypZZ4sPkXkDIXMdhWnEzvGS0s/
26dDW99vt3sEl2AkcuZ0pkvwukJ3ftVLFhHAn0+wL6jEfFqYFZGeCIaT3UHZ
UgEiLKbPpSVfQ+6EXrGn/D7iWOb3gjJzcTgiqilsfQMOWIQIjqsUozIoZMu+
dU3IqB4TRdnwsV9a6OJX2gxTx+ntMo1yiEOyDMu9HoHmWHWW4XEbky5mKahr
BSP7TPYRvXsw/CrwiWd0QOzbeGFUuRpfb84qr2h8CnXv/s3O+jXYHiIr+byy
C6r1zq3t6rWYCax9sDryOfjHovTdLP6ECfsb7TthN7xftSS3udVDMJV5+ca7
HlxvD63KsXyIVYtVNPe79iHzU9cdd89GvOxs7hOfksB4h2cN3fAvxGuE5gY/
JiH2uJwQa9WEQsQkiej9oOgjvpNOIqwxHRC2bxuAgh/ETbBtRvxZ/RHlG4No
2d1oMO/WAsfU8p2vyCFwRF4r853FiE4VyFLUX6FEc9Bos+0jXFnI5x4MHgYv
YW/a2PrHOK8rtZ5mv0Yif1FokWMrLEaictgfX8Ocyshhe7Qhy1yYnZI/goCV
DkNKPu24y2Y6F7BGsffrR+6gZweEJon+zUOjcFLipfF2PsHP/d9WNMSPQSo+
+eXStqeYUMPRIt1xGBzeFXN2Uye2Ko6ioH4cDEujwHCfZwirbqqJCJgAzV/l
aTWzC/tsF5exFybQb8LhVd7qgk7SMbdvhW9Q1HPcrMbsOS74ZUdcd5bi95Mz
Dl6lzzExVKG+a1iKrDUfONssujEDqT955i1O3E4MD7/ZDUWIjuFp00mw2Nxk
hU0P7n78HPtPxyRc+5b9oCrogfGBpaf9D72DtfvaVCu7XsSlqX4Qa8mg9uD+
6lZhL87/aqmpdkeGZ/SBPdGOfdiprdFkv3kK5N4kw/I/+rB0y0sFh5pCWy1/
hR9LAk5Qr+jCZTnKKP9GjSoJrBcMbm28Kkck7/u7rgIJ3vB/ujZ7TQ7rAFnR
IaEEQYrp4MhsOe41cM811UngflFnxqdYjrorlV4xIgk0hdvN6LVydFgu6hjq
kaBCuy2VNyLH+4O3ycpPEhyo1eYEj8tRrR/b+mLuv49CAgPpUjmiOzfVqXyR
IKNMapI8JcecE1kQtiBB3EbVxshZORapKIXqLiHhfdRTYa9BQbd0z3jCahK0
5amSSS0KkgBmX5kBifr73Q95yynkLZOLe41I2CiHp9BXUTDknC+zZZKgF3CZ
c0wKppvuHBm1JNGJ1iVVphTe/h0brGVD4tKE1vtIcwoV5R4+G+xIfLEvejBo
Q8FW+4VNjiOJGsmbkix7CopmnnGzE4moX2wv+TpSqI49pqVwJmHOPB2luo5C
jJULzciVxOjjht2ECwXnYaUP7A0k/gVg8l66
        "]]},
      Annotation[#, "Charting`Private`Tag$827650#1"]& ]}, {}}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJw9l3dcjf8bxstIJEIpNJC0lFJSlCuRNLSEKNFCSRKVpKE0aGhpau+99z6n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      "]]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      TagBox[
       FormBox[
        TemplateBox[{
          TagBox[
           RowBox[{"p", "-", "uniform"}], HoldForm]}, "Norm"], 
        TraditionalForm], TraditionalForm, Editable -> True], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox["\"||f(p)-p||\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->300,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.02379662001671112, 
   0.9444271909999159}, {-0.0481646103395665, 0.4715186828599653}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.884012196029457*^9, 3.884012240295251*^9, 3.884012288198164*^9, 
   3.884012559057365*^9, 3.884012851486004*^9, 3.884013028165442*^9, 
   3.8840133863463306`*^9, 3.88401344700156*^9, 3.88401365179841*^9, 
   3.884013727078261*^9, 3.884014233835062*^9, 3.88401545927282*^9, 
   3.884015628293305*^9, 3.884016832143217*^9, 3.884017468138897*^9, {
   3.8849965806439734`*^9, 3.884996629899561*^9}, 3.885214273871223*^9, 
   3.885218473571974*^9, 3.8852859380636253`*^9, 3.885414923689454*^9, 
   3.8855026180478477`*^9, 3.8855135304394093`*^9, 3.885554140265173*^9, 
   3.8855543496074467`*^9, 3.885566091951065*^9, {3.885566621282222*^9, 
   3.885566638331708*^9}, 3.8855818924880657`*^9, {3.885581970691094*^9, 
   3.885582003814713*^9}, 3.8855821892850723`*^9, 3.894049946325272*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"99daf57a-4a86-4845-9c8e-8e152d2c5a47"]
}, Open  ]],

Cell[TextData[StyleBox["How correlated are the two measures of interest?", \
"Subsubsection"]], "Text",
 CellChangeTimes->{
  3.884012468718375*^9, {3.8854112231992893`*^9, 
   3.885411230638398*^9}},ExpressionUUID->"d18e6fe8-4851-4794-80ab-\
ad1cd7ef15da"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subdata34", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.88401251958403*^9, 3.884012523490527*^9}, {
  3.884522229796391*^9, 3.884522232535627*^9}, {3.885411215808626*^9, 
  3.885411234584916*^9}, {3.8855543055942783`*^9, 3.885554305927394*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"9f5b0b72-8071-4e58-b063-5343828c8b86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Correlation", "[", "subdata34", "]"}]], "Input",
 CellChangeTimes->{{3.8855705853778763`*^9, 3.885570590074708*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"e86540fd-e4b0-4f43-9109-c2bcc5d1ab8b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999998`", ",", "0.9631136679316249`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9631136679316249`", ",", "1.000000000000003`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.885570590843029*^9, 3.89404994637573*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"b4e999fa-a669-47e5-aa7e-378dccc50326"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"subdata34", ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<p^*-p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], 
       "]"}], ",", "\"\<||f(p)-p||\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.885411256591475*^9, 3.885411264614998*^9}, {
  3.885582202203837*^9, 3.885582230285551*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"0dc25bca-6da7-4383-a301-62d703eefa27"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVmHc8Vf8fx6VB36wGGkaZWUWERC+UZISoFElCUrJCoogyEpK9ufZ2r73X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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      TemplateBox[{
        TagBox[
         RowBox[{
           SuperscriptBox["p", "*"], "-", "p"}], HoldForm]}, "Norm"], 
      HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"||f(p)-p||\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.6104319087649597}, {0, 0.4215186828599653}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8854149239492292`*^9, 3.885502618247889*^9, 
  3.885513530587756*^9, 3.88555414042266*^9, 3.885554349800375*^9, 
  3.885566092019573*^9, 3.885582232005629*^9, 3.894049946437029*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"f6c22626-7dc8-4e25-8408-5b47f16fd3f9"]
}, Open  ]],

Cell[TextData[{
 StyleBox["What kinds of ", "Subsubsection"],
 StyleBox[Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["A", "TI"]], TraditionalForm], "errors" -> {}, "input" -> 
     "f_A", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]], "Subsubsection",
  ExpressionUUID->"8512e72b-8b45-4ed7-8e9f-e461df2bb9b2"], "Subsubsection"],
 StyleBox[" are we sampling?", "Subsubsection"]
}], "Text",
 CellChangeTimes->{
  3.884012468718375*^9, {3.8854112231992893`*^9, 3.885411230638398*^9}, {
   3.8854113123423634`*^9, 
   3.885411343232925*^9}},ExpressionUUID->"8312be97-203e-48cf-83d1-\
bc57acb2cbe6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subdata12", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.88401251958403*^9, 3.884012523490527*^9}, {
  3.884522229796391*^9, 3.884522232535627*^9}, {3.885411215808626*^9, 
  3.885411234584916*^9}, {3.8854114321098223`*^9, 3.8854114403093357`*^9}, {
  3.8855543093969517`*^9, 3.885554309764226*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"570acaad-b543-4f83-a08e-1e24a16d9341"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Correlation", "[", "subdata12", "]"}]], "Input",
 CellChangeTimes->{{3.8855705949316998`*^9, 3.8855705978630753`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"8b09e2ef-a851-4293-b069-7f25bddcd2cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999999`", ",", "0.1614240620214962`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1614240620214962`", ",", "0.9999999999999997`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.885570598535365*^9, 3.8940499464650507`*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"951d4952-88aa-4dd0-b32d-10d96c318732"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"subdata12", ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{
        RowBox[{"\"\<||\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Subscript", "[", 
            RowBox[{"\"\<f\>\"", ",", "\"\<A\>\""}], "]"}], ",", 
           "StandardForm"}], "]"}], "<>", "\"\<||\>\""}], ",", "\"\<op\>\""}],
        "]"}], ",", 
      RowBox[{"TraditionalForm", "[", 
       RowBox[{"Norm", "[", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<p^*-uniform\>\"", ",", "TeXForm", ",", "HoldForm"}], 
         "]"}], "]"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.885411256591475*^9, 3.885411264614998*^9}, {
  3.885411442695984*^9, 3.885411443697698*^9}, {3.885582286553431*^9, 
  3.8855822969200687`*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"058de0ee-0d9b-470f-9b87-2a3cbec466df"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.0055000000000000005`],
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwV2nc4lm8bB/BUCCWiVFQkSiiVUsKXyEiZSUV2SaSEUikzSWVElEol+dmy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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      SubscriptBox[
      "\"||\\!\\(\\*SubscriptBox[\\\"\\\\\\\"f\\\\\\\"\\\", \\\"\\\\\\\"A\\\\\
\\\"\\\"]\\)||\"", "\"op\""], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      TagBox[
       FormBox[
        TemplateBox[{
          TagBox[
           RowBox[{
             SuperscriptBox["p", "*"], "-", "uniform"}], HoldForm]}, "Norm"], 
        TraditionalForm], TraditionalForm, Editable -> True], HoldForm], 
     TraditionalForm]},
  AxesOrigin->{0.2686799874621285, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.2686799874621285, 0.8702069484436326}, {
    0, 0.4047588788200761}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8854149244594812`*^9, 3.885502618440385*^9, 3.885513530760907*^9, 
   3.885554140576174*^9, 3.8855543499227867`*^9, 3.885566092110731*^9, {
   3.885582288452887*^9, 3.8855822977111998`*^9}, 3.8940499465237303`*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"e1228e11-0f4e-431f-8267-3062c20e9871"]
}, Open  ]],

Cell[TextData[StyleBox["Appendix A: Finding optimal reports with Mathematica \
in the Log Scoring rule case seems difficult", "Section"]], "Text",
 CellChangeTimes->{{3.882351447443527*^9, 3.882351462064146*^9}, {
  3.882353919518772*^9, 3.88235393580939*^9}, {3.8823540496517477`*^9, 
  3.882354084308435*^9}},ExpressionUUID->"8a9fb35f-fb11-4d30-a07a-\
43036cbf40d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";", 
  RowBox[{"A", "=", 
   RowBox[{"RandomA", "[", "3", "]"}]}], ";", 
  RowBox[{"Timing", "[", 
   RowBox[{"TimeConstrained", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"LogScore", "[", 
           RowBox[{
            RowBox[{"Array", "[", 
             RowBox[{"x", ",", "3"}], "]"}], ",", 
            RowBox[{"A", ".", 
             RowBox[{"Array", "[", 
              RowBox[{"x", ",", "3"}], "]"}]}]}], "]"}], ",", 
          RowBox[{"x", "[", "1", "]"}]}], "]"}], "==", "0"}], "&&", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"LogScore", "[", 
           RowBox[{
            RowBox[{"Array", "[", 
             RowBox[{"x", ",", "3"}], "]"}], ",", 
            RowBox[{"A", ".", 
             RowBox[{"Array", "[", 
              RowBox[{"x", ",", "3"}], "]"}]}]}], "]"}], ",", 
          RowBox[{"x", "[", "2", "]"}]}], "]"}], "==", "0"}], "&&", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"LogScore", "[", 
           RowBox[{
            RowBox[{"Array", "[", 
             RowBox[{"x", ",", "3"}], "]"}], ",", 
            RowBox[{"A", ".", 
             RowBox[{"Array", "[", 
              RowBox[{"x", ",", "3"}], "]"}]}]}], "]"}], ",", 
          RowBox[{"x", "[", "3", "]"}]}], "]"}], "==", "0"}]}], "]"}], ",", 
     "300"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882351467209118*^9, 3.882351534077632*^9}, {
  3.8823515643836813`*^9, 3.8823515752029123`*^9}, {3.882351627672665*^9, 
  3.8823516553038187`*^9}, {3.8823533508236628`*^9, 3.882353389521041*^9}, {
  3.882353486322263*^9, 3.882353538251112*^9}, {3.8823538786624327`*^9, 
  3.88235388521876*^9}, {3.882353945691869*^9, 3.882353982402789*^9}, {
  3.882354571699568*^9, 3.8823545796866713`*^9}, {3.8823771252066193`*^9, 
  3.882377136386488*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"c2c1c730-bafc-48c6-a274-43ba3ad36131"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"301.024495`", ",", "$Aborted"}], "}"}]], "Output",
 CellChangeTimes->{3.882353380918837*^9, 3.882353449913496*^9, 
  3.8823535152588453`*^9, 3.8823538707912703`*^9, 3.882354024010352*^9, 
  3.8823545379243603`*^9, 3.882366895716436*^9, 3.882377045553648*^9, 
  3.882377128682798*^9, 3.8823774368326397`*^9, 3.883964472165922*^9, 
  3.88401299333641*^9, 3.884996759022229*^9, 3.8855824599784403`*^9, 
  3.894050246557242*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"5baa7cd2-d941-4cba-934c-19a470e374e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"RandomA", "[", "3", "]"}]}], ";", 
  RowBox[{"TimeConstrained", "[", 
   RowBox[{
    RowBox[{"Maximize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"LogScore", "[", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{"pmax", ",", "3"}], "]"}], ",", 
          RowBox[{"A", ".", 
           RowBox[{"Array", "[", 
            RowBox[{"pmax", ",", "3"}], "]"}]}]}], "]"}], ",", 
        RowBox[{"IsDistr", "[", 
         RowBox[{"Array", "[", 
          RowBox[{"pmax", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{"pmax", ",", "3"}], "]"}]}], "]"}], ",", "500"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8823517275959*^9, 3.882351749913484*^9}, {
   3.882351788273098*^9, 3.8823517892821617`*^9}, {3.8823518332493973`*^9, 
   3.8823518335052443`*^9}, {3.882353999148975*^9, 3.882354033267448*^9}, 
   3.8823771458961267`*^9},
 CellLabel->
  "In[146]:=",ExpressionUUID->"1fed6f77-c2bc-4c1b-9a33-733c986f582e"],

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"pmax", "[", "3", "]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"37", " ", 
           RowBox[{"pmax", "[", "1", "]"}]}], "82"], "+", 
         FractionBox[
          RowBox[{"9", " ", 
           RowBox[{"pmax", "[", "2", "]"}]}], "35"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"pmax", "[", "2", "]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"35", " ", 
           RowBox[{"pmax", "[", "1", "]"}]}], "82"], "+", 
         FractionBox[
          RowBox[{"54", " ", 
           RowBox[{"pmax", "[", "2", "]"}]}], "175"], "+", 
         FractionBox[
          RowBox[{"11", " ", 
           RowBox[{"pmax", "[", "3", "]"}]}], "85"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"pmax", "[", "1", "]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"5", " ", 
           RowBox[{"pmax", "[", "1", "]"}]}], "41"], "+", 
         FractionBox[
          RowBox[{"76", " ", 
           RowBox[{"pmax", "[", "2", "]"}]}], "175"], "+", 
         FractionBox[
          RowBox[{"74", " ", 
           RowBox[{"pmax", "[", "3", "]"}]}], "85"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"pmax", "[", "1", "]"}], "+", 
        RowBox[{"pmax", "[", "2", "]"}], "+", 
        RowBox[{"pmax", "[", "3", "]"}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{"NonNegative", "[", 
       RowBox[{"pmax", "[", "1", "]"}], "]"}], "&&", 
      RowBox[{"NonNegative", "[", 
       RowBox[{"pmax", "[", "2", "]"}], "]"}], "&&", 
      RowBox[{"NonNegative", "[", 
       RowBox[{"pmax", "[", "3", "]"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pmax", "[", "1", "]"}], ",", 
     RowBox[{"pmax", "[", "2", "]"}], ",", 
     RowBox[{"pmax", "[", "3", "]"}]}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{{3.8823517815700903`*^9, 3.882351796011108*^9}, 
   3.882351840482773*^9, 3.882353449977921*^9, 3.882354538142*^9, 
   3.882366896034439*^9, 3.88237704572502*^9, 3.8823774370892363`*^9, 
   3.883964472417289*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"5a00b5ce-926d-4d61-91cc-af0815e769f7"],

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"pmax", "[", "1", "]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"411", " ", 
           RowBox[{"pmax", "[", "1", "]"}]}], "1000"], "+", 
         FractionBox[
          RowBox[{"271", " ", 
           RowBox[{"pmax", "[", "2", "]"}]}], "500"], "+", 
         FractionBox[
          RowBox[{"7", " ", 
           RowBox[{"pmax", "[", "3", "]"}]}], "200"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"pmax", "[", "3", "]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"47", " ", 
           RowBox[{"pmax", "[", "1", "]"}]}], "200"], "+", 
         FractionBox[
          RowBox[{"169", " ", 
           RowBox[{"pmax", "[", "2", "]"}]}], "500"], "+", 
         FractionBox[
          RowBox[{"409", " ", 
           RowBox[{"pmax", "[", "3", "]"}]}], "1000"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"pmax", "[", "2", "]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"177", " ", 
           RowBox[{"pmax", "[", "1", "]"}]}], "500"], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           RowBox[{"pmax", "[", "2", "]"}]}], "25"], "+", 
         FractionBox[
          RowBox[{"139", " ", 
           RowBox[{"pmax", "[", "3", "]"}]}], "250"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"pmax", "[", "1", "]"}], "+", 
        RowBox[{"pmax", "[", "2", "]"}], "+", 
        RowBox[{"pmax", "[", "3", "]"}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{"NonNegative", "[", 
       RowBox[{"pmax", "[", "1", "]"}], "]"}], "&&", 
      RowBox[{"NonNegative", "[", 
       RowBox[{"pmax", "[", "2", "]"}], "]"}], "&&", 
      RowBox[{"NonNegative", "[", 
       RowBox[{"pmax", "[", "3", "]"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pmax", "[", "1", "]"}], ",", 
     RowBox[{"pmax", "[", "2", "]"}], ",", 
     RowBox[{"pmax", "[", "3", "]"}]}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{3.885556810444797*^9, 3.885557250661913*^9, 
  3.8855577617794447`*^9, 3.8855582117877483`*^9, 3.88555877400062*^9, 
  3.885560089205797*^9, 3.8855635007908087`*^9, 3.88556371215156*^9, 
  3.885565737129141*^9, 3.894050246724779*^9},
 CellLabel->
  "Out[146]=",ExpressionUUID->"4e9a23c7-a531-4bcf-95ab-996c1dd1e153"]
}, Open  ]]
}, Open  ]]
},
Evaluator->"ManyOutcomes",
WindowSize->{1440, 762},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->{},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
FrontEndVersion->"13.2 for Linux x86 (64-bit) (November 18, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"af308597-56b3-4762-8e3d-bb13947d53c9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 400, 8, 160, "Title",ExpressionUUID->"52092686-dc98-4dd8-8bd4-ac5ee8fd66a5"],
Cell[983, 32, 226, 5, 53, "Subtitle",ExpressionUUID->"f2a24689-57a4-4c2a-ac2a-edb571e64304"],
Cell[1212, 39, 184, 3, 52, "Text",ExpressionUUID->"a79707f7-8a46-41e1-b993-d355e381a1a1"],
Cell[1399, 44, 357, 9, 29, "Input",ExpressionUUID->"a082005a-818a-4701-9b4a-60b74b157c53"],
Cell[1759, 55, 675, 18, 29, "Input",ExpressionUUID->"16f40baf-3d37-448c-904c-cfe18c131f4c"],
Cell[2437, 75, 835, 24, 29, "Input",ExpressionUUID->"2223da2f-387b-43f5-8f08-96535f2e593a"],
Cell[3275, 101, 1428, 35, 72, "Input",ExpressionUUID->"0dfd78a9-229a-4ed4-9cc7-ef90784371e3"],
Cell[4706, 138, 695, 18, 29, "Input",ExpressionUUID->"9ea27e63-19f8-459a-b3fd-4431739986e2"],
Cell[5404, 158, 368, 8, 32, "Input",ExpressionUUID->"d9a8303c-2ca2-45a9-a2df-02b5ef206b56"],
Cell[5775, 168, 1225, 30, 29, "Input",ExpressionUUID->"770c7b71-a8a4-44af-8766-accfebe860ad"],
Cell[7003, 200, 240, 6, 35, "Text",ExpressionUUID->"f91a842f-7af8-4dc5-83ec-5e59cdace189"],
Cell[7246, 208, 594, 13, 29, "Input",ExpressionUUID->"b0d939f4-fc4a-492b-a65d-5c6d077e63f2"],
Cell[7843, 223, 1132, 27, 29, "Input",ExpressionUUID->"bc039291-3d44-469a-b9d1-0d4250d6868a"],
Cell[8978, 252, 246, 6, 35, "Text",ExpressionUUID->"abd03ebf-f933-436f-b261-4e4f058c681c"],
Cell[9227, 260, 2073, 46, 133, "Input",ExpressionUUID->"c61d7e58-5349-4d03-a78c-fd44833344c8"],
Cell[11303, 308, 442, 9, 35, "Text",ExpressionUUID->"9ec41904-5c26-49b9-afb3-2b550d559319"],
Cell[11748, 319, 1115, 28, 29, "Input",ExpressionUUID->"3eadf192-d187-4ec0-ac6c-178c5f7837b0"],
Cell[12866, 349, 254, 6, 35, "Text",ExpressionUUID->"6874576d-c5fe-445e-ab5a-653735ecffe1"],
Cell[13123, 357, 443, 11, 29, "Input",ExpressionUUID->"270a0f29-44b8-4812-964d-f899b9c5b99d"],
Cell[13569, 370, 1217, 32, 29, "Input",ExpressionUUID->"82b8f933-55a7-4f58-b90b-176a8a1591ad"],
Cell[14789, 404, 1071, 29, 29, "Input",ExpressionUUID->"83f3ba3f-0ba5-4c88-80d6-aa771c2d3b6c"],
Cell[15863, 435, 232, 6, 35, "Text",ExpressionUUID->"208cdb7b-43c8-4b60-b2e7-13f6e479fb89"],
Cell[16098, 443, 594, 15, 29, "Input",ExpressionUUID->"3bd49f14-5583-4a63-8db7-1558f454fc36"],
Cell[16695, 460, 390, 7, 29, "Input",ExpressionUUID->"ba63bfc5-ba4b-4118-a771-787d3012a929"],
Cell[17088, 469, 229, 4, 52, "Text",ExpressionUUID->"b5dcdf67-e79d-47e7-a453-d7222081b353"],
Cell[17320, 475, 561, 9, 29, "Input",ExpressionUUID->"4a66a0c2-6328-42e5-ae41-d549a8c6232b"],
Cell[17884, 486, 467, 10, 29, "Input",ExpressionUUID->"e9bcb382-6c7c-4d5d-8441-4ba263e50f6f"],
Cell[18354, 498, 189, 3, 41, "Text",ExpressionUUID->"9acd8a7f-f213-49c9-8ab2-3ea6b1bb38ab"],
Cell[18546, 503, 259, 7, 35, "Text",ExpressionUUID->"c0109029-748a-4884-994c-ebba86f21b1d"],
Cell[CellGroupData[{
Cell[18830, 514, 505, 14, 29, "Input",ExpressionUUID->"6bfe6974-c524-4911-9e80-82e764af22e5"],
Cell[19338, 530, 533, 7, 33, "Output",ExpressionUUID->"658bf447-925b-434b-88f1-8db7db91c5e7"]
}, Open  ]],
Cell[19886, 540, 260, 6, 35, "Text",ExpressionUUID->"89e66e66-f753-4d76-b4c3-68a5a5507f36"],
Cell[CellGroupData[{
Cell[20171, 550, 412, 11, 29, "Input",ExpressionUUID->"51e11772-2eb6-4940-b2cb-b60f9d53bc62"],
Cell[20586, 563, 509, 7, 33, "Output",ExpressionUUID->"220b54da-fad1-457b-94af-6decd1fbd55a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21132, 575, 448, 11, 29, "Input",ExpressionUUID->"c63b2baa-371e-403c-9eec-ca877bc79a52"],
Cell[21583, 588, 510, 7, 33, "Output",ExpressionUUID->"7bf5c319-5183-43c1-9f0f-cbcfdb8661c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22130, 600, 284, 5, 29, "Input",ExpressionUUID->"e81e4cfa-b334-40dc-94a2-16ad3a989a31"],
Cell[22417, 607, 514, 7, 33, "Output",ExpressionUUID->"df6fa323-646e-439c-8cd4-1ed08cb96627"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22968, 619, 785, 19, 29, "Input",ExpressionUUID->"f05e6e36-044b-40f5-8b05-85eec96e2289"],
Cell[23756, 640, 571, 9, 33, "Output",ExpressionUUID->"164b0e73-e0ac-489e-bb0d-98010c5e66b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24364, 654, 760, 19, 29, "Input",ExpressionUUID->"4c03a6ab-0d9e-44a1-a6cb-a92562a7a1a3"],
Cell[25127, 675, 558, 9, 33, "Output",ExpressionUUID->"7986878b-09cc-493a-b903-8ff6c5ad0c0f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25722, 689, 763, 19, 29, "Input",ExpressionUUID->"ae05c6e2-7548-4a58-b704-bdf4accb0515"],
Cell[26488, 710, 532, 9, 33, "Output",ExpressionUUID->"a127322a-ef05-4f60-8513-e7c74b437696"]
}, Open  ]],
Cell[27035, 722, 201, 3, 41, "Text",ExpressionUUID->"6dc0f605-1ae0-4474-b9f9-3acfb8a9f6e5"],
Cell[CellGroupData[{
Cell[27261, 729, 393, 6, 29, "Input",ExpressionUUID->"6c9fc37b-ad46-47a6-bdfb-a4fb0d6b8973"],
Cell[27657, 737, 1087, 16, 33, "Output",ExpressionUUID->"eab3bed4-ffc1-40bb-9285-2e45cb6bab48"]
}, Open  ]],
Cell[28759, 756, 186, 3, 35, "Text",ExpressionUUID->"66d4e9ab-4259-4c88-8ea9-0e554cee8db3"],
Cell[CellGroupData[{
Cell[28970, 763, 441, 11, 29, "Input",ExpressionUUID->"e724b586-ffc9-4389-b2b7-31120086c1f9"],
Cell[29414, 776, 58162, 989, 243, "Output",ExpressionUUID->"4ee0cfd4-11ec-48be-89fd-11fa1fd78372"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87613, 1770, 540, 12, 29, "Input",ExpressionUUID->"7c21eead-b6d6-42b2-ae00-0b585eb4e8e1"],
Cell[88156, 1784, 26467, 448, 201, "Output",ExpressionUUID->"fd2fd91c-18fa-4235-b4b3-f7cb5341e3c7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114660, 2237, 461, 10, 29, "Input",ExpressionUUID->"9c9a5756-efbc-40fb-a086-e349a1cb319a"],
Cell[115124, 2249, 1058, 15, 33, "Output",ExpressionUUID->"7dcb9690-e6e2-46e6-84c3-6c7cf20617bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116219, 2269, 611, 13, 29, "Input",ExpressionUUID->"30afd8a1-8b6a-48d5-90a4-42d41d4d9cb2"],
Cell[116833, 2284, 1088, 15, 33, "Output",ExpressionUUID->"d78a1249-32f9-4747-9d6d-f3d5be7a7631"]
}, Open  ]],
Cell[117936, 2302, 293, 6, 35, "Text",ExpressionUUID->"d54c6a41-2ea7-4a44-a7c1-4b2eea4c0584"],
Cell[CellGroupData[{
Cell[118254, 2312, 844, 20, 29, "Input",ExpressionUUID->"de6263a4-990a-4613-837f-00f3bac289ef"],
Cell[119101, 2334, 1109, 15, 33, "Output",ExpressionUUID->"fcc688d6-1a4a-4e15-a23f-742abb9adb58"]
}, Open  ]],
Cell[120225, 2352, 191, 3, 41, "Text",ExpressionUUID->"f2aac8c7-1a18-4fe0-a3be-49a79025d8f9"],
Cell[CellGroupData[{
Cell[120441, 2359, 463, 12, 29, "Input",ExpressionUUID->"05111001-323d-47e1-ad50-250ddbba09a2"],
Cell[120907, 2373, 682, 10, 33, "Output",ExpressionUUID->"3e153567-4f1d-4709-a7f4-dfabfafa4fca"]
}, Open  ]],
Cell[121604, 2386, 214, 4, 40, "Text",ExpressionUUID->"55b3816c-e93d-4fa2-8e67-c3f3e6051394"],
Cell[CellGroupData[{
Cell[121843, 2394, 473, 11, 29, "Input",ExpressionUUID->"4a53cff5-3071-4a9a-ae7e-f1f2c795f4dc"],
Cell[122319, 2407, 693, 10, 33, "Output",ExpressionUUID->"e81a77b1-ff2d-46ab-8e4b-e70a0e30a50c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123049, 2422, 303, 6, 29, "Input",ExpressionUUID->"f8186337-1080-4d0f-aff4-2b6bb890260f"],
Cell[123355, 2430, 765, 11, 33, "Output",ExpressionUUID->"a24ed4f8-abee-456a-b9db-eef4280c574b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124157, 2446, 308, 6, 29, "Input",ExpressionUUID->"767f3c63-5cdb-4f5f-893a-01160ddc0ee7"],
Cell[124468, 2454, 771, 11, 33, "Output",ExpressionUUID->"89c21613-1c10-431b-bc73-a84ab2ed0276"]
}, Open  ]],
Cell[CellGroupData[{
Cell[125276, 2470, 427, 11, 29, "Input",ExpressionUUID->"a077a830-676e-4845-a9f7-19513786400f"],
Cell[125706, 2483, 546, 8, 33, "Output",ExpressionUUID->"757d9bb5-fad6-4416-993d-23ed6d6a98e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126289, 2496, 636, 14, 29, "Input",ExpressionUUID->"d137ea22-3fe7-4399-a086-a562f4ea015f"],
Cell[126928, 2512, 658, 9, 33, "Output",ExpressionUUID->"084a443a-9f62-4392-b0ec-be67da6cc338"]
}, Open  ]],
Cell[127601, 2524, 188, 3, 40, "Text",ExpressionUUID->"a5b3381e-5bc7-4e32-acde-6e2ae37355f9"],
Cell[127792, 2529, 499, 9, 35, "Text",ExpressionUUID->"2e321a92-5669-472e-9ca8-ef13a71a2916"],
Cell[128294, 2540, 153, 3, 35, "Text",ExpressionUUID->"41977bd3-f400-4807-8edd-b13e2913870b"],
Cell[CellGroupData[{
Cell[128472, 2547, 1285, 27, 29, "Input",ExpressionUUID->"fd4ac32f-5316-444e-93b2-efdbf4464fdf"],
Cell[129760, 2576, 1619, 23, 33, "Output",ExpressionUUID->"07186c32-ae0c-4877-ad34-3793a6811e8d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131416, 2604, 1597, 35, 71, "Input",ExpressionUUID->"eda06d8d-112f-47fc-9de8-a48e9acf17e0"],
Cell[133016, 2641, 566, 10, 49, "Output",ExpressionUUID->"1e9fa2e9-d95d-4cc9-a8b5-d35f2850de2f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133619, 2656, 1226, 28, 29, "Input",ExpressionUUID->"de44aca1-900d-40b1-b91d-1c4d1820d5fb"],
Cell[134848, 2686, 708, 12, 49, "Output",ExpressionUUID->"89447c1a-022a-4fca-9955-8582540fdc28"]
}, Open  ]],
Cell[135571, 2701, 157, 3, 35, "Text",ExpressionUUID->"defb7954-b9b8-46b0-a898-357fb45c2b0c"],
Cell[CellGroupData[{
Cell[135753, 2708, 893, 22, 29, "Input",ExpressionUUID->"5f8494f4-9290-428f-a89f-fbcfad210bc3"],
Cell[136649, 2732, 632, 9, 33, "Output",ExpressionUUID->"948e349d-662c-4073-8d2e-6514cba6cd6f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137318, 2746, 1330, 30, 29, "Input",ExpressionUUID->"5b4d6d27-5fd6-4fe3-998a-3f76d33b603f"],
Cell[138651, 2778, 715, 12, 33, "Output",ExpressionUUID->"ce4c3e71-5c34-403a-af55-222d2f0744da"]
}, Open  ]],
Cell[139381, 2793, 198, 3, 41, "Text",ExpressionUUID->"e7393d13-5e2a-4711-a8c1-e7d50c682f84"],
Cell[CellGroupData[{
Cell[139604, 2800, 927, 19, 29, "Input",ExpressionUUID->"9be00068-9b64-4554-acac-7a3769614870"],
Cell[140534, 2821, 1219, 19, 33, "Output",ExpressionUUID->"8fc2fbc0-c31c-4f75-96ff-2e98bf84801d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141790, 2845, 658, 13, 29, "Input",ExpressionUUID->"182f5977-a283-466a-89b2-5cb368b5978b"],
Cell[142451, 2860, 1041, 16, 33, "Output",ExpressionUUID->"93e7ab8c-fbcd-4d87-a17e-6121dae5418a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143529, 2881, 736, 17, 29, "Input",ExpressionUUID->"9e2cd2fe-1eca-48c5-b2ba-42c79bd3afde"],
Cell[144268, 2900, 1006, 15, 33, "Output",ExpressionUUID->"48d5a854-3543-48d6-8c9f-cb79999a0fc1"]
}, Open  ]],
Cell[145289, 2918, 199, 3, 41, "Text",ExpressionUUID->"9437ae99-8f26-49b3-a145-139f2d8bc546"],
Cell[145491, 2923, 339, 5, 35, "Text",ExpressionUUID->"e371340b-4359-4caf-978e-1c21e8db72fc"],
Cell[145833, 2930, 127, 3, 35, "Text",ExpressionUUID->"60ab241d-86a3-4250-a1f9-195e7c2ebf9a"],
Cell[CellGroupData[{
Cell[145985, 2937, 833, 16, 29, "Input",ExpressionUUID->"3e012485-486d-403a-9f7e-89da1f01dab3"],
Cell[146821, 2955, 1149, 17, 33, "Output",ExpressionUUID->"d2570f90-6160-493a-848e-1966fb405a10"]
}, Open  ]],
Cell[147985, 2975, 155, 3, 35, "Text",ExpressionUUID->"a3bbc49f-a26f-44c3-8f81-3d58cfc40d9b"],
Cell[CellGroupData[{
Cell[148165, 2982, 665, 14, 29, "Input",ExpressionUUID->"6dd8bd6b-7bc5-4a44-a85a-c0711c83bf90"],
Cell[148833, 2998, 635, 10, 33, "Output",ExpressionUUID->"fadc9b41-934c-43c3-8a64-d7bef4289603"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149505, 3013, 685, 14, 29, "Input",ExpressionUUID->"869393f6-6e96-474d-a27a-78a2a8f1e131"],
Cell[150193, 3029, 566, 9, 33, "Output",ExpressionUUID->"57520077-cfbd-4d11-8001-cd9f5e42a110"]
}, Open  ]],
Cell[150774, 3041, 273, 6, 35, "Text",ExpressionUUID->"d8d88217-436d-4d0e-bcaa-22d2d3cc4673"],
Cell[151050, 3049, 153, 3, 35, "Text",ExpressionUUID->"bdf29abe-5688-4a0d-b425-45486a90d298"],
Cell[CellGroupData[{
Cell[151228, 3056, 1391, 29, 29, "Input",ExpressionUUID->"4d596275-86c1-4a07-8c52-74844e94ae74"],
Cell[152622, 3087, 1060, 16, 33, "Output",ExpressionUUID->"def1e7b8-a112-4868-944e-700e8d4e106c"]
}, Open  ]],
Cell[153697, 3106, 155, 3, 35, "Text",ExpressionUUID->"abb3e2ef-c528-412d-9257-976a4140b46a"],
Cell[CellGroupData[{
Cell[153877, 3113, 996, 24, 29, "Input",ExpressionUUID->"2c7efffc-3c84-4d07-ac32-9273cb85ec32"],
Cell[154876, 3139, 532, 9, 33, "Output",ExpressionUUID->"8db9c90b-1e78-4ab4-95e6-61a8b220b1e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155445, 3153, 1016, 24, 29, "Input",ExpressionUUID->"cc4283da-740b-45da-8f0a-23c8eff6430b"],
Cell[156464, 3179, 539, 9, 33, "Output",ExpressionUUID->"2a304ae7-b8cb-4e60-83b7-1dcece3add34"]
}, Open  ]],
Cell[157018, 3191, 444, 8, 35, "Text",ExpressionUUID->"e5ab2273-6ff1-48dc-81e5-d86df3dd382d"],
Cell[157465, 3201, 151, 3, 35, "Text",ExpressionUUID->"4935439e-1d14-42f1-b180-456352e4dabb"],
Cell[CellGroupData[{
Cell[157641, 3208, 1704, 36, 71, "Input",ExpressionUUID->"4390b101-6984-46b0-8cfa-3b628c26c55d"],
Cell[159348, 3246, 1108, 17, 33, "Output",ExpressionUUID->"414f032a-e6c9-4b9c-930a-b65173243c4e"]
}, Open  ]],
Cell[160471, 3266, 153, 3, 35, "Text",ExpressionUUID->"d28f7fac-f558-487b-9eed-54d046a7da0b"],
Cell[CellGroupData[{
Cell[160649, 3273, 1362, 31, 71, "Input",ExpressionUUID->"59f4228a-ff92-40cd-873e-32f6312d085f"],
Cell[162014, 3306, 536, 9, 33, "Output",ExpressionUUID->"28a50a9b-9160-483b-af83-e1fe170514ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162587, 3320, 1211, 30, 71, "Input",ExpressionUUID->"264d754c-b1e2-47a5-b464-699a5380092f"],
Cell[163801, 3352, 465, 8, 33, "Output",ExpressionUUID->"2add1619-dd41-4413-8b1f-3be8036b0687"]
}, Open  ]],
Cell[164281, 3363, 275, 6, 35, "Text",ExpressionUUID->"11f66b9a-afa6-4866-ab56-9c82ba74a901"],
Cell[164559, 3371, 151, 3, 35, "Text",ExpressionUUID->"7443f3f6-f2e3-4f31-85ce-e169a852ab65"],
Cell[CellGroupData[{
Cell[164735, 3378, 833, 20, 29, "Input",ExpressionUUID->"86cb9997-ca36-4d6f-9487-8806be04ad50"],
Cell[165571, 3400, 804, 12, 33, "Output",ExpressionUUID->"04a0d884-d820-498c-b576-bfbb806fcec4"]
}, Open  ]],
Cell[166390, 3415, 153, 3, 35, "Text",ExpressionUUID->"2f7812c3-156e-4dfc-a794-caf0bb921948"],
Cell[CellGroupData[{
Cell[166568, 3422, 885, 20, 29, "Input",ExpressionUUID->"3233da1a-da1f-4afe-a511-1dfb0535abf6"],
Cell[167456, 3444, 714, 11, 33, "Output",ExpressionUUID->"5f1d7749-2b65-47cb-97f3-9cc3b2c8fb4f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168207, 3460, 730, 16, 29, "Input",ExpressionUUID->"a0222a4d-efbe-4169-a3bf-c09f67b01443"],
Cell[168940, 3478, 462, 8, 33, "Output",ExpressionUUID->"7df5317d-fd59-4413-bc56-c8afc53a1091"]
}, Open  ]],
Cell[169417, 3489, 356, 7, 35, "Text",ExpressionUUID->"dc53f0b7-f2ea-4fba-98a0-8f3dc980cc6c"],
Cell[CellGroupData[{
Cell[169798, 3500, 756, 19, 29, "Input",ExpressionUUID->"11ce6ce8-72b4-4725-b23a-076e91d2c25c"],
Cell[170557, 3521, 295, 6, 49, "Output",ExpressionUUID->"df35aec4-400d-4d89-b0eb-16209636886d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170889, 3532, 755, 19, 29, "Input",ExpressionUUID->"771596c2-b491-4ce7-8d56-f1186d5f5e46"],
Cell[171647, 3553, 319, 6, 48, "Output",ExpressionUUID->"bb7bce44-d9cc-45ff-bc67-16d5ef33e538"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172003, 3564, 1268, 26, 29, "Input",ExpressionUUID->"d688878c-d8b2-48a9-9d7d-7f2374b4a633"],
Cell[173274, 3592, 732, 11, 33, "Output",ExpressionUUID->"86f69fc8-5c48-4b5f-a851-5d49022c0ab3"]
}, Open  ]],
Cell[174021, 3606, 256, 4, 52, "Text",ExpressionUUID->"9e6de677-46db-4ec0-8762-9ef426624530"],
Cell[174280, 3612, 271, 5, 29, "Input",ExpressionUUID->"e6f51016-5e10-4e8b-bdb0-ebf777d1b42c"],
Cell[174554, 3619, 611, 10, 29, "Input",ExpressionUUID->"aeaaac0b-5e91-4721-bd1f-eef3302176d5"],
Cell[175168, 3631, 684, 11, 58, "Text",ExpressionUUID->"f120ba02-f818-408b-ac21-5e52ef7edf53"],
Cell[175855, 3644, 235, 5, 29, "Input",ExpressionUUID->"a3281549-1eac-48d5-b10c-8bf9ecb0b074"],
Cell[CellGroupData[{
Cell[176115, 3653, 1978, 45, 113, "Input",ExpressionUUID->"5db2f5a9-df69-4497-a0e4-b917f0451902"],
Cell[178096, 3700, 200120, 4777, 6616, "Output",ExpressionUUID->"cc956d37-0746-42cd-978b-4a6c500ca534"]
}, Open  ]],
Cell[CellGroupData[{
Cell[378253, 8482, 204, 3, 29, "Input",ExpressionUUID->"b33539b1-165b-4342-abf1-b6f1a550d418"],
Cell[378460, 8487, 290, 4, 33, "Output",ExpressionUUID->"2d9e20bd-4323-4789-8b7e-3816757bb8dd"]
}, Open  ]],
Cell[378765, 8494, 525, 13, 29, "Input",ExpressionUUID->"8e7af88f-8653-455c-96da-ff3899e0b789"],
Cell[CellGroupData[{
Cell[379315, 8511, 202, 3, 29, "Input",ExpressionUUID->"ab83ea66-5d29-4883-b38a-853e5306a39f"],
Cell[379520, 8516, 175, 2, 33, "Output",ExpressionUUID->"b4debf9b-7999-47d8-a629-c4a90526fe3d"]
}, Open  ]],
Cell[379710, 8521, 263, 5, 52, "Text",ExpressionUUID->"67e49088-12fb-4680-bb21-f30391a17f78"],
Cell[379976, 8528, 310, 5, 41, "Text",ExpressionUUID->"61346ca4-f287-4398-8526-8659ecda89a6"],
Cell[380289, 8535, 283, 4, 35, "Text",ExpressionUUID->"5288f603-4799-4ac9-82ce-84b682498503"],
Cell[CellGroupData[{
Cell[380597, 8543, 524, 13, 29, "Input",ExpressionUUID->"1f6b266c-15e6-496d-9ac9-d8327512c003"],
Cell[381124, 8558, 1180, 16, 33, "Output",ExpressionUUID->"a37c2250-5f22-45c2-9830-5a27ed7af5ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[382341, 8579, 579, 14, 29, "Input",ExpressionUUID->"50b9d80c-9541-49f5-92dc-3583a1598ce9"],
Cell[382923, 8595, 1123, 15, 33, "Output",ExpressionUUID->"9f2db439-133e-4e01-9eca-1293bff2d852"]
}, Open  ]],
Cell[CellGroupData[{
Cell[384083, 8615, 523, 13, 29, "Input",ExpressionUUID->"10da9712-fb1e-4794-a6e6-4d28e45604c0"],
Cell[384609, 8630, 1094, 15, 33, "Output",ExpressionUUID->"26b58a2e-5870-41ff-a031-90574753d0aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[385740, 8650, 523, 13, 29, "Input",ExpressionUUID->"7a0d0bda-9dff-48ea-bdbe-73b5d3250f25"],
Cell[386266, 8665, 816, 11, 33, "Output",ExpressionUUID->"51ea554c-aa30-48a5-b8b9-6cf59a513328"]
}, Open  ]],
Cell[CellGroupData[{
Cell[387119, 8681, 527, 13, 29, "Input",ExpressionUUID->"46a95096-7afe-4d80-ad18-72757d871861"],
Cell[387649, 8696, 918, 15, 33, "Output",ExpressionUUID->"2f3a2ca1-a932-4b1c-8926-431c8804cbca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[388604, 8716, 531, 13, 29, "Input",ExpressionUUID->"9a79cd16-1916-40e8-a769-2f7e05ad0bc0"],
Cell[389138, 8731, 731, 10, 33, "Output",ExpressionUUID->"a48ed21d-38ee-4836-b429-8d0d05d08712"]
}, Open  ]],
Cell[389884, 8744, 403, 8, 35, "Text",ExpressionUUID->"06ea9157-768d-4dab-8667-990511ad0c76"],
Cell[CellGroupData[{
Cell[390312, 8756, 522, 13, 29, "Input",ExpressionUUID->"ac889393-5bee-4134-9bd2-da26ec5567b0"],
Cell[390837, 8771, 560, 10, 33, "Output",ExpressionUUID->"b835165f-2d08-4bed-81c2-5e04efe2a58c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[391434, 8786, 576, 14, 29, "Input",ExpressionUUID->"b6ecf5de-46b6-421f-ba52-19b569cfa03e"],
Cell[392013, 8802, 560, 10, 33, "Output",ExpressionUUID->"4391d642-b26f-46d8-8e10-a9e6745a2165"]
}, Open  ]],
Cell[CellGroupData[{
Cell[392610, 8817, 523, 13, 29, "Input",ExpressionUUID->"8aaa46c1-c7aa-4dfb-b391-300c4990f500"],
Cell[393136, 8832, 551, 10, 33, "Output",ExpressionUUID->"5deb60fa-c6ed-4877-b047-243e363853fe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[393724, 8847, 521, 13, 29, "Input",ExpressionUUID->"884bf848-8085-4718-ae05-f1ea98dc45e4"],
Cell[394248, 8862, 799, 11, 33, "Output",ExpressionUUID->"f8e0ea23-d284-4f7c-87cc-3fcf51840cd1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[395084, 8878, 527, 13, 29, "Input",ExpressionUUID->"8ecb4a78-0e8a-48b2-8865-8d9b22c77b0c"],
Cell[395614, 8893, 851, 14, 33, "Output",ExpressionUUID->"2a2c4643-5690-4f05-b4eb-ef133bfadf08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[396502, 8912, 535, 13, 29, "Input",ExpressionUUID->"e21f1523-53e5-4432-8fca-2040d26c7cee"],
Cell[397040, 8927, 731, 10, 33, "Output",ExpressionUUID->"cc6e4436-339f-4287-ba03-d96041b58907"]
}, Open  ]],
Cell[397786, 8940, 195, 3, 41, "Text",ExpressionUUID->"02dc9801-cbc1-4508-8b2d-2670874dde45"],
Cell[CellGroupData[{
Cell[398006, 8947, 725, 20, 29, "Input",ExpressionUUID->"8c1d4098-8393-43b8-9725-a22f060b202f"],
Cell[398734, 8969, 29007, 480, 1230, "Output",ExpressionUUID->"1d0a0a16-de69-4899-a88f-52881ffcb41a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[427778, 9454, 219, 3, 29, "Input",ExpressionUUID->"63a6f114-ce42-4dc1-af7b-04e86949537f"],
Cell[428000, 9459, 243, 3, 33, "Output",ExpressionUUID->"b5624b24-a371-4774-ba5f-eeaa13937f81"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428280, 9467, 234, 3, 29, "Input",ExpressionUUID->"f494e38a-148b-46d1-8203-083a0f423654"],
Cell[428517, 9472, 217, 3, 33, "Output",ExpressionUUID->"3cbbaa11-90e3-4e6f-ac5b-7f822d12a6d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428771, 9480, 224, 3, 29, "Input",ExpressionUUID->"2ecf04d0-f7ba-4e2a-affa-000ff89c0e8a"],
Cell[428998, 9485, 317, 7, 33, "Output",ExpressionUUID->"f335c1c2-f8c5-4934-a604-6e487114d157"]
}, Open  ]],
Cell[CellGroupData[{
Cell[429352, 9497, 931, 24, 29, "Input",ExpressionUUID->"ef48ff56-6fd0-432a-a74a-e4f71fcb8d13"],
Cell[430286, 9523, 30169, 485, 1313, "Output",ExpressionUUID->"c832d22f-7993-480e-a9f3-a9d481b96da0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[460492, 10013, 268, 4, 29, "Input",ExpressionUUID->"3cd0f59d-46cd-444f-9682-faaae62d578c"],
Cell[460763, 10019, 268, 3, 33, "Output",ExpressionUUID->"8dd9dd16-bdfe-4f9c-91ed-019952bd3d60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[461068, 10027, 283, 4, 29, "Input",ExpressionUUID->"aa8c642d-c5ea-440a-a193-04e9e8d2729a"],
Cell[461354, 10033, 240, 3, 33, "Output",ExpressionUUID->"68eb9c1f-b590-4ed4-96fc-7ccc24788c92"]
}, Open  ]],
Cell[CellGroupData[{
Cell[461631, 10041, 277, 4, 29, "Input",ExpressionUUID->"e3e31f7e-d545-4b1e-beb2-daf6159111df"],
Cell[461911, 10047, 340, 7, 33, "Output",ExpressionUUID->"479a88e9-4a54-4612-b4f4-7a624afa849b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[462288, 10059, 999, 28, 32, "Input",ExpressionUUID->"f055bd0e-24c1-4229-8146-645c0909f237"],
Cell[463290, 10089, 28567, 473, 1148, "Output",ExpressionUUID->"5f29fd53-aca9-4cd5-94c3-b3bae58da92c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[491894, 10567, 321, 5, 29, "Input",ExpressionUUID->"d901c51e-6cb7-4cb7-856e-3ddd4ab2f892"],
Cell[492218, 10574, 317, 4, 33, "Output",ExpressionUUID->"e0117328-96e1-49b8-aa1d-9159b6d4550f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[492572, 10583, 336, 5, 29, "Input",ExpressionUUID->"7c988a2b-0833-4b78-be47-f9ba9ec0b42d"],
Cell[492911, 10590, 284, 4, 33, "Output",ExpressionUUID->"749d3795-c606-4b1d-979e-9bfe72ebd483"]
}, Open  ]],
Cell[CellGroupData[{
Cell[493232, 10599, 328, 5, 29, "Input",ExpressionUUID->"8a5e178a-779d-434e-9d7a-c02333a88f3f"],
Cell[493563, 10606, 384, 8, 33, "Output",ExpressionUUID->"c9c069e5-9988-4e95-a868-ec079408c193"]
}, Open  ]],
Cell[CellGroupData[{
Cell[493984, 10619, 1061, 30, 32, "Input",ExpressionUUID->"b0620cad-1906-4efd-871a-a68d2eb28f0c"],
Cell[495048, 10651, 29353, 480, 1230, "Output",ExpressionUUID->"5cd0463c-8713-4a98-9671-9cce65948541"]
}, Open  ]],
Cell[CellGroupData[{
Cell[524438, 11136, 321, 5, 29, "Input",ExpressionUUID->"8610105e-99f0-4bfc-a3c1-7d125596fed9"],
Cell[524762, 11143, 313, 4, 33, "Output",ExpressionUUID->"cb0ab842-5c16-42e5-bcd6-ed26ac217b68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[525112, 11152, 336, 5, 29, "Input",ExpressionUUID->"fdb5c0f6-2c73-44bf-aea4-258f1c15d1b1"],
Cell[525451, 11159, 283, 4, 33, "Output",ExpressionUUID->"02899b4a-06bf-476b-a040-a4075b7058e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[525771, 11168, 330, 5, 29, "Input",ExpressionUUID->"9283b3f8-481d-4036-953d-a772df44778f"],
Cell[526104, 11175, 385, 8, 33, "Output",ExpressionUUID->"5db8267b-5543-439d-bd4d-4911550293db"]
}, Open  ]],
Cell[526504, 11186, 191, 3, 41, "Text",ExpressionUUID->"d6439e93-e358-4d59-b506-d4acb696c1ab"],
Cell[526698, 11191, 302, 5, 40, "Text",ExpressionUUID->"1f210c38-852d-4655-b049-a7f494cc73da"],
Cell[527003, 11198, 788, 21, 29, "Input",ExpressionUUID->"5ae7840b-63f1-4362-b9ed-75cfe762febd"],
Cell[CellGroupData[{
Cell[527816, 11223, 609, 15, 29, "Input",ExpressionUUID->"a6a0702c-e4e1-4943-a491-b9a4c2f732cf"],
Cell[528428, 11240, 640, 9, 33, "Output",ExpressionUUID->"ffd66cb9-c1d4-4e99-b8f3-a8ef90794770"]
}, Open  ]],
Cell[CellGroupData[{
Cell[529105, 11254, 566, 15, 29, "Input",ExpressionUUID->"3a1179e9-988c-474e-b095-2fce78f18317"],
Cell[529674, 11271, 635, 10, 33, "Output",ExpressionUUID->"ca17e2aa-0266-41af-8209-8700aa06fc59"]
}, Open  ]],
Cell[CellGroupData[{
Cell[530346, 11286, 616, 16, 29, "Input",ExpressionUUID->"f28775d2-c99f-4137-8c54-e7b3320ab2af"],
Cell[530965, 11304, 600, 9, 33, "Output",ExpressionUUID->"cc7edce9-1113-471e-a0c7-0b93a756ccaa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[531602, 11318, 621, 16, 29, "Input",ExpressionUUID->"2040d380-e350-43df-8111-705037320099"],
Cell[532226, 11336, 595, 9, 33, "Output",ExpressionUUID->"af3f3474-7ad5-4866-a543-4c43fd616147"]
}, Open  ]],
Cell[CellGroupData[{
Cell[532858, 11350, 429, 10, 29, "Input",ExpressionUUID->"3fd8a46c-11f2-48ca-916e-0a4e2ed4b6d2"],
Cell[533290, 11362, 793, 13, 36, "Output",ExpressionUUID->"8aed541d-1c5a-482b-bbd9-260d6eda567a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[534120, 11380, 221, 4, 29, "Input",ExpressionUUID->"9947c43f-9abd-4455-b460-acdbadf88111"],
Cell[534344, 11386, 398, 11, 33, "Output",ExpressionUUID->"1319459a-105f-49a1-9fe2-8d5cc46b3c2f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[534779, 11402, 2226, 48, 51, "Input",ExpressionUUID->"cb73a2b9-4eb1-42d7-9fe1-30ef7c8020e9"],
Cell[537008, 11452, 24240, 420, 173, "Output",ExpressionUUID->"248d00a7-28c2-4206-b886-495e5e79a0c9"]
}, Open  ]],
Cell[561263, 11875, 267, 4, 40, "Text",ExpressionUUID->"6793148c-c7ec-43d2-9ab7-8e1d3a80fa81"],
Cell[561533, 11881, 796, 22, 29, "Input",ExpressionUUID->"1dd9c4a6-ca4b-4cba-9239-a5e2d3ee4369"],
Cell[CellGroupData[{
Cell[562354, 11907, 614, 16, 29, "Input",ExpressionUUID->"c19bb5f4-66b6-4e1d-a602-6dc3ee7688ac"],
Cell[562971, 11925, 613, 9, 33, "Output",ExpressionUUID->"18ae9ae0-b5fb-40fd-999a-4ca1ed841fca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[563621, 11939, 569, 15, 29, "Input",ExpressionUUID->"012f849d-14c7-42c8-bb66-7268266e6f9a"],
Cell[564193, 11956, 610, 9, 33, "Output",ExpressionUUID->"899f29e4-0986-49ef-81bf-a0a562197b37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[564840, 11970, 616, 16, 29, "Input",ExpressionUUID->"2f91c725-a7cf-4e26-9f50-0fe01fe504df"],
Cell[565459, 11988, 648, 10, 33, "Output",ExpressionUUID->"459e44f9-126f-41e3-bf5c-3d3944ca9e8e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[566144, 12003, 620, 16, 29, "Input",ExpressionUUID->"f9b8a4a2-ee72-4337-b220-b75af31a7ddc"],
Cell[566767, 12021, 636, 10, 33, "Output",ExpressionUUID->"e1ff38b7-0c6f-4f24-ab92-b2885ffb02b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[567440, 12036, 428, 10, 29, "Input",ExpressionUUID->"cf51cffa-bf90-4d46-ab58-7b12be332b53"],
Cell[567871, 12048, 798, 13, 36, "Output",ExpressionUUID->"bb105252-34d6-489e-ad79-3b33b3c899c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[568706, 12066, 223, 4, 29, "Input",ExpressionUUID->"385248a4-21df-476f-bcba-a0399a123695"],
Cell[568932, 12072, 395, 10, 33, "Output",ExpressionUUID->"ccfebee4-3cb0-40a0-8f49-d779f6bfcc37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[569364, 12087, 2347, 51, 71, "Input",ExpressionUUID->"131707eb-e1ba-4073-895b-9de4a1bcb94e"],
Cell[571714, 12140, 24418, 428, 181, "Output",ExpressionUUID->"e6903ea8-9180-48db-a9db-2d8279c189eb"]
}, Open  ]],
Cell[596147, 12571, 237, 4, 40, "Text",ExpressionUUID->"4b15408e-205b-424d-999a-ec13adbf5a97"],
Cell[596387, 12577, 790, 22, 29, "Input",ExpressionUUID->"cc3a88e5-8418-47c1-92e5-d8400e7d7c83"],
Cell[CellGroupData[{
Cell[597202, 12603, 614, 16, 29, "Input",ExpressionUUID->"a1068824-8851-452a-90f5-af4a36dde8b5"],
Cell[597819, 12621, 620, 9, 33, "Output",ExpressionUUID->"3ee0d5cd-50d0-4f86-9faa-ef58671cbc46"]
}, Open  ]],
Cell[CellGroupData[{
Cell[598476, 12635, 564, 15, 29, "Input",ExpressionUUID->"488c2fec-f2bf-497a-8e61-281f4a4c9a27"],
Cell[599043, 12652, 612, 9, 33, "Output",ExpressionUUID->"39726977-2f8d-4cfc-af9d-be3adb903744"]
}, Open  ]],
Cell[CellGroupData[{
Cell[599692, 12666, 616, 16, 29, "Input",ExpressionUUID->"6a44f6b2-8e6a-42de-a795-0d8dbdabaa8c"],
Cell[600311, 12684, 657, 10, 33, "Output",ExpressionUUID->"9ec7cdc7-90e1-468c-864a-39f80c11640d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[601005, 12699, 618, 16, 29, "Input",ExpressionUUID->"adf0d353-b631-4010-99de-9aa7d2ce817b"],
Cell[601626, 12717, 652, 10, 33, "Output",ExpressionUUID->"4d6d16db-d91b-4421-8bd8-14950922cda3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[602315, 12732, 426, 10, 29, "Input",ExpressionUUID->"6dddb80e-63fd-43be-beae-857f43da7c1d"],
Cell[602744, 12744, 824, 14, 36, "Output",ExpressionUUID->"160896ba-156f-44b7-847f-3c4bebf0391b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[603605, 12763, 221, 4, 29, "Input",ExpressionUUID->"21802f2b-5f19-4319-9995-42af3474945b"],
Cell[603829, 12769, 396, 11, 33, "Output",ExpressionUUID->"89e3f9bd-45a3-4430-b457-2b7112cc10a9"]
}, Open  ]],
Cell[604240, 12783, 848, 20, 32, "Input",ExpressionUUID->"7040c131-d525-445f-b66a-0475cf5b8dde"],
Cell[CellGroupData[{
Cell[605113, 12807, 3041, 65, 71, "Input",ExpressionUUID->"a152af05-5111-42a9-88e3-54ae9d0bfa5b"],
Cell[608157, 12874, 26464, 454, 188, "Output",ExpressionUUID->"c53db7e4-24a6-45a5-8a5e-8576aeeeae21"]
}, Open  ]],
Cell[634636, 13331, 225, 4, 40, "Text",ExpressionUUID->"be3288b6-eaf2-4572-bda5-d3264f983fd0"],
Cell[634864, 13337, 789, 22, 29, "Input",ExpressionUUID->"67723295-67e9-4a71-848e-f883623de3e7"],
Cell[CellGroupData[{
Cell[635678, 13363, 614, 16, 29, "Input",ExpressionUUID->"88a6f15a-7b2e-4896-9027-bda98425f0f8"],
Cell[636295, 13381, 592, 9, 33, "Output",ExpressionUUID->"96910600-a5c3-4d4c-a294-594b6cb731bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[636924, 13395, 562, 15, 29, "Input",ExpressionUUID->"5e06c5b0-1e5b-41a5-a8bd-1b7fe495453f"],
Cell[637489, 13412, 589, 9, 33, "Output",ExpressionUUID->"8588075c-35bb-4e98-b224-d8d5af4f5641"]
}, Open  ]],
Cell[CellGroupData[{
Cell[638115, 13426, 618, 16, 29, "Input",ExpressionUUID->"b47c32ad-2386-4df8-ab05-ddd6908a2d91"],
Cell[638736, 13444, 633, 10, 33, "Output",ExpressionUUID->"40ffeafd-cb06-4fa3-8821-3140e009d6f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[639406, 13459, 620, 16, 29, "Input",ExpressionUUID->"77ca7e86-da6d-49d7-be68-2c68df03e2d3"],
Cell[640029, 13477, 626, 10, 33, "Output",ExpressionUUID->"aa7ca6cb-5e90-4689-9276-58acf66d1902"]
}, Open  ]],
Cell[CellGroupData[{
Cell[640692, 13492, 428, 10, 29, "Input",ExpressionUUID->"6d86ed36-b41a-4fe8-bf25-cb7f6bcd5a29"],
Cell[641123, 13504, 800, 14, 36, "Output",ExpressionUUID->"e52eed04-ab9e-443c-9441-1da940c353ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[641960, 13523, 225, 4, 29, "Input",ExpressionUUID->"d9643718-9482-4ceb-9264-48487cb08031"],
Cell[642188, 13529, 392, 10, 33, "Output",ExpressionUUID->"95f5aad9-d0e4-4def-98c2-e6f5c6c79983"]
}, Open  ]],
Cell[642595, 13542, 715, 20, 32, "Input",ExpressionUUID->"ac4676b1-9676-4372-8e9d-97091a577aa7"],
Cell[CellGroupData[{
Cell[643335, 13566, 3087, 67, 71, "Input",ExpressionUUID->"3d3c0f7d-606e-499e-9109-cac419baede8"],
Cell[646425, 13635, 25814, 450, 197, "Output",ExpressionUUID->"1bc47f8e-ac32-4a04-95a4-bc4324417765"]
}, Open  ]],
Cell[672254, 14088, 331, 6, 40, "Text",ExpressionUUID->"6235bc7a-10ae-41cf-8d57-acc08927cb2e"],
Cell[672588, 14096, 866, 23, 29, "Input",ExpressionUUID->"2eff472a-7724-4f66-8f51-21202a3e7e84"],
Cell[CellGroupData[{
Cell[673479, 14123, 666, 16, 29, "Input",ExpressionUUID->"58ab65c8-2022-45f6-9eca-598bd358e4eb"],
Cell[674148, 14141, 455, 7, 33, "Output",ExpressionUUID->"5a0e88d8-38db-4a79-be3f-e740a6274169"]
}, Open  ]],
Cell[CellGroupData[{
Cell[674640, 14153, 613, 16, 29, "Input",ExpressionUUID->"95735ba9-bd58-4131-b383-336426200a9d"],
Cell[675256, 14171, 621, 9, 33, "Output",ExpressionUUID->"8a9a775a-7769-429b-8c23-9e271db53d66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[675914, 14185, 663, 16, 29, "Input",ExpressionUUID->"bf0989d3-47be-440f-9e70-452e3ebba401"],
Cell[676580, 14203, 654, 10, 33, "Output",ExpressionUUID->"5ba5bffc-91b0-4a61-9b3d-1ec6d7d52540"]
}, Open  ]],
Cell[CellGroupData[{
Cell[677271, 14218, 663, 16, 29, "Input",ExpressionUUID->"65c5f2f7-2920-4017-9b80-96486484ecb7"],
Cell[677937, 14236, 627, 10, 33, "Output",ExpressionUUID->"fc1eb5fa-a78b-4731-b83a-5466f06ac8ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[678601, 14251, 524, 11, 29, "Input",ExpressionUUID->"978dd4c7-9246-4503-82e9-19b882fe6ea3"],
Cell[679128, 14264, 817, 14, 36, "Output",ExpressionUUID->"7b210730-e409-4c4f-9a2a-eede5d07a00f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[679982, 14283, 2105, 47, 51, "Input",ExpressionUUID->"72cedf42-02c6-4c13-b20a-2f22c88d941b"],
Cell[682090, 14332, 24118, 418, 174, "Output",ExpressionUUID->"99daf57a-4a86-4845-9c8e-8e152d2c5a47"]
}, Open  ]],
Cell[706223, 14753, 257, 5, 40, "Text",ExpressionUUID->"d18e6fe8-4851-4794-80ab-ad1cd7ef15da"],
Cell[706483, 14760, 837, 22, 29, "Input",ExpressionUUID->"9f5b0b72-8071-4e58-b063-5343828c8b86"],
Cell[CellGroupData[{
Cell[707345, 14786, 223, 4, 29, "Input",ExpressionUUID->"e86540fd-e4b0-4f43-9109-c2bcc5d1ab8b"],
Cell[707571, 14792, 391, 10, 33, "Output",ExpressionUUID->"b4e999fa-a669-47e5-aa7e-378dccc50326"]
}, Open  ]],
Cell[CellGroupData[{
Cell[707999, 14807, 542, 13, 29, "Input",ExpressionUUID->"0dc25bca-6da7-4383-a301-62d703eefa27"],
Cell[708544, 14822, 23323, 424, 234, "Output",ExpressionUUID->"f6c22626-7dc8-4e25-8408-5b47f16fd3f9"]
}, Open  ]],
Cell[731882, 15249, 702, 17, 42, "Text",ExpressionUUID->"8312be97-203e-48cf-83d1-bc57acb2cbe6"],
Cell[732587, 15268, 890, 23, 29, "Input",ExpressionUUID->"570acaad-b543-4f83-a08e-1e24a16d9341"],
Cell[CellGroupData[{
Cell[733502, 15295, 225, 4, 29, "Input",ExpressionUUID->"8b09e2ef-a851-4293-b069-7f25bddcd2cf"],
Cell[733730, 15301, 395, 10, 33, "Output",ExpressionUUID->"951d4952-88aa-4dd0-b32d-10d96c318732"]
}, Open  ]],
Cell[CellGroupData[{
Cell[734162, 15316, 967, 24, 51, "Input",ExpressionUUID->"058de0ee-0d9b-470f-9b87-2a3cbec466df"],
Cell[735132, 15342, 23345, 427, 232, "Output",ExpressionUUID->"e1228e11-0f4e-431f-8267-3062c20e9871"]
}, Open  ]],
Cell[758492, 15772, 368, 5, 52, "Text",ExpressionUUID->"8a9fb35f-fb11-4d30-a07a-43036cbf40d7"],
Cell[CellGroupData[{
Cell[758885, 15781, 2053, 52, 113, "Input",ExpressionUUID->"c2c1c730-bafc-48c6-a274-43ba3ad36131"],
Cell[760941, 15835, 547, 10, 33, "Output",ExpressionUUID->"5baa7cd2-d941-4cba-934c-19a470e374e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[761525, 15850, 1058, 28, 29, "Input",ExpressionUUID->"1fed6f77-c2bc-4c1b-9a33-733c986f582e"],
Cell[762586, 15880, 2404, 66, 88, "Output",ExpressionUUID->"5a00b5ce-926d-4d61-91cc-af0815e769f7"],
Cell[764993, 15948, 2554, 70, 88, "Output",ExpressionUUID->"4e9a23c7-a531-4bcf-95ab-996c1dd1e153"]
}, Open  ]]
}, Open  ]]
}
]
*)

